/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.StoragePolicy;
import org.finra.herd.model.api.xml.StoragePolicyCreateRequest;
import org.finra.herd.model.api.xml.StoragePolicyFilter;
import org.finra.herd.model.api.xml.StoragePolicyKey;
import org.finra.herd.model.api.xml.StoragePolicyRule;
import org.finra.herd.model.api.xml.StoragePolicyTransition;
import org.finra.herd.model.api.xml.StoragePolicyUpdateRequest;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.StoragePolicyEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class StoragePolicyServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateStoragePolicy() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicy resultStoragePolicy = this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), storagePolicyKey, new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "ENABLED"), (Object)resultStoragePolicy);
    }

    @Test
    public void testCreateStoragePolicyMissingRequiredParameters() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(new StoragePolicyKey("      \t\t ", STORAGE_POLICY_NAME), STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, "      \t\t "), STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, STORAGE_POLICY_NAMESPACE_CD, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, "      \t\t ", STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy rule type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy rule type must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, null, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy rule value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy rule value must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, "      \t\t ", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is specified without business object definition namespace.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name and namespace must be specified together.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition namespace is specified without business object definition name.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name and namespace must be specified together.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is specified without business object format usage.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format usage and file type must be specified together.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is specified without business object format file type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format usage and file type must be specified together.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, "      \t\t ", STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "      \t\t ", "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy transition type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy transition type must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy status is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy status must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStoragePolicyMissingOptionalParametersPassedAsWhitespace() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicy resultStoragePolicy = this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, "      \t\t ", "      \t\t ", "      \t\t ", "      \t\t ", STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), storagePolicyKey, new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(null, null, null, null, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "ENABLED"), (Object)resultStoragePolicy);
    }

    @Test
    public void testCreateStoragePolicyMissingOptionalParametersPassedAsNulls() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicy resultStoragePolicy = this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, null, null, null, null, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), storagePolicyKey, new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(null, null, null, null, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "ENABLED"), (Object)resultStoragePolicy);
    }

    @Test
    public void testCreateStoragePolicyTrimParameters() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicy resultStoragePolicy = this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(new StoragePolicyKey(this.addWhitespace(STORAGE_POLICY_NAMESPACE_CD), this.addWhitespace(STORAGE_POLICY_NAME)), this.addWhitespace(STORAGE_POLICY_RULE_TYPE), STORAGE_POLICY_RULE_VALUE, this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), this.addWhitespace(STORAGE_NAME), this.addWhitespace(STORAGE_POLICY_TRANSITION_TYPE), this.addWhitespace("ENABLED")));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "ENABLED"), (Object)resultStoragePolicy);
    }

    @Test
    public void testCreateStoragePolicyUpperCaseParameters() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicy resultStoragePolicy = this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD.toUpperCase(), STORAGE_POLICY_NAME.toUpperCase()), STORAGE_POLICY_RULE_TYPE.toUpperCase(), STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), STORAGE_NAME.toUpperCase(), STORAGE_POLICY_TRANSITION_TYPE.toUpperCase(), "ENABLED".toUpperCase()));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME.toUpperCase()), new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "ENABLED"), (Object)resultStoragePolicy);
    }

    @Test
    public void testCreateStoragePolicyLowerCaseParameters() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicy resultStoragePolicy = this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD.toLowerCase(), STORAGE_POLICY_NAME.toLowerCase()), STORAGE_POLICY_RULE_TYPE.toLowerCase(), STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), STORAGE_NAME.toLowerCase(), STORAGE_POLICY_TRANSITION_TYPE.toLowerCase(), "ENABLED".toLowerCase()));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME.toLowerCase()), new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "ENABLED"), (Object)resultStoragePolicy);
    }

    @Test
    public void testCreateStoragePolicyInvalidParameters() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        StoragePolicyCreateRequest request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(new StoragePolicyKey("I_DO_NOT_EXIST", STORAGE_POLICY_NAME), STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage policy namespace.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", request.getStoragePolicyKey().getNamespace()), (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(new StoragePolicyKey(this.addSlash(STORAGE_POLICY_NAMESPACE_CD), STORAGE_POLICY_NAME), STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, this.addSlash(STORAGE_POLICY_NAME)), STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Storage policy name can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, "I_DO_NOT_EXIST", STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage policy rule type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage policy rule type with code \"%s\" doesn't exist.", request.getStoragePolicyRule().getRuleType()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, -1, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using a negative storage policy rule value.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Storage policy rule value must be a positive integer or zero.", (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, "I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object definition namespace.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", request.getStoragePolicyFilter().getBusinessObjectDefinitionName(), request.getStoragePolicyFilter().getNamespace()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object definition name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", request.getStoragePolicyFilter().getBusinessObjectDefinitionName(), request.getStoragePolicyFilter().getNamespace()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object format file type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("File type with code \"%s\" doesn't exist.", request.getStoragePolicyFilter().getBusinessObjectFormatFileType()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, "I_DO_NOT_EXIST", STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", request.getStoragePolicyFilter().getStorageName()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "I_DO_NOT_EXIST", "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage policy transition type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage policy transition type with code \"%s\" doesn't exist.", request.getStoragePolicyTransition().getTransitionType()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "I_DO_NOT_EXIST");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage policy status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage policy status \"%s\" doesn't exist.", request.getStatus()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStoragePolicyStoragePolicyFilterStorageInvalidStoragePlatform() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3, STORAGE_PLATFORM_CODE);
        StoragePolicyCreateRequest request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME_3, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using non-S3 storage platform for storage policy filter storage.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage platform for storage with name \"%s\" is not \"%s\".", request.getStoragePolicyFilter().getStorageName(), "S3"), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStoragePolicyStoragePolicyFilterStorageBucketNameNotConfigured() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3, "S3");
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        StoragePolicyCreateRequest request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME_3, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an IllegalStateException when storage policy filter storage has no S3 bucket name attribute configured.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), request.getStoragePolicyFilter().getStorageName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStoragePolicyStoragePolicyFilterStoragePathPrefixValidationNotEnabled() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3, "S3", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        StoragePolicyCreateRequest request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME_3, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an IllegalStateException when storage policy filter storage has no S3 path prefix validation enabled.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Path prefix validation must be enabled on \"%s\" storage.", request.getStoragePolicyFilter().getStorageName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStoragePolicyStoragePolicyFilterStorageFileExistenceValidationNotEnabled() {
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX), Boolean.TRUE.toString()));
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3, "S3", attributes);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        StoragePolicyCreateRequest request = this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME_3, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED");
        try {
            this.storagePolicyService.createStoragePolicy(request);
            Assert.fail((String)"Should throw an IllegalStateException when storage policy filter storage has no S3 file existence validation enabled.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("File existence validation must be enabled on \"%s\" storage.", request.getStoragePolicyFilter().getStorageName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStoragePolicyAlreadyExists() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyService.createStoragePolicy(this.storagePolicyServiceTestHelper.createStoragePolicyCreateRequest(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an AlreadyExistsException when storage policy already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create storage policy with name \"%s\" because it already exists for namespace \"%s\".", storagePolicyKey.getStoragePolicyName(), storagePolicyKey.getNamespace()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStoragePolicy() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicyEntity storagePolicyEntity = this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicy resultStoragePolicy = this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED"));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), storagePolicyKey, new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "DISABLED"), (Object)resultStoragePolicy);
        Assert.assertTrue((resultStoragePolicy.getId() > storagePolicyEntity.getId() ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateStoragePolicyMissingRequiredParameters() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            this.storagePolicyService.updateStoragePolicy(new StoragePolicyKey("      \t\t ", STORAGE_POLICY_NAME), this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, "      \t\t "), this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, STORAGE_POLICY_NAMESPACE_CD, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest("      \t\t ", STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy rule type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy rule type must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, null, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy rule value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy rule value must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, "      \t\t ", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is specified without business object definition namespace.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name and namespace must be specified together.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition namespace is specified without business object definition name.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name and namespace must be specified together.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is specified without business object format usage.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format usage and file type must be specified together.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is specified without business object format file type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format usage and file type must be specified together.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, "      \t\t ", STORAGE_POLICY_TRANSITION_TYPE, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "      \t\t ", "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy transition type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy transition type must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy status is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy status must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStoragePolicyMissingOptionalParametersPassedAsWhitespace() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicyEntity storagePolicyEntity = this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicy resultStoragePolicy = this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, "      \t\t ", "      \t\t ", "      \t\t ", "      \t\t ", STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED"));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), storagePolicyKey, new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(null, null, null, null, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "DISABLED"), (Object)resultStoragePolicy);
        Assert.assertTrue((resultStoragePolicy.getId() > storagePolicyEntity.getId() ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateStoragePolicyMissingOptionalParametersPassedAsNulls() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicyEntity storagePolicyEntity = this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicy resultStoragePolicy = this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, null, null, null, null, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED"));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), storagePolicyKey, new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(null, null, null, null, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "DISABLED"), (Object)resultStoragePolicy);
        Assert.assertTrue((resultStoragePolicy.getId() > storagePolicyEntity.getId() ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateStoragePolicyTrimParameters() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicyEntity storagePolicyEntity = this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicy resultStoragePolicy = this.storagePolicyService.updateStoragePolicy(new StoragePolicyKey(this.addWhitespace(STORAGE_POLICY_NAMESPACE_CD), this.addWhitespace(STORAGE_POLICY_NAME)), this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(this.addWhitespace(STORAGE_POLICY_RULE_TYPE), STORAGE_POLICY_RULE_VALUE, this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), this.addWhitespace(STORAGE_NAME), this.addWhitespace(STORAGE_POLICY_TRANSITION_TYPE), this.addWhitespace("DISABLED")));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "DISABLED"), (Object)resultStoragePolicy);
        Assert.assertTrue((resultStoragePolicy.getId() > storagePolicyEntity.getId() ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateStoragePolicyUpperCaseParameters() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicyEntity storagePolicyEntity = this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicy resultStoragePolicy = this.storagePolicyService.updateStoragePolicy(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD.toUpperCase(), STORAGE_POLICY_NAME.toUpperCase()), this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE.toUpperCase(), STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), STORAGE_NAME.toUpperCase(), STORAGE_POLICY_TRANSITION_TYPE.toUpperCase(), "DISABLED".toUpperCase()));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "DISABLED"), (Object)resultStoragePolicy);
        Assert.assertTrue((resultStoragePolicy.getId() > storagePolicyEntity.getId() ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateStoragePolicyLowerCaseParameters() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        StoragePolicyEntity storagePolicyEntity = this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicy resultStoragePolicy = this.storagePolicyService.updateStoragePolicy(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD.toLowerCase(), STORAGE_POLICY_NAME.toLowerCase()), this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE.toLowerCase(), STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), STORAGE_NAME.toLowerCase(), STORAGE_POLICY_TRANSITION_TYPE.toLowerCase(), "DISABLED".toLowerCase()));
        Assert.assertEquals((Object)new StoragePolicy(resultStoragePolicy.getId(), new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "DISABLED"), (Object)resultStoragePolicy);
        Assert.assertTrue((resultStoragePolicy.getId() > storagePolicyEntity.getId() ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateStoragePolicyInvalidParameters() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicyUpdateRequest request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest("I_DO_NOT_EXIST", STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage policy rule type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage policy rule type with code \"%s\" doesn't exist.", request.getStoragePolicyRule().getRuleType()), (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, -1, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when using a negative storage policy rule value.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Storage policy rule value must be a positive integer or zero.", (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, "I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object definition namespace.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", request.getStoragePolicyFilter().getBusinessObjectDefinitionName(), request.getStoragePolicyFilter().getNamespace()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object definition name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", request.getStoragePolicyFilter().getBusinessObjectDefinitionName(), request.getStoragePolicyFilter().getNamespace()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object format file type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("File type with code \"%s\" doesn't exist.", request.getStoragePolicyFilter().getBusinessObjectFormatFileType()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, "I_DO_NOT_EXIST", STORAGE_POLICY_TRANSITION_TYPE, "DISABLED");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", request.getStoragePolicyFilter().getStorageName()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "I_DO_NOT_EXIST", "DISABLED");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage policy transition type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage policy transition type with code \"%s\" doesn't exist.", request.getStoragePolicyTransition().getTransitionType()), (Object)e.getMessage());
        }
        request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "I_DO_NOT_EXIST");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage policy status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage policy status \"%s\" doesn't exist.", request.getStatus()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStoragePolicyStoragePolicyFilterStorageInvalidStoragePlatform() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3, STORAGE_PLATFORM_CODE);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicyUpdateRequest request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME_3, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using non-S3 storage platform for storage policy filter storage.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage platform for storage with name \"%s\" is not \"%s\".", request.getStoragePolicyFilter().getStorageName(), "S3"), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStoragePolicyStoragePolicyFilterStorageBucketNameNotConfigured() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_5, "S3");
        StoragePolicyUpdateRequest request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME_5, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an IllegalStateException when storage policy filter storage has no S3 bucket name attribute configured.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), request.getStoragePolicyFilter().getStorageName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStoragePolicyStoragePolicyFilterStoragePathPrefixValidationNotEnabled() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_5, "S3", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME);
        StoragePolicyUpdateRequest request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME_5, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an IllegalStateException when storage policy filter storage has no S3 path prefix validation enabled.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Path prefix validation must be enabled on \"%s\" storage.", request.getStoragePolicyFilter().getStorageName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStoragePolicyStoragePolicyFilterStorageFileExistenceValidationNotEnabled() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting();
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE_2, STORAGE_POLICY_RULE_VALUE_2, BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME_2, STORAGE_POLICY_TRANSITION_TYPE_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX), Boolean.TRUE.toString()));
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_5, "S3", attributes);
        StoragePolicyUpdateRequest request = this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME_5, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED");
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, request);
            Assert.fail((String)"Should throw an IllegalStateException when storage policy filter storage has no S3 file existence validation enabled.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("File existence validation must be enabled on \"%s\" storage.", request.getStoragePolicyFilter().getStorageName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStoragePolicyNoExists() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        try {
            this.storagePolicyService.updateStoragePolicy(storagePolicyKey, this.storagePolicyServiceTestHelper.createStoragePolicyUpdateRequest(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "DISABLED"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when trying to retrieve a non-existing storage policy.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage policy with name \"%s\" does not exist for \"%s\" namespace.", STORAGE_POLICY_NAME, STORAGE_POLICY_NAMESPACE_CD), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStoragePolicy() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        StoragePolicyEntity storagePolicyEntity = this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicy resultStoragePolicy = this.storagePolicyService.getStoragePolicy(storagePolicyKey);
        Assert.assertEquals((Object)new StoragePolicy(storagePolicyEntity.getId().intValue(), storagePolicyKey, new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "ENABLED"), (Object)resultStoragePolicy);
    }

    @Test
    public void testGetStoragePolicyMissingRequiredParameters() {
        try {
            this.storagePolicyService.getStoragePolicy(new StoragePolicyKey("      \t\t ", STORAGE_POLICY_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storagePolicyService.getStoragePolicy(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage policy name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStoragePolicyTrimParameters() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        StoragePolicyEntity storagePolicyEntity = this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicy resultStoragePolicy = this.storagePolicyService.getStoragePolicy(new StoragePolicyKey(this.addWhitespace(STORAGE_POLICY_NAMESPACE_CD), this.addWhitespace(STORAGE_POLICY_NAME)));
        Assert.assertEquals((Object)new StoragePolicy(storagePolicyEntity.getId().intValue(), storagePolicyKey, new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "ENABLED"), (Object)resultStoragePolicy);
    }

    @Test
    public void testGetStoragePolicyUpperCaseParameters() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        StoragePolicyEntity storagePolicyEntity = this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicy resultStoragePolicy = this.storagePolicyService.getStoragePolicy(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD.toUpperCase(), STORAGE_POLICY_NAME.toUpperCase()));
        Assert.assertEquals((Object)new StoragePolicy(storagePolicyEntity.getId().intValue(), storagePolicyKey, new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "ENABLED"), (Object)resultStoragePolicy);
    }

    @Test
    public void testGetStoragePolicyLowerCaseParameters() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        StoragePolicyEntity storagePolicyEntity = this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_POLICY_TRANSITION_TYPE, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StoragePolicy resultStoragePolicy = this.storagePolicyService.getStoragePolicy(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD.toLowerCase(), STORAGE_POLICY_NAME.toLowerCase()));
        Assert.assertEquals((Object)new StoragePolicy(storagePolicyEntity.getId().intValue(), storagePolicyKey, new StoragePolicyRule(STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE), new StoragePolicyFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME), new StoragePolicyTransition(STORAGE_POLICY_TRANSITION_TYPE), "ENABLED"), (Object)resultStoragePolicy);
    }

    @Test
    public void testGetStoragePolicyNoExists() {
        try {
            this.storagePolicyService.getStoragePolicy(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when trying to retrieve a non-existing storage policy.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage policy with name \"%s\" does not exist for \"%s\" namespace.", STORAGE_POLICY_NAME, STORAGE_POLICY_NAMESPACE_CD), (Object)e.getMessage());
        }
    }
}

