/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.BusinessObjectDefinitionDaoTestHelper;
import org.finra.herd.dao.FileTypeDaoTestHelper;
import org.finra.herd.dao.NamespaceDao;
import org.finra.herd.dao.NamespaceDaoTestHelper;
import org.finra.herd.dao.StorageDao;
import org.finra.herd.dao.StorageDaoTestHelper;
import org.finra.herd.dao.StoragePolicyRuleTypeDao;
import org.finra.herd.dao.StoragePolicyRuleTypeDaoTestHelper;
import org.finra.herd.dao.StoragePolicyTransitionTypeDao;
import org.finra.herd.dao.StoragePolicyTransitionTypeDaoTestHelper;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.StoragePolicyCreateRequest;
import org.finra.herd.model.api.xml.StoragePolicyFilter;
import org.finra.herd.model.api.xml.StoragePolicyKey;
import org.finra.herd.model.api.xml.StoragePolicyRule;
import org.finra.herd.model.api.xml.StoragePolicyTransition;
import org.finra.herd.model.api.xml.StoragePolicyUpdateRequest;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StoragePolicyServiceTestHelper {
    @Autowired
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Autowired
    private BusinessObjectDefinitionDaoTestHelper businessObjectDefinitionDaoTestHelper;
    @Autowired
    private ConfigurationHelper configurationHelper;
    @Autowired
    private FileTypeDaoTestHelper fileTypeDaoTestHelper;
    @Autowired
    private NamespaceDao namespaceDao;
    @Autowired
    private NamespaceDaoTestHelper namespaceDaoTestHelper;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private StorageDaoTestHelper storageDaoTestHelper;
    @Autowired
    private StoragePolicyRuleTypeDao storagePolicyRuleTypeDao;
    @Autowired
    private StoragePolicyRuleTypeDaoTestHelper storagePolicyRuleTypeDaoTestHelper;
    @Autowired
    private StoragePolicyTransitionTypeDao storagePolicyTransitionTypeDao;
    @Autowired
    private StoragePolicyTransitionTypeDaoTestHelper storagePolicyTransitionTypeDaoTestHelper;

    public void createDatabaseEntitiesForStoragePolicyTesting() {
        this.createDatabaseEntitiesForStoragePolicyTesting(AbstractServiceTest.STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(AbstractServiceTest.STORAGE_POLICY_RULE_TYPE), AbstractServiceTest.BDEF_NAMESPACE, AbstractServiceTest.BDEF_NAME, Arrays.asList(AbstractServiceTest.FORMAT_FILE_TYPE_CODE), Arrays.asList(AbstractServiceTest.STORAGE_NAME), Arrays.asList(AbstractServiceTest.STORAGE_POLICY_TRANSITION_TYPE));
    }

    public void createDatabaseEntitiesForStoragePolicyTesting(String storagePolicyNamespace, List<String> storagePolicyRuleTypes, String businessObjectDefinitionNamespace, String businessObjectDefinitionName, List<String> fileTypes, List<String> storageNames, List<String> storagePolicyTransitionTypes) {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity;
        NamespaceEntity storagePolicyNamespaceEntity = this.namespaceDao.getNamespaceByCd(storagePolicyNamespace);
        if (storagePolicyNamespaceEntity == null) {
            this.namespaceDaoTestHelper.createNamespaceEntity(storagePolicyNamespace);
        }
        if (!CollectionUtils.isEmpty(storagePolicyRuleTypes)) {
            for (String storagePolicyRuleType : storagePolicyRuleTypes) {
                if (this.storagePolicyRuleTypeDao.getStoragePolicyRuleTypeByCode(storagePolicyRuleType) != null) continue;
                this.storagePolicyRuleTypeDaoTestHelper.createStoragePolicyRuleTypeEntity(storagePolicyRuleType, AbstractServiceTest.DESCRIPTION);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)businessObjectDefinitionName) && (businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(businessObjectDefinitionNamespace, businessObjectDefinitionName))) == null) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(businessObjectDefinitionNamespace, businessObjectDefinitionName, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.BDEF_DESCRIPTION);
        }
        if (!CollectionUtils.isEmpty(fileTypes)) {
            for (String businessObjectFormatFileType : fileTypes) {
                this.fileTypeDaoTestHelper.createFileTypeEntity(businessObjectFormatFileType);
            }
        }
        if (!CollectionUtils.isEmpty(storageNames)) {
            for (String storageName : storageNames) {
                if (this.storageDao.getStorageByName(storageName) != null) continue;
                this.storageDaoTestHelper.createStorageEntity(storageName, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), AbstractServiceTest.S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX), Boolean.TRUE.toString()), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), Boolean.TRUE.toString())));
            }
        }
        if (!CollectionUtils.isEmpty(storagePolicyTransitionTypes)) {
            for (String storagePolicyTransitionType : storagePolicyTransitionTypes) {
                if (this.storagePolicyTransitionTypeDao.getStoragePolicyTransitionTypeByCode(storagePolicyTransitionType) != null) continue;
                this.storagePolicyTransitionTypeDaoTestHelper.createStoragePolicyTransitionTypeEntity(storagePolicyTransitionType);
            }
        }
    }

    public StoragePolicyCreateRequest createStoragePolicyCreateRequest(StoragePolicyKey storagePolicyKey, String storagePolicyRuleType, Integer storagePolicyRuleValue, String businessObjectDefinitionNamespace, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, String storageName, String storagePolicyTransitionType, String storagePolicyStatus) {
        StoragePolicyCreateRequest request = new StoragePolicyCreateRequest();
        request.setStoragePolicyKey(storagePolicyKey);
        StoragePolicyRule storagePolicyRule = new StoragePolicyRule();
        request.setStoragePolicyRule(storagePolicyRule);
        storagePolicyRule.setRuleType(storagePolicyRuleType);
        storagePolicyRule.setRuleValue(storagePolicyRuleValue);
        StoragePolicyFilter storagePolicyFilter = new StoragePolicyFilter();
        request.setStoragePolicyFilter(storagePolicyFilter);
        storagePolicyFilter.setNamespace(businessObjectDefinitionNamespace);
        storagePolicyFilter.setBusinessObjectDefinitionName(businessObjectDefinitionName);
        storagePolicyFilter.setBusinessObjectFormatUsage(businessObjectFormatUsage);
        storagePolicyFilter.setBusinessObjectFormatFileType(businessObjectFormatFileType);
        storagePolicyFilter.setStorageName(storageName);
        StoragePolicyTransition storagePolicyTransition = new StoragePolicyTransition();
        request.setStoragePolicyTransition(storagePolicyTransition);
        storagePolicyTransition.setTransitionType(storagePolicyTransitionType);
        request.setStatus(storagePolicyStatus);
        return request;
    }

    public StoragePolicyUpdateRequest createStoragePolicyUpdateRequest(String storagePolicyRuleType, Integer storagePolicyRuleValue, String businessObjectDefinitionNamespace, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, String storageName, String storagePolicyTransitionType, String storagePolicyStatus) {
        StoragePolicyUpdateRequest request = new StoragePolicyUpdateRequest();
        StoragePolicyRule storagePolicyRule = new StoragePolicyRule();
        request.setStoragePolicyRule(storagePolicyRule);
        storagePolicyRule.setRuleType(storagePolicyRuleType);
        storagePolicyRule.setRuleValue(storagePolicyRuleValue);
        StoragePolicyFilter storagePolicyFilter = new StoragePolicyFilter();
        request.setStoragePolicyFilter(storagePolicyFilter);
        storagePolicyFilter.setNamespace(businessObjectDefinitionNamespace);
        storagePolicyFilter.setBusinessObjectDefinitionName(businessObjectDefinitionName);
        storagePolicyFilter.setBusinessObjectFormatUsage(businessObjectFormatUsage);
        storagePolicyFilter.setBusinessObjectFormatFileType(businessObjectFormatFileType);
        storagePolicyFilter.setStorageName(storageName);
        StoragePolicyTransition storagePolicyTransition = new StoragePolicyTransition();
        request.setStoragePolicyTransition(storagePolicyTransition);
        storagePolicyTransition.setTransitionType(storagePolicyTransitionType);
        request.setStatus(storagePolicyStatus);
        return request;
    }

    public String getExpectedStoragePolicyKeyAndVersionAsString(StoragePolicyKey storagePolicyKey, Integer storagePolicyVersion) {
        return String.format("namespace: \"%s\", storagePolicyName: \"%s\", storagePolicyVersion: \"%d\"", storagePolicyKey.getNamespace(), storagePolicyKey.getStoragePolicyName(), storagePolicyVersion);
    }

    public String getExpectedStoragePolicyNotFoundErrorMessage(StoragePolicyKey storagePolicyKey) {
        return String.format("Storage policy with name \"%s\" does not exist for \"%s\" namespace.", storagePolicyKey.getStoragePolicyName(), storagePolicyKey.getNamespace());
    }
}

