/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.List;
import javax.persistence.PersistenceException;
import org.finra.herd.core.Command;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.Storage;
import org.finra.herd.model.api.xml.StorageAttributesUpdateRequest;
import org.finra.herd.model.api.xml.StorageCreateRequest;
import org.finra.herd.model.api.xml.StorageKey;
import org.finra.herd.model.api.xml.StorageKeys;
import org.finra.herd.model.api.xml.StorageUpdateRequest;
import org.finra.herd.model.jpa.StorageAttributeEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class StorageServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateStorage() {
        StorageCreateRequest request = this.getNewStorageCreateRequest();
        Storage result = this.storageService.createStorage(request);
        Assert.assertEquals((Object)new Storage(request.getName(), request.getStoragePlatformName(), request.getAttributes()), (Object)result);
    }

    @Test
    public void testCreateStorageInvalidParameters() {
        try {
            this.storageService.createStorage(new StorageCreateRequest(STORAGE_NAME, this.addSlash(STORAGE_PLATFORM_CODE), NO_ATTRIBUTES));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage platform name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Storage platform name can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.storageService.createStorage(new StorageCreateRequest(this.addSlash(DATA_PROVIDER_NAME), STORAGE_PLATFORM_CODE, NO_ATTRIBUTES));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Storage name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStorageMissingOptionalParameters() {
        StorageCreateRequest request = this.getNewStorageCreateRequest();
        request.setAttributes(null);
        Storage result = this.storageService.createStorage(request);
        Assert.assertEquals((Object)new Storage(request.getName(), request.getStoragePlatformName(), NO_ATTRIBUTES), (Object)result);
    }

    @Test
    public void testCreateStorageMissingRequiredParameters() {
        try {
            this.storageService.createStorage(new StorageCreateRequest("      \t\t ", STORAGE_PLATFORM_CODE, NO_ATTRIBUTES));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStorageStorageAlreadyExists() {
        StorageCreateRequest storageCreateRequest = this.getNewStorageCreateRequest();
        this.storageService.createStorage(storageCreateRequest);
        try {
            this.storageService.createStorage(storageCreateRequest);
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" already exists.", storageCreateRequest.getName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteStorage() {
        Storage storage = this.storageService.createStorage(this.getNewStorageCreateRequest());
        Storage result = this.storageService.deleteStorage(new StorageKey(storage.getName()));
        Assert.assertEquals((Object)storage, (Object)result);
        Assert.assertNull((Object)this.storageDao.getStorageByName(storage.getName()));
    }

    @Ignore
    @Test(expected=PersistenceException.class)
    public void testDeleteStorageConstraintViolation() throws Exception {
        final StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, BDATA_STATUS, STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        this.executeWithoutLogging(SqlExceptionHelper.class, new Command(){

            public void execute() {
                StorageKey alternateKey = new StorageKey(storageUnitEntity.getStorage().getName());
                StorageServiceTest.this.storageService.deleteStorage(alternateKey);
            }
        });
    }

    @Test
    public void testDeleteStorageInvalidName() {
        try {
            this.storageService.deleteStorage(new StorageKey(INVALID_VALUE));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", INVALID_VALUE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetAllStorage() {
        List storageKeys = this.storageDaoTestHelper.getTestStorageKeys();
        for (StorageKey storageKey : storageKeys) {
            this.storageDaoTestHelper.createStorageEntity(storageKey.getStorageName());
        }
        StorageKeys result = this.storageService.getAllStorage();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getStorageKeys().containsAll(storageKeys));
    }

    @Test
    public void testGetStorage() {
        Storage storage = this.storageService.createStorage(this.getNewStorageCreateRequest());
        Storage result = this.storageService.getStorage(new StorageKey(storage.getName()));
        Assert.assertEquals((Object)storage, (Object)result);
    }

    @Test
    public void testGetStorageInvalidStorageName() {
        try {
            this.storageService.getStorage(new StorageKey(INVALID_VALUE));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", INVALID_VALUE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStorage() {
        Storage storage = this.storageService.createStorage(this.getNewStorageCreateRequest());
        Storage result = this.storageService.updateStorage(new StorageKey(storage.getName()), new StorageUpdateRequest());
        Assert.assertEquals((Object)new Storage(storage.getName(), storage.getStoragePlatformName(), storage.getAttributes()), (Object)result);
    }

    @Test
    public void testUpdateStorageAttributes() {
        StorageCreateRequest request = this.getNewStorageCreateRequest();
        Storage storage = this.storageService.createStorage(request);
        Storage result = this.storageService.updateStorageAttributes(new StorageKey(storage.getName()), new StorageAttributesUpdateRequest(this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
        Assert.assertEquals((Object)new Storage(storage.getName(), storage.getStoragePlatformName(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()), (Object)result);
    }

    @Test
    public void testUpdateStorageAttributesRemoveAllAttributes() {
        StorageCreateRequest request = this.getNewStorageCreateRequest();
        Storage storage = this.storageService.createStorage(request);
        Storage result = this.storageService.updateStorageAttributes(new StorageKey(storage.getName()), new StorageAttributesUpdateRequest(NO_ATTRIBUTES));
        Assert.assertEquals((Object)new Storage(storage.getName(), storage.getStoragePlatformName(), NO_ATTRIBUTES), (Object)result);
    }

    @Test
    public void testUpdateStorageAttributesStorageHasDuplicateAttributes() {
        StorageCreateRequest request = this.getNewStorageCreateRequest();
        Storage storage = this.storageService.createStorage(request);
        StorageEntity storageEntity = this.storageDao.getStorageByName(storage.getName());
        StorageAttributeEntity storageAttributeEntity = new StorageAttributeEntity();
        storageAttributeEntity.setStorage(storageEntity);
        storageAttributeEntity.setName(((Attribute)request.getAttributes().get(0)).getName().toUpperCase());
        storageEntity.getAttributes().add(storageAttributeEntity);
        this.storageDao.saveAndRefresh((Object)storageEntity);
        try {
            this.storageService.updateStorageAttributes(new StorageKey(storage.getName()), new StorageAttributesUpdateRequest(this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Found duplicate attribute with name \"%s\" for \"%s\" storage.", ((Attribute)request.getAttributes().get(0)).getName().toLowerCase(), storage.getName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStorageAttributesStorageNoExists() {
        try {
            this.storageService.updateStorageAttributes(new StorageKey(INVALID_VALUE), new StorageAttributesUpdateRequest(this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", INVALID_VALUE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStorageStorageNoExists() {
        try {
            this.storageService.updateStorage(new StorageKey(INVALID_VALUE), new StorageUpdateRequest());
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", INVALID_VALUE), (Object)e.getMessage());
        }
    }

    private StorageCreateRequest getNewStorageCreateRequest() {
        return new StorageCreateRequest(STORAGE_NAME, "S3", this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
    }
}

