/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.JobAction;
import org.finra.herd.model.api.xml.NotificationRegistrationKey;
import org.finra.herd.model.api.xml.StorageUnitNotificationFilter;
import org.finra.herd.model.api.xml.StorageUnitNotificationRegistration;
import org.finra.herd.model.api.xml.StorageUnitNotificationRegistrationCreateRequest;
import org.finra.herd.model.api.xml.StorageUnitNotificationRegistrationKeys;
import org.finra.herd.model.api.xml.StorageUnitNotificationRegistrationUpdateRequest;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.model.jpa.StorageUnitNotificationRegistrationEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class StorageUnitNotificationRegistrationServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateStorageUnitNotificationRegistration() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting();
        StorageUnitNotificationRegistration result = this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "DISABLED"));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(result.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "DISABLED"), (Object)result);
    }

    @Test
    public void testCreateStorageUnitNotificationRegistrationAlreadyExists() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an AlreadyExistsException when storage unit notification already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create storage unit notification with name \"%s\" because it already exists for namespace \"%s\".", notificationRegistrationKey.getNotificationName(), notificationRegistrationKey.getNamespace()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStorageUnitNotificationRegistrationDuplicateJobActions() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting();
        StorageUnitNotificationRegistrationCreateRequest request = new StorageUnitNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), Arrays.asList(new JobAction(NAMESPACE.toLowerCase(), JOB_NAME.toLowerCase(), CORRELATION_DATA), new JobAction(NAMESPACE.toUpperCase(), JOB_NAME.toUpperCase(), CORRELATION_DATA)), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when create request contains duplicate job actions.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate job action {namespace: \"%s\", jobName: \"%s\"} found.", ((JobAction)request.getJobActions().get(1)).getNamespace(), ((JobAction)request.getJobActions().get(1)).getJobName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStorageUnitNotificationRegistrationInvalidParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting();
        StorageUnitNotificationRegistrationCreateRequest request = new StorageUnitNotificationRegistrationCreateRequest(new NotificationRegistrationKey("I_DO_NOT_EXIST", NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing namespace.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", request.getStorageUnitNotificationRegistrationKey().getNamespace()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(new NotificationRegistrationKey(this.addSlash(NAMESPACE), NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE, this.addSlash(NOTIFICATION_NAME)), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when notification name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Notification name can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, "I_DO_NOT_EXIST", new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing notification event type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Notification event type with code \"%s\" doesn't exist.", request.getStorageUnitEventType()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NOTIFICATION_EVENT_TYPE, new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using non-supported notification event type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Notification event type \"%s\" is not supported for storage unit notification registration.", request.getStorageUnitEventType()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object definition name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", request.getStorageUnitNotificationFilter().getBusinessObjectDefinitionName(), request.getStorageUnitNotificationFilter().getNamespace()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object format file type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("File type with code \"%s\" doesn't exist.", request.getStorageUnitNotificationFilter().getBusinessObjectFormatFileType()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", request.getStorageUnitNotificationFilter().getStorageName()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, "I_DO_NOT_EXIST", STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing new storage unit status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage unit status \"%s\" doesn't exist.", request.getStorageUnitNotificationFilter().getNewStorageUnitStatus()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, "I_DO_NOT_EXIST"), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing old storage unit status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage unit status \"%s\" doesn't exist.", request.getStorageUnitNotificationFilter().getOldStorageUnitStatus()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS.toUpperCase(), STORAGE_UNIT_STATUS.toLowerCase()), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using new and old storage unit statuses that are the same");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The new storage unit status is the same as the old one.", (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), Arrays.asList(new JobAction(NAMESPACE, "I_DO_NOT_EXIST", CORRELATION_DATA)), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing job definition.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Job definition with namespace \"%s\" and job name \"%s\" doesn't exist.", ((JobAction)request.getJobActions().get(0)).getNamespace(), ((JobAction)request.getJobActions().get(0)).getJobName()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "I_DO_NOT_EXIST");
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing notification registration status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("The notification registration status \"%s\" doesn't exist.", request.getNotificationRegistrationStatus()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStorageUnitNotificationRegistrationLowerCaseParameters() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(NAMESPACE.toUpperCase(), Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name()), BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), Arrays.asList(FORMAT_FILE_TYPE_CODE.toUpperCase()), Arrays.asList(STORAGE_NAME.toUpperCase()), Arrays.asList(STORAGE_UNIT_STATUS.toUpperCase(), STORAGE_UNIT_STATUS_2.toUpperCase()), Arrays.asList(new JobAction(NAMESPACE.toUpperCase(), JOB_NAME.toUpperCase(), "      \t\t ")));
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase()), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toLowerCase(), new StorageUnitNotificationFilter(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, STORAGE_NAME.toLowerCase(), STORAGE_UNIT_STATUS.toLowerCase(), STORAGE_UNIT_STATUS_2.toLowerCase()), Arrays.asList(new JobAction(NAMESPACE.toLowerCase(), JOB_NAME.toLowerCase(), CORRELATION_DATA.toLowerCase())), "ENABLED".toLowerCase()));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toLowerCase()), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, STORAGE_NAME.toUpperCase(), STORAGE_UNIT_STATUS.toUpperCase(), STORAGE_UNIT_STATUS_2.toUpperCase()), Arrays.asList(new JobAction(NAMESPACE.toUpperCase(), JOB_NAME.toUpperCase(), CORRELATION_DATA.toLowerCase())), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testCreateStorageUnitNotificationRegistrationMissingOptionalParametersPassedAsNulls() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting();
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, null, null, null, STORAGE_NAME, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE, JOB_NAME, null)), null));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, null, null, null, STORAGE_NAME, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE, JOB_NAME, null)), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testCreateStorageUnitNotificationRegistrationMissingOptionalParametersPassedAsWhitespace() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting();
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, "      \t\t ", "      \t\t ", null, STORAGE_NAME, "      \t\t ", "      \t\t "), Arrays.asList(new JobAction(JOB_NAMESPACE, JOB_NAME, "      \t\t ")), "      \t\t "));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, null, null, null, STORAGE_NAME, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE, JOB_NAME, "      \t\t ")), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testCreateStorageUnitNotificationRegistrationMissingRequiredParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(new NotificationRegistrationKey("      \t\t ", NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE, "      \t\t "), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when notification name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A notification name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, "      \t\t ", new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage unit notification event type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage unit event type must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), null, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when job actions are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one notification action must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), Arrays.asList(new JobAction("      \t\t ", JOB_NAME, CORRELATION_DATA)), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when job action job namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A job action namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), Arrays.asList(new JobAction(NAMESPACE, "      \t\t ", CORRELATION_DATA)), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when job action job name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A job action job name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateStorageUnitNotificationRegistrationTrimParameters() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting();
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(new NotificationRegistrationKey(this.addWhitespace(NAMESPACE), this.addWhitespace(NOTIFICATION_NAME)), this.addWhitespace(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name()), new StorageUnitNotificationFilter(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(STORAGE_NAME), this.addWhitespace(STORAGE_UNIT_STATUS), this.addWhitespace(STORAGE_UNIT_STATUS_2)), Arrays.asList(new JobAction(this.addWhitespace(JOB_NAMESPACE), this.addWhitespace(JOB_NAME), this.addWhitespace(CORRELATION_DATA))), this.addWhitespace("ENABLED")));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), Arrays.asList(new JobAction(JOB_NAMESPACE, JOB_NAME, this.addWhitespace(CORRELATION_DATA))), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testCreateStorageUnitNotificationRegistrationUpperCaseParameters() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(NAMESPACE.toLowerCase(), Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name()), BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), Arrays.asList(FORMAT_FILE_TYPE_CODE.toLowerCase()), Arrays.asList(STORAGE_NAME.toLowerCase()), Arrays.asList(STORAGE_UNIT_STATUS.toLowerCase(), STORAGE_UNIT_STATUS_2.toLowerCase()), Arrays.asList(new JobAction(NAMESPACE.toLowerCase(), JOB_NAME.toLowerCase(), "      \t\t ")));
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.createStorageUnitNotificationRegistration(new StorageUnitNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase()), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toUpperCase(), new StorageUnitNotificationFilter(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, STORAGE_NAME.toUpperCase(), STORAGE_UNIT_STATUS.toUpperCase(), STORAGE_UNIT_STATUS_2.toUpperCase()), Arrays.asList(new JobAction(NAMESPACE.toUpperCase(), JOB_NAME.toUpperCase(), CORRELATION_DATA.toUpperCase())), "ENABLED".toUpperCase()));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toUpperCase()), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, STORAGE_NAME.toLowerCase(), STORAGE_UNIT_STATUS.toLowerCase(), STORAGE_UNIT_STATUS_2.toLowerCase()), Arrays.asList(new JobAction(NAMESPACE.toLowerCase(), JOB_NAME.toLowerCase(), CORRELATION_DATA.toUpperCase())), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testDeleteStorageUnitNotificationRegistration() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        StorageUnitNotificationRegistrationEntity storageUnitNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertNotNull((Object)this.storageUnitNotificationRegistrationDao.getStorageUnitNotificationRegistrationByAltKey(notificationRegistrationKey));
        StorageUnitNotificationRegistration deletedStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.deleteStorageUnitNotificationRegistration(notificationRegistrationKey);
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(storageUnitNotificationRegistrationEntity.getId().intValue(), new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)deletedStorageUnitNotificationRegistration);
        Assert.assertNull((Object)this.storageUnitNotificationRegistrationDao.getStorageUnitNotificationRegistrationByAltKey(notificationRegistrationKey));
    }

    @Test
    public void testDeleteStorageUnitNotificationRegistrationLowerCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase());
        StorageUnitNotificationRegistrationEntity storageUnitNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertNotNull((Object)this.storageUnitNotificationRegistrationDao.getStorageUnitNotificationRegistrationByAltKey(notificationRegistrationKey));
        StorageUnitNotificationRegistration deletedStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.deleteStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase()));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(storageUnitNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)deletedStorageUnitNotificationRegistration);
        Assert.assertNull((Object)this.storageUnitNotificationRegistrationDao.getStorageUnitNotificationRegistrationByAltKey(notificationRegistrationKey));
    }

    @Test
    public void testDeleteStorageUnitNotificationRegistrationMissingRequiredParameters() {
        try {
            this.storageUnitNotificationRegistrationService.deleteStorageUnitNotificationRegistration(new NotificationRegistrationKey("      \t\t ", NOTIFICATION_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.deleteStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when notification name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A notification name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteStorageUnitNotificationRegistrationStorageUnitNotificationNoExists() {
        try {
            this.storageUnitNotificationRegistrationService.deleteStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when trying to delete a non-existing storage unit notification.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage unit notification registration with name \"%s\" does not exist for \"%s\" namespace.", NOTIFICATION_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteStorageUnitNotificationRegistrationTrimParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        StorageUnitNotificationRegistrationEntity storageUnitNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertNotNull((Object)this.storageUnitNotificationRegistrationDao.getStorageUnitNotificationRegistrationByAltKey(notificationRegistrationKey));
        StorageUnitNotificationRegistration deletedStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.deleteStorageUnitNotificationRegistration(new NotificationRegistrationKey(this.addWhitespace(NAMESPACE), this.addWhitespace(NOTIFICATION_NAME)));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(storageUnitNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)deletedStorageUnitNotificationRegistration);
        Assert.assertNull((Object)this.storageUnitNotificationRegistrationDao.getStorageUnitNotificationRegistrationByAltKey(notificationRegistrationKey));
    }

    @Test
    public void testDeleteStorageUnitNotificationRegistrationUpperCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase());
        StorageUnitNotificationRegistrationEntity storageUnitNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertNotNull((Object)this.storageUnitNotificationRegistrationDao.getStorageUnitNotificationRegistrationByAltKey(notificationRegistrationKey));
        StorageUnitNotificationRegistration deletedStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.deleteStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase()));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(storageUnitNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)deletedStorageUnitNotificationRegistration);
        Assert.assertNull((Object)this.storageUnitNotificationRegistrationDao.getStorageUnitNotificationRegistrationByAltKey(notificationRegistrationKey));
    }

    @Test
    public void testGetStorageUnitNotificationRegistration() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistration(notificationRegistrationKey);
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationLowerCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase());
        StorageUnitNotificationRegistrationEntity storageUnitNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase()));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(storageUnitNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationMissingRequiredParameters() {
        try {
            this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistration(new NotificationRegistrationKey("      \t\t ", NOTIFICATION_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when notification name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A notification name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationNoExists() {
        try {
            this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when trying to retrieve a non-existing storage unit notification.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage unit notification registration with name \"%s\" does not exist for \"%s\" namespace.", NOTIFICATION_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationTrimParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        StorageUnitNotificationRegistrationEntity storageUnitNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistration(new NotificationRegistrationKey(this.addWhitespace(NAMESPACE), this.addWhitespace(NOTIFICATION_NAME)));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(storageUnitNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationUpperCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase());
        StorageUnitNotificationRegistrationEntity storageUnitNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase()));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(storageUnitNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNamespace() {
        for (NotificationRegistrationKey notificationRegistrationKey : this.notificationRegistrationDaoTestHelper.getTestNotificationRegistrationKeys()) {
            this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, STORAGE_NAME, null, null, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        }
        StorageUnitNotificationRegistrationKeys resultKeys = this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNamespace(NAMESPACE);
        Assert.assertEquals((Object)this.notificationRegistrationDaoTestHelper.getExpectedNotificationRegistrationKeys(), (Object)resultKeys.getStorageUnitNotificationRegistrationKeys());
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNamespaceLowerCaseParameters() {
        for (NotificationRegistrationKey notificationRegistrationKey : this.notificationRegistrationDaoTestHelper.getTestNotificationRegistrationKeys()) {
            NotificationRegistrationKey notificationRegistrationKeyUpperCase = new NotificationRegistrationKey(notificationRegistrationKey.getNamespace().toUpperCase(), notificationRegistrationKey.getNotificationName().toUpperCase());
            this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKeyUpperCase, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        }
        StorageUnitNotificationRegistrationKeys resultKeys = this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNamespace(NAMESPACE.toLowerCase());
        ArrayList<NotificationRegistrationKey> expectedKeys = new ArrayList<NotificationRegistrationKey>();
        for (NotificationRegistrationKey origKey : this.notificationRegistrationDaoTestHelper.getExpectedNotificationRegistrationKeys()) {
            NotificationRegistrationKey expectedKey = new NotificationRegistrationKey();
            expectedKeys.add(expectedKey);
            expectedKey.setNamespace(origKey.getNamespace().toUpperCase());
            expectedKey.setNotificationName(origKey.getNotificationName().toUpperCase());
        }
        Assert.assertEquals(expectedKeys, (Object)resultKeys.getStorageUnitNotificationRegistrationKeys());
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNamespaceMissingRequiredParameters() {
        try {
            this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNamespace("      \t\t ");
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNamespaceNamespaceNoExists() {
        try {
            this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNamespace(NAMESPACE);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing namespace.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNamespaceStorageUnitNotificationsNoExist() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting();
        StorageUnitNotificationRegistrationKeys resultKeys = this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNamespace(NAMESPACE);
        Assert.assertEquals(new ArrayList(), (Object)resultKeys.getStorageUnitNotificationRegistrationKeys());
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNamespaceTrimParameters() {
        for (NotificationRegistrationKey notificationRegistrationKey : this.notificationRegistrationDaoTestHelper.getTestNotificationRegistrationKeys()) {
            this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        }
        StorageUnitNotificationRegistrationKeys resultKeys = this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNamespace(this.addWhitespace(NAMESPACE));
        Assert.assertEquals((Object)this.notificationRegistrationDaoTestHelper.getExpectedNotificationRegistrationKeys(), (Object)resultKeys.getStorageUnitNotificationRegistrationKeys());
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNamespaceUpperCaseParameters() {
        for (NotificationRegistrationKey notificationRegistrationKey : this.notificationRegistrationDaoTestHelper.getTestNotificationRegistrationKeys()) {
            NotificationRegistrationKey notificationRegistrationKeyLowerCase = new NotificationRegistrationKey(notificationRegistrationKey.getNamespace().toLowerCase(), notificationRegistrationKey.getNotificationName().toLowerCase());
            this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKeyLowerCase, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        }
        StorageUnitNotificationRegistrationKeys resultKeys = this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNamespace(NAMESPACE.toUpperCase());
        ArrayList<NotificationRegistrationKey> expectedKeys = new ArrayList<NotificationRegistrationKey>();
        for (NotificationRegistrationKey origKey : this.notificationRegistrationDaoTestHelper.getExpectedNotificationRegistrationKeys()) {
            NotificationRegistrationKey expectedKey = new NotificationRegistrationKey();
            expectedKeys.add(expectedKey);
            expectedKey.setNamespace(origKey.getNamespace().toLowerCase());
            expectedKey.setNotificationName(origKey.getNotificationName().toLowerCase());
        }
        Assert.assertEquals(expectedKeys, (Object)resultKeys.getStorageUnitNotificationRegistrationKeys());
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNotificationFilter() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new StorageUnitNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)));
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNotificationFilterInvalidParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new StorageUnitNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)));
        Assert.assertTrue((boolean)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter("I_DO_NO_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)).getStorageUnitNotificationRegistrationKeys().isEmpty());
        Assert.assertTrue((boolean)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(BDEF_NAMESPACE, "I_DO_NO_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)).getStorageUnitNotificationRegistrationKeys().isEmpty());
        Assert.assertTrue((boolean)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, "I_DO_NO_EXIST", FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)).getStorageUnitNotificationRegistrationKeys().isEmpty());
        Assert.assertTrue((boolean)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NO_EXIST", NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)).getStorageUnitNotificationRegistrationKeys().isEmpty());
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNotificationFilterLowerCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new StorageUnitNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)));
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNotificationFilterMissingOptionalParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new StorageUnitNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, NO_FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, NO_FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)));
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNotificationFilterMissingRequiredParameters() {
        try {
            this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(NO_BDEF_NAMESPACE, BDEF_NAME, NO_FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(BDEF_NAMESPACE, NO_BDEF_NAME, NO_FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNotificationFilterTrimParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new StorageUnitNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)));
    }

    @Test
    public void testGetStorageUnitNotificationRegistrationsByNotificationFilterUpperCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new StorageUnitNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.storageUnitNotificationRegistrationService.getStorageUnitNotificationRegistrationsByNotificationFilter(new StorageUnitNotificationFilter(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS)));
    }

    @Test
    public void testUpdateStorageUnitNotificationRegistration() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name()), BDEF_NAMESPACE_2, BDEF_NAME_2, Arrays.asList(FORMAT_FILE_TYPE_CODE, FORMAT_FILE_TYPE_CODE_2), Arrays.asList(STORAGE_NAME, STORAGE_NAME_2), Arrays.asList(STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, STORAGE_UNIT_STATUS_3, STORAGE_UNIT_STATUS_4), this.notificationRegistrationDaoTestHelper.getTestJobActions2());
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, STORAGE_UNIT_STATUS_3, NO_STORAGE_UNIT_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "DISABLED"));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, STORAGE_UNIT_STATUS_3, NO_STORAGE_UNIT_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "DISABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testUpdateStorageUnitNotificationRegistrationInvalidParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), NOTIFICATION_EVENT_TYPE), BDEF_NAMESPACE_2, BDEF_NAME_2, Arrays.asList(FORMAT_FILE_TYPE_CODE, FORMAT_FILE_TYPE_CODE_2), Arrays.asList(STORAGE_NAME, STORAGE_NAME_2), Arrays.asList(STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, STORAGE_UNIT_STATUS_3, STORAGE_UNIT_STATUS_4), this.notificationRegistrationDaoTestHelper.getTestJobActions2());
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        StorageUnitNotificationRegistrationUpdateRequest request = new StorageUnitNotificationRegistrationUpdateRequest("I_DO_NOT_EXIST", new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing notification event type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Notification event type with code \"%s\" doesn't exist.", request.getStorageUnitEventType()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationUpdateRequest(NOTIFICATION_EVENT_TYPE, new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using non-supported notification event type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Notification event type \"%s\" is not supported for storage unit notification registration.", request.getStorageUnitEventType()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object definition name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", request.getStorageUnitNotificationFilter().getBusinessObjectDefinitionName(), request.getStorageUnitNotificationFilter().getNamespace()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object format file type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("File type with code \"%s\" doesn't exist.", request.getStorageUnitNotificationFilter().getBusinessObjectFormatFileType()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", request.getStorageUnitNotificationFilter().getStorageName()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, "I_DO_NOT_EXIST", STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing new storage unit status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage unit status \"%s\" doesn't exist.", request.getStorageUnitNotificationFilter().getNewStorageUnitStatus()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, "I_DO_NOT_EXIST"), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing old storage unit status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage unit status \"%s\" doesn't exist.", request.getStorageUnitNotificationFilter().getOldStorageUnitStatus()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS.toUpperCase(), STORAGE_UNIT_STATUS.toLowerCase()), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using new and old storage unit statuses that are the same");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The new storage unit status is the same as the old one.", (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), Arrays.asList(new JobAction(NAMESPACE, "I_DO_NOT_EXIST", CORRELATION_DATA)), "ENABLED");
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing job definition.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Job definition with namespace \"%s\" and job name \"%s\" doesn't exist.", ((JobAction)request.getJobActions().get(0)).getNamespace(), ((JobAction)request.getJobActions().get(0)).getJobName()), (Object)e.getMessage());
        }
        request = new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "I_DO_NOT_EXIST");
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing notification registration status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("The notification registration status \"%s\" doesn't exist.", request.getNotificationRegistrationStatus()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStorageUnitNotificationRegistrationLowerCaseParameters() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(NAMESPACE.toUpperCase(), Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toUpperCase(), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toUpperCase()), BDEF_NAMESPACE_2.toUpperCase(), BDEF_NAME_2.toUpperCase(), Arrays.asList(FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE_2.toUpperCase()), Arrays.asList(STORAGE_NAME.toUpperCase(), STORAGE_NAME_2.toUpperCase()), Arrays.asList(STORAGE_UNIT_STATUS.toUpperCase(), STORAGE_UNIT_STATUS_2.toUpperCase(), STORAGE_UNIT_STATUS_3.toUpperCase(), STORAGE_UNIT_STATUS_4.toUpperCase()), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toUpperCase(), JOB_NAME_2.toUpperCase(), null)));
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase());
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toUpperCase(), BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, STORAGE_NAME.toUpperCase(), STORAGE_UNIT_STATUS.toUpperCase(), STORAGE_UNIT_STATUS_2.toUpperCase(), Arrays.asList(new JobAction(JOB_NAMESPACE.toUpperCase(), JOB_NAME.toUpperCase(), CORRELATION_DATA)), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase()), new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toLowerCase(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2.toLowerCase(), BDEF_NAME_2.toLowerCase(), FORMAT_USAGE_CODE_2.toLowerCase(), FORMAT_FILE_TYPE_CODE_2.toLowerCase(), FORMAT_VERSION_2, STORAGE_NAME_2.toLowerCase(), STORAGE_UNIT_STATUS_3.toLowerCase(), NO_STORAGE_UNIT_STATUS), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toLowerCase(), JOB_NAME_2.toLowerCase(), CORRELATION_DATA_2.toLowerCase())), "enabled"));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toUpperCase(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2.toUpperCase(), BDEF_NAME_2.toUpperCase(), FORMAT_USAGE_CODE_2.toLowerCase(), FORMAT_FILE_TYPE_CODE_2.toUpperCase(), FORMAT_VERSION_2, STORAGE_NAME_2.toUpperCase(), STORAGE_UNIT_STATUS_3.toUpperCase(), NO_STORAGE_UNIT_STATUS), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toUpperCase(), JOB_NAME_2.toUpperCase(), CORRELATION_DATA_2.toLowerCase())), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testUpdateStorageUnitNotificationRegistrationMissingOptionalParametersPassedAsNulls() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name()), BDEF_NAMESPACE_2, BDEF_NAME_2, null, null, Arrays.asList(STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions());
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, null, null, null, STORAGE_NAME, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE_2, JOB_NAME_2, null)), "ENABLED"));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, null, null, null, STORAGE_NAME, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE_2, JOB_NAME_2, null)), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testUpdateStorageUnitNotificationRegistrationMissingOptionalParametersPassedAsWhitespace() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name()), BDEF_NAMESPACE_2, BDEF_NAME_2, null, null, Arrays.asList(STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions());
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(notificationRegistrationKey, new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, "      \t\t ", "      \t\t ", null, STORAGE_NAME, "      \t\t ", "      \t\t "), Arrays.asList(new JobAction(JOB_NAMESPACE_2, JOB_NAME_2, "      \t\t ")), "ENABLED"));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, null, null, null, STORAGE_NAME, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE_2, JOB_NAME_2, "      \t\t ")), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testUpdateStorageUnitNotificationRegistrationMissingRequiredParameters() {
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(new NotificationRegistrationKey("      \t\t ", NOTIFICATION_NAME), new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, "      \t\t "), new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when notification name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A notification name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when notification registration status is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A notification registration status must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStorageUnitNotificationRegistrationNoExists() {
        try {
            this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "ENABLED"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when trying to update a non-existing storage unit notification.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage unit notification registration with name \"%s\" does not exist for \"%s\" namespace.", NOTIFICATION_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateStorageUnitNotificationRegistrationTrimParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name()), BDEF_NAMESPACE_2, BDEF_NAME_2, Arrays.asList(FORMAT_FILE_TYPE_CODE, FORMAT_FILE_TYPE_CODE_2), Arrays.asList(STORAGE_NAME, STORAGE_NAME_2), Arrays.asList(STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, STORAGE_UNIT_STATUS_3, STORAGE_UNIT_STATUS_4), this.notificationRegistrationDaoTestHelper.getTestJobActions2());
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(new NotificationRegistrationKey(this.addWhitespace(NAMESPACE), this.addWhitespace(NOTIFICATION_NAME)), new StorageUnitNotificationRegistrationUpdateRequest(this.addWhitespace(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name()), new StorageUnitNotificationFilter(this.addWhitespace(BDEF_NAMESPACE_2), this.addWhitespace(BDEF_NAME_2), this.addWhitespace(FORMAT_USAGE_CODE_2), this.addWhitespace(FORMAT_FILE_TYPE_CODE_2), FORMAT_VERSION_2, this.addWhitespace(STORAGE_NAME_2), this.addWhitespace(STORAGE_UNIT_STATUS_3), NO_STORAGE_UNIT_STATUS), Arrays.asList(new JobAction(this.addWhitespace(JOB_NAMESPACE_2), this.addWhitespace(JOB_NAME_2), this.addWhitespace(CORRELATION_DATA_2))), "      \t\t ENABLED      \t\t "));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, STORAGE_UNIT_STATUS_3, NO_STORAGE_UNIT_STATUS), Arrays.asList(new JobAction(JOB_NAMESPACE_2, JOB_NAME_2, this.addWhitespace(CORRELATION_DATA_2))), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testUpdateStorageUnitNotificationRegistrationUpperCaseParameters() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(NAMESPACE.toLowerCase(), Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toLowerCase(), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toLowerCase()), BDEF_NAMESPACE_2.toLowerCase(), BDEF_NAME_2.toLowerCase(), Arrays.asList(FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE_2.toLowerCase()), Arrays.asList(STORAGE_NAME.toLowerCase(), STORAGE_NAME_2.toLowerCase()), Arrays.asList(STORAGE_UNIT_STATUS.toLowerCase(), STORAGE_UNIT_STATUS_2.toLowerCase(), STORAGE_UNIT_STATUS_3.toLowerCase(), STORAGE_UNIT_STATUS_4.toLowerCase()), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toLowerCase(), JOB_NAME_2.toLowerCase(), null)));
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase());
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toLowerCase(), BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, STORAGE_NAME.toLowerCase(), STORAGE_UNIT_STATUS.toLowerCase(), STORAGE_UNIT_STATUS_2.toLowerCase(), Arrays.asList(new JobAction(JOB_NAMESPACE.toLowerCase(), JOB_NAME.toLowerCase(), CORRELATION_DATA)), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase()), new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toUpperCase(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2.toUpperCase(), BDEF_NAME_2.toUpperCase(), FORMAT_USAGE_CODE_2.toUpperCase(), FORMAT_FILE_TYPE_CODE_2.toUpperCase(), FORMAT_VERSION_2, STORAGE_NAME_2.toUpperCase(), STORAGE_UNIT_STATUS_3.toUpperCase(), NO_STORAGE_UNIT_STATUS), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toUpperCase(), JOB_NAME_2.toUpperCase(), CORRELATION_DATA_2.toUpperCase())), "ENABLED"));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase()), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name().toLowerCase(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2.toLowerCase(), BDEF_NAME_2.toLowerCase(), FORMAT_USAGE_CODE_2.toUpperCase(), FORMAT_FILE_TYPE_CODE_2.toLowerCase(), FORMAT_VERSION_2, STORAGE_NAME_2.toLowerCase(), STORAGE_UNIT_STATUS_3.toLowerCase(), NO_STORAGE_UNIT_STATUS), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toLowerCase(), JOB_NAME_2.toLowerCase(), CORRELATION_DATA_2.toUpperCase())), "ENABLED"), (Object)resultStorageUnitNotificationRegistration);
    }

    @Test
    public void testUpdateStorageUnitNotificationRegistrationWithDisabledStatus() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name()), BDEF_NAMESPACE_2, BDEF_NAME_2, Arrays.asList(FORMAT_FILE_TYPE_CODE, FORMAT_FILE_TYPE_CODE_2), Arrays.asList(STORAGE_NAME, STORAGE_NAME_2), Arrays.asList(STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, STORAGE_UNIT_STATUS_3, STORAGE_UNIT_STATUS_4), this.notificationRegistrationDaoTestHelper.getTestJobActions2());
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        StorageUnitNotificationRegistration resultStorageUnitNotificationRegistration = this.storageUnitNotificationRegistrationService.updateStorageUnitNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), new StorageUnitNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, STORAGE_UNIT_STATUS_3, NO_STORAGE_UNIT_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "DISABLED"));
        Assert.assertEquals((Object)new StorageUnitNotificationRegistration(resultStorageUnitNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), new StorageUnitNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, STORAGE_UNIT_STATUS_3, NO_STORAGE_UNIT_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "DISABLED"), (Object)resultStorageUnitNotificationRegistration);
    }
}

