/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StorageUnitDownloadCredential;
import org.finra.herd.model.api.xml.StorageUnitUploadCredential;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class StorageUnitServiceGetCredentialTest
extends AbstractServiceTest {
    @Test
    public void getStorageUnitUploadCredentialWithBdataVersion() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
        businessObjectDataKey.setNamespace(NAMESPACE);
        businessObjectDataKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        businessObjectDataKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        businessObjectDataKey.setBusinessObjectFormatVersion(FORMAT_VERSION);
        businessObjectDataKey.setPartitionValue(PARTITION_VALUE);
        businessObjectDataKey.setBusinessObjectDataVersion(DATA_VERSION);
        Boolean createNewVersion = false;
        String storageName = STORAGE_NAME;
        this.createBusinessObjectFormatEntity(businessObjectDataKey);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), "testRole"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucket"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"));
        this.storageDaoTestHelper.createStorageEntity(storageName, "S3", attributes);
        StorageUnitUploadCredential storageUnitUploadCredential = this.storageUnitService.getStorageUnitUploadCredential(businessObjectDataKey, createNewVersion, storageName);
        Assert.assertNotNull((Object)storageUnitUploadCredential);
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsAccessKey());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSecretKey());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSessionToken());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSessionExpirationTime());
    }

    @Test
    public void getStorageUnitUploadCredentialWithCreateNewVersion() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
        businessObjectDataKey.setNamespace(NAMESPACE);
        businessObjectDataKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        businessObjectDataKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        businessObjectDataKey.setBusinessObjectFormatVersion(FORMAT_VERSION);
        businessObjectDataKey.setPartitionValue(PARTITION_VALUE);
        Boolean createNewVersion = true;
        String storageName = STORAGE_NAME;
        this.createBusinessObjectFormatEntity(businessObjectDataKey);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), "testRole"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucket"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"));
        this.storageDaoTestHelper.createStorageEntity(storageName, "S3", attributes);
        StorageUnitUploadCredential storageUnitUploadCredential = this.storageUnitService.getStorageUnitUploadCredential(businessObjectDataKey, createNewVersion, storageName);
        Assert.assertNotNull((Object)storageUnitUploadCredential);
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsAccessKey());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSecretKey());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSessionToken());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSessionExpirationTime());
    }

    @Test
    public void getStorageUnitUploadCredentialUseStorageAttributeDuration() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
        businessObjectDataKey.setNamespace(NAMESPACE);
        businessObjectDataKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        businessObjectDataKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        businessObjectDataKey.setBusinessObjectFormatVersion(FORMAT_VERSION);
        businessObjectDataKey.setPartitionValue(PARTITION_VALUE);
        businessObjectDataKey.setBusinessObjectDataVersion(DATA_VERSION);
        Boolean createNewVersion = false;
        String storageName = STORAGE_NAME;
        this.createBusinessObjectFormatEntity(businessObjectDataKey);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), "testRole"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucket"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_SESSION_DURATION_SECS), "12345"));
        this.storageDaoTestHelper.createStorageEntity(storageName, "S3", attributes);
        StorageUnitUploadCredential storageUnitUploadCredential = this.storageUnitService.getStorageUnitUploadCredential(businessObjectDataKey, createNewVersion, storageName);
        Assert.assertNotNull((Object)storageUnitUploadCredential);
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsAccessKey());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSecretKey());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSessionToken());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSessionExpirationTime());
    }

    @Test
    public void getStorageUnitUploadCredentialAssertOneOfBdataOrCreateNewVersionRequired() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
        businessObjectDataKey.setNamespace(NAMESPACE);
        businessObjectDataKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        businessObjectDataKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        businessObjectDataKey.setBusinessObjectFormatVersion(FORMAT_VERSION);
        businessObjectDataKey.setPartitionValue(PARTITION_VALUE);
        businessObjectDataKey.setBusinessObjectDataVersion(null);
        Boolean createNewVersion = null;
        String storageName = STORAGE_NAME;
        this.createBusinessObjectFormatEntity(businessObjectDataKey);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), "testRole"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucket"));
        this.storageDaoTestHelper.createStorageEntity(storageName, "S3", attributes);
        try {
            this.storageUnitService.getStorageUnitUploadCredential(businessObjectDataKey, createNewVersion, storageName);
            Assert.fail((String)"Expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"One of businessObjectDataVersion or createNewVersion must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void getStorageUnitUploadCredentialAssertBDataVersionAndCreateNewVersionExclusive() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
        businessObjectDataKey.setNamespace(NAMESPACE);
        businessObjectDataKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        businessObjectDataKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        businessObjectDataKey.setBusinessObjectFormatVersion(FORMAT_VERSION);
        businessObjectDataKey.setPartitionValue(PARTITION_VALUE);
        businessObjectDataKey.setBusinessObjectDataVersion(DATA_VERSION);
        Boolean createNewVersion = true;
        String storageName = STORAGE_NAME;
        this.createBusinessObjectFormatEntity(businessObjectDataKey);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), "testRole"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucket"));
        this.storageDaoTestHelper.createStorageEntity(storageName, "S3", attributes);
        try {
            this.storageUnitService.getStorageUnitUploadCredential(businessObjectDataKey, createNewVersion, storageName);
            Assert.fail((String)"Expected an IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"createNewVersion must be false or unspecified when businessObjectDataVersion is specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void getStorageUnitDownloadCredential() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
        businessObjectDataKey.setNamespace(NAMESPACE);
        businessObjectDataKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        businessObjectDataKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        businessObjectDataKey.setBusinessObjectFormatVersion(FORMAT_VERSION);
        businessObjectDataKey.setPartitionValue(PARTITION_VALUE);
        businessObjectDataKey.setBusinessObjectDataVersion(DATA_VERSION);
        String storageName = STORAGE_NAME;
        this.createBusinessObjectFormatEntity(businessObjectDataKey);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_DOWNLOAD_ROLE_ARN), "testRole"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucket"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"));
        this.storageDaoTestHelper.createStorageEntity(storageName, "S3", attributes);
        StorageUnitDownloadCredential storageUnitDownloadCredential = this.storageUnitService.getStorageUnitDownloadCredential(businessObjectDataKey, storageName);
        Assert.assertNotNull((Object)storageUnitDownloadCredential);
        Assert.assertNotNull((Object)storageUnitDownloadCredential.getAwsCredential());
        Assert.assertNotNull((Object)storageUnitDownloadCredential.getAwsCredential().getAwsAccessKey());
        Assert.assertNotNull((Object)storageUnitDownloadCredential.getAwsCredential().getAwsSecretKey());
        Assert.assertNotNull((Object)storageUnitDownloadCredential.getAwsCredential().getAwsSessionToken());
        Assert.assertNotNull((Object)storageUnitDownloadCredential.getAwsCredential().getAwsSessionExpirationTime());
    }

    @Test
    public void getStorageUnitUploadCredentialWithInvalidDurationStorageAttribute() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
        businessObjectDataKey.setNamespace(NAMESPACE);
        businessObjectDataKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        businessObjectDataKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        businessObjectDataKey.setBusinessObjectFormatVersion(FORMAT_VERSION);
        businessObjectDataKey.setPartitionValue(PARTITION_VALUE);
        businessObjectDataKey.setBusinessObjectDataVersion(DATA_VERSION);
        Boolean createNewVersion = false;
        String storageName = STORAGE_NAME;
        this.createBusinessObjectFormatEntity(businessObjectDataKey);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), "testRole"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucket"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_SESSION_DURATION_SECS), "notAValidInteger"));
        this.storageDaoTestHelper.createStorageEntity(storageName, "S3", attributes);
        try {
            this.storageUnitService.getStorageUnitUploadCredential(businessObjectDataKey, createNewVersion, storageName);
            Assert.fail((String)"Expected an IllegalStateException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)"Storage attribute \"upload.session.duration.secs\" must be a valid integer. Actual value is \"notAValidInteger\"", (Object)e.getMessage());
        }
    }

    @Test
    public void getStorageUnitUploadCredentialWithKmsId() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
        businessObjectDataKey.setNamespace(NAMESPACE);
        businessObjectDataKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        businessObjectDataKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        businessObjectDataKey.setBusinessObjectFormatVersion(FORMAT_VERSION);
        businessObjectDataKey.setPartitionValue(PARTITION_VALUE);
        Boolean createNewVersion = true;
        String storageName = STORAGE_NAME;
        this.createBusinessObjectFormatEntity(businessObjectDataKey);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), "testRole"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucket"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KMS_KEY_ID), "test"));
        this.storageDaoTestHelper.createStorageEntity(storageName, "S3", attributes);
        StorageUnitUploadCredential storageUnitUploadCredential = this.storageUnitService.getStorageUnitUploadCredential(businessObjectDataKey, createNewVersion, storageName);
        Assert.assertNotNull((Object)storageUnitUploadCredential);
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsAccessKey());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSecretKey());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSessionToken());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSessionExpirationTime());
        Assert.assertEquals((Object)"test", (Object)storageUnitUploadCredential.getAwsKmsKeyId());
    }

    @Test
    public void getStorageUnitUploadCredentialAssertStorageNameTrim() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey();
        businessObjectDataKey.setNamespace(NAMESPACE);
        businessObjectDataKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        businessObjectDataKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        businessObjectDataKey.setBusinessObjectFormatVersion(FORMAT_VERSION);
        businessObjectDataKey.setPartitionValue(PARTITION_VALUE);
        Boolean createNewVersion = true;
        String storageName = STORAGE_NAME;
        this.createBusinessObjectFormatEntity(businessObjectDataKey);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), "testRole"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucket"));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"));
        this.storageDaoTestHelper.createStorageEntity(storageName, "S3", attributes);
        StorageUnitUploadCredential storageUnitUploadCredential = this.storageUnitService.getStorageUnitUploadCredential(businessObjectDataKey, createNewVersion, "      \t\t " + storageName + "      \t\t ");
        Assert.assertNotNull((Object)storageUnitUploadCredential);
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsAccessKey());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSecretKey());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSessionToken());
        Assert.assertNotNull((Object)storageUnitUploadCredential.getAwsCredential().getAwsSessionExpirationTime());
    }

    private void createBusinessObjectFormatEntity(BusinessObjectDataKey businessObjectDataKey) {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(businessObjectDataKey.getNamespace(), businessObjectDataKey.getBusinessObjectDefinitionName(), businessObjectDataKey.getBusinessObjectFormatUsage(), businessObjectDataKey.getBusinessObjectFormatFileType(), businessObjectDataKey.getBusinessObjectFormatVersion(), null, Boolean.valueOf(true), PARTITION_KEY, null, null, null, null, null, null, null);
    }
}

