/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.JobAction;
import org.finra.herd.model.api.xml.JobDefinition;
import org.finra.herd.model.api.xml.NotificationRegistrationKey;
import org.finra.herd.model.dto.BusinessObjectDataNotificationEventParamsDto;
import org.finra.herd.model.dto.NotificationEventParamsDto;
import org.finra.herd.model.dto.StorageUnitNotificationEventParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.model.jpa.NotificationJobActionEntity;
import org.finra.herd.model.jpa.StorageUnitNotificationRegistrationEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.NotificationActionService;
import org.junit.Assert;
import org.junit.Test;

public class StorageUnitStatusChangeNotificationJobActionServiceTest
extends AbstractServiceTest {
    @Test
    public void testGetIdentifyingInformation() throws Exception {
        JobDefinition jobDefinition = this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/activitiWorkflowLogVariablesNoRegex.bpmn20.xml");
        ArrayList<JobAction> jobActions = new ArrayList<JobAction>();
        jobActions.add(new JobAction(jobDefinition.getNamespace(), jobDefinition.getJobName(), CORRELATION_DATA));
        StorageUnitNotificationRegistrationEntity storageUnitNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, jobActions, "ENABLED");
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        StorageUnitNotificationEventParamsDto storageUnitNotificationEventParamsDto = new StorageUnitNotificationEventParamsDto();
        storageUnitNotificationEventParamsDto.setBusinessObjectData(this.businessObjectDataHelper.createBusinessObjectDataFromEntity(businessObjectDataEntity));
        storageUnitNotificationEventParamsDto.setStorageUnitNotificationRegistration(storageUnitNotificationRegistrationEntity);
        storageUnitNotificationEventParamsDto.setEventType(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name());
        storageUnitNotificationEventParamsDto.setNotificationJobAction((NotificationJobActionEntity)storageUnitNotificationRegistrationEntity.getNotificationActions().toArray()[0]);
        storageUnitNotificationEventParamsDto.setStorageName(STORAGE_NAME);
        NotificationActionService notificationActionService = this.notificationActionFactory.getNotificationActionHandler("STRGE_UNIT", NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name());
        String expectedValue = String.format("namespace: \"%s\", actionId: \"%s\" with " + this.businessObjectDataHelper.businessObjectDataKeyToString(businessObjectDataKey) + ", storageName: \"%s\"", storageUnitNotificationRegistrationEntity.getNamespace().getCode(), ((NotificationJobActionEntity)storageUnitNotificationRegistrationEntity.getNotificationActions().toArray()[0]).getId(), STORAGE_NAME);
        Assert.assertEquals((Object)expectedValue, (Object)notificationActionService.getIdentifyingInformation((NotificationEventParamsDto)storageUnitNotificationEventParamsDto, this.businessObjectDataHelper));
    }

    @Test
    public void testGetIdentifyingInformationInvalidParamsDto() {
        NotificationActionService notificationActionService = this.notificationActionFactory.getNotificationActionHandler("STRGE_UNIT", NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name());
        try {
            notificationActionService.getIdentifyingInformation((NotificationEventParamsDto)new BusinessObjectDataNotificationEventParamsDto(), this.businessObjectDataHelper);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Notification event parameters DTO passed to the method must be an instance of StorageUnitNotificationEventParamsDto.", (Object)e.getMessage());
        }
    }

    @Test
    public void testPerformNotificationActionInvalidParamsDto() throws Exception {
        NotificationActionService notificationActionService = this.notificationActionFactory.getNotificationActionHandler("STRGE_UNIT", NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name());
        try {
            notificationActionService.performNotificationAction((NotificationEventParamsDto)new BusinessObjectDataNotificationEventParamsDto());
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Notification event parameters DTO passed to the method must be an instance of StorageUnitNotificationEventParamsDto.", (Object)e.getMessage());
        }
    }
}

