/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.TagType;
import org.finra.herd.model.api.xml.TagTypeCreateRequest;
import org.finra.herd.model.api.xml.TagTypeKey;
import org.finra.herd.model.api.xml.TagTypeKeys;
import org.finra.herd.model.api.xml.TagTypeSearchRequest;
import org.finra.herd.model.api.xml.TagTypeSearchResponse;
import org.finra.herd.model.api.xml.TagTypeUpdateRequest;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.TagTypeServiceImpl;
import org.junit.Assert;
import org.junit.Test;

public class TagTypeServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateTagType() throws Exception {
        TagType resultTagType = this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION), (Object)resultTagType);
    }

    @Test
    public void testCreateTagTypeDisplayNameAlreadyExists() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(TAG_TYPE_2), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Display name \"%s\" already exists for tag type \"%s\".", TAG_TYPE_DISPLAY_NAME, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTypeInvalidParameters() {
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(this.addSlash(TAG_TYPE)), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Tag type code can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTypeMissingRequiredParameters() {
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey("      \t\t "), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(TAG_TYPE), "      \t\t ", TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A display name must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, null, TAG_TYPE_DESCRIPTION));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type order must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTypeTagTypeAlreadyExists() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        try {
            this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create tag type with code \"%s\" because it already exists.", TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTypeTrimParameters() throws Exception {
        TagType resultTagType = this.tagTypeService.createTagType(new TagTypeCreateRequest(new TagTypeKey(this.addWhitespace(TAG_TYPE)), this.addWhitespace(TAG_TYPE_DISPLAY_NAME), TAG_TYPE_ORDER, this.addWhitespace(TAG_TYPE_DESCRIPTION)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, this.addWhitespace(TAG_TYPE_DESCRIPTION)), (Object)resultTagType);
    }

    @Test
    public void testDeleteTagType() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.deleteTagType(new TagTypeKey(TAG_TYPE));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION), (Object)resultTagType);
        Assert.assertNull((Object)this.tagTypeDao.getTagTypeByKey(resultTagType.getTagTypeKey()));
    }

    @Test
    public void testDeleteTagTypeLowerCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.deleteTagType(new TagTypeKey(TAG_TYPE.toLowerCase()));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION), (Object)resultTagType);
        Assert.assertNull((Object)this.tagTypeDao.getTagTypeByKey(resultTagType.getTagTypeKey()));
    }

    @Test
    public void testDeleteTagTypeMissingRequiredParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        try {
            this.tagTypeService.deleteTagType(new TagTypeKey("      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteTagTypeTagTypeNotExists() {
        try {
            this.tagTypeService.deleteTagType(new TagTypeKey("I_DO_NOT_EXIST"));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag type with code \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteTagTypeTrimParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.deleteTagType(new TagTypeKey(this.addWhitespace(TAG_TYPE)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION), (Object)resultTagType);
        Assert.assertNull((Object)this.tagTypeDao.getTagTypeByKey(resultTagType.getTagTypeKey()));
    }

    @Test
    public void testDeleteTagTypeUpperCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.deleteTagType(new TagTypeKey(TAG_TYPE.toUpperCase()));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION), (Object)resultTagType);
        Assert.assertNull((Object)this.tagTypeDao.getTagTypeByKey(resultTagType.getTagTypeKey()));
    }

    @Test
    public void testGetTagType() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.getTagType(new TagTypeKey(TAG_TYPE));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION), (Object)resultTagType);
    }

    @Test
    public void testGetTagTypeLowerCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.getTagType(new TagTypeKey(TAG_TYPE.toLowerCase()));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION), (Object)resultTagType);
    }

    @Test
    public void testGetTagTypeMissingRequiredParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        try {
            this.tagTypeService.getTagType(new TagTypeKey("      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagTypeTagTypeNotExists() {
        try {
            this.tagTypeService.getTagType(new TagTypeKey(TAG_TYPE));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag type with code \"%s\" doesn't exist.", TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagTypeTrimParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.getTagType(new TagTypeKey(this.addWhitespace(TAG_TYPE)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION), (Object)resultTagType);
    }

    @Test
    public void testGetTagTypeUpperCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.getTagType(new TagTypeKey(TAG_TYPE.toUpperCase()));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION), (Object)resultTagType);
    }

    @Test
    public void testGetTagTypes() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2);
        TagTypeKeys resultTagTypeKeys = this.tagTypeService.getTagTypes();
        Assert.assertNotNull((Object)resultTagTypeKeys);
        Assert.assertEquals(Arrays.asList(new TagTypeKey(TAG_TYPE), new TagTypeKey(TAG_TYPE_2)), (Object)resultTagTypeKeys.getTagTypeKeys());
    }

    @Test
    public void testGetTagTypesTagTypesNoExist() {
        TagTypeKeys resultTagTypeKeys = this.tagTypeService.getTagTypes();
        Assert.assertNotNull((Object)resultTagTypeKeys);
        Assert.assertEquals((long)0L, (long)resultTagTypeKeys.getTagTypeKeys().size());
    }

    @Test
    public void testSearchTagTypes() {
        this.createDatabaseEntitiesForTagTypeSearchTesting();
        TagTypeSearchResponse tagTypeSearchResponse = this.tagTypeService.searchTagTypes(new TagTypeSearchRequest(), (Set)Sets.newHashSet((Object[])new String[]{TagTypeServiceImpl.DISPLAY_NAME_FIELD, TagTypeServiceImpl.TAG_TYPE_ORDER_FIELD, TagTypeServiceImpl.DESCRIPTION_FIELD}));
        Assert.assertEquals((Object)new TagTypeSearchResponse(Arrays.asList(new TagType(new TagTypeKey(TAG_TYPE_2), TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION_2), new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION))), (Object)tagTypeSearchResponse);
    }

    @Test
    public void testSearchTagTypesInvalidParameters() {
        try {
            this.tagTypeService.searchTagTypes(new TagTypeSearchRequest(), (Set)Sets.newHashSet((Object[])new String[]{"INVALID_FIELD_OPTION"}));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Search response field \"invalid_field_option\" is not supported.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSearchTagTypesLowerCaseParameters() {
        this.createDatabaseEntitiesForTagTypeSearchTesting();
        TagTypeSearchResponse tagTypeSearchResponse = this.tagTypeService.searchTagTypes(new TagTypeSearchRequest(), (Set)Sets.newHashSet((Object[])new String[]{TagTypeServiceImpl.DISPLAY_NAME_FIELD.toLowerCase(), TagTypeServiceImpl.TAG_TYPE_ORDER_FIELD.toLowerCase(), TagTypeServiceImpl.DESCRIPTION_FIELD.toLowerCase()}));
        Assert.assertEquals((Object)new TagTypeSearchResponse(Arrays.asList(new TagType(new TagTypeKey(TAG_TYPE_2), TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION_2), new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION))), (Object)tagTypeSearchResponse);
    }

    @Test
    public void testSearchTagTypesMissingOptionalParameters() {
        this.createDatabaseEntitiesForTagTypeSearchTesting();
        Assert.assertEquals((Object)new TagTypeSearchResponse(Arrays.asList(new TagType(new TagTypeKey(TAG_TYPE_2), NO_TAG_TYPE_DISPLAY_NAME, NO_TAG_TYPE_ORDER, NO_TAG_TYPE_DESCRIPTION), new TagType(new TagTypeKey(TAG_TYPE), NO_TAG_TYPE_DISPLAY_NAME, NO_TAG_TYPE_ORDER, NO_TAG_TYPE_DESCRIPTION))), (Object)this.tagTypeService.searchTagTypes(new TagTypeSearchRequest(), NO_SEARCH_RESPONSE_FIELDS));
        Assert.assertEquals((Object)new TagTypeSearchResponse(Arrays.asList(new TagType(new TagTypeKey(TAG_TYPE_2), TAG_TYPE_DISPLAY_NAME_2, NO_TAG_TYPE_ORDER, NO_TAG_TYPE_DESCRIPTION), new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, NO_TAG_TYPE_ORDER, NO_TAG_TYPE_DESCRIPTION))), (Object)this.tagTypeService.searchTagTypes(new TagTypeSearchRequest(), (Set)Sets.newHashSet((Object[])new String[]{TagTypeServiceImpl.DISPLAY_NAME_FIELD})));
        Assert.assertEquals((Object)new TagTypeSearchResponse(Arrays.asList(new TagType(new TagTypeKey(TAG_TYPE_2), NO_TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, NO_TAG_TYPE_DESCRIPTION), new TagType(new TagTypeKey(TAG_TYPE), NO_TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER_2, NO_TAG_TYPE_DESCRIPTION))), (Object)this.tagTypeService.searchTagTypes(new TagTypeSearchRequest(), (Set)Sets.newHashSet((Object[])new String[]{TagTypeServiceImpl.TAG_TYPE_ORDER_FIELD})));
        Assert.assertEquals((Object)new TagTypeSearchResponse(Arrays.asList(new TagType(new TagTypeKey(TAG_TYPE_2), NO_TAG_TYPE_DISPLAY_NAME, NO_TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION_2), new TagType(new TagTypeKey(TAG_TYPE), NO_TAG_TYPE_DISPLAY_NAME, NO_TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION))), (Object)this.tagTypeService.searchTagTypes(new TagTypeSearchRequest(), (Set)Sets.newHashSet((Object[])new String[]{TagTypeServiceImpl.DESCRIPTION_FIELD})));
    }

    @Test
    public void testSearchTagTypesMissingRequiredParameters() {
        try {
            this.tagTypeService.searchTagTypes(null, (Set)Sets.newHashSet((Object[])new String[]{TagTypeServiceImpl.DISPLAY_NAME_FIELD, TagTypeServiceImpl.TAG_TYPE_ORDER_FIELD, TagTypeServiceImpl.DESCRIPTION_FIELD}));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type search request must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSearchTagTypesTrimParameters() {
        this.createDatabaseEntitiesForTagTypeSearchTesting();
        TagTypeSearchResponse tagTypeSearchResponse = this.tagTypeService.searchTagTypes(new TagTypeSearchRequest(), (Set)Sets.newHashSet((Object[])new String[]{this.addWhitespace(TagTypeServiceImpl.DISPLAY_NAME_FIELD), this.addWhitespace(TagTypeServiceImpl.TAG_TYPE_ORDER_FIELD), this.addWhitespace(TagTypeServiceImpl.DESCRIPTION_FIELD)}));
        Assert.assertEquals((Object)new TagTypeSearchResponse(Arrays.asList(new TagType(new TagTypeKey(TAG_TYPE_2), TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION_2), new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION))), (Object)tagTypeSearchResponse);
    }

    @Test
    public void testSearchTagTypesUpperCaseParameters() {
        this.createDatabaseEntitiesForTagTypeSearchTesting();
        TagTypeSearchResponse tagTypeSearchResponse = this.tagTypeService.searchTagTypes(new TagTypeSearchRequest(), (Set)Sets.newHashSet((Object[])new String[]{TagTypeServiceImpl.DISPLAY_NAME_FIELD.toUpperCase(), TagTypeServiceImpl.TAG_TYPE_ORDER_FIELD.toUpperCase(), TagTypeServiceImpl.DESCRIPTION_FIELD.toUpperCase()}));
        Assert.assertEquals((Object)new TagTypeSearchResponse(Arrays.asList(new TagType(new TagTypeKey(TAG_TYPE_2), TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION_2), new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION))), (Object)tagTypeSearchResponse);
    }

    @Test
    public void testUpdateTagType() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2), (Object)resultTagType);
    }

    @Test
    public void testUpdateTagTypeDisplayNameAlreadyExists() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2);
        try {
            this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Display name \"%s\" already exists for tag type \"%s\".", TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagTypeLowerCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE.toLowerCase()), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2.toLowerCase(), TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2.toLowerCase()));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME_2.toLowerCase(), TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2.toLowerCase()), (Object)resultTagType);
    }

    @Test
    public void testUpdateTagTypeMissingRequiredParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        try {
            this.tagTypeService.updateTagType(new TagTypeKey("      \t\t "), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest("      \t\t ", TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A display name must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2, null, TAG_TYPE_DESCRIPTION_2));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type order must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagTypeNoChangesToDisplayName() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE, TAG_TYPE_DESCRIPTION);
        TagType updatedTagType = this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE_2, TAG_TYPE_DESCRIPTION_2));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE_2, TAG_TYPE_DESCRIPTION_2), (Object)updatedTagType);
    }

    @Test
    public void testUpdateTagTypeNoChangesToDisplayNameExceptForCase() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, INTEGER_VALUE, TAG_TYPE_DESCRIPTION);
        TagType updatedTagType = this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME.toLowerCase(), INTEGER_VALUE_2, TAG_TYPE_DESCRIPTION_2));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME.toLowerCase(), INTEGER_VALUE_2, TAG_TYPE_DESCRIPTION_2), (Object)updatedTagType);
    }

    @Test
    public void testUpdateTagTypeTagTypeNotExists() {
        try {
            this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag type with code \"%s\" doesn't exist.", TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagTypeTrimParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.updateTagType(new TagTypeKey(this.addWhitespace(TAG_TYPE)), new TagTypeUpdateRequest(this.addWhitespace(TAG_TYPE_DISPLAY_NAME_2), TAG_TYPE_ORDER_2, this.addWhitespace(TAG_TYPE_DESCRIPTION_2)));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER_2, this.addWhitespace(TAG_TYPE_DESCRIPTION_2)), (Object)resultTagType);
    }

    @Test
    public void testUpdateTagTypeUpperCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagType resultTagType = this.tagTypeService.updateTagType(new TagTypeKey(TAG_TYPE.toUpperCase()), new TagTypeUpdateRequest(TAG_TYPE_DISPLAY_NAME_2.toUpperCase(), TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2.toUpperCase()));
        Assert.assertEquals((Object)new TagType(new TagTypeKey(TAG_TYPE), TAG_TYPE_DISPLAY_NAME_2.toUpperCase(), TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION_2.toUpperCase()), (Object)resultTagType);
    }

    private void createDatabaseEntitiesForTagTypeSearchTesting() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER_2, TAG_TYPE_DESCRIPTION);
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION_2);
    }
}

