/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.CompleteUploadSingleParamsDto;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.UploadDownloadHelperService;
import org.finra.herd.service.impl.UploadDownloadHelperServiceImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class UploadDownloadHelperServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="uploadDownloadHelperServiceImpl")
    private UploadDownloadHelperService uploadDownloadHelperServiceImpl;

    @After
    public void cleanEnv() throws IOException {
        for (S3FileTransferRequestParamsDto params : Arrays.asList(S3FileTransferRequestParamsDto.builder().withS3BucketName(this.storageDaoTestHelper.getS3LoadingDockBucketName()).withS3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build(), S3FileTransferRequestParamsDto.builder().withS3BucketName(this.storageDaoTestHelper.getS3ExternalBucketName()).withS3KeyPrefix(TEST_S3_KEY_PREFIX + "/").build())) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    @Test
    public void testPrepareForFileMove() {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_LOADING_DOCK"), sourceBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, TARGET_S3_KEY, Long.valueOf(1024L), NO_ROW_COUNT);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        StorageUnitEntity targetStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_EXTERNAL"), targetBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(targetStorageUnitEntity, TARGET_S3_KEY, Long.valueOf(1024L), NO_ROW_COUNT);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1024]), null);
        this.s3Operations.putObject(putObjectRequest, null);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto();
        this.uploadDownloadHelperService.prepareForFileMove(TARGET_S3_KEY, completeUploadSingleParamsDto);
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testPrepareForFileMoveSourceStorageFileNoExists() throws Exception {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto();
        this.executeWithoutLogging(UploadDownloadHelperServiceImpl.class, () -> this.uploadDownloadHelperService.prepareForFileMove(FILE_NAME, completeUploadSingleParamsDto));
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"UPLOADING", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"UPLOADING", (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertNull((Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertNull((Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertNull((Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertNull((Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testPrepareForFileMoveSourceStatusNotUploading() throws Exception {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID");
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_LOADING_DOCK"), sourceBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, FILE_NAME, Long.valueOf(1024L), NO_ROW_COUNT);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        StorageUnitEntity targetStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_EXTERNAL"), targetBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(targetStorageUnitEntity, FILE_NAME, Long.valueOf(1024L), NO_ROW_COUNT);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto();
        this.executeWithoutLogging(UploadDownloadHelperServiceImpl.class, () -> this.uploadDownloadHelperService.prepareForFileMove(FILE_NAME, completeUploadSingleParamsDto));
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"VALID", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"UPLOADING", (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertNull((Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertEquals((Object)"VALID", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertNull((Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testPrepareForFileMoveTargetStatusNotUploading() throws Exception {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_LOADING_DOCK"), sourceBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, FILE_NAME, Long.valueOf(1024L), NO_ROW_COUNT);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID");
        StorageUnitEntity targetStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_EXTERNAL"), targetBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(targetStorageUnitEntity, FILE_NAME, Long.valueOf(1024L), NO_ROW_COUNT);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto();
        this.executeWithoutLogging(UploadDownloadHelperServiceImpl.class, () -> this.uploadDownloadHelperService.prepareForFileMove(FILE_NAME, completeUploadSingleParamsDto));
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"UPLOADING", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"VALID", (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertNull((Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertNull((Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertEquals((Object)"VALID", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testPrepareForFileMoveSourceS3FileNoExists() throws Exception {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_LOADING_DOCK"), sourceBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, FILE_NAME, Long.valueOf(1024L), NO_ROW_COUNT);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        StorageUnitEntity targetStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_EXTERNAL"), targetBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(targetStorageUnitEntity, FILE_NAME, Long.valueOf(1024L), NO_ROW_COUNT);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto();
        this.executeWithoutLogging(UploadDownloadHelperServiceImpl.class, () -> this.uploadDownloadHelperService.prepareForFileMove(FILE_NAME, completeUploadSingleParamsDto));
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"DELETED", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"INVALID", (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"DELETED", (Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertEquals((Object)"INVALID", (Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testPrepareForFileMoveTargetS3FileAlreadyExists() throws Exception {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_LOADING_DOCK"), sourceBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, TARGET_S3_KEY, Long.valueOf(1024L), NO_ROW_COUNT);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        StorageUnitEntity targetStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_EXTERNAL"), targetBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(targetStorageUnitEntity, TARGET_S3_KEY, Long.valueOf(1024L), NO_ROW_COUNT);
        this.s3Operations.putObject(new PutObjectRequest(this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
        this.s3Operations.putObject(new PutObjectRequest(this.storageDaoTestHelper.getS3ExternalBucketName(), TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto();
        this.executeWithoutLogging(UploadDownloadHelperServiceImpl.class, () -> this.uploadDownloadHelperService.prepareForFileMove(TARGET_S3_KEY, completeUploadSingleParamsDto));
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"DELETED", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"INVALID", (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"DELETED", (Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertEquals((Object)"INVALID", (Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testPerformFileMove() {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        this.s3Operations.putObject(new PutObjectRequest(this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity), this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, "UPLOADING", "RE-ENCRYPTING", this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity), this.storageDaoTestHelper.getS3ExternalBucketName(), TARGET_S3_KEY, "UPLOADING", "RE-ENCRYPTING", "mock_kms_id", this.emrHelper.getAwsParamsDto());
        this.uploadDownloadHelperService.performFileMove(completeUploadSingleParamsDto);
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"VALID", (Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testPerformFileMoveS3CopyFails() throws Exception {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity), "", "mock_s3_file_name_service_exception", "UPLOADING", "RE-ENCRYPTING", this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity), "", "mock_s3_file_name_service_exception", "UPLOADING", "RE-ENCRYPTING", "mock_kms_id", this.emrHelper.getAwsParamsDto());
        this.executeWithoutLogging(UploadDownloadHelperServiceImpl.class, () -> this.uploadDownloadHelperService.performFileMove(completeUploadSingleParamsDto));
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"INVALID", (Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testExecuteFileMoveAfterSteps() {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_LOADING_DOCK"), sourceBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, TARGET_S3_KEY, Long.valueOf(1024L), NO_ROW_COUNT);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        StorageUnitEntity targetStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_EXTERNAL"), targetBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(targetStorageUnitEntity, TARGET_S3_KEY, Long.valueOf(1024L), NO_ROW_COUNT);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1024]), null);
        this.s3Operations.putObject(putObjectRequest, null);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity), this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, "UPLOADING", "RE-ENCRYPTING", this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity), this.storageDaoTestHelper.getS3ExternalBucketName(), TARGET_S3_KEY, "RE-ENCRYPTING", "VALID", "mock_kms_id", this.emrHelper.getAwsParamsDto());
        this.uploadDownloadHelperService.executeFileMoveAfterSteps(completeUploadSingleParamsDto);
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"DELETED", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"VALID", (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"DELETED", (Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertEquals((Object)"VALID", (Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testExecuteFileMoveAfterStepsTargetStatusNotReEncrypting() {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_LOADING_DOCK"), sourceBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, TARGET_S3_KEY, Long.valueOf(1024L), NO_ROW_COUNT);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        StorageUnitEntity targetStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_EXTERNAL"), targetBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(targetStorageUnitEntity, TARGET_S3_KEY, Long.valueOf(1024L), NO_ROW_COUNT);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1024]), null);
        this.s3Operations.putObject(putObjectRequest, null);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity), this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, "UPLOADING", "RE-ENCRYPTING", this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity), this.storageDaoTestHelper.getS3ExternalBucketName(), TARGET_S3_KEY, "RE-ENCRYPTING", "VALID", "mock_kms_id", this.emrHelper.getAwsParamsDto());
        this.uploadDownloadHelperService.executeFileMoveAfterSteps(completeUploadSingleParamsDto);
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"DELETED", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)BDATA_STATUS, (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"DELETED", (Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertNull((Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testExecuteFileMoveAfterStepsNewTargetStatusNotValid() {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_LOADING_DOCK"), sourceBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, TARGET_S3_KEY, Long.valueOf(1024L), NO_ROW_COUNT);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        StorageUnitEntity targetStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDaoHelper.getStorageEntity("S3_MANAGED_EXTERNAL"), targetBusinessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(targetStorageUnitEntity, TARGET_S3_KEY, Long.valueOf(1024L), NO_ROW_COUNT);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1024]), null);
        this.s3Operations.putObject(putObjectRequest, null);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity), this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, "UPLOADING", "RE-ENCRYPTING", this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity), this.storageDaoTestHelper.getS3ExternalBucketName(), TARGET_S3_KEY, "RE-ENCRYPTING", "INVALID", "mock_kms_id", this.emrHelper.getAwsParamsDto());
        this.uploadDownloadHelperService.executeFileMoveAfterSteps(completeUploadSingleParamsDto);
        sourceBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity));
        targetBusinessObjectDataEntity = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity));
        Assert.assertEquals((Object)"DELETED", (Object)sourceBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"INVALID", (Object)targetBusinessObjectDataEntity.getStatus().getCode());
        Assert.assertEquals((Object)"DELETED", (Object)completeUploadSingleParamsDto.getSourceNewStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
        Assert.assertEquals((Object)"INVALID", (Object)completeUploadSingleParamsDto.getTargetNewStatus());
        Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
    }

    @Test
    public void testUploadDownloadHelperServiceMethodsNewTransactionPropagation() throws Exception {
        this.executeWithoutLogging(UploadDownloadHelperServiceImpl.class, () -> {
            CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto();
            this.uploadDownloadHelperServiceImpl.prepareForFileMove("KEY_DOES_NOT_EXIST", completeUploadSingleParamsDto);
            Assert.assertNull((Object)completeUploadSingleParamsDto.getSourceBusinessObjectDataKey());
            Assert.assertNull((Object)completeUploadSingleParamsDto.getSourceNewStatus());
            Assert.assertNull((Object)completeUploadSingleParamsDto.getSourceOldStatus());
            Assert.assertNull((Object)completeUploadSingleParamsDto.getTargetBusinessObjectDataKey());
            Assert.assertNull((Object)completeUploadSingleParamsDto.getTargetNewStatus());
            Assert.assertNull((Object)completeUploadSingleParamsDto.getTargetOldStatus());
            completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION), "", "mock_s3_file_name_service_exception", "UPLOADING", "RE-ENCRYPTING", new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION), "", "mock_s3_file_name_service_exception", "UPLOADING", "RE-ENCRYPTING", "mock_kms_id", this.emrHelper.getAwsParamsDto());
            this.uploadDownloadHelperServiceImpl.performFileMove(completeUploadSingleParamsDto);
            Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getSourceNewStatus());
            Assert.assertEquals((Object)"UPLOADING", (Object)completeUploadSingleParamsDto.getSourceOldStatus());
            Assert.assertEquals((Object)"INVALID", (Object)completeUploadSingleParamsDto.getTargetNewStatus());
            Assert.assertEquals((Object)"RE-ENCRYPTING", (Object)completeUploadSingleParamsDto.getTargetOldStatus());
            this.uploadDownloadHelperServiceImpl.executeFileMoveAfterSteps(new CompleteUploadSingleParamsDto());
            this.uploadDownloadHelperServiceImpl.deleteSourceFileFromS3(new CompleteUploadSingleParamsDto());
            try {
                this.uploadDownloadHelperServiceImpl.updateBusinessObjectDataStatus(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION), null);
                Assert.fail((String)"Should throw an ObjectNotFoundException.");
            }
            catch (ObjectNotFoundException e) {
                Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
            }
        });
    }

    @Test
    public void testDeleteSourceFileFromS3() {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        this.s3Operations.putObject(new PutObjectRequest(this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity), this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, "UPLOADING", "RE-ENCRYPTING", this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity), this.storageDaoTestHelper.getS3ExternalBucketName(), TARGET_S3_KEY, "UPLOADING", "RE-ENCRYPTING", "mock_kms_id", this.emrHelper.getAwsParamsDto());
        this.uploadDownloadHelperService.deleteSourceFileFromS3(completeUploadSingleParamsDto);
    }

    @Test
    public void testDeleteSourceFileFromS3Fails() throws Exception {
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, LATEST_VERSION_FLAG_SET, "RE-ENCRYPTING");
        this.s3Operations.putObject(new PutObjectRequest(this.storageDaoTestHelper.getS3LoadingDockBucketName(), TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1024]), null), null);
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto(this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity), "", "mock_s3_file_name_service_exception", "UPLOADING", "RE-ENCRYPTING", this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity), "", "mock_s3_file_name_service_exception", "UPLOADING", "RE-ENCRYPTING", "mock_kms_id", null);
        this.executeWithoutLogging(UploadDownloadHelperServiceImpl.class, () -> this.uploadDownloadHelperService.deleteSourceFileFromS3(completeUploadSingleParamsDto));
    }
}

