/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.finra.herd.core.helper.LogLevel;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStatusUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSampleDataFileKey;
import org.finra.herd.model.api.xml.DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest;
import org.finra.herd.model.api.xml.DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationResponse;
import org.finra.herd.model.api.xml.DownloadSingleInitiationResponse;
import org.finra.herd.model.api.xml.SampleDataFile;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.model.api.xml.UploadBusinessObjectDefinitionSampleDataFileInitiationRequest;
import org.finra.herd.model.api.xml.UploadBusinessObjectDefinitionSampleDataFileInitiationResponse;
import org.finra.herd.model.api.xml.UploadSingleCredentialExtensionResponse;
import org.finra.herd.model.api.xml.UploadSingleInitiationRequest;
import org.finra.herd.model.api.xml.UploadSingleInitiationResponse;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.UploadDownloadService;
import org.finra.herd.service.impl.UploadDownloadServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class UploadDownloadServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="uploadDownloadServiceImpl")
    private UploadDownloadService uploadDownloadServiceImpl;

    @Test
    public void testInitiateUploadSingle() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest());
        this.uploadDownloadServiceTestHelper.validateUploadSingleInitiationResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), FILE_NAME, 1024L, null, resultUploadSingleInitiationResponse);
    }

    @Test
    public void testInitiateUploadSingleMissingRequiredParameters() {
        UploadSingleInitiationRequest request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        request.setSourceBusinessObjectFormatKey(null);
        try {
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format key is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format key must be specified.", (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getSourceBusinessObjectFormatKey().setNamespace("      \t\t ");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getSourceBusinessObjectFormatKey().setBusinessObjectDefinitionName("      \t\t ");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getSourceBusinessObjectFormatKey().setBusinessObjectFormatUsage("      \t\t ");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getSourceBusinessObjectFormatKey().setBusinessObjectFormatFileType("      \t\t ");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getSourceBusinessObjectFormatKey().setBusinessObjectFormatVersion(null);
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        request.setTargetBusinessObjectFormatKey(null);
        try {
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format key is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format key must be specified.", (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getTargetBusinessObjectFormatKey().setNamespace("      \t\t ");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getTargetBusinessObjectFormatKey().setBusinessObjectDefinitionName("      \t\t ");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getTargetBusinessObjectFormatKey().setBusinessObjectFormatUsage("      \t\t ");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getTargetBusinessObjectFormatKey().setBusinessObjectFormatFileType("      \t\t ");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getTargetBusinessObjectFormatKey().setBusinessObjectFormatVersion(null);
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        ((Attribute)request.getBusinessObjectDataAttributes().get(0)).setName("      \t\t ");
        try {
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An attribute name must be specified.", (Object)e.getMessage());
        }
        request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        request.setFile(null);
        try {
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when file information is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"File information must be specified.", (Object)e.getMessage());
        }
        request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        request.getFile().setFileName("      \t\t ");
        try {
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when file name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A file name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateUploadSingleMissingOptionalParameters() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationRequest request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        request.setBusinessObjectDataAttributes(null);
        request.getFile().setFileSizeBytes(null);
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(request);
        this.uploadDownloadServiceTestHelper.validateUploadSingleInitiationResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, NO_ATTRIBUTES, FILE_NAME, null, null, resultUploadSingleInitiationResponse);
    }

    @Test
    public void testInitiateUploadSingleTrimParameters() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME_2), this.addWhitespace(FORMAT_USAGE_CODE_2), this.addWhitespace(FORMAT_FILE_TYPE_CODE_2), FORMAT_VERSION_2));
        this.uploadDownloadServiceTestHelper.validateUploadSingleInitiationResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), FILE_NAME, 1024L, null, resultUploadSingleInitiationResponse);
    }

    @Test
    public void testInitiateUploadSingleUpperCaseParameters() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, NAMESPACE.toLowerCase(), BDEF_NAME_2.toLowerCase(), FORMAT_USAGE_CODE_2.toLowerCase(), FORMAT_FILE_TYPE_CODE_2.toLowerCase(), FORMAT_VERSION_2));
        this.uploadDownloadServiceTestHelper.validateUploadSingleInitiationResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), FILE_NAME, 1024L, null, resultUploadSingleInitiationResponse);
    }

    @Test
    public void testInitiateUploadSingleLowerCaseParameters() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, NAMESPACE.toUpperCase(), BDEF_NAME_2.toUpperCase(), FORMAT_USAGE_CODE_2.toUpperCase(), FORMAT_FILE_TYPE_CODE_2.toUpperCase(), FORMAT_VERSION_2));
        this.uploadDownloadServiceTestHelper.validateUploadSingleInitiationResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), FILE_NAME, 1024L, null, resultUploadSingleInitiationResponse);
    }

    @Test
    public void testInitiateUploadSingleInvalidParameters() {
        UploadSingleInitiationRequest request;
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getSourceBusinessObjectFormatKey().setNamespace("I_DO_NOT_EXIST");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getSourceBusinessObjectFormatKey().setBusinessObjectDefinitionName("I_DO_NOT_EXIST");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getSourceBusinessObjectFormatKey().setBusinessObjectFormatUsage("I_DO_NOT_EXIST");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getSourceBusinessObjectFormatKey().setBusinessObjectFormatFileType("I_DO_NOT_EXIST");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getSourceBusinessObjectFormatKey().setBusinessObjectFormatVersion(INVALID_FORMAT_VERSION);
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getTargetBusinessObjectFormatKey().setNamespace("I_DO_NOT_EXIST");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2), (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getTargetBusinessObjectFormatKey().setBusinessObjectDefinitionName("I_DO_NOT_EXIST");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2), (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getTargetBusinessObjectFormatKey().setBusinessObjectFormatUsage("I_DO_NOT_EXIST");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME_2, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2), (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getTargetBusinessObjectFormatKey().setBusinessObjectFormatFileType("I_DO_NOT_EXIST");
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, "I_DO_NOT_EXIST", FORMAT_VERSION_2), (Object)e.getMessage());
        }
        try {
            request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
            request.getTargetBusinessObjectFormatKey().setBusinessObjectFormatVersion(INVALID_FORMAT_VERSION);
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, INVALID_FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateUploadSingleDuplicateAttributes() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationRequest request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        request.setBusinessObjectDataAttributes(Arrays.asList(new Attribute("Attribute Name 3".toLowerCase(), "Attribute Value 3"), new Attribute("Attribute Name 3".toUpperCase(), "Attribute Value 3")));
        try {
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate attributes are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate attribute name found: %s", "Attribute Name 3".toUpperCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateUploadSingleRequiredAttribute() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        this.businessObjectFormatDaoTestHelper.createBusinessObjectDataAttributeDefinitionEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "Attribute Name 1");
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest());
        this.uploadDownloadServiceTestHelper.validateUploadSingleInitiationResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), FILE_NAME, 1024L, null, resultUploadSingleInitiationResponse);
    }

    @Test
    public void testInitiateUploadSingleRequiredAttributeMissingValue() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        this.businessObjectFormatDaoTestHelper.createBusinessObjectDataAttributeDefinitionEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "Attribute Name 1");
        UploadSingleInitiationRequest request = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        request.setBusinessObjectDataAttributes(Arrays.asList(new Attribute("Attribute Name 1", "      \t\t ")));
        try {
            this.uploadDownloadService.initiateUploadSingle(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when required attribute value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The business object format has a required attribute \"%s\" which was not specified or has a value which is blank.", "Attribute Name 1"), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateUploadSingleAssertUseTargetStorageInRequest() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3);
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucketName"));
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$environment/$namespace/$businessObjectDataPartitionValue"));
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KMS_KEY_ID), "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012"));
        UploadSingleInitiationRequest uploadSingleInitiationRequest = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        uploadSingleInitiationRequest.setTargetStorageName(STORAGE_NAME_3);
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(uploadSingleInitiationRequest);
        this.uploadDownloadServiceTestHelper.validateUploadSingleInitiationResponse(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), FILE_NAME, 1024L, STORAGE_NAME_3, resultUploadSingleInitiationResponse);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, resultUploadSingleInitiationResponse.getTargetBusinessObjectData().getPartitionValue(), null, Integer.valueOf(0)));
        Assert.assertNotNull((Object)targetBusinessObjectDataEntity);
        Assert.assertNotNull((Object)targetBusinessObjectDataEntity.getStorageUnits());
        Assert.assertEquals((long)1L, (long)targetBusinessObjectDataEntity.getStorageUnits().size());
        StorageUnitEntity storageUnit = (StorageUnitEntity)IterableUtils.get((Iterable)targetBusinessObjectDataEntity.getStorageUnits(), (int)0);
        Assert.assertNotNull((Object)storageUnit);
        Assert.assertNotNull((Object)storageUnit.getStorage());
        Assert.assertEquals((Object)STORAGE_NAME_3, (Object)storageUnit.getStorage().getName());
    }

    @Test
    public void testInitiateUploadSingleAssertTargetStorageBucketNameRequired() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3);
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$environment/$namespace/$businessObjectDataPartitionValue"));
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KMS_KEY_ID), "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012"));
        UploadSingleInitiationRequest uploadSingleInitiationRequest = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        uploadSingleInitiationRequest.setTargetStorageName(STORAGE_NAME_3);
        try {
            this.uploadDownloadService.initiateUploadSingle(uploadSingleInitiationRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)("Attribute \"" + this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME) + "\" for \"" + STORAGE_NAME_3 + "\" storage must be configured."), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateUploadSingleAssertTargetStorageKmsKeyIdRequired() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3);
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucketName"));
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$environment/$namespace/$businessObjectDataPartitionValue"));
        UploadSingleInitiationRequest uploadSingleInitiationRequest = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        uploadSingleInitiationRequest.setTargetStorageName(STORAGE_NAME_3);
        try {
            this.uploadDownloadService.initiateUploadSingle(uploadSingleInitiationRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)("Attribute \"" + this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KMS_KEY_ID) + "\" for \"" + STORAGE_NAME_3 + "\" storage must be configured."), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateUploadSingleAssertTargetStoragePrefixTemplateRequired() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3);
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucketName"));
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KMS_KEY_ID), "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012"));
        UploadSingleInitiationRequest uploadSingleInitiationRequest = this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest();
        uploadSingleInitiationRequest.setTargetStorageName(STORAGE_NAME_3);
        try {
            this.uploadDownloadService.initiateUploadSingle(uploadSingleInitiationRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)("Storage \"" + STORAGE_NAME_3 + "\" has no S3 key prefix velocity template configured."), (Object)e.getMessage());
        }
    }

    @Test
    public void testPerformCompleteUploadSingleMessage() {
        this.runPerformCompleteUploadSingleMessageTest();
    }

    @Test
    public void testPerformCompleteUploadSingleMessageWithDebugLoggingEnabled() throws Exception {
        LogLevel origLogLevel = this.getLogLevel(UploadDownloadServiceImpl.class);
        this.setLogLevel(UploadDownloadServiceImpl.class, LogLevel.DEBUG);
        try {
            this.runPerformCompleteUploadSingleMessageTest();
        }
        finally {
            this.setLogLevel(UploadDownloadServiceImpl.class, origLogLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPerformCompleteUploadSingleMessageTest() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, FILE_NAME));
        String filePath = ((StorageFile)((StorageUnit)resultUploadSingleInitiationResponse.getTargetBusinessObjectData().getStorageUnits().get(0)).getStorageFiles().get(0)).getFilePath();
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.storageDaoTestHelper.getS3LoadingDockBucketName(), filePath, (InputStream)new ByteArrayInputStream(new byte[1024]), null);
        this.s3Operations.putObject(putObjectRequest, null);
        try {
            UploadDownloadServiceImpl.CompleteUploadSingleMessageResult result = this.uploadDownloadService.performCompleteUploadSingleMessage(filePath);
            Assert.assertEquals((Object)"UPLOADING", (Object)result.getSourceOldBusinessObjectDataStatus());
            Assert.assertEquals((Object)"DELETED", (Object)result.getSourceNewBusinessObjectDataStatus());
            Assert.assertEquals((Object)"UPLOADING", (Object)result.getTargetOldBusinessObjectDataStatus());
            Assert.assertEquals((Object)"VALID", (Object)result.getTargetNewBusinessObjectDataStatus());
            result = this.uploadDownloadService.performCompleteUploadSingleMessage(filePath);
            Assert.assertEquals((Object)"DELETED", (Object)result.getSourceOldBusinessObjectDataStatus());
            Assert.assertNull((Object)result.getSourceNewBusinessObjectDataStatus());
            Assert.assertEquals((Object)"VALID", (Object)result.getTargetOldBusinessObjectDataStatus());
            Assert.assertNull((Object)result.getTargetNewBusinessObjectDataStatus());
        }
        finally {
            this.s3Dao.deleteDirectory(S3FileTransferRequestParamsDto.builder().withS3BucketName(this.storageDaoTestHelper.getS3LoadingDockBucketName()).withS3KeyPrefix(filePath).build());
            this.s3Operations.rollback();
        }
    }

    @Test
    public void testPerformCompleteUploadSingleMessageStorageFileNoExists() {
        UploadDownloadServiceImpl.CompleteUploadSingleMessageResult result = this.uploadDownloadService.performCompleteUploadSingleMessage("KEY_DOES_NOT_EXIST");
        Assert.assertNull((Object)result.getSourceBusinessObjectDataKey());
        Assert.assertNull((Object)result.getSourceNewBusinessObjectDataStatus());
        Assert.assertNull((Object)result.getSourceOldBusinessObjectDataStatus());
        Assert.assertNull((Object)result.getTargetBusinessObjectDataKey());
        Assert.assertNull((Object)result.getTargetNewBusinessObjectDataStatus());
        Assert.assertNull((Object)result.getTargetOldBusinessObjectDataStatus());
    }

    @Test
    public void testPerformCompleteUploadSingleMessageS3FileNoExists() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, FILE_NAME));
        String filePath = ((StorageFile)((StorageUnit)resultUploadSingleInitiationResponse.getTargetBusinessObjectData().getStorageUnits().get(0)).getStorageFiles().get(0)).getFilePath();
        UploadDownloadServiceImpl.CompleteUploadSingleMessageResult result = this.uploadDownloadService.performCompleteUploadSingleMessage(filePath);
        Assert.assertEquals((Object)"UPLOADING", (Object)result.getSourceOldBusinessObjectDataStatus());
        Assert.assertEquals((Object)"DELETED", (Object)result.getSourceNewBusinessObjectDataStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)result.getTargetOldBusinessObjectDataStatus());
        Assert.assertEquals((Object)"INVALID", (Object)result.getTargetNewBusinessObjectDataStatus());
    }

    @Test
    public void testPerformCompleteUploadSingleMessageSourceBusinessObjectDataStatusNotUploading() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, FILE_NAME));
        String filePath = ((StorageFile)((StorageUnit)resultUploadSingleInitiationResponse.getTargetBusinessObjectData().getStorageUnits().get(0)).getStorageFiles().get(0)).getFilePath();
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.businessObjectDataStatusService.updateBusinessObjectDataStatus(this.businessObjectDataHelper.getBusinessObjectDataKey(resultUploadSingleInitiationResponse.getSourceBusinessObjectData()), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
        UploadDownloadServiceImpl.CompleteUploadSingleMessageResult result = this.uploadDownloadService.performCompleteUploadSingleMessage(filePath);
        Assert.assertEquals((Object)BDATA_STATUS, (Object)result.getSourceOldBusinessObjectDataStatus());
        Assert.assertNull((Object)result.getSourceNewBusinessObjectDataStatus());
        Assert.assertEquals((Object)"UPLOADING", (Object)result.getTargetOldBusinessObjectDataStatus());
        Assert.assertNull((Object)result.getTargetNewBusinessObjectDataStatus());
    }

    @Test
    public void testPerformCompleteUploadSingleMessageTargetBusinessObjectDataStatusNotUploading() {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, FILE_NAME));
        String filePath = ((StorageFile)((StorageUnit)resultUploadSingleInitiationResponse.getTargetBusinessObjectData().getStorageUnits().get(0)).getStorageFiles().get(0)).getFilePath();
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.businessObjectDataStatusService.updateBusinessObjectDataStatus(this.businessObjectDataHelper.getBusinessObjectDataKey(resultUploadSingleInitiationResponse.getTargetBusinessObjectData()), new BusinessObjectDataStatusUpdateRequest(BDATA_STATUS));
        UploadDownloadServiceImpl.CompleteUploadSingleMessageResult result = this.uploadDownloadService.performCompleteUploadSingleMessage(filePath);
        Assert.assertEquals((Object)"UPLOADING", (Object)result.getSourceOldBusinessObjectDataStatus());
        Assert.assertNull((Object)result.getSourceNewBusinessObjectDataStatus());
        Assert.assertEquals((Object)BDATA_STATUS, (Object)result.getTargetOldBusinessObjectDataStatus());
        Assert.assertNull((Object)result.getTargetNewBusinessObjectDataStatus());
    }

    @Test
    public void testInitiateDownloadSingle() {
        UploadSingleInitiationResponse uploadSingleInitiationResponse = this.uploadDownloadServiceTestHelper.createUploadedFileData("VALID");
        DownloadSingleInitiationResponse downloadSingleInitiationResponse = this.initiateDownload(uploadSingleInitiationResponse.getTargetBusinessObjectData());
        this.uploadDownloadServiceTestHelper.validateDownloadSingleInitiationResponse(uploadSingleInitiationResponse, downloadSingleInitiationResponse);
    }

    @Test
    public void testInitiateDownloadSingleBusinessObjectDataNoExists() {
        String INVALID_PARTITION_VALUE = "DOES_NOT_EXIST";
        UploadSingleInitiationResponse uploadSingleInitiationResponse = this.uploadDownloadServiceTestHelper.createUploadedFileData("VALID");
        uploadSingleInitiationResponse.getTargetBusinessObjectData().setPartitionValue(INVALID_PARTITION_VALUE);
        try {
            this.initiateDownload(uploadSingleInitiationResponse.getTargetBusinessObjectData());
            Assert.fail((String)"Suppose to throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            BusinessObjectData businessObjectData = uploadSingleInitiationResponse.getTargetBusinessObjectData();
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectData.getNamespace(), businessObjectData.getBusinessObjectDefinitionName(), businessObjectData.getBusinessObjectFormatUsage(), businessObjectData.getBusinessObjectFormatFileType(), businessObjectData.getBusinessObjectFormatVersion(), INVALID_PARTITION_VALUE, NO_SUBPARTITION_VALUES, businessObjectData.getVersion(), null), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateDownloadSingleMultipleStorageFilesExist() {
        UploadSingleInitiationResponse uploadSingleInitiationResponse = this.uploadDownloadServiceTestHelper.createUploadedFileData("VALID");
        BusinessObjectDataEntity targetBusinessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(this.businessObjectDataHelper.getBusinessObjectDataKey(uploadSingleInitiationResponse.getTargetBusinessObjectData()));
        StorageUnitEntity targetStorageUnitEntity = (StorageUnitEntity)IterableUtils.get((Iterable)targetBusinessObjectDataEntity.getStorageUnits(), (int)0);
        this.storageFileDaoTestHelper.createStorageFileEntity(targetStorageUnitEntity, FILE_NAME_2, Long.valueOf(1024L), Long.valueOf(1000L));
        try {
            this.initiateDownload(uploadSingleInitiationResponse.getTargetBusinessObjectData());
            Assert.fail((String)"Suppose to throw an IllegalArgumentException when business object has more than one storage file.");
        }
        catch (IllegalArgumentException e) {
            BusinessObjectData businessObjectData = uploadSingleInitiationResponse.getTargetBusinessObjectData();
            Assert.assertEquals((Object)String.format("Found 2 registered storage files when expecting one in \"%s\" storage for the business object data {%s}.", targetStorageUnitEntity.getStorage().getName(), this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectData))), (Object)e.getMessage());
        }
    }

    @Test
    public void testInitiateDownloadSingleBusinessObjectDataStatusNotValid() {
        UploadSingleInitiationResponse uploadSingleInitiationResponse = this.uploadDownloadServiceTestHelper.createUploadedFileData("RE-ENCRYPTING");
        try {
            this.initiateDownload(uploadSingleInitiationResponse.getTargetBusinessObjectData());
            Assert.fail((String)"Suppose to throw an IllegalArgumentException when business object data is not in VALID status.");
        }
        catch (IllegalArgumentException e) {
            BusinessObjectData businessObjectData = uploadSingleInitiationResponse.getTargetBusinessObjectData();
            Assert.assertEquals((Object)String.format("Business object data status \"%s\" does not match the expected status \"%s\" for the business object data {%s}.", uploadSingleInitiationResponse.getTargetBusinessObjectData().getStatus(), "VALID", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectData.getNamespace(), businessObjectData.getBusinessObjectDefinitionName(), businessObjectData.getBusinessObjectFormatUsage(), businessObjectData.getBusinessObjectFormatFileType(), businessObjectData.getBusinessObjectFormatVersion(), businessObjectData.getPartitionValue(), businessObjectData.getSubPartitionValues(), businessObjectData.getVersion())), (Object)e.getMessage());
        }
    }

    @Test
    public void testExtendUploadSingleCredentials() throws InterruptedException {
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse uploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest());
        Thread.sleep(10L);
        UploadSingleCredentialExtensionResponse uploadSingleCredentialExtensionResponse = this.extendUploadSingleCredentials(uploadSingleInitiationResponse.getSourceBusinessObjectData());
        Assert.assertNotNull((Object)uploadSingleCredentialExtensionResponse.getAwsAccessKey());
        Assert.assertNotNull((Object)uploadSingleCredentialExtensionResponse.getAwsSecretKey());
        Assert.assertNotNull((Object)uploadSingleCredentialExtensionResponse.getAwsSessionToken());
        Assert.assertNotNull((Object)uploadSingleCredentialExtensionResponse.getAwsSessionExpirationTime());
        Assert.assertNotNull((Object)uploadSingleInitiationResponse.getAwsSessionExpirationTime());
        if (uploadSingleCredentialExtensionResponse.getAwsSessionExpirationTime().toGregorianCalendar().getTimeInMillis() <= uploadSingleInitiationResponse.getAwsSessionExpirationTime().toGregorianCalendar().getTimeInMillis()) {
            Assert.fail((String)("Initial expiration time \"" + uploadSingleInitiationResponse.getAwsSessionExpirationTime().toGregorianCalendar().getTimeInMillis() + "\" is not > extended expiration time \"" + uploadSingleCredentialExtensionResponse.getAwsSessionExpirationTime().toGregorianCalendar().getTimeInMillis() + "\"."));
        }
    }

    @Test
    public void testExtendUploadSingleCredentialsBusinessObjectDataStatusNotValid() {
        UploadSingleInitiationResponse uploadSingleInitiationResponse = this.uploadDownloadServiceTestHelper.createUploadedFileData("VALID");
        try {
            this.extendUploadSingleCredentials(uploadSingleInitiationResponse.getSourceBusinessObjectData());
            Assert.fail((String)"Suppose to throw an IllegalArgumentException when business object data is not in VALID status.");
        }
        catch (IllegalArgumentException e) {
            BusinessObjectData businessObjectData = uploadSingleInitiationResponse.getSourceBusinessObjectData();
            Assert.assertEquals((Object)String.format("Business object data {%s} has a status of \"%s\" and must be \"%s\" to extend credentials.", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectData.getNamespace(), businessObjectData.getBusinessObjectDefinitionName(), businessObjectData.getBusinessObjectFormatUsage(), businessObjectData.getBusinessObjectFormatFileType(), businessObjectData.getBusinessObjectFormatVersion(), businessObjectData.getPartitionValue(), NO_SUBPARTITION_VALUES, businessObjectData.getVersion()), "DELETED", "UPLOADING"), (Object)e.getMessage());
        }
    }

    @Test
    public void testExtendUploadSingleCredentialsBusinessObjectDataNoExists() {
        String INVALID_PARTITION_VALUE = "DOES_NOT_EXIST";
        UploadSingleInitiationResponse uploadSingleInitiationResponse = this.uploadDownloadServiceTestHelper.createUploadedFileData("VALID");
        uploadSingleInitiationResponse.getSourceBusinessObjectData().setPartitionValue(INVALID_PARTITION_VALUE);
        try {
            this.extendUploadSingleCredentials(uploadSingleInitiationResponse.getSourceBusinessObjectData());
            Assert.fail((String)"Suppose to throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            BusinessObjectData businessObjectData = uploadSingleInitiationResponse.getSourceBusinessObjectData();
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectData.getNamespace(), businessObjectData.getBusinessObjectDefinitionName(), businessObjectData.getBusinessObjectFormatUsage(), businessObjectData.getBusinessObjectFormatFileType(), businessObjectData.getBusinessObjectFormatVersion(), INVALID_PARTITION_VALUE, NO_SUBPARTITION_VALUES, businessObjectData.getVersion(), null), (Object)e.getMessage());
        }
    }

    @Test
    public void testUploadDownloadHelperServiceMethodsNewTransactionPropagation() {
        this.uploadDownloadServiceImpl.performCompleteUploadSingleMessage("KEY_DOES_NOT_EXIST");
    }

    private DownloadSingleInitiationResponse initiateDownload(BusinessObjectData businessObjectData) {
        return this.uploadDownloadService.initiateDownloadSingle(businessObjectData.getNamespace(), businessObjectData.getBusinessObjectDefinitionName(), businessObjectData.getBusinessObjectFormatUsage(), businessObjectData.getBusinessObjectFormatFileType(), Integer.valueOf(businessObjectData.getBusinessObjectFormatVersion()), businessObjectData.getPartitionValue(), Integer.valueOf(businessObjectData.getVersion()));
    }

    private UploadSingleCredentialExtensionResponse extendUploadSingleCredentials(BusinessObjectData businessObjectData) {
        return this.uploadDownloadService.extendUploadSingleCredentials(businessObjectData.getNamespace(), businessObjectData.getBusinessObjectDefinitionName(), businessObjectData.getBusinessObjectFormatUsage(), businessObjectData.getBusinessObjectFormatFileType(), Integer.valueOf(businessObjectData.getBusinessObjectFormatVersion()), businessObjectData.getPartitionValue(), Integer.valueOf(businessObjectData.getVersion()));
    }

    @Test
    public void testDownloadBusinessObjectDefinitionSampleFile() {
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_DOWNLOAD_ROLE_ARN), DOWNLOADER_ROLE_ARN)));
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), Arrays.asList(new SampleDataFile(DIRECTORY_PATH, FILE_NAME)));
        DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest downloadRequest = new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest();
        BusinessObjectDefinitionSampleDataFileKey sampleDataFileKey = new BusinessObjectDefinitionSampleDataFileKey();
        sampleDataFileKey.setNamespace(NAMESPACE);
        sampleDataFileKey.setBusinessObjectDefinitionName(BDEF_NAME);
        sampleDataFileKey.setDirectoryPath(DIRECTORY_PATH);
        sampleDataFileKey.setFileName(FILE_NAME);
        downloadRequest.setBusinessObjectDefinitionSampleDataFileKey(sampleDataFileKey);
        DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationResponse downloadResponse = this.uploadDownloadService.initiateDownloadSingleSampleFile(downloadRequest);
        Assert.assertNotNull((Object)downloadResponse.getAwsSessionExpirationTime());
        Assert.assertNotNull((Object)downloadResponse.getPreSignedUrl());
        Assert.assertEquals((Object)new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationResponse(new BusinessObjectDefinitionSampleDataFileKey(NAMESPACE, BDEF_NAME, DIRECTORY_PATH, FILE_NAME), S3_BUCKET_NAME, "mock_aws_assumed_role_access_key", "mock_aws_assumed_role_secret_key", "mock_aws_assumed_role_session_token", downloadResponse.getAwsSessionExpirationTime(), downloadResponse.getPreSignedUrl()), (Object)downloadResponse);
    }

    @Test
    public void testDownloadBusinessObjectDefinitionSampleFileLowerCaseParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectDefinitionServiceTestHelper.getTestSampleDataFiles());
        List<SampleDataFile> sampleFileList = this.businessObjectDefinitionServiceTestHelper.getTestSampleDataFiles();
        StorageEntity storageEntity = this.storageDaoHelper.getStorageEntity(STORAGE_NAME);
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucketName"));
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_DOWNLOAD_ROLE_ARN), "downloadRole"));
        DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest downloadRequest = new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest();
        BusinessObjectDefinitionSampleDataFileKey sampleDataFileKey = new BusinessObjectDefinitionSampleDataFileKey();
        sampleDataFileKey.setBusinessObjectDefinitionName(BDEF_NAME);
        sampleDataFileKey.setNamespace(NAMESPACE);
        sampleDataFileKey.setDirectoryPath(sampleFileList.get(0).getDirectoryPath());
        sampleDataFileKey.setFileName(sampleFileList.get(0).getFileName());
        BusinessObjectDefinitionSampleDataFileKey sampleDataFileKeyLowerCase = new BusinessObjectDefinitionSampleDataFileKey();
        sampleDataFileKeyLowerCase.setBusinessObjectDefinitionName(BDEF_NAME.toLowerCase());
        sampleDataFileKeyLowerCase.setNamespace(NAMESPACE.toLowerCase());
        sampleDataFileKeyLowerCase.setDirectoryPath(sampleFileList.get(0).getDirectoryPath());
        sampleDataFileKeyLowerCase.setFileName(sampleFileList.get(0).getFileName());
        downloadRequest.setBusinessObjectDefinitionSampleDataFileKey(sampleDataFileKeyLowerCase);
        DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationResponse downloadResponse = this.uploadDownloadService.initiateDownloadSingleSampleFile(downloadRequest);
        Assert.assertEquals((Object)downloadResponse.getBusinessObjectDefinitionSampleDataFileKey(), (Object)sampleDataFileKey);
        Assert.assertNotNull((Object)downloadResponse.getAwsS3BucketName());
        Assert.assertNotNull((Object)downloadResponse.getAwsAccessKey());
        Assert.assertNotNull((Object)downloadResponse.getAwsSecretKey());
        Assert.assertNotNull((Object)downloadResponse.getAwsSessionExpirationTime());
        Assert.assertNotNull((Object)downloadResponse.getAwsSessionToken());
        Assert.assertNotNull((Object)downloadResponse.getPreSignedUrl());
    }

    @Test
    public void testDownloadBusinessObjectDefinitionSampleFileUpperCaseParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectDefinitionServiceTestHelper.getTestSampleDataFiles());
        List<SampleDataFile> sampleFileList = this.businessObjectDefinitionServiceTestHelper.getTestSampleDataFiles();
        StorageEntity storageEntity = this.storageDaoHelper.getStorageEntity(STORAGE_NAME);
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucketName"));
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_DOWNLOAD_ROLE_ARN), "downloadRole"));
        DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest downloadRequest = new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest();
        BusinessObjectDefinitionSampleDataFileKey sampleDataFileKey = new BusinessObjectDefinitionSampleDataFileKey();
        sampleDataFileKey.setBusinessObjectDefinitionName(BDEF_NAME);
        sampleDataFileKey.setNamespace(NAMESPACE);
        sampleDataFileKey.setDirectoryPath(sampleFileList.get(0).getDirectoryPath());
        sampleDataFileKey.setFileName(sampleFileList.get(0).getFileName());
        BusinessObjectDefinitionSampleDataFileKey sampleDataFileKeyUpperCase = new BusinessObjectDefinitionSampleDataFileKey();
        sampleDataFileKeyUpperCase.setBusinessObjectDefinitionName(BDEF_NAME.toUpperCase());
        sampleDataFileKeyUpperCase.setNamespace(NAMESPACE.toUpperCase());
        sampleDataFileKeyUpperCase.setDirectoryPath(sampleFileList.get(0).getDirectoryPath());
        sampleDataFileKeyUpperCase.setFileName(sampleFileList.get(0).getFileName());
        downloadRequest.setBusinessObjectDefinitionSampleDataFileKey(sampleDataFileKeyUpperCase);
        DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationResponse downloadResponse = this.uploadDownloadService.initiateDownloadSingleSampleFile(downloadRequest);
        Assert.assertEquals((Object)downloadResponse.getBusinessObjectDefinitionSampleDataFileKey(), (Object)sampleDataFileKey);
        Assert.assertNotNull((Object)downloadResponse.getAwsS3BucketName());
        Assert.assertNotNull((Object)downloadResponse.getAwsAccessKey());
        Assert.assertNotNull((Object)downloadResponse.getAwsSecretKey());
        Assert.assertNotNull((Object)downloadResponse.getAwsSessionExpirationTime());
        Assert.assertNotNull((Object)downloadResponse.getAwsSessionToken());
        Assert.assertNotNull((Object)downloadResponse.getPreSignedUrl());
    }

    @Test
    public void testDownloadBusinessObjectDefinitionSampleFileTrimmedParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectDefinitionServiceTestHelper.getTestSampleDataFiles());
        List<SampleDataFile> sampleFileList = this.businessObjectDefinitionServiceTestHelper.getTestSampleDataFiles();
        StorageEntity storageEntity = this.storageDaoHelper.getStorageEntity(STORAGE_NAME);
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), "testBucketName"));
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_DOWNLOAD_ROLE_ARN), "downloadRole"));
        DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest downloadRequest = new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest();
        BusinessObjectDefinitionSampleDataFileKey sampleDataFileKey = new BusinessObjectDefinitionSampleDataFileKey();
        sampleDataFileKey.setBusinessObjectDefinitionName(BDEF_NAME);
        sampleDataFileKey.setNamespace(NAMESPACE);
        sampleDataFileKey.setDirectoryPath(sampleFileList.get(0).getDirectoryPath());
        sampleDataFileKey.setFileName(sampleFileList.get(0).getFileName());
        BusinessObjectDefinitionSampleDataFileKey sampleDataFileKeyPadded = new BusinessObjectDefinitionSampleDataFileKey();
        sampleDataFileKeyPadded.setBusinessObjectDefinitionName(" " + BDEF_NAME + " ");
        sampleDataFileKeyPadded.setNamespace(" " + NAMESPACE + " ");
        sampleDataFileKeyPadded.setDirectoryPath(sampleFileList.get(0).getDirectoryPath());
        sampleDataFileKeyPadded.setFileName(sampleFileList.get(0).getFileName());
        downloadRequest.setBusinessObjectDefinitionSampleDataFileKey(sampleDataFileKeyPadded);
        DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationResponse downloadResponse = this.uploadDownloadService.initiateDownloadSingleSampleFile(downloadRequest);
        Assert.assertEquals((Object)downloadResponse.getBusinessObjectDefinitionSampleDataFileKey(), (Object)sampleDataFileKey);
        Assert.assertNotNull((Object)downloadResponse.getAwsS3BucketName());
        Assert.assertNotNull((Object)downloadResponse.getAwsAccessKey());
        Assert.assertNotNull((Object)downloadResponse.getAwsSecretKey());
        Assert.assertNotNull((Object)downloadResponse.getAwsSessionExpirationTime());
        Assert.assertNotNull((Object)downloadResponse.getAwsSessionToken());
        Assert.assertNotNull((Object)downloadResponse.getPreSignedUrl());
    }

    @Test
    public void testDownloadBusinessObjectDefinitionSampleFilesMissingRequiredParameters() {
        try {
            this.uploadDownloadService.initiateDownloadSingleSampleFile(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A download business object definition sample data file single initiation request must be specified.", (Object)e.getMessage());
        }
        try {
            this.uploadDownloadService.initiateDownloadSingleSampleFile(new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest(null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition sample data file key must be specified.", (Object)e.getMessage());
        }
        try {
            this.uploadDownloadService.initiateDownloadSingleSampleFile(new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest(new BusinessObjectDefinitionSampleDataFileKey("      \t\t ", BDEF_NAME, DIRECTORY_PATH, FILE_NAME)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.uploadDownloadService.initiateDownloadSingleSampleFile(new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest(new BusinessObjectDefinitionSampleDataFileKey(NAMESPACE, "      \t\t ", DIRECTORY_PATH, FILE_NAME)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.uploadDownloadService.initiateDownloadSingleSampleFile(new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest(new BusinessObjectDefinitionSampleDataFileKey(NAMESPACE, BDEF_NAME, "      \t\t ", FILE_NAME)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A directory path must be specified.", (Object)e.getMessage());
        }
        try {
            this.uploadDownloadService.initiateDownloadSingleSampleFile(new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest(new BusinessObjectDefinitionSampleDataFileKey(NAMESPACE, BDEF_NAME, DIRECTORY_PATH, "      \t\t ")));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A file name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDownloadBusinessObjectDefinitionInvalidParameters() {
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_DOWNLOAD_ROLE_ARN), DOWNLOADER_ROLE_ARN)));
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), Arrays.asList(new SampleDataFile(DIRECTORY_PATH, FILE_NAME)));
        try {
            this.uploadDownloadService.initiateDownloadSingleSampleFile(new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest(new BusinessObjectDefinitionSampleDataFileKey("I_DO_NOT_EXIST", BDEF_NAME, DIRECTORY_PATH, FILE_NAME)));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME), (Object)e.getMessage());
        }
        try {
            this.uploadDownloadService.initiateDownloadSingleSampleFile(new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest(new BusinessObjectDefinitionSampleDataFileKey(NAMESPACE, "I_DO_NOT_EXIST", DIRECTORY_PATH, FILE_NAME)));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionNotFoundErrorMessage(NAMESPACE, "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.uploadDownloadService.initiateDownloadSingleSampleFile(new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest(new BusinessObjectDefinitionSampleDataFileKey(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FILE_NAME)));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" and namespace \"%s\" does not have the specified sample file registered with file name \"%s\" in directory path \"%s\"", BDEF_NAME, NAMESPACE, FILE_NAME, "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.uploadDownloadService.initiateDownloadSingleSampleFile(new DownloadBusinessObjectDefinitionSampleDataFileSingleInitiationRequest(new BusinessObjectDefinitionSampleDataFileKey(NAMESPACE, BDEF_NAME, DIRECTORY_PATH, "I_DO_NOT_EXIST")));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" and namespace \"%s\" does not have the specified sample file registered with file name \"%s\" in directory path \"%s\"", BDEF_NAME, NAMESPACE, "I_DO_NOT_EXIST", DIRECTORY_PATH), (Object)e.getMessage());
        }
    }

    @Test
    public void testUploadBusinessObjectDefinitionSampleFile() {
        String s3_velocity_template = "$namespace/$businessObjectDefinitionName";
        String expectedS3Keyprefix = NAMESPACE.toLowerCase() + "/" + BDEF_NAME.toLowerCase() + "/";
        expectedS3Keyprefix = expectedS3Keyprefix.replace("_", "-");
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), UPLOADER_ROLE_ARN), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), s3_velocity_template)));
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        UploadBusinessObjectDefinitionSampleDataFileInitiationRequest request = new UploadBusinessObjectDefinitionSampleDataFileInitiationRequest();
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        request.setBusinessObjectDefinitionKey(businessObjectDefinitionKey);
        UploadBusinessObjectDefinitionSampleDataFileInitiationResponse response = this.uploadDownloadService.initiateUploadSampleFile(request);
        Assert.assertEquals((Object)response.getBusinessObjectDefinitionKey(), (Object)businessObjectDefinitionKey);
        Assert.assertEquals((Object)response.getAwsS3BucketName(), (Object)S3_BUCKET_NAME);
        Assert.assertEquals((Object)response.getS3KeyPrefix(), (Object)expectedS3Keyprefix);
        Assert.assertEquals((Object)response.getAwsAccessKey(), (Object)"mock_aws_assumed_role_access_key");
        Assert.assertEquals((Object)response.getAwsSecretKey(), (Object)"mock_aws_assumed_role_secret_key");
        Assert.assertEquals((Object)response.getAwsSessionToken(), (Object)"mock_aws_assumed_role_session_token");
    }

    @Test
    public void testUploadBusinessObjectDefinitionSampleFileLowerCase() {
        String s3_velocity_template = "$namespace/$businessObjectDefinitionName";
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), UPLOADER_ROLE_ARN), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), s3_velocity_template)));
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        UploadBusinessObjectDefinitionSampleDataFileInitiationRequest request = new UploadBusinessObjectDefinitionSampleDataFileInitiationRequest();
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionKey businessObjectDefinitionKeyLowerCase = new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase());
        request.setBusinessObjectDefinitionKey(businessObjectDefinitionKeyLowerCase);
        UploadBusinessObjectDefinitionSampleDataFileInitiationResponse response = this.uploadDownloadService.initiateUploadSampleFile(request);
        Assert.assertEquals((Object)response.getBusinessObjectDefinitionKey(), (Object)businessObjectDefinitionKey);
        Assert.assertEquals((Object)response.getAwsS3BucketName(), (Object)S3_BUCKET_NAME);
        Assert.assertEquals((Object)response.getAwsAccessKey(), (Object)"mock_aws_assumed_role_access_key");
        Assert.assertEquals((Object)response.getAwsSecretKey(), (Object)"mock_aws_assumed_role_secret_key");
        Assert.assertEquals((Object)response.getAwsSessionToken(), (Object)"mock_aws_assumed_role_session_token");
    }

    @Test
    public void testUploadBusinessObjectDefinitionSampleFileUpperCase() {
        String s3_velocity_template = "$namespace/$businessObjectDefinitionName";
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), UPLOADER_ROLE_ARN), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), s3_velocity_template)));
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        UploadBusinessObjectDefinitionSampleDataFileInitiationRequest request = new UploadBusinessObjectDefinitionSampleDataFileInitiationRequest();
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionKey businessObjectDefinitionKeyUpperCase = new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase());
        request.setBusinessObjectDefinitionKey(businessObjectDefinitionKeyUpperCase);
        UploadBusinessObjectDefinitionSampleDataFileInitiationResponse response = this.uploadDownloadService.initiateUploadSampleFile(request);
        Assert.assertEquals((Object)response.getBusinessObjectDefinitionKey(), (Object)businessObjectDefinitionKey);
        Assert.assertEquals((Object)response.getAwsS3BucketName(), (Object)S3_BUCKET_NAME);
        Assert.assertEquals((Object)response.getAwsAccessKey(), (Object)"mock_aws_assumed_role_access_key");
        Assert.assertEquals((Object)response.getAwsSecretKey(), (Object)"mock_aws_assumed_role_secret_key");
        Assert.assertEquals((Object)response.getAwsSessionToken(), (Object)"mock_aws_assumed_role_session_token");
    }

    @Test
    public void testUploadBusinessObjectDefinitionSampleFileTrimedParameters() {
        String s3_velocity_template = "$namespace/$businessObjectDefinitionName";
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), UPLOADER_ROLE_ARN), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), s3_velocity_template)));
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        UploadBusinessObjectDefinitionSampleDataFileInitiationRequest request = new UploadBusinessObjectDefinitionSampleDataFileInitiationRequest();
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionKey businessObjectDefinitionKeyWhitespace = new BusinessObjectDefinitionKey("    " + NAMESPACE + " ", "   " + BDEF_NAME + "  ");
        request.setBusinessObjectDefinitionKey(businessObjectDefinitionKeyWhitespace);
        UploadBusinessObjectDefinitionSampleDataFileInitiationResponse response = this.uploadDownloadService.initiateUploadSampleFile(request);
        Assert.assertEquals((Object)response.getBusinessObjectDefinitionKey(), (Object)businessObjectDefinitionKey);
        Assert.assertEquals((Object)response.getAwsS3BucketName(), (Object)S3_BUCKET_NAME);
        Assert.assertEquals((Object)response.getAwsAccessKey(), (Object)"mock_aws_assumed_role_access_key");
        Assert.assertEquals((Object)response.getAwsSecretKey(), (Object)"mock_aws_assumed_role_secret_key");
        Assert.assertEquals((Object)response.getAwsSessionToken(), (Object)"mock_aws_assumed_role_session_token");
    }

    @Test
    public void testUploadBusinessObjectDefinitionSampleFileMissingParameter() {
        UploadBusinessObjectDefinitionSampleDataFileInitiationRequest request;
        BusinessObjectDefinitionKey businessObjectDefinitionKey;
        try {
            this.uploadDownloadService.initiateUploadSampleFile(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An upload initiation request must be specified.", (Object)e.getMessage());
        }
        try {
            this.uploadDownloadService.initiateUploadSampleFile(new UploadBusinessObjectDefinitionSampleDataFileInitiationRequest(null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition key must be specified.", (Object)e.getMessage());
        }
        try {
            businessObjectDefinitionKey = new BusinessObjectDefinitionKey("NAMESPACE", null);
            request = new UploadBusinessObjectDefinitionSampleDataFileInitiationRequest(businessObjectDefinitionKey);
            this.uploadDownloadService.initiateUploadSampleFile(request);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            businessObjectDefinitionKey = new BusinessObjectDefinitionKey(null, "BDEF");
            request = new UploadBusinessObjectDefinitionSampleDataFileInitiationRequest(businessObjectDefinitionKey);
            this.uploadDownloadService.initiateUploadSampleFile(request);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUploadBusinessObjectDefinitionSampleFileInvalidParameter() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        UploadBusinessObjectDefinitionSampleDataFileInitiationRequest request = new UploadBusinessObjectDefinitionSampleDataFileInitiationRequest(businessObjectDefinitionKey);
        try {
            this.uploadDownloadService.initiateUploadSampleFile(request);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionNotFoundErrorMessage(NAMESPACE, BDEF_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testUploadBusinessObjectDefinitionSampleFileMissingTemplate() {
        String expectedS3Keyprefix = NAMESPACE.toLowerCase() + "/" + BDEF_NAME.toLowerCase() + "/";
        expectedS3Keyprefix = expectedS3Keyprefix.replace("_", "-");
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_UPLOAD_ROLE_ARN), UPLOADER_ROLE_ARN)));
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        UploadBusinessObjectDefinitionSampleDataFileInitiationRequest request = new UploadBusinessObjectDefinitionSampleDataFileInitiationRequest();
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        request.setBusinessObjectDefinitionKey(businessObjectDefinitionKey);
        try {
            this.uploadDownloadService.initiateUploadSampleFile(request);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage \"%s\" has no S3 key prefix velocity template configured.", "S3_MANAGED_SAMPLE_DATA"), (Object)e.getMessage());
        }
    }
}

