/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti;

import java.util.concurrent.LinkedBlockingQueue;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.spring.SpringAsyncExecutor;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ActivitiProcessEngineConfigurationTest
extends AbstractServiceTest {
    @Autowired
    private ProcessEngineConfiguration processEngineConfiguration;
    @Autowired
    @Qualifier(value="getAsyncExecutor")
    private TaskExecutor genericTaskExecutor;

    @Test
    public void testActivitiThreadPoolIsIsolatedFromGenericAsyncPool() {
        AsyncExecutor asyncExecutor = this.processEngineConfiguration.getAsyncExecutor();
        SpringAsyncExecutor springAsyncExecutor = (SpringAsyncExecutor)asyncExecutor;
        TaskExecutor taskExecutor = springAsyncExecutor.getTaskExecutor();
        Assert.assertTrue((this.genericTaskExecutor != taskExecutor ? 1 : 0) != 0);
    }

    @Test
    public void testActivitiThreadPoolUsesConfiguredValues() {
        AsyncExecutor asyncExecutor = this.processEngineConfiguration.getAsyncExecutor();
        SpringAsyncExecutor springAsyncExecutor = (SpringAsyncExecutor)asyncExecutor;
        TaskExecutor taskExecutor = springAsyncExecutor.getTaskExecutor();
        ThreadPoolTaskExecutor threadPoolTaskExecutor = (ThreadPoolTaskExecutor)taskExecutor;
        Integer corePoolSize = threadPoolTaskExecutor.getCorePoolSize();
        Integer maxPoolSize = threadPoolTaskExecutor.getMaxPoolSize();
        Integer keepAliveSeconds = threadPoolTaskExecutor.getKeepAliveSeconds();
        Integer remainingCapacity = ((LinkedBlockingQueue)threadPoolTaskExecutor.getThreadPoolExecutor().getQueue()).remainingCapacity();
        Assert.assertEquals((Object)this.configurationHelper.getProperty(ConfigurationValue.ACTIVITI_THREAD_POOL_CORE_POOL_SIZE, Integer.class), (Object)corePoolSize);
        Assert.assertEquals((Object)this.configurationHelper.getProperty(ConfigurationValue.ACTIVITI_THREAD_POOL_MAX_POOL_SIZE, Integer.class), (Object)maxPoolSize);
        Assert.assertEquals((Object)this.configurationHelper.getProperty(ConfigurationValue.ACTIVITI_THREAD_POOL_KEEP_ALIVE_SECS, Integer.class), (Object)keepAliveSeconds);
        Assert.assertEquals((Object)this.configurationHelper.getProperty(ConfigurationValue.ACTIVITI_THREAD_POOL_QUEUE_CAPACITY, Integer.class), (Object)remainingCapacity);
    }
}

