/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.CheckBusinessObjectDataAvailability;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Test;

public class CheckBusinessObjectDataAvailabilityTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testAvailabilityTaskWithPartitionValues() throws Exception {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(null);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>(this.getMandatoryFields());
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionKey", "${partitionKey}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValues", "${partitionValues}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getMandatoryParameters());
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionKey", "PRTN_CLMN001"));
        parameters.add(this.buildParameter("partitionValues", this.herdStringHelper.buildStringWithDefaultDelimiter(STORAGE_1_AVAILABLE_PARTITION_VALUES)));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("isAllDataAvailable", Boolean.TRUE);
        this.testActivitiServiceTaskSuccess(CheckBusinessObjectDataAvailability.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testAvailabilityTaskWithPartitionRange() throws Exception {
        this.businessObjectDataAvailabilityTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityTesting(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueProcessDatesForApril2014(PARTITION_KEY_GROUP);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>(this.getMandatoryFields());
        fieldExtensionList.add(this.buildFieldExtension("startPartitionValue", "${startPartitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("endPartitionValue", "${endPartitionValue}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getMandatoryParameters());
        parameters.add(this.buildParameter("startPartitionValue", "2014-04-02"));
        parameters.add(this.buildParameter("endPartitionValue", "2014-04-08"));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("isAllDataAvailable", Boolean.FALSE);
        this.testActivitiServiceTaskSuccess(CheckBusinessObjectDataAvailability.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testAvailabilityTaskWithInvalidFormatVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", "invalid_integer"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectFormatVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(CheckBusinessObjectDataAvailability.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testAvailabilityTaskWithInvalidDataVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectDataVersion", "invalid_integer"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(CheckBusinessObjectDataAvailability.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testAvailabilityTaskWithPartitionRangeWithoutStartPartitionValue() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>(this.getMandatoryFields());
        fieldExtensionList.add(this.buildFieldExtension("startPartitionValue", "${startPartitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("endPartitionValue", "${endPartitionValue}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getMandatoryParameters());
        parameters.add(this.buildParameter("startPartitionValue", "      \t\t "));
        parameters.add(this.buildParameter("endPartitionValue", "2014-04-08"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "A start partition value for the partition value range must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(CheckBusinessObjectDataAvailability.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    private List<FieldExtension> getMandatoryFields() {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("storageName", "${storageName}"));
        return fieldExtensionList;
    }

    private List<Parameter> getMandatoryParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("storageName", STORAGE_NAME));
        return parameters;
    }
}

