/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.history.HistoricProcessInstance;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CheckEmrClusterTest
extends AbstractServiceTest {
    public static final String taskName = "checkClusterServiceTask";

    @Before
    public void createDatabaseEntities() {
        this.ec2OnDemandPricingDaoTestHelper.createEc2OnDemandPricingEntities();
    }

    @Test
    public void testCheckClusterByClusterIdStepId() throws Exception {
        List<FieldExtension> fieldExtensions = this.getOptionalFieldExtensions();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrStepId");
        fieldExtension.setExpression("${addHiveStepServiceTask_emrStepId}");
        fieldExtensions.add(fieldExtension);
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(this.getCheckClusterActivitiXml(fieldExtensions), this.getParameters(true, "false", "false"));
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String hiveStepId = (String)variables.get("addHiveStepServiceTask_emrStepId");
        String emrStepId = (String)variables.get("checkClusterServiceTask_step_id");
        Assert.assertEquals((Object)hiveStepId, (Object)emrStepId);
        String emrStepJarLocation = (String)variables.get("checkClusterServiceTask_step_jarLocation");
        Assert.assertNull((Object)emrStepJarLocation);
        String shellStepId = (String)variables.get("addShellStepServiceTask_emrStepId");
        Assert.assertNotNull((Object)shellStepId);
        String activeStepId = (String)variables.get("checkClusterServiceTask_activeStep_id");
        Assert.assertEquals((Object)shellStepId, (Object)activeStepId);
        String activeStepJarLocation = (String)variables.get("checkClusterServiceTask_activeStep_jarLocation");
        Assert.assertNull((Object)activeStepJarLocation);
    }

    @Test
    public void testCheckClusterByClusterIdStepIdRequestedStepHasNoId() throws Exception {
        List<FieldExtension> fieldExtensions = this.getOptionalFieldExtensions();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrStepId");
        fieldExtension.setExpression("${addHiveStepServiceTask_emrStepId}");
        fieldExtensions.add(fieldExtension);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", "testCluster1"));
        parameters.add(new Parameter("hiveStepName", "mock_step_without_id_name"));
        parameters.add(new Parameter("hiveScriptLocation", "a_hive_step_location"));
        parameters.add(new Parameter("shellStepName", "mock_step_running_name"));
        parameters.add(new Parameter("shellScriptLocation", "a_shell_step_location"));
        parameters.add(new Parameter("verbose", "false"));
        parameters.add(new Parameter("retrieveInstanceFleets", "false"));
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(this.getCheckClusterActivitiXml(fieldExtensions), parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String hiveStepId = (String)variables.get("addHiveStepServiceTask_emrStepId");
        Assert.assertNotNull((Object)hiveStepId);
        String emrStepId = (String)variables.get("checkClusterServiceTask_step_id");
        Assert.assertNull((Object)emrStepId);
        String emrStepJarLocation = (String)variables.get("checkClusterServiceTask_step_jarLocation");
        Assert.assertNull((Object)emrStepJarLocation);
        String shellStepId = (String)variables.get("addShellStepServiceTask_emrStepId");
        Assert.assertNotNull((Object)shellStepId);
        String activeStepId = (String)variables.get("checkClusterServiceTask_activeStep_id");
        Assert.assertEquals((Object)shellStepId, (Object)activeStepId);
        String activeStepJarLocation = (String)variables.get("checkClusterServiceTask_activeStep_jarLocation");
        Assert.assertNull((Object)activeStepJarLocation);
    }

    @Test
    public void testCheckClusterByClusterIdStepIdVerbose() throws Exception {
        List<FieldExtension> fieldExtensions = this.getOptionalFieldExtensions();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrStepId");
        fieldExtension.setExpression("${addHiveStepServiceTask_emrStepId}");
        fieldExtensions.add(fieldExtension);
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(this.getCheckClusterActivitiXml(fieldExtensions), this.getParameters(true, "true", "false"));
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String hiveStepId = (String)variables.get("addHiveStepServiceTask_emrStepId");
        Assert.assertNotNull((Object)hiveStepId);
        String emrStepId = (String)variables.get("checkClusterServiceTask_step_id");
        Assert.assertEquals((Object)hiveStepId, (Object)emrStepId);
        String emrStepJarLocation = (String)variables.get("checkClusterServiceTask_step_jarLocation");
        Assert.assertNotNull((Object)emrStepJarLocation);
        String shellStepId = (String)variables.get("addShellStepServiceTask_emrStepId");
        Assert.assertNotNull((Object)shellStepId);
        String activeStepId = (String)variables.get("checkClusterServiceTask_activeStep_id");
        Assert.assertEquals((Object)shellStepId, (Object)activeStepId);
        String activeStepJarLocation = (String)variables.get("checkClusterServiceTask_activeStep_jarLocation");
        Assert.assertNotNull((Object)activeStepJarLocation);
    }

    @Test
    public void testCheckClusterByClusterIdStepIdNoActiveStep() throws Exception {
        List<FieldExtension> fieldExtensions = this.getOptionalFieldExtensions();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrStepId");
        fieldExtension.setExpression("${addHiveStepServiceTask_emrStepId}");
        fieldExtensions.add(fieldExtension);
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(this.getCheckClusterActivitiXml(fieldExtensions), this.getParameters(false, "false", "false"));
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String hiveStepId = (String)variables.get("addHiveStepServiceTask_emrStepId");
        Assert.assertNotNull((Object)hiveStepId);
        String emrStepId = (String)variables.get("checkClusterServiceTask_step_id");
        Assert.assertEquals((Object)hiveStepId, (Object)emrStepId);
        String emrStepJarLocation = (String)variables.get("checkClusterServiceTask_step_jarLocation");
        Assert.assertNull((Object)emrStepJarLocation);
        String activeStepId = (String)variables.get("checkClusterServiceTask_activeStep_id");
        Assert.assertNull((Object)activeStepId);
    }

    @Test
    public void testCheckClusterByClusterIdStepIdActiveStepHasNoId() throws Exception {
        List<FieldExtension> fieldExtensions = this.getOptionalFieldExtensions();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrStepId");
        fieldExtension.setExpression("${addHiveStepServiceTask_emrStepId}");
        fieldExtensions.add(fieldExtension);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", "testCluster1"));
        parameters.add(new Parameter("hiveStepName", "a_hive_step"));
        parameters.add(new Parameter("hiveScriptLocation", "a_hive_step_location"));
        parameters.add(new Parameter("shellStepName", "mock_step_running_without_id_name"));
        parameters.add(new Parameter("shellScriptLocation", "a_shell_step_location"));
        parameters.add(new Parameter("verbose", "false"));
        parameters.add(new Parameter("retrieveInstanceFleets", "false"));
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(this.getCheckClusterActivitiXml(fieldExtensions), parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String hiveStepId = (String)variables.get("addHiveStepServiceTask_emrStepId");
        Assert.assertNotNull((Object)hiveStepId);
        String emrStepId = (String)variables.get("checkClusterServiceTask_step_id");
        Assert.assertEquals((Object)hiveStepId, (Object)emrStepId);
        String emrStepJarLocation = (String)variables.get("checkClusterServiceTask_step_jarLocation");
        Assert.assertNull((Object)emrStepJarLocation);
        String activeStepId = (String)variables.get("checkClusterServiceTask_activeStep_id");
        Assert.assertNull((Object)activeStepId);
    }

    @Test
    public void testCheckCluster() throws Exception {
        Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowCheckEmrCluster.bpmn20.xml", this.getParameters(true, "", "false"));
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        Assert.assertTrue((boolean)variables.containsKey("checkClusterServiceTask_emrClusterId"));
        Assert.assertTrue((boolean)variables.containsKey("checkClusterServiceTask_emrClusterStatus"));
        Assert.assertTrue((boolean)variables.containsKey("checkClusterServiceTask_emrClusterStatus_creationTime"));
        Assert.assertTrue((boolean)variables.containsKey("checkClusterServiceTask_emrClusterStatus_readyTime"));
        Assert.assertTrue((boolean)variables.containsKey("checkClusterServiceTask_emrClusterStatus_endTime"));
        Assert.assertTrue((boolean)variables.containsKey("checkClusterServiceTask_emrClusterStatus_changeReasonCode"));
        Assert.assertTrue((boolean)variables.containsKey("checkClusterServiceTask_emrClusterStatus_changeReasonMessage"));
    }

    @Test
    public void testCheckClusterByRetrieveInstanceFleets() throws Exception {
        List<FieldExtension> fieldExtensions = this.getOptionalFieldExtensions();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrStepId");
        fieldExtension.setExpression("${addHiveStepServiceTask_emrStepId}");
        fieldExtensions.add(fieldExtension);
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(this.getCheckClusterActivitiXml(fieldExtensions), this.getParameters(true, "true", "true"));
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String emrClusterInstanceFleetJson = (String)variables.get("checkClusterServiceTask_instance_fleets");
        Assert.assertNotNull((Object)emrClusterInstanceFleetJson);
    }

    private List<Parameter> getParameters(boolean isShellStepRunning, String verbose, String retrieveInstanceFleets) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", "testCluster1"));
        parameters.add(new Parameter("hiveStepName", "a_hive_step"));
        parameters.add(new Parameter("hiveScriptLocation", "a_hive_step_location"));
        parameters.add(new Parameter("shellStepName", isShellStepRunning ? "mock_step_running_name" : "a_shell_step"));
        parameters.add(new Parameter("shellScriptLocation", "a_shell_step_location"));
        parameters.add(new Parameter("verbose", verbose));
        parameters.add(new Parameter("retrieveInstanceFleets", retrieveInstanceFleets));
        return parameters;
    }

    private String getCheckClusterActivitiXml(List<FieldExtension> checkClusterFieldExtensions) throws Exception {
        BpmnModel bpmnModel = this.getBpmnModelForXmlResource("classpath:org/finra/herd/service/activitiWorkflowCheckEmrCluster.bpmn20.xml");
        ServiceTask serviceTask = (ServiceTask)((Process)bpmnModel.getProcesses().get(0)).getFlowElement(taskName);
        serviceTask.getFieldExtensions().addAll(checkClusterFieldExtensions);
        return this.getActivitiXmlFromBpmnModel(bpmnModel);
    }

    private List<FieldExtension> getOptionalFieldExtensions() {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrClusterId");
        fieldExtension.setExpression("${createClusterServiceTask_emrClusterId}");
        fieldExtensionList.add(fieldExtension);
        fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("verbose");
        fieldExtension.setExpression("${verbose}");
        fieldExtensionList.add(fieldExtension);
        fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("retrieveInstanceFleets");
        fieldExtension.setExpression("${retrieveInstanceFleets}");
        fieldExtensionList.add(fieldExtension);
        return fieldExtensionList;
    }
}

