/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.engine.history.HistoricProcessInstance;
import org.finra.herd.model.api.xml.BusinessObjectDataAttribute;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.CreateBusinessObjectDataAttribute;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Assert;
import org.junit.Test;

public class CreateBusinessObjectDataAttributeTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testCreateBusinessObjectDataAttribute() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAttributeName", "${businessObjectDataAttributeName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAttributeValue", "${businessObjectDataAttributeValue}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("subPartitionValues", this.herdStringHelper.buildStringWithDefaultDelimiter(SUBPARTITION_VALUES)));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataAttributeName", "Attribute Name 1"));
        parameters.add(this.buildParameter("businessObjectDataAttributeValue", "Attribute Value 1"));
        String activitiXml = this.buildActivitiXml(CreateBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList);
        Job job = this.jobServiceTestHelper.createJobFromActivitiXml(activitiXml, parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
        Assert.assertEquals((Object)"SUCCESS", (Object)serviceTaskStatus);
        String jsonResponse = (String)variables.get(this.getServiceTaskVariableName("jsonResponse"));
        ObjectMapper objectMapper = new ObjectMapper();
        BusinessObjectDataAttribute businessObjectDataAttribute = (BusinessObjectDataAttribute)objectMapper.readValue(jsonResponse.getBytes(), BusinessObjectDataAttribute.class);
        Assert.assertEquals((Object)BDEF_NAMESPACE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getNamespace());
        Assert.assertEquals((Object)BDEF_NAME, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)FORMAT_USAGE_CODE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)FORMAT_FILE_TYPE_CODE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)FORMAT_VERSION, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)PARTITION_VALUE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getPartitionValue());
        Assert.assertEquals((Object)SUBPARTITION_VALUES, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getSubPartitionValues());
        Assert.assertEquals((Object)DATA_VERSION, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectDataVersion());
        Assert.assertEquals((Object)"Attribute Name 1", (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectDataAttributeName());
        Assert.assertEquals((Object)"Attribute Value 1", (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeValue());
    }

    @Test
    public void testCreateBusinessObjectDataAttributeMissingRequiredParameter() throws Exception {
        ArrayList fieldExtensionList = new ArrayList();
        ArrayList parameters = new ArrayList();
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "A namespace must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(CreateBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testCreateBusinessObjectDataAttributeMissingOptionalParameters() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAttributeName", "${businessObjectDataAttributeName}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataAttributeName", "Attribute Name 1"));
        String activitiXml = this.buildActivitiXml(CreateBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList);
        Job job = this.jobServiceTestHelper.createJobFromActivitiXml(activitiXml, parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
        Assert.assertEquals((Object)"SUCCESS", (Object)serviceTaskStatus);
        String jsonResponse = (String)variables.get(this.getServiceTaskVariableName("jsonResponse"));
        ObjectMapper objectMapper = new ObjectMapper();
        BusinessObjectDataAttribute businessObjectDataAttribute = (BusinessObjectDataAttribute)objectMapper.readValue(jsonResponse.getBytes(), BusinessObjectDataAttribute.class);
        Assert.assertEquals((Object)BDEF_NAMESPACE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getNamespace());
        Assert.assertEquals((Object)BDEF_NAME, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)FORMAT_USAGE_CODE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)FORMAT_FILE_TYPE_CODE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)FORMAT_VERSION, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)PARTITION_VALUE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getPartitionValue());
        Assert.assertEquals((Object)NO_SUBPARTITION_VALUES, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getSubPartitionValues());
        Assert.assertEquals((Object)DATA_VERSION, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectDataVersion());
        Assert.assertEquals((Object)"Attribute Name 1", (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectDataAttributeName());
        Assert.assertNull((Object)businessObjectDataAttribute.getBusinessObjectDataAttributeValue());
    }

    @Test
    public void testCreateBusinessObjectDataAttributeMissingOptionalParametersSubPartitionValuesAsEmptyString() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAttributeName", "${businessObjectDataAttributeName}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("subPartitionValues", ""));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataAttributeName", "Attribute Name 1"));
        String activitiXml = this.buildActivitiXml(CreateBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList);
        Job job = this.jobServiceTestHelper.createJobFromActivitiXml(activitiXml, parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
        Assert.assertEquals((Object)"SUCCESS", (Object)serviceTaskStatus);
        String jsonResponse = (String)variables.get(this.getServiceTaskVariableName("jsonResponse"));
        ObjectMapper objectMapper = new ObjectMapper();
        BusinessObjectDataAttribute businessObjectDataAttribute = (BusinessObjectDataAttribute)objectMapper.readValue(jsonResponse.getBytes(), BusinessObjectDataAttribute.class);
        Assert.assertEquals((Object)BDEF_NAMESPACE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getNamespace());
        Assert.assertEquals((Object)BDEF_NAME, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)FORMAT_USAGE_CODE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)FORMAT_FILE_TYPE_CODE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectFormatFileType());
        Assert.assertEquals((Object)FORMAT_VERSION, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)PARTITION_VALUE, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getPartitionValue());
        Assert.assertEquals((Object)NO_SUBPARTITION_VALUES, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getSubPartitionValues());
        Assert.assertEquals((Object)DATA_VERSION, (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectDataVersion());
        Assert.assertEquals((Object)"Attribute Name 1", (Object)businessObjectDataAttribute.getBusinessObjectDataAttributeKey().getBusinessObjectDataAttributeName());
        Assert.assertNull((Object)businessObjectDataAttribute.getBusinessObjectDataAttributeValue());
    }

    @Test
    public void testCreateBusinessObjectDataAttributeInvalidBusinessObjectFormatVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", "NOT_AN_INTEGER"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"businessObjectFormatVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(CreateBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testCreateBusinessObjectDataAttributeInvalidBusinessObjectDataVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataVersion", "NOT_AN_INTEGER"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"businessObjectDataVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(CreateBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }
}

