/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.JdbcExecutionRequest;
import org.finra.herd.model.api.xml.JdbcExecutionResponse;
import org.finra.herd.model.api.xml.JdbcStatement;
import org.finra.herd.model.api.xml.JdbcStatementStatus;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.JobCreateRequest;
import org.finra.herd.model.api.xml.JobStatusEnum;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.JdbcServiceTestHelper;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.ExecuteJdbc;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class ExecuteJdbcTest
extends HerdActivitiServiceTaskTest {
    private static final String JAVA_DELEGATE_CLASS_NAME = ExecuteJdbc.class.getCanonicalName();
    @Autowired
    private JdbcServiceTestHelper jdbcServiceTestHelper;

    @Test
    public void testExecuteJdbcSuccess() throws Exception {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        this.populateParameters(jdbcExecutionRequest, fieldExtensionList, parameters);
        JdbcExecutionResponse expectedJdbcExecutionResponse = new JdbcExecutionResponse();
        expectedJdbcExecutionResponse.setStatements(jdbcExecutionRequest.getStatements());
        ((JdbcStatement)expectedJdbcExecutionResponse.getStatements().get(0)).setStatus(JdbcStatementStatus.SUCCESS);
        ((JdbcStatement)expectedJdbcExecutionResponse.getStatements().get(0)).setResult("1");
        String expectedJdbcExecutionResponseJson = this.jsonHelper.objectToJson((Object)expectedJdbcExecutionResponse);
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", expectedJdbcExecutionResponseJson);
        this.testActivitiServiceTaskSuccess(JAVA_DELEGATE_CLASS_NAME, fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testExecuteJdbcErrorValidation() throws Exception {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        jdbcExecutionRequest.setConnection(null);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        this.populateParameters(jdbcExecutionRequest, fieldExtensionList, parameters);
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("jsonResponse", "IS_NULL");
        variableValuesToValidate.put("taskErrorMessage", "JDBC connection is required");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(JAVA_DELEGATE_CLASS_NAME, fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testExecuteJdbcErrorStatement() throws Exception {
        JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
        ((JdbcStatement)jdbcExecutionRequest.getStatements().get(0)).setSql("case2");
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        this.populateParameters(jdbcExecutionRequest, fieldExtensionList, parameters);
        JdbcExecutionResponse expectedJdbcExecutionResponse = new JdbcExecutionResponse();
        expectedJdbcExecutionResponse.setStatements(jdbcExecutionRequest.getStatements());
        ((JdbcStatement)expectedJdbcExecutionResponse.getStatements().get(0)).setStatus(JdbcStatementStatus.ERROR);
        ((JdbcStatement)expectedJdbcExecutionResponse.getStatements().get(0)).setErrorMessage("java.sql.SQLException: test DataIntegrityViolationException cause");
        String expectedJdbcExecutionResponseString = this.jsonHelper.objectToJson((Object)expectedJdbcExecutionResponse);
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("jsonResponse", expectedJdbcExecutionResponseString);
        variableValuesToValidate.put("taskErrorMessage", "There are failed executions. See JSON response for details.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(JAVA_DELEGATE_CLASS_NAME, fieldExtensionList, parameters, variableValuesToValidate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void testExecuteJdbcWithReceiveTask() throws Exception {
        this.executeJdbcTestHelper.prepareHerdDatabaseForExecuteJdbcWithReceiveTaskTest("testNamespace", "testHerdWorkflow", "classpath:org/finra/herd/service/testActivitiWorkflowExecuteJdbcTaskWithReceiveTask.bpmn20.xml");
        try {
            JdbcExecutionRequest jdbcExecutionRequest = this.jdbcServiceTestHelper.createDefaultUpdateJdbcExecutionRequest();
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            parameters.add(new Parameter("contentType", "xml"));
            parameters.add(new Parameter("jdbcExecutionRequest", this.xmlHelper.objectToXml((Object)jdbcExecutionRequest)));
            JobCreateRequest jobCreateRequest = this.jobServiceTestHelper.createJobCreateRequest("testNamespace", "testHerdWorkflow");
            jobCreateRequest.setParameters(parameters);
            Job jobStartResponse = this.jobService.createAndStartJob(jobCreateRequest);
            this.waitUntilAllProcessCompleted();
            Job jobGetResponse = this.jobService.getJob(jobStartResponse.getId(), true);
            Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)jobGetResponse.getStatus());
            Assert.assertTrue((boolean)jobGetResponse.getParameters().contains(new Parameter("service_taskStatus", "SUCCESS")));
            JdbcExecutionResponse expectedJdbcExecutionResponse = new JdbcExecutionResponse();
            JdbcStatement originalJdbcStatement = (JdbcStatement)jdbcExecutionRequest.getStatements().get(0);
            JdbcStatement expectedJdbcStatement = new JdbcStatement();
            expectedJdbcStatement.setType(originalJdbcStatement.getType());
            expectedJdbcStatement.setSql(originalJdbcStatement.getSql());
            expectedJdbcStatement.setStatus(JdbcStatementStatus.SUCCESS);
            expectedJdbcStatement.setResult("1");
            expectedJdbcExecutionResponse.setStatements(Arrays.asList(expectedJdbcStatement));
            Parameter expectedJdbcExecutionResponseParameter = new Parameter("service_jsonResponse", this.jsonHelper.objectToJson((Object)expectedJdbcExecutionResponse));
            Assert.assertTrue((boolean)jobGetResponse.getParameters().contains(expectedJdbcExecutionResponseParameter));
        }
        finally {
            this.executeJdbcTestHelper.cleanUpHerdDatabaseAfterExecuteJdbcWithReceiveTaskTest("testNamespace", "testHerdWorkflow");
            this.deleteActivitiDeployments();
        }
    }

    private void populateParameters(JdbcExecutionRequest jdbcExecutionRequest, List<FieldExtension> fieldExtensionList, List<Parameter> parameters) {
        try {
            String jdbcExecutionRequestString = this.xmlHelper.objectToXml((Object)jdbcExecutionRequest);
            fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
            fieldExtensionList.add(this.buildFieldExtension("jdbcExecutionRequest", "${jdbcExecutionRequest}"));
            parameters.add(this.buildParameter("contentType", "xml"));
            parameters.add(this.buildParameter("jdbcExecutionRequest", jdbcExecutionRequestString));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

