/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.BusinessObjectFormatDdlCollectionRequest;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.GenerateBusinessObjectFormatDdlCollection;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.finra.herd.service.activiti.task.LogVariables;
import org.junit.Test;

public class GenerateBusinessObjectFormatDdlCollectionTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testGenerateBusinessObjectFormatDdlCollectionXml() throws Exception {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlCollectionTesting();
        BusinessObjectFormatDdlCollectionRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlCollectionRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatDdlCollectionRequest", "${businessObjectFormatDdlCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectFormatDdlCollectionRequest", this.xmlHelper.objectToXml((Object)request)));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("businessObjectFormatDdlCollection", this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdlCollectionResponse().getDdlCollection());
        this.executeWithoutLogging(LogVariables.class, () -> this.testActivitiServiceTaskSuccess(GenerateBusinessObjectFormatDdlCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlCollectionJson() throws Exception {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlCollectionTesting();
        BusinessObjectFormatDdlCollectionRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlCollectionRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatDdlCollectionRequest", "${businessObjectFormatDdlCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectFormatDdlCollectionRequest", this.jsonHelper.objectToJson((Object)request)));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("businessObjectFormatDdlCollection", this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdlCollectionResponse().getDdlCollection());
        this.executeWithoutLogging(LogVariables.class, () -> this.testActivitiServiceTaskSuccess(GenerateBusinessObjectFormatDdlCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlCollectionWrongContentType() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatDdlCollectionRequest", "${businessObjectFormatDdlCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "wrong_content_type"));
        parameters.add(this.buildParameter("businessObjectFormatDdlCollectionRequest", "some_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"ContentType\" must be a valid value of either \"xml\" or \"json\".");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GenerateBusinessObjectFormatDdlCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlCollectionNoRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatDdlCollectionRequest", "${businessObjectFormatDdlCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectFormatDdlCollectionRequest", "      \t\t "));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectFormatDdlCollectionRequest\" must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GenerateBusinessObjectFormatDdlCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlCollectionWrongXmlRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatDdlCollectionRequest", "${businessObjectFormatDdlCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectFormatDdlCollectionRequest", "wrong_xml_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectFormatDdlCollectionRequest\" must be valid xml string.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GenerateBusinessObjectFormatDdlCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlCollectionWrongJsonRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatDdlCollectionRequest", "${businessObjectFormatDdlCollectionRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectFormatDdlCollectionRequest", "wrong_json_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectFormatDdlCollectionRequest\" must be valid json string.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GenerateBusinessObjectFormatDdlCollection.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }
}

