/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.GetBusinessObjectDefinition;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Test;

public class GetBusinessObjectDefinitionTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testGetBusinessObjectDefinition() throws Exception {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        this.testActivitiServiceTaskSuccess(GetBusinessObjectDefinition.class.getCanonicalName(), fieldExtensionList, parameters, null);
    }

    @Test
    public void testGetBusinessObjectDefinitionMissingBusinessObjectDefinitionName() throws Exception {
        ArrayList fieldExtensionList = new ArrayList();
        ArrayList parameters = new ArrayList();
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
            variableValuesToValidate.put("taskErrorMessage", "A namespace must be specified.");
            this.testActivitiServiceTaskFailure(GetBusinessObjectDefinition.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        });
    }

    @Test
    public void testGetBusinessObjectDefinitionNoExists() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
            variableValuesToValidate.put("taskErrorMessage", String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, NAMESPACE));
            this.testActivitiServiceTaskFailure(GetBusinessObjectDefinition.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        });
    }
}

