/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.BusinessObjectFormat;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.GetBusinessObjectFormat;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Test;

public class GetBusinessObjectFormatTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testGetBusinessObjectFormat() throws Exception {
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", INITIAL_FORMAT_VERSION.toString()));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)businessObjectFormat));
        this.testActivitiServiceTaskSuccess(GetBusinessObjectFormat.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetBusinessObjectFormatMissingOptionalParameters() throws Exception {
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)businessObjectFormat));
        this.testActivitiServiceTaskSuccess(GetBusinessObjectFormat.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetBusinessObjectFormatMissingBusinessObjectDefinitionName() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
            variableValuesToValidate.put("taskErrorMessage", "A business object definition name must be specified.");
            this.testActivitiServiceTaskFailure(GetBusinessObjectFormat.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        });
    }

    @Test
    public void testGetBusinessObjectFormatInvalidFormatVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", "INVALID_INTEGER_VALUE"));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
            variableValuesToValidate.put("taskErrorMessage", "\"businessObjectFormatVersion\" must be a valid integer value.");
            this.testActivitiServiceTaskFailure(GetBusinessObjectFormat.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        });
    }

    @Test
    public void testGetBusinessObjectFormatNoExists() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
            variableValuesToValidate.put("taskErrorMessage", String.format(this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), new Object[0]));
            this.testActivitiServiceTaskFailure(GetBusinessObjectFormat.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        });
    }
}

