/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchFilter;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchKey;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchRequest;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.dto.BusinessObjectDataSearchResultPagingInfoDto;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.finra.herd.service.activiti.task.SearchBusinessObjectData;
import org.junit.Test;

public class SearchBusinessObjectDataTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testSearchBusinessObjectDataWithXML() throws Exception {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        BusinessObjectDataSearchRequest businessObjectDataSearchRequest = this.getBusinessObjectDataSearchRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataSearchRequest", "${businessObjectDataSearchRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataSearchRequest", this.xmlHelper.objectToXml((Object)businessObjectDataSearchRequest)));
        parameters.add(this.buildParameter("pageNum", PAGE_NUMBER_ONE.toString()));
        parameters.add(this.buildParameter("pageSize", PAGE_SIZE_ONE_THOUSAND.toString()));
        BusinessObjectDataSearchResultPagingInfoDto result = this.businessObjectDataService.searchBusinessObjectData(PAGE_NUMBER_ONE, PAGE_SIZE_ONE_THOUSAND, businessObjectDataSearchRequest);
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)result.getBusinessObjectDataSearchResult()));
        this.testActivitiServiceTaskSuccess(SearchBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testSearchBusinessObjectDataWithJson() throws Exception {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        BusinessObjectDataSearchRequest businessObjectDataSearchRequest = this.getBusinessObjectDataSearchRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataSearchRequest", "${businessObjectDataSearchRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectDataSearchRequest", this.jsonHelper.objectToJson((Object)businessObjectDataSearchRequest)));
        parameters.add(this.buildParameter("pageNum", PAGE_NUMBER_ONE.toString()));
        parameters.add(this.buildParameter("pageSize", PAGE_SIZE_ONE_THOUSAND.toString()));
        BusinessObjectDataSearchResultPagingInfoDto result = this.businessObjectDataService.searchBusinessObjectData(PAGE_NUMBER_ONE, PAGE_SIZE_ONE_THOUSAND, businessObjectDataSearchRequest);
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)result.getBusinessObjectDataSearchResult()));
        this.testActivitiServiceTaskSuccess(SearchBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testSearchBusinessObjectDataWithBadParameter() throws Exception {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        BusinessObjectDataSearchRequest businessObjectDataSearchRequest = this.getBusinessObjectDataSearchRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataSearchRequest", "${businessObjectDataSearchRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "bad_type"));
        parameters.add(this.buildParameter("businessObjectDataSearchRequest", this.jsonHelper.objectToJson((Object)businessObjectDataSearchRequest)));
        String expectedBadFormatMessage = "\"ContentType\" must be a valid value of either \"xml\" or \"json\".";
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("taskErrorMessage", expectedBadFormatMessage);
        this.testActivitiServiceTaskFailure(SearchBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    private BusinessObjectDataSearchRequest getBusinessObjectDataSearchRequest() {
        BusinessObjectDataSearchRequest businessObjectDataSearchRequest = new BusinessObjectDataSearchRequest();
        ArrayList<BusinessObjectDataSearchFilter> businessObjectDataSearchFilters = new ArrayList<BusinessObjectDataSearchFilter>();
        ArrayList<BusinessObjectDataSearchKey> businessObjectDataSearchKeys = new ArrayList<BusinessObjectDataSearchKey>();
        BusinessObjectDataSearchKey businessObjectDataSearchKey = new BusinessObjectDataSearchKey();
        businessObjectDataSearchKey.setNamespace(NAMESPACE);
        businessObjectDataSearchKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataSearchKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        businessObjectDataSearchKeys.add(businessObjectDataSearchKey);
        BusinessObjectDataSearchFilter businessObjectDataSearchFilter = new BusinessObjectDataSearchFilter(businessObjectDataSearchKeys);
        businessObjectDataSearchFilters.add(businessObjectDataSearchFilter);
        businessObjectDataSearchRequest.setBusinessObjectDataSearchFilters(businessObjectDataSearchFilters);
        return businessObjectDataSearchRequest;
    }
}

