/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.advice;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.finra.herd.model.annotation.NamespacePermission;
import org.finra.herd.model.annotation.NamespacePermissions;
import org.finra.herd.model.api.xml.BusinessObjectDataNotificationFilter;
import org.finra.herd.model.api.xml.BusinessObjectDataNotificationRegistrationCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionCreateRequest;
import org.finra.herd.model.api.xml.JobAction;
import org.finra.herd.model.api.xml.NamespaceAuthorization;
import org.finra.herd.model.api.xml.NamespacePermissionEnum;
import org.finra.herd.model.api.xml.NotificationRegistrationKey;
import org.finra.herd.model.dto.ApplicationUser;
import org.finra.herd.model.dto.SecurityUserWrapper;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDefinitionService;
import org.finra.herd.service.advice.NamespaceSecurityAdvice;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class NamespaceSecurityAdviceTest
extends AbstractServiceTest {
    @Autowired
    private NamespaceSecurityAdvice namespaceSecurityAdvice;
    @Autowired
    @Qualifier(value="businessObjectDefinitionServiceImpl")
    private BusinessObjectDefinitionService businessObjectDefinitionServiceImpl;

    @Override
    @After
    public void after() {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void assertAdviceEnabled() {
        String username = "username";
        Class<?> generatedByClass = ((Object)((Object)this)).getClass();
        ApplicationUser applicationUser = new ApplicationUser(generatedByClass);
        applicationUser.setUserId(username);
        applicationUser.setNamespaceAuthorizations(Collections.emptySet());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(username, "password", false, false, false, false, Collections.emptyList(), applicationUser), null));
        try {
            this.businessObjectDefinitionServiceImpl.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, null, null, null));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
        }
    }

    @Test
    public void checkPermissionAssertNoExceptionWhenHasPermissions() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("foo", Arrays.asList(NamespacePermissionEnum.READ)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenCurrentUserHasWrongPermissionType() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("foo", Arrays.asList(NamespacePermissionEnum.WRITE)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[READ]\" permission(s) to the namespace \"foo\"", userId), (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertNoExceptionWhenNoSecurityContext() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenCurrentUserHasWrongNamespace() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("bar", Arrays.asList(NamespacePermissionEnum.READ)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[READ]\" permission(s) to the namespace \"foo\"", userId), (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertNoExceptionWhenMultipleAnnotationsAndAllPermissionsValid() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethodMultipleAnnotations", String.class, String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace1", "namespace2"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo", "bar"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("foo", Arrays.asList(NamespacePermissionEnum.READ)));
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("bar", Arrays.asList(NamespacePermissionEnum.WRITE)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenMultipleAnnotationsAndUserHasOneWrongPermission() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethodMultipleAnnotations", String.class, String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace1", "namespace2"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo", "bar"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("foo", Arrays.asList(NamespacePermissionEnum.READ)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[WRITE]\" permission(s) to the namespace \"bar\"", userId), (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertNoExceptionWhenComplexCaseAndUserHasAllPermissions() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", BusinessObjectDataNotificationRegistrationCreateRequest.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"request"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        BusinessObjectDataNotificationRegistrationCreateRequest request = new BusinessObjectDataNotificationRegistrationCreateRequest();
        request.setBusinessObjectDataNotificationRegistrationKey(new NotificationRegistrationKey("ns1", null));
        request.setBusinessObjectDataNotificationFilter(new BusinessObjectDataNotificationFilter("ns2", null, null, null, null, null, null, null));
        request.setJobActions(Arrays.asList(new JobAction("ns3", null, null), new JobAction("ns4", null, null)));
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{request});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("ns1", Arrays.asList(NamespacePermissionEnum.WRITE)));
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("ns2", Arrays.asList(NamespacePermissionEnum.READ)));
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("ns3", Arrays.asList(NamespacePermissionEnum.EXECUTE)));
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("ns4", Arrays.asList(NamespacePermissionEnum.EXECUTE)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenComplexCaseAndUserHasWrongPermission() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", BusinessObjectDataNotificationRegistrationCreateRequest.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"request"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        BusinessObjectDataNotificationRegistrationCreateRequest request = new BusinessObjectDataNotificationRegistrationCreateRequest();
        request.setBusinessObjectDataNotificationRegistrationKey(new NotificationRegistrationKey("ns1", null));
        request.setBusinessObjectDataNotificationFilter(new BusinessObjectDataNotificationFilter("ns2", null, null, null, null, null, null, null));
        request.setJobActions(Arrays.asList(new JobAction("ns3", null, null), new JobAction("ns4", null, null)));
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{request});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("ns1", Arrays.asList(NamespacePermissionEnum.WRITE)));
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("ns2", Arrays.asList(NamespacePermissionEnum.READ)));
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("ns3", Arrays.asList(NamespacePermissionEnum.EXECUTE)));
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("ns4", Arrays.asList(NamespacePermissionEnum.READ)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[EXECUTE]\" permission(s) to the namespace \"ns4\"", userId), (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertErrorWhenAnnotationFieldRefersToNonString() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", Integer.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"aNumber"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{1});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)"Object must be of type class java.lang.String or interface java.util.Collection. Actual object.class = class java.lang.Integer", (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertNoErrorWhenMethodDoesNotHaveAnnotations() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", new Class[0]);
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[0]);
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void checkPermissionAssertNoErrorWhenUserHasMultiplePermissions() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("foo", Arrays.asList(NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenCurrentUserHasNoAnyRequiredPermissions() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethodMultiplePermissions", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("foo", Arrays.asList(NamespacePermissionEnum.WRITE_DESCRIPTIVE_CONTENT)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[READ OR WRITE]\" permission(s) to the namespace \"foo\"", userId), (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertAccessApprovedWhenUserRequiresMultiplePermissionsButIsMissingOne() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethodMultiplePermissions", String.class);
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("foo", Arrays.asList(NamespacePermissionEnum.READ)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenCurrentUserHasNullAuthorizations() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(null);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[READ]\" permission(s) to the namespace \"foo\"", userId), (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenCurrentUserHasNullPermissions() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("foo", null));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[READ]\" permission(s) to the namespace \"foo\"", userId), (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenApplicationUserIsNull() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        String userId = "userId";
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), null), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)"Current user does not have \"[READ]\" permission(s) to the namespace \"foo\"", (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenPrincipalIsNotSecurityUserWrapper() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"streetcreds", null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)"Current user does not have \"[READ]\" permission(s) to the namespace \"foo\"", (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenPrincipalIsNull() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken(null, null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)"Current user does not have \"[READ]\" permission(s) to the namespace \"foo\"", (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertNoExceptionWhenHasPermissionsNamespaceIgnoreCase() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("FOO", Arrays.asList(NamespacePermissionEnum.READ)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void checkPermissionAssertNoExceptionWhenNamespaceBlank() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"      \t\t "});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void checkPermissionAssertNoExceptionWhenHasPermissionsNamespaceTrimmed() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"      \t\t foo      \t\t "});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("foo", Arrays.asList(NamespacePermissionEnum.READ)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void checkPermissionAssertAccessDeniedWhenNoPermissionsNamespaceTrimmed() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"      \t\t foo      \t\t "});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        applicationUser.getNamespaceAuthorizations().add(new NamespaceAuthorization("bar", Arrays.asList(NamespacePermissionEnum.READ)));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[READ]\" permission(s) to the namespace \"foo\"", userId), (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertMultipleAccessDeniedExceptionsAreGatheredIntoSingleMessageWhenMultipleAnnotations() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethodMultipleAnnotations", String.class, String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace1", "namespace2"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{"foo", "bar"});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[READ]\" permission(s) to the namespace \"foo\"%nUser \"%s\" does not have \"[WRITE]\" permission(s) to the namespace \"bar\"", userId, userId), (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertMultipleAccessDeniedExceptionsAreGatheredIntoSingleMessageWhenCollections() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", List.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespaces"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{Arrays.asList("foo", "bar")});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AccessDeniedException.class, e.getClass());
            Assert.assertEquals((Object)String.format("User \"%s\" does not have \"[READ]\" permission(s) to the namespace \"foo\"%nUser \"%s\" does not have \"[READ]\" permission(s) to the namespace \"bar\"", userId, userId), (Object)e.getMessage());
        }
    }

    @Test
    public void checkPermissionAssertNoExceptionWhenNull() throws Exception {
        JoinPoint joinPoint = (JoinPoint)Mockito.mock(JoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = NamespaceSecurityAdviceTest.class.getDeclaredMethod("mockMethod", String.class);
        Mockito.when((Object)methodSignature.getParameterNames()).thenReturn((Object)new String[]{"namespace"});
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)joinPoint.getArgs()).thenReturn((Object)new Object[]{null});
        String userId = "userId";
        ApplicationUser applicationUser = new ApplicationUser(((Object)((Object)this)).getClass());
        applicationUser.setUserId(userId);
        applicationUser.setNamespaceAuthorizations(new HashSet());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper(userId, "", false, false, false, false, Arrays.asList(new GrantedAuthority[0]), applicationUser), null));
        try {
            this.namespaceSecurityAdvice.checkPermission(joinPoint);
        }
        catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @NamespacePermission(fields={"#namespace"}, permissions={NamespacePermissionEnum.READ})
    private void mockMethod(String namespace) {
    }

    @NamespacePermissions(value={@NamespacePermission(fields={"#namespace1"}, permissions={NamespacePermissionEnum.READ}), @NamespacePermission(fields={"#namespace2"}, permissions={NamespacePermissionEnum.WRITE})})
    private void mockMethodMultipleAnnotations(String namespace1, String namespace2) {
    }

    @NamespacePermissions(value={@NamespacePermission(fields={"#request.businessObjectDataNotificationRegistrationKey.namespace"}, permissions={NamespacePermissionEnum.WRITE}), @NamespacePermission(fields={"#request.businessObjectDataNotificationFilter.namespace"}, permissions={NamespacePermissionEnum.READ}), @NamespacePermission(fields={"#request.jobActions.![namespace]"}, permissions={NamespacePermissionEnum.EXECUTE})})
    private void mockMethod(BusinessObjectDataNotificationRegistrationCreateRequest request) {
    }

    @NamespacePermission(fields={"#aNumber"}, permissions={NamespacePermissionEnum.READ})
    private void mockMethod(Integer aNumber) {
    }

    private void mockMethod() {
    }

    @NamespacePermission(fields={"#namespace"}, permissions={NamespacePermissionEnum.READ, NamespacePermissionEnum.WRITE})
    private void mockMethodMultiplePermissions(String namespace) {
    }

    @NamespacePermission(fields={"#namespaces"}, permissions={NamespacePermissionEnum.READ})
    private void mockMethod(List<String> namespaces) {
    }
}

