/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.advice;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.finra.herd.core.Command;
import org.finra.herd.core.MockProceedingJoinPoint;
import org.finra.herd.core.SuppressLogging;
import org.finra.herd.core.helper.LogLevel;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.advice.StopWatchAdvice;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class StopWatchAdviceTest
extends AbstractServiceTest {
    @InjectMocks
    private StopWatchAdvice stopWatchAdvice;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testLogMethodTime() throws Throwable {
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint((Object)new StopWatchAdviceTest(), StopWatchAdviceTest.class.getDeclaredMethod("mockMethod", new Class[0]));
        this.stopWatchAdvice.logMethodTime(joinPoint);
    }

    @Test
    public void testLogMethodTimeTargetMethodIsInterface() throws Throwable {
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint(new Command(){

            public void execute() throws Exception {
            }
        }, Command.class.getDeclaredMethod("execute", new Class[0]));
        this.stopWatchAdvice.logMethodTime(joinPoint);
    }

    @Test
    public void testLogMethodTimeTargetMethodTargetClassSuppressLogging() throws Throwable {
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint((Object)new MockClassThatSuppressLogging(), MockClassThatSuppressLogging.class.getDeclaredMethod("mockMethod", new Class[0]));
        this.stopWatchAdvice.logMethodTime(joinPoint);
    }

    @Test
    public void testLogMethodTimeTargetMethodTargetMethodSuppressLogging() throws Throwable {
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint((Object)new StopWatchAdviceTest(), StopWatchAdviceTest.class.getDeclaredMethod("mockMethodThatSuppressLogging", new Class[0]));
        this.stopWatchAdvice.logMethodTime(joinPoint);
    }

    @Test
    public void testLogMethodTimeWithInfoLoggingDisabled() throws Throwable {
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint((Object)new StopWatchAdviceTest(), StopWatchAdviceTest.class.getDeclaredMethod("mockMethod", new Class[0]));
        LogLevel origLogLevel = this.getLogLevel("org.finra.herd.core.StopWatchAdvice");
        this.setLogLevel("org.finra.herd.core.StopWatchAdvice", LogLevel.OFF);
        try {
            this.stopWatchAdvice.logMethodTime(joinPoint);
        }
        finally {
            this.setLogLevel("org.finra.herd.core.StopWatchAdvice", origLogLevel);
        }
    }

    @Test
    public void testLogMethodTimeWithInfoLoggingEnabled() throws Throwable {
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint((Object)new StopWatchAdviceTest(), StopWatchAdviceTest.class.getDeclaredMethod("mockMethod", new Class[0]));
        LogLevel origLogLevel = this.getLogLevel("org.finra.herd.core.StopWatchAdvice");
        this.setLogLevel("org.finra.herd.core.StopWatchAdvice", LogLevel.INFO);
        try {
            this.stopWatchAdvice.logMethodTime(joinPoint);
        }
        finally {
            this.setLogLevel("org.finra.herd.core.StopWatchAdvice", origLogLevel);
        }
    }

    private ProceedingJoinPoint getMockedProceedingJoinPoint(Object targetObject, Method method) throws Exception {
        ProceedingJoinPoint joinPoint = (ProceedingJoinPoint)Mockito.mock(ProceedingJoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Mockito.when((Object)joinPoint.getTarget()).thenReturn(targetObject);
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)methodSignature.getName()).thenReturn((Object)method.getName());
        return joinPoint;
    }

    private void mockMethod() {
    }

    @SuppressLogging
    private void mockMethodThatSuppressLogging() {
    }

    @SuppressLogging
    private class MockClassThatSuppressLogging
    extends MockProceedingJoinPoint {
        private MockClassThatSuppressLogging() {
        }

        private void mockMethod() {
        }
    }
}

