/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.jpa.BusinessObjectDataAttributeDefinitionEntity;
import org.finra.herd.model.jpa.BusinessObjectDataAttributeEntity;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AttributeDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AttributeDaoHelperTest
extends AbstractServiceTest {
    @InjectMocks
    private AttributeDaoHelper attributeDaoHelper;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testUpdateBusinessObjectDataAttributesAttributeAdded() {
        List<Attribute> attributes = Arrays.asList(new Attribute(ATTRIBUTE_NAME, ATTRIBUTE_VALUE));
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setAttributes(new ArrayList());
        this.attributeDaoHelper.updateBusinessObjectDataAttributes(businessObjectDataEntity, attributes);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)businessObjectDataEntity.getAttributes()));
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = (BusinessObjectDataAttributeEntity)IterableUtils.get((Iterable)businessObjectDataEntity.getAttributes(), (int)0);
        Assert.assertEquals((Object)businessObjectDataEntity, (Object)businessObjectDataAttributeEntity.getBusinessObjectData());
        Assert.assertEquals((Object)ATTRIBUTE_NAME, (Object)businessObjectDataAttributeEntity.getName());
        Assert.assertEquals((Object)ATTRIBUTE_VALUE, (Object)businessObjectDataAttributeEntity.getValue());
    }

    @Test
    public void testUpdateBusinessObjectDataAttributesAttributeDeleted() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = new BusinessObjectDataAttributeEntity();
        businessObjectDataAttributeEntity.setName(ATTRIBUTE_NAME);
        businessObjectDataAttributeEntity.setValue(ATTRIBUTE_VALUE);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        ArrayList<BusinessObjectDataAttributeEntity> businessObjectDataAttributeEntities = new ArrayList<BusinessObjectDataAttributeEntity>();
        businessObjectDataEntity.setAttributes(businessObjectDataAttributeEntities);
        businessObjectDataAttributeEntities.add(businessObjectDataAttributeEntity);
        this.attributeDaoHelper.updateBusinessObjectDataAttributes(businessObjectDataEntity, NO_ATTRIBUTES);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((long)0L, (long)CollectionUtils.size((Object)businessObjectDataEntity.getAttributes()));
    }

    @Test
    public void testUpdateBusinessObjectDataAttributesAttributeValueNotUpdated() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = new BusinessObjectDataAttributeEntity();
        businessObjectDataAttributeEntity.setName(ATTRIBUTE_NAME);
        businessObjectDataAttributeEntity.setValue(ATTRIBUTE_VALUE);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        ArrayList<BusinessObjectDataAttributeEntity> businessObjectDataAttributeEntities = new ArrayList<BusinessObjectDataAttributeEntity>();
        businessObjectDataEntity.setAttributes(businessObjectDataAttributeEntities);
        businessObjectDataAttributeEntities.add(businessObjectDataAttributeEntity);
        this.attributeDaoHelper.updateBusinessObjectDataAttributes(businessObjectDataEntity, Arrays.asList(new Attribute(ATTRIBUTE_NAME, ATTRIBUTE_VALUE)));
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)businessObjectDataEntity.getAttributes()));
        BusinessObjectDataAttributeEntity result = (BusinessObjectDataAttributeEntity)IterableUtils.get((Iterable)businessObjectDataEntity.getAttributes(), (int)0);
        Assert.assertEquals((Object)ATTRIBUTE_NAME, (Object)result.getName());
        Assert.assertEquals((Object)ATTRIBUTE_VALUE, (Object)result.getValue());
    }

    @Test
    public void testUpdateBusinessObjectDataAttributesAttributeValueUpdated() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = new BusinessObjectDataAttributeEntity();
        businessObjectDataAttributeEntity.setName(ATTRIBUTE_NAME);
        businessObjectDataAttributeEntity.setValue(ATTRIBUTE_VALUE);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        ArrayList<BusinessObjectDataAttributeEntity> businessObjectDataAttributeEntities = new ArrayList<BusinessObjectDataAttributeEntity>();
        businessObjectDataEntity.setAttributes(businessObjectDataAttributeEntities);
        businessObjectDataAttributeEntities.add(businessObjectDataAttributeEntity);
        this.attributeDaoHelper.updateBusinessObjectDataAttributes(businessObjectDataEntity, Arrays.asList(new Attribute(ATTRIBUTE_NAME, "   Attribute Value 2  ")));
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)businessObjectDataEntity.getAttributes()));
        BusinessObjectDataAttributeEntity result = (BusinessObjectDataAttributeEntity)IterableUtils.get((Iterable)businessObjectDataEntity.getAttributes(), (int)0);
        Assert.assertEquals((Object)ATTRIBUTE_NAME, (Object)result.getName());
        Assert.assertEquals((Object)"   Attribute Value 2  ", (Object)result.getValue());
    }

    @Test
    public void testUpdateBusinessObjectDataAttributesAttributeValueUpdatedAttributeNamesEqualIgnoreCase() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = new BusinessObjectDataAttributeEntity();
        businessObjectDataAttributeEntity.setName(ATTRIBUTE_NAME.toUpperCase());
        businessObjectDataAttributeEntity.setValue(ATTRIBUTE_VALUE);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        ArrayList<BusinessObjectDataAttributeEntity> businessObjectDataAttributeEntities = new ArrayList<BusinessObjectDataAttributeEntity>();
        businessObjectDataEntity.setAttributes(businessObjectDataAttributeEntities);
        businessObjectDataAttributeEntities.add(businessObjectDataAttributeEntity);
        this.attributeDaoHelper.updateBusinessObjectDataAttributes(businessObjectDataEntity, Arrays.asList(new Attribute(ATTRIBUTE_NAME.toLowerCase(), "   Attribute Value 2  ")));
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)businessObjectDataEntity.getAttributes()));
        BusinessObjectDataAttributeEntity result = (BusinessObjectDataAttributeEntity)IterableUtils.get((Iterable)businessObjectDataEntity.getAttributes(), (int)0);
        Assert.assertEquals((Object)ATTRIBUTE_NAME.toUpperCase(), (Object)result.getName());
        Assert.assertEquals((Object)"   Attribute Value 2  ", (Object)result.getValue());
    }

    @Test
    public void testUpdateBusinessObjectDataAttributesDuplicateAttributes() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntityA = new BusinessObjectDataAttributeEntity();
        businessObjectDataAttributeEntityA.setName(ATTRIBUTE_NAME.toUpperCase());
        businessObjectDataAttributeEntityA.setValue(ATTRIBUTE_VALUE);
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntityB = new BusinessObjectDataAttributeEntity();
        businessObjectDataAttributeEntityB.setName(ATTRIBUTE_NAME.toLowerCase());
        businessObjectDataAttributeEntityB.setValue("   Attribute Value 2  ");
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        ArrayList<BusinessObjectDataAttributeEntity> businessObjectDataAttributeEntities = new ArrayList<BusinessObjectDataAttributeEntity>();
        businessObjectDataEntity.setAttributes(businessObjectDataAttributeEntities);
        businessObjectDataAttributeEntities.add(businessObjectDataAttributeEntityA);
        businessObjectDataAttributeEntities.add(businessObjectDataAttributeEntityB);
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.attributeDaoHelper.updateBusinessObjectDataAttributes(businessObjectDataEntity, NO_ATTRIBUTES);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Found duplicate attribute with name \"%s\" for business object data. Business object data: {%s}", ATTRIBUTE_NAME.toLowerCase(), BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataEntityAltKeyToString(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateAttributesAgainstBusinessObjectDataAttributeDefinitionsAttributeNamesEqualIgnoreCase() {
        BusinessObjectDataAttributeDefinitionEntity businessObjectDataAttributeDefinitionEntity = new BusinessObjectDataAttributeDefinitionEntity();
        businessObjectDataAttributeDefinitionEntity.setName(ATTRIBUTE_NAME.toUpperCase());
        this.attributeDaoHelper.validateAttributesAgainstBusinessObjectDataAttributeDefinitions(Arrays.asList(new Attribute(ATTRIBUTE_NAME.toLowerCase(), ATTRIBUTE_VALUE)), Arrays.asList(businessObjectDataAttributeDefinitionEntity));
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateAttributesAgainstBusinessObjectDataAttributeDefinitionsRequiredAttributeHasBlankValue() {
        BusinessObjectDataAttributeDefinitionEntity businessObjectDataAttributeDefinitionEntity = new BusinessObjectDataAttributeDefinitionEntity();
        businessObjectDataAttributeDefinitionEntity.setName(ATTRIBUTE_NAME);
        try {
            this.attributeDaoHelper.validateAttributesAgainstBusinessObjectDataAttributeDefinitions(Arrays.asList(new Attribute(ATTRIBUTE_NAME, "      \t\t ")), Arrays.asList(businessObjectDataAttributeDefinitionEntity));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The business object format has a required attribute \"%s\" which was not specified or has a value which is blank.", ATTRIBUTE_NAME), (Object)e.getMessage());
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateAttributesAgainstBusinessObjectDataAttributeDefinitionsRequiredAttributeIsMissing() {
        BusinessObjectDataAttributeDefinitionEntity businessObjectDataAttributeDefinitionEntity = new BusinessObjectDataAttributeDefinitionEntity();
        businessObjectDataAttributeDefinitionEntity.setName(ATTRIBUTE_NAME);
        try {
            this.attributeDaoHelper.validateAttributesAgainstBusinessObjectDataAttributeDefinitions(NO_ATTRIBUTES, Arrays.asList(businessObjectDataAttributeDefinitionEntity));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The business object format has a required attribute \"%s\" which was not specified or has a value which is blank.", ATTRIBUTE_NAME), (Object)e.getMessage());
        }
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataHelper});
    }
}

