/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataRetryStoragePolicyTransitionRequest;
import org.finra.herd.model.api.xml.StoragePolicyKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.StoragePolicySelection;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataRetryStoragePolicyTransitionHelperTest
extends AbstractServiceTest {
    @Test
    public void testRetryStoragePolicyTransition() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey);
        BusinessObjectData businessObjectData = this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, businessObjectData);
    }

    @Test
    public void testRetryStoragePolicyTransitionBusinessObjectDataNoExists() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, NO_BDATA_STATUS), (Object)e.getMessage());
        }
    }

    @Test
    public void testRetryStoragePolicyTransitionInvalidParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey);
        Assert.assertNotNull((Object)this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey));
        Assert.assertNotNull((Object)this.storagePolicyDao.getStoragePolicyByAltKey(storagePolicyKey));
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        for (int i = 0; i < SUBPARTITION_VALUES.size(); ++i) {
            ArrayList<String> testSubPartitionValues = new ArrayList<String>(SUBPARTITION_VALUES);
            testSubPartitionValues.set(i, "I_DO_NOT_EXIST");
            try {
                this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
                Assert.fail();
                continue;
            }
            catch (ObjectNotFoundException e) {
                Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
            }
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(new StoragePolicyKey("I_DO_NOT_EXIST", STORAGE_POLICY_NAME)));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.storagePolicyServiceTestHelper.getExpectedStoragePolicyNotFoundErrorMessage(new StoragePolicyKey("I_DO_NOT_EXIST", STORAGE_POLICY_NAME)), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, "I_DO_NOT_EXIST")));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.storagePolicyServiceTestHelper.getExpectedStoragePolicyNotFoundErrorMessage(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, "I_DO_NOT_EXIST")), (Object)e.getMessage());
        }
    }

    @Test
    public void testRetryStoragePolicyTransitionLowerCaseParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey);
        BusinessObjectData businessObjectData = this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD.toLowerCase(), STORAGE_POLICY_NAME.toLowerCase())));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, businessObjectData);
    }

    @Test
    public void testRetryStoragePolicyTransitionMissingOptionalParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey);
        BusinessObjectData businessObjectData = this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, businessObjectData);
    }

    @Test
    public void testRetryStoragePolicyTransitionMissingRequiredParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t ", (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), "      \t\t ", (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), "      \t\t ", (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), "      \t\t "), DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, NO_DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data retry storage policy transition request must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy key must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(new StoragePolicyKey("      \t\t ", STORAGE_POLICY_NAME)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, "      \t\t ")));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy name must be specified.", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetryStoragePolicyTransitionNoSqsQueueName() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_SQS_QUEUE_NAME.getKey(), "      \t\t ");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
            StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
            this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey, STORAGE_NAME, S3_BUCKET_NAME, "ARCHIVING");
            try {
                this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
                Assert.fail();
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)String.format("SQS queue name not found. Ensure the \"%s\" configuration entry is configured.", ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_SQS_QUEUE_NAME.getKey()), (Object)e.getMessage());
            }
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testRetryStoragePolicyTransitionStorageHasNoBucketName() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey, STORAGE_NAME, NO_S3_BUCKET_NAME, "ARCHIVING");
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), STORAGE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testRetryStoragePolicyTransitionStoragePolicyFilterDoesNotMatchBusinessObjectData() {
        int i;
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        ArrayList<StoragePolicyKey> storagePolicyKeys = new ArrayList<StoragePolicyKey>();
        for (i = 0; i < 4; ++i) {
            storagePolicyKeys.add(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME + "_" + i));
        }
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity((StoragePolicyKey)storagePolicyKeys.get(0), "DAYS_SINCE_BDATA_REGISTERED", AbstractServiceTest.BDATA_AGE_IN_DAYS, BDEF_NAMESPACE_2, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME, "ENABLED", AbstractServiceTest.INITIAL_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity((StoragePolicyKey)storagePolicyKeys.get(1), "DAYS_SINCE_BDATA_REGISTERED", AbstractServiceTest.BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME, "ENABLED", AbstractServiceTest.INITIAL_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity((StoragePolicyKey)storagePolicyKeys.get(2), "DAYS_SINCE_BDATA_REGISTERED", AbstractServiceTest.BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME, "ENABLED", AbstractServiceTest.INITIAL_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity((StoragePolicyKey)storagePolicyKeys.get(3), "DAYS_SINCE_BDATA_REGISTERED", AbstractServiceTest.BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE_2, STORAGE_NAME, STORAGE_NAME, "ENABLED", AbstractServiceTest.INITIAL_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET);
        for (i = 0; i < 4; ++i) {
            try {
                this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest((StoragePolicyKey)storagePolicyKeys.get(i)));
                Assert.fail();
                continue;
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)String.format("Business object data does not match storage policy filter. Storage policy: {%s}, business object data: {%s}", this.storagePolicyServiceTestHelper.getExpectedStoragePolicyKeyAndVersionAsString((StoragePolicyKey)storagePolicyKeys.get(i), INITIAL_VERSION), this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testRetryStoragePolicyTransitionStoragePolicyFilterNoOptionalFields() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List<StoragePolicyKey> storagePolicyKeys = Arrays.asList(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME_2));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKeys.get(0));
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKeys.get(1), "DAYS_SINCE_BDATA_REGISTERED", AbstractServiceTest.BDATA_AGE_IN_DAYS, NO_BDEF_NAMESPACE, NO_BDEF_NAME, NO_FORMAT_USAGE_CODE, NO_FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME, "ENABLED", AbstractServiceTest.INITIAL_VERSION, AbstractServiceTest.LATEST_VERSION_FLAG_SET);
        BusinessObjectData businessObjectData = this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKeys.get(1)));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, businessObjectData);
    }

    @Test
    public void testRetryStoragePolicyTransitionStoragePolicyNoExists() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.storagePolicyServiceTestHelper.getExpectedStoragePolicyNotFoundErrorMessage(storagePolicyKey), (Object)e.getMessage());
        }
    }

    @Test
    public void testRetryStoragePolicyTransitionStorageUnitHasNoStorageFiles() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey, STORAGE_NAME, S3_BUCKET_NAME, "ARCHIVING");
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        storageUnitEntity.getStorageFiles().clear();
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has no storage files registered in \"%s\" storage. Business object data: {%s}", STORAGE_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testRetryStoragePolicyTransitionStorageUnitNoExists() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey, STORAGE_NAME, S3_BUCKET_NAME, NO_STORAGE_UNIT_STATUS);
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has no storage unit in \"%s\" storage. Business object data: {%s}", STORAGE_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testRetryStoragePolicyTransitionStorageUnitNotInArchivingState() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey, STORAGE_NAME, S3_BUCKET_NAME, STORAGE_UNIT_STATUS);
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(businessObjectDataKey, new BusinessObjectDataRetryStoragePolicyTransitionRequest(storagePolicyKey));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data is not currently being archived. Storage unit in \"%s\" storage must have \"%s\" status, but it actually has \"%s\" status. Business object data: {%s}", STORAGE_NAME, "ARCHIVING", STORAGE_UNIT_STATUS, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testRetryStoragePolicyTransitionTrimParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey);
        BusinessObjectData businessObjectData = this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(new StoragePolicyKey(this.addWhitespace(STORAGE_POLICY_NAMESPACE_CD), this.addWhitespace(STORAGE_POLICY_NAME))));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, businessObjectData);
    }

    @Test
    public void testRetryStoragePolicyTransitionUpperCaseParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForRetryStoragePolicyTransitionTesting(businessObjectDataKey, storagePolicyKey);
        BusinessObjectData businessObjectData = this.businessObjectDataRetryStoragePolicyTransitionHelper.retryStoragePolicyTransition(new BusinessObjectDataKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataRetryStoragePolicyTransitionRequest(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD.toUpperCase(), STORAGE_POLICY_NAME.toUpperCase())));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, businessObjectData);
    }

    @Test
    public void testSendStoragePolicySelectionSqsMessageSqsOperationFails() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        try {
            this.businessObjectDataRetryStoragePolicyTransitionHelper.sendStoragePolicySelectionSqsMessage("mock_sqs_queue_not_found_name", new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("AWS SQS queue with \"%s\" name not found.", "mock_sqs_queue_not_found_name"), (Object)e.getMessage());
        }
    }
}

