/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.finra.herd.model.api.xml.AttributeValueFilter;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchFilter;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchKey;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchRequest;
import org.finra.herd.model.api.xml.LatestBeforePartitionValue;
import org.finra.herd.model.api.xml.PartitionValueFilter;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataSearchHelperTest
extends AbstractServiceTest {
    @Test
    public void testValidateBusinessObjectDataSearchRequestIllegalArgumentExceptions() {
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchRequest(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data search request must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchRequest(new BusinessObjectDataSearchRequest());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data search filter must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchRequest(new BusinessObjectDataSearchRequest(new ArrayList()));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data search filter must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchRequest(new BusinessObjectDataSearchRequest(Arrays.asList(new BusinessObjectDataSearchFilter(), new BusinessObjectDataSearchFilter())));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A list of business object data search filters can only have one element.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchRequest(new BusinessObjectDataSearchRequest(Collections.singletonList(new BusinessObjectDataSearchFilter())));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data search key must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchRequest(new BusinessObjectDataSearchRequest(Collections.singletonList(new BusinessObjectDataSearchFilter(new ArrayList()))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data search key must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchRequest(new BusinessObjectDataSearchRequest(Collections.singletonList(new BusinessObjectDataSearchFilter(Arrays.asList(new BusinessObjectDataSearchKey(), new BusinessObjectDataSearchKey())))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A list of business object data search keys can only have one element.", (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateBusinessObjectDataSearchKeyIllegalArgumentExceptions() {
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchKey(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data search key must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchKey(new BusinessObjectDataSearchKey("      \t\t ", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NO_PARTITION_VALUE_FILTERS, NO_ATTRIBUTE_VALUE_FILTERS, NO_FILTER_ON_LATEST_VALID_VERSION, NO_FILTER_ON_RETENTION_EXPIRATION));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchKey(new BusinessObjectDataSearchKey(BDEF_NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NO_PARTITION_VALUE_FILTERS, NO_ATTRIBUTE_VALUE_FILTERS, NO_FILTER_ON_LATEST_VALID_VERSION, NO_FILTER_ON_RETENTION_EXPIRATION));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchKey(new BusinessObjectDataSearchKey(BDEF_NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NO_PARTITION_VALUE_FILTERS, NO_ATTRIBUTE_VALUE_FILTERS, NO_FILTER_ON_LATEST_VALID_VERSION, NO_FILTER_ON_RETENTION_EXPIRATION));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchKey(new BusinessObjectDataSearchKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Collections.singletonList(new PartitionValueFilter(PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(PARTITION_VALUE), NO_LATEST_AFTER_PARTITION_VALUE)), NO_ATTRIBUTE_VALUE_FILTERS, NO_FILTER_ON_LATEST_VALID_VERSION, NO_FILTER_ON_RETENTION_EXPIRATION));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Only partition values or partition range are supported in partition value filter.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchKey(new BusinessObjectDataSearchKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NO_PARTITION_VALUE_FILTERS, Collections.singletonList(new AttributeValueFilter("      \t\t ", "")), NO_FILTER_ON_LATEST_VALID_VERSION, NO_FILTER_ON_RETENTION_EXPIRATION));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Either attribute name or attribute value filter must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testValidatePagingParameter() {
        Assert.assertEquals((Object)INTEGER_VALUE, (Object)this.businessObjectDataSearchHelper.validatePagingParameter(PARAMETER_NAME, INTEGER_VALUE, null, Integer.valueOf(Integer.MAX_VALUE)));
        Assert.assertEquals((Object)INTEGER_VALUE_2, (Object)this.businessObjectDataSearchHelper.validatePagingParameter(PARAMETER_NAME, null, INTEGER_VALUE_2, Integer.valueOf(Integer.MAX_VALUE)));
        try {
            this.businessObjectDataSearchHelper.validatePagingParameter(PARAMETER_NAME, Integer.valueOf(0), null, Integer.valueOf(Integer.MAX_VALUE));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A %s greater than 0 must be specified.", PARAMETER_NAME), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataSearchHelper.validatePagingParameter(PARAMETER_NAME, Integer.valueOf(Integer.MAX_VALUE), null, Integer.valueOf(0x7FFFFFFE));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A %s less than %d must be specified.", PARAMETER_NAME, 0x7FFFFFFE), (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateBusinessObjectDataSearchKey() {
        AttributeValueFilter attributeValueFilter = new AttributeValueFilter();
        attributeValueFilter.setAttributeName(null);
        attributeValueFilter.setAttributeValue(ATTRIBUTE_VALUE);
        this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchKey(new BusinessObjectDataSearchKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NO_PARTITION_VALUE_FILTERS, Arrays.asList(attributeValueFilter), NO_FILTER_ON_LATEST_VALID_VERSION, NO_FILTER_ON_RETENTION_EXPIRATION));
        attributeValueFilter = new AttributeValueFilter();
        attributeValueFilter.setAttributeName(ATTRIBUTE_NAME);
        attributeValueFilter.setAttributeValue(null);
        this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchKey(new BusinessObjectDataSearchKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NO_PARTITION_VALUE_FILTERS, Arrays.asList(attributeValueFilter), NO_FILTER_ON_LATEST_VALID_VERSION, NO_FILTER_ON_RETENTION_EXPIRATION));
        attributeValueFilter = new AttributeValueFilter();
        attributeValueFilter.setAttributeName(ATTRIBUTE_NAME);
        attributeValueFilter.setAttributeValue(ATTRIBUTE_VALUE);
        this.businessObjectDataSearchHelper.validateBusinessObjectDataSearchKey(new BusinessObjectDataSearchKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NO_PARTITION_VALUE_FILTERS, Arrays.asList(attributeValueFilter), NO_FILTER_ON_LATEST_VALID_VERSION, NO_FILTER_ON_RETENTION_EXPIRATION));
    }
}

