/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.finra.herd.dao.ConfigurationDao;
import org.finra.herd.dao.helper.HerdStringHelper;
import org.finra.herd.dao.helper.XmlHelper;
import org.finra.herd.model.MethodNotAllowedException;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.ConfigurationEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.ConfigurationDaoHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ConfigurationDaoHelperTest
extends AbstractServiceTest {
    @Mock
    private ConfigurationDao configurationDao;
    @InjectMocks
    private ConfigurationDaoHelper configurationDaoHelper;
    @Mock
    private HerdStringHelper herdStringHelper;
    @Mock
    private XmlHelper xmlHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCheckNotAllowedMethod() {
        String blockedMethodListAsText = STRING_VALUE;
        List<String> blockedMethods = Arrays.asList(METHOD_NAME);
        ConfigurationEntity configurationEntity = (ConfigurationEntity)Mockito.mock(ConfigurationEntity.class);
        Mockito.when((Object)configurationEntity.getValueClob()).thenReturn((Object)blockedMethodListAsText);
        Mockito.when((Object)this.configurationDao.getConfigurationByKey(ConfigurationValue.NOT_ALLOWED_HERD_ENDPOINTS.getKey())).thenReturn((Object)configurationEntity);
        Mockito.when((Object)this.herdStringHelper.splitStringWithDefaultDelimiter(blockedMethodListAsText)).thenReturn(blockedMethods);
        try {
            this.configurationDaoHelper.checkNotAllowedMethod(METHOD_NAME);
            Assert.fail();
        }
        catch (MethodNotAllowedException e) {
            Assert.assertEquals((Object)"The requested method is not allowed.", (Object)e.getMessage());
        }
        ((ConfigurationDao)Mockito.verify((Object)this.configurationDao)).getConfigurationByKey(ConfigurationValue.NOT_ALLOWED_HERD_ENDPOINTS.getKey());
        ((HerdStringHelper)Mockito.verify((Object)this.herdStringHelper)).splitStringWithDefaultDelimiter(blockedMethodListAsText);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCheckNotAllowedMethodBlockedMethodListIsBlank() {
        ConfigurationEntity configurationEntity = (ConfigurationEntity)Mockito.mock(ConfigurationEntity.class);
        Mockito.when((Object)configurationEntity.getValueClob()).thenReturn((Object)"      \t\t ");
        Mockito.when((Object)this.configurationDao.getConfigurationByKey(ConfigurationValue.NOT_ALLOWED_HERD_ENDPOINTS.getKey())).thenReturn((Object)configurationEntity);
        this.configurationDaoHelper.checkNotAllowedMethod(METHOD_NAME);
        ((ConfigurationDao)Mockito.verify((Object)this.configurationDao)).getConfigurationByKey(ConfigurationValue.NOT_ALLOWED_HERD_ENDPOINTS.getKey());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCheckNotAllowedMethodBlockedMethodListIsNull() {
        ConfigurationEntity configurationEntity = (ConfigurationEntity)Mockito.mock(ConfigurationEntity.class);
        Mockito.when((Object)configurationEntity.getValueClob()).thenReturn(null);
        Mockito.when((Object)this.configurationDao.getConfigurationByKey(ConfigurationValue.NOT_ALLOWED_HERD_ENDPOINTS.getKey())).thenReturn((Object)configurationEntity);
        this.configurationDaoHelper.checkNotAllowedMethod(METHOD_NAME);
        ((ConfigurationDao)Mockito.verify((Object)this.configurationDao)).getConfigurationByKey(ConfigurationValue.NOT_ALLOWED_HERD_ENDPOINTS.getKey());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCheckNotAllowedMethodMethodIsNotBlocked() {
        String blockedMethodListAsText = STRING_VALUE;
        List<String> blockedMethods = Arrays.asList(METHOD_NAME);
        ConfigurationEntity configurationEntity = (ConfigurationEntity)Mockito.mock(ConfigurationEntity.class);
        Mockito.when((Object)configurationEntity.getValueClob()).thenReturn((Object)blockedMethodListAsText);
        Mockito.when((Object)this.configurationDao.getConfigurationByKey(ConfigurationValue.NOT_ALLOWED_HERD_ENDPOINTS.getKey())).thenReturn((Object)configurationEntity);
        Mockito.when((Object)this.herdStringHelper.splitStringWithDefaultDelimiter(blockedMethodListAsText)).thenReturn(blockedMethods);
        this.configurationDaoHelper.checkNotAllowedMethod(METHOD_NAME_2);
        ((ConfigurationDao)Mockito.verify((Object)this.configurationDao)).getConfigurationByKey(ConfigurationValue.NOT_ALLOWED_HERD_ENDPOINTS.getKey());
        ((HerdStringHelper)Mockito.verify((Object)this.herdStringHelper)).splitStringWithDefaultDelimiter(blockedMethodListAsText);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetClobProperty() {
        ConfigurationEntity configurationEntity = (ConfigurationEntity)Mockito.mock(ConfigurationEntity.class);
        Mockito.when((Object)configurationEntity.getValueClob()).thenReturn((Object)CONFIGURATION_VALUE);
        Mockito.when((Object)this.configurationDao.getConfigurationByKey(CONFIGURATION_KEY)).thenReturn((Object)configurationEntity);
        String result = this.configurationDaoHelper.getClobProperty(CONFIGURATION_KEY);
        ((ConfigurationDao)Mockito.verify((Object)this.configurationDao)).getConfigurationByKey(CONFIGURATION_KEY);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)CONFIGURATION_VALUE, (Object)result);
    }

    @Test
    public void testGetClobPropertyConfigurationNoExists() {
        Mockito.when((Object)this.configurationDao.getConfigurationByKey(CONFIGURATION_KEY)).thenReturn(null);
        String result = this.configurationDaoHelper.getClobProperty(CONFIGURATION_KEY);
        ((ConfigurationDao)Mockito.verify((Object)this.configurationDao)).getConfigurationByKey(CONFIGURATION_KEY);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testGetClobPropertyConfigurationValueIsBlank() {
        ConfigurationEntity configurationEntity = (ConfigurationEntity)Mockito.mock(ConfigurationEntity.class);
        Mockito.when((Object)configurationEntity.getValueClob()).thenReturn((Object)"      \t\t ");
        Mockito.when((Object)this.configurationDao.getConfigurationByKey(CONFIGURATION_KEY)).thenReturn((Object)configurationEntity);
        String result = this.configurationDaoHelper.getClobProperty(CONFIGURATION_KEY);
        ((ConfigurationDao)Mockito.verify((Object)this.configurationDao)).getConfigurationByKey(CONFIGURATION_KEY);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testGetXmlClobPropertyAndUnmarshallToObject() throws JAXBException {
        ConfigurationEntity configurationEntity = (ConfigurationEntity)Mockito.mock(ConfigurationEntity.class);
        Mockito.when((Object)configurationEntity.getValueClob()).thenReturn((Object)CONFIGURATION_VALUE);
        Mockito.when((Object)this.configurationDao.getConfigurationByKey(CONFIGURATION_KEY)).thenReturn((Object)configurationEntity);
        Mockito.when((Object)this.xmlHelper.unmarshallXmlToObject(String.class, CONFIGURATION_VALUE)).thenReturn((Object)STRING_VALUE);
        String result = (String)this.configurationDaoHelper.getXmlClobPropertyAndUnmarshallToObject(String.class, CONFIGURATION_KEY);
        ((ConfigurationDao)Mockito.verify((Object)this.configurationDao)).getConfigurationByKey(CONFIGURATION_KEY);
        ((XmlHelper)Mockito.verify((Object)this.xmlHelper)).unmarshallXmlToObject(String.class, CONFIGURATION_VALUE);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)STRING_VALUE, (Object)result);
    }

    @Test
    public void testGetXmlClobPropertyAndUnmarshallToObjectConfigurationValueIsBlank() {
        ConfigurationEntity configurationEntity = (ConfigurationEntity)Mockito.mock(ConfigurationEntity.class);
        Mockito.when((Object)configurationEntity.getValueClob()).thenReturn((Object)"      \t\t ");
        Mockito.when((Object)this.configurationDao.getConfigurationByKey(CONFIGURATION_KEY)).thenReturn((Object)configurationEntity);
        String result = (String)this.configurationDaoHelper.getXmlClobPropertyAndUnmarshallToObject(String.class, CONFIGURATION_KEY);
        ((ConfigurationDao)Mockito.verify((Object)this.configurationDao)).getConfigurationByKey(CONFIGURATION_KEY);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetXmlClobPropertyAndUnmarshallToObjectJAXBException() throws JAXBException {
        ConfigurationEntity configurationEntity = (ConfigurationEntity)Mockito.mock(ConfigurationEntity.class);
        Mockito.when((Object)configurationEntity.getValueClob()).thenReturn((Object)CONFIGURATION_VALUE);
        Mockito.when((Object)this.configurationDao.getConfigurationByKey(CONFIGURATION_KEY)).thenReturn((Object)configurationEntity);
        Mockito.when((Object)this.xmlHelper.unmarshallXmlToObject(String.class, CONFIGURATION_VALUE)).thenThrow(new Throwable[]{new JAXBException(ERROR_MESSAGE)});
        try {
            this.configurationDaoHelper.getXmlClobPropertyAndUnmarshallToObject(String.class, CONFIGURATION_KEY);
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Failed to unmarshall \"%s\" configuration value to %s.", CONFIGURATION_KEY, String.class.getName()), (Object)e.getMessage());
        }
        ((ConfigurationDao)Mockito.verify((Object)this.configurationDao)).getConfigurationByKey(CONFIGURATION_KEY);
        ((XmlHelper)Mockito.verify((Object)this.xmlHelper)).unmarshallXmlToObject(String.class, CONFIGURATION_VALUE);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationDao, this.herdStringHelper, this.xmlHelper});
    }
}

