/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.finra.herd.core.HerdDateUtils;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.AttributeDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDataInvalidateUnregisteredRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.MessageHeaderDefinition;
import org.finra.herd.model.api.xml.NotificationMessageDefinition;
import org.finra.herd.model.api.xml.NotificationMessageDefinitions;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.MessageHeader;
import org.finra.herd.model.dto.NotificationMessage;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.ConfigurationEntity;
import org.finra.herd.model.jpa.MessageTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.NotificationMessageBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class DefaultNotificationMessageBuilderTest
extends AbstractServiceTest {
    @Autowired
    private NotificationMessageBuilder defaultNotificationMessageBuilder;

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesNoMessageDefinitions() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(null);
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2).size());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions()));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2).size());
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithJsonPayload() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithJsonPayloadAndWithMessageHeaders() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ArrayList<MessageHeaderDefinition> messageHeaderDefinitions = new ArrayList<MessageHeaderDefinition>();
        messageHeaderDefinitions.add(new MessageHeaderDefinition("environment", "$herd_environment"));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("messageType", MESSAGE_TYPE));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("messageVersion", MESSAGE_VERSION));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("sourceSystem", SOURCE_SYSTEM));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("messageId", "$uuid"));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("userId", "$username"));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("namespace", "$namespace"));
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", messageHeaderDefinitions)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((long)7L, (long)CollectionUtils.size((Object)((NotificationMessage)result.get(0)).getMessageHeaders()));
        String uuid = ((MessageHeader)((NotificationMessage)result.get(0)).getMessageHeaders().get(4)).getValue();
        Assert.assertEquals((long)UUID.randomUUID().toString().length(), (long)StringUtils.length((CharSequence)uuid));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, Arrays.asList(new MessageHeader("environment", this.configurationHelper.getProperty(ConfigurationValue.HERD_ENVIRONMENT)), new MessageHeader("messageType", MESSAGE_TYPE), new MessageHeader("messageVersion", MESSAGE_VERSION), new MessageHeader("sourceSystem", SOURCE_SYSTEM), new MessageHeader("messageId", uuid), new MessageHeader("userId", "SYSTEM"), new MessageHeader("namespace", NAMESPACE)), (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithJsonPayloadNoOldBusinessObjectDataStatus() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, NO_BDATA_STATUS);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, NO_BDATA_STATUS, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithJsonPayloadNoSubPartitionValues() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(NO_SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        BusinessObjectDataKey expectedBusinessObjectDataKey = (BusinessObjectDataKey)businessObjectDataKey.clone();
        expectedBusinessObjectDataKey.setSubPartitionValues(null);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, expectedBusinessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithJsonPayloadWithMultipleAttributes() throws Exception {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("Attribute Name 1", "Attribute Value 1"));
        attributes.add(new Attribute("Attribute Name 2", "   Attribute Value 2  "));
        attributes.add(new Attribute("Attribute Name 3", "Attribute Value 3"));
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 1", AbstractServiceTest.PUBLISH_ATTRIBUTE));
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 2", AbstractServiceTest.PUBLISH_ATTRIBUTE));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, attributeDefinitions, attributes);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, attributes.subList(0, 2), NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithJsonPayloadWithSingleAttribute() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, Collections.singletonList(new Attribute("Attribute Name 3", "Attribute Value 3")), NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithJsonPayloadWithSingleSubPartitionValue() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES.subList(0, 1), NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayload() throws Exception {
        this.testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadHelper(SUBPARTITION_VALUES, "SYSTEM");
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadNoSubPartitionValues() throws Exception {
        this.testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadHelper(NO_SUBPARTITION_VALUES, "SYSTEM");
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadWithMessageHeaders() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ArrayList<MessageHeaderDefinition> messageHeaderDefinitions = new ArrayList<MessageHeaderDefinition>();
        messageHeaderDefinitions.add(new MessageHeaderDefinition("environment", "$herd_environment"));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("messageType", MESSAGE_TYPE));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("messageVersion", MESSAGE_VERSION));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("sourceSystem", SOURCE_SYSTEM));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("messageId", "$uuid"));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("userId", "$username"));
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", messageHeaderDefinitions)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((long)6L, (long)CollectionUtils.size((Object)((NotificationMessage)result.get(0)).getMessageHeaders()));
        String uuid = ((MessageHeader)((NotificationMessage)result.get(0)).getMessageHeaders().get(4)).getValue();
        Assert.assertEquals((long)UUID.randomUUID().toString().length(), (long)StringUtils.length((CharSequence)uuid));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, Arrays.asList(new MessageHeader("environment", this.configurationHelper.getProperty(ConfigurationValue.HERD_ENVIRONMENT)), new MessageHeader("messageType", MESSAGE_TYPE), new MessageHeader("messageVersion", MESSAGE_VERSION), new MessageHeader("sourceSystem", SOURCE_SYSTEM), new MessageHeader("messageId", uuid), new MessageHeader("userId", "SYSTEM")), (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadWithUserInContext() throws Exception {
        Authentication originalAuthentication = SecurityContextHolder.getContext().getAuthentication();
        try {
            SecurityContextHolder.getContext().setAuthentication(new Authentication(){

                public String getName() {
                    return null;
                }

                public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
                }

                public boolean isAuthenticated() {
                    return false;
                }

                public Object getPrincipal() {
                    List authorities = Collections.emptyList();
                    return new User("testUsername", "", authorities);
                }

                public Object getDetails() {
                    return null;
                }

                public Object getCredentials() {
                    return null;
                }

                public Collection<? extends GrantedAuthority> getAuthorities() {
                    return null;
                }
            });
            this.testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadHelper(SUBPARTITION_VALUES, "testUsername");
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(originalAuthentication);
        }
    }

    @Test
    public void testBuildBusinessObjectFormatVersionChangeMessagesNoMessageDefinitions() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        BusinessObjectFormatKey businessObjectFormatKey = this.businessObjectFormatHelper.getBusinessObjectFormatKey(businessObjectFormatEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(null);
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.messageNotificationEventService.processBusinessObjectFormatVersionChangeNotificationEvent(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION).size());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions()));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.messageNotificationEventService.processBusinessObjectFormatVersionChangeNotificationEvent(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION).size());
    }

    @Test
    public void testBuildBusinessObjectFormatValueChangeMessagesWithJsonPayload() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        BusinessObjectFormatKey businessObjectFormatKey = this.businessObjectFormatHelper.getBusinessObjectFormatKey(businessObjectFormatEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectFormatKey\" : {\n    \"namespace\" : \"$businessObjectFormatKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectFormatKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectFormatKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectFormatKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectFormatKey.businessObjectFormatVersion\n  },\n  \"newBusinessObjectFormatVersion\" : \"$newBusinessObjectFormatVersion\"#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion)),\n  \"oldBusinessObjectFormatVersion\" : \"$oldBusinessObjectFormatVersion\"#end\n}\n", Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectFormatVersionChangeNotificationEvent(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectFormatVersionChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectFormatKey, businessObjectFormatKey.getBusinessObjectFormatVersion().toString(), NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectFormatValueChangeMessagesWithJsonPayloadWithNoMessageType() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        BusinessObjectFormatKey businessObjectFormatKey = this.businessObjectFormatHelper.getBusinessObjectFormatKey(businessObjectFormatEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(NO_MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectFormatKey\" : {\n    \"namespace\" : \"$businessObjectFormatKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectFormatKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectFormatKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectFormatKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectFormatKey.businessObjectFormatVersion\n  },\n  \"newBusinessObjectFormatVersion\" : \"$newBusinessObjectFormatVersion\"#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion)),\n  \"oldBusinessObjectFormatVersion\" : \"$oldBusinessObjectFormatVersion\"#end\n}\n", Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.messageNotificationEventService.processBusinessObjectFormatVersionChangeNotificationEvent(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            Assert.assertEquals((Object)String.format("Notification message type must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)illegalStateException.getMessage());
        }
    }

    @Test
    public void testBuildBusinessObjectFormatValueChangeMessagesWithJsonPayloadWithNoMessageDestination() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        BusinessObjectFormatKey businessObjectFormatKey = this.businessObjectFormatHelper.getBusinessObjectFormatKey(businessObjectFormatEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, NO_MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectFormatKey\" : {\n    \"namespace\" : \"$businessObjectFormatKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectFormatKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectFormatKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectFormatKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectFormatKey.businessObjectFormatVersion\n  },\n  \"newBusinessObjectFormatVersion\" : \"$newBusinessObjectFormatVersion\"#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion)),\n  \"oldBusinessObjectFormatVersion\" : \"$oldBusinessObjectFormatVersion\"#end\n}\n", Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.messageNotificationEventService.processBusinessObjectFormatVersionChangeNotificationEvent(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            Assert.assertEquals((Object)String.format("Notification message destination must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)illegalStateException.getMessage());
        }
    }

    @Test
    public void testBuildSystemMonitorResponse() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            NotificationMessage result = this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            this.validateSystemMonitorResponseNotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "HERD_OUTGOING_QUEUE", result);
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseInvalidVelocityTemplate() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "#if($missingEndOfIfStatement");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            Assert.fail();
        }
        catch (ParseErrorException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Encountered \"<EOF>\" at systemMonitorResponse[line 1, column 28]"));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseInvalidXmlRequestPayload() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(INVALID_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Payload is not valid XML:\n%s", INVALID_VALUE), (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseInvalidXpathExpression() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey(), "key=///");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("XPath expression \"///\" could not be evaluated against payload"));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseInvalidXpathProperties() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey(), "key=\\uxxxx");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Unable to load XPath properties from configuration with key '%s'", ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey()), (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseNoMessageVelocityTemplate() throws Exception {
        HashMap<String, Object> overrideMap = new HashMap<String, Object>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertNull((Object)this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage()));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseNoXPathExpressions() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            Assert.fail();
        }
        catch (MethodInvocationException e) {
            Assert.assertEquals((Object)"Variable $incoming_message_correlation_id has not been set at systemMonitorResponse[line 11, column 29]", (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    private void testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadHelper(List<String> subPartitionValues, String expectedTriggeredByUsername) throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(subPartitionValues, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), expectedTriggeredByUsername, BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    private void validateBusinessObjectDataStatusChangeMessageWithJsonPayload(String expectedMessageType, String expectedMessageDestination, BusinessObjectDataKey expectedBusinessObjectDataKey, String expectedNewBusinessObjectDataStatus, String expectedOldBusinessObjectDataStatus, List<Attribute> expectedBusinessObjectDataAttributes, List<MessageHeader> expectedMessageHeaders, NotificationMessage notificationMessage) throws IOException {
        Assert.assertNotNull((Object)notificationMessage);
        Assert.assertEquals((Object)expectedMessageType, (Object)notificationMessage.getMessageType());
        Assert.assertEquals((Object)expectedMessageDestination, (Object)notificationMessage.getMessageDestination());
        BusinessObjectDataStatusChangeJsonMessagePayload businessObjectDataStatusChangeJsonMessagePayload = (BusinessObjectDataStatusChangeJsonMessagePayload)this.jsonHelper.unmarshallJsonToObject(BusinessObjectDataStatusChangeJsonMessagePayload.class, notificationMessage.getMessageText());
        Assert.assertEquals((long)StringUtils.length((CharSequence)businessObjectDataStatusChangeJsonMessagePayload.eventDate), (long)StringUtils.length((CharSequence)HerdDateUtils.now().toString()));
        Assert.assertEquals((Object)expectedBusinessObjectDataKey, (Object)businessObjectDataStatusChangeJsonMessagePayload.businessObjectDataKey);
        Assert.assertEquals((Object)expectedNewBusinessObjectDataStatus, (Object)businessObjectDataStatusChangeJsonMessagePayload.newBusinessObjectDataStatus);
        Assert.assertEquals((Object)expectedOldBusinessObjectDataStatus, (Object)businessObjectDataStatusChangeJsonMessagePayload.oldBusinessObjectDataStatus);
        Assert.assertEquals((long)CollectionUtils.size(expectedBusinessObjectDataAttributes), (long)CollectionUtils.size(businessObjectDataStatusChangeJsonMessagePayload.attributes));
        if (CollectionUtils.isNotEmpty(expectedBusinessObjectDataAttributes)) {
            for (Attribute expectedAttribute : expectedBusinessObjectDataAttributes) {
                Assert.assertTrue((boolean)businessObjectDataStatusChangeJsonMessagePayload.attributes.containsKey(expectedAttribute.getName()));
                Assert.assertEquals((Object)expectedAttribute.getValue(), (Object)businessObjectDataStatusChangeJsonMessagePayload.attributes.get(expectedAttribute.getName()));
            }
        }
        Assert.assertEquals(expectedMessageHeaders, (Object)notificationMessage.getMessageHeaders());
    }

    private void validateBusinessObjectFormatVersionChangeMessageWithJsonPayload(String expectedMessageType, String expectedMessageDestination, BusinessObjectFormatKey expectedBusinessObjectFormatKey, String expectedNewBusinessObjectFormatVersion, String expectedOldBusinessObjectFormatVersion, NotificationMessage notificationMessage) throws IOException {
        Assert.assertNotNull((Object)notificationMessage);
        Assert.assertEquals((Object)expectedMessageType, (Object)notificationMessage.getMessageType());
        Assert.assertEquals((Object)expectedMessageDestination, (Object)notificationMessage.getMessageDestination());
        BusinessObjectFormatVersionChangeJsonMessagePayload businessObjectFormatVersionChangeJsonMessagePayload = (BusinessObjectFormatVersionChangeJsonMessagePayload)this.jsonHelper.unmarshallJsonToObject(BusinessObjectFormatVersionChangeJsonMessagePayload.class, notificationMessage.getMessageText());
        Assert.assertEquals((long)StringUtils.length((CharSequence)businessObjectFormatVersionChangeJsonMessagePayload.eventDate), (long)StringUtils.length((CharSequence)HerdDateUtils.now().toString()));
        Assert.assertEquals((Object)expectedBusinessObjectFormatKey, (Object)businessObjectFormatVersionChangeJsonMessagePayload.businessObjectFormatKey);
        Assert.assertEquals((Object)expectedNewBusinessObjectFormatVersion, (Object)businessObjectFormatVersionChangeJsonMessagePayload.newBusinessObjectFormatVersion);
        Assert.assertEquals((Object)expectedOldBusinessObjectFormatVersion, (Object)businessObjectFormatVersionChangeJsonMessagePayload.oldBusinessObjectFormatVersion);
    }

    private static class BusinessObjectFormatVersionChangeJsonMessagePayload {
        public BusinessObjectFormatKey businessObjectFormatKey;
        public String eventDate;
        public String newBusinessObjectFormatVersion;
        public String oldBusinessObjectFormatVersion;

        private BusinessObjectFormatVersionChangeJsonMessagePayload() {
        }
    }

    private static class BusinessObjectDataStatusChangeJsonMessagePayload {
        public Map<String, String> attributes;
        public BusinessObjectDataKey businessObjectDataKey;
        public String eventDate;
        public String newBusinessObjectDataStatus;
        public String oldBusinessObjectDataStatus;

        private BusinessObjectDataStatusChangeJsonMessagePayload() {
        }
    }
}

