/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.finra.herd.dao.impl.MockEc2OperationsImpl;
import org.finra.herd.model.api.xml.EmrClusterDefinition;
import org.finra.herd.model.api.xml.InstanceDefinition;
import org.finra.herd.model.api.xml.InstanceDefinitions;
import org.finra.herd.model.api.xml.MasterInstanceDefinition;
import org.finra.herd.model.api.xml.NodeTag;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class EmrClusterDefinitionHelperTest
extends AbstractServiceTest {
    @Test
    public void testValidateEmrClusterDefinitionConfigurationNullSubnet() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.setSubnetId(null);
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationValid() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
        }
        catch (Exception e) {
            Assert.fail((String)("expected no exception, but " + e.getClass() + " was thrown. " + e));
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationMasterSpotPriceSpecified() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceSpotPrice(BigDecimal.ONE);
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
        }
        catch (Exception e) {
            Assert.fail((String)("expected no exception, but " + e.getClass() + " was thrown. " + e));
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationMasterMaxSearchPriceSpecified() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceMaxSearchPrice(BigDecimal.ONE);
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
        }
        catch (Exception e) {
            Assert.fail((String)("expected no exception, but " + e.getClass() + " was thrown. " + e));
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationMasterMaxSearchPriceAndOnDemandThresholdSpecified() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceMaxSearchPrice(BigDecimal.ONE);
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceOnDemandThreshold(BigDecimal.ONE);
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
        }
        catch (Exception e) {
            Assert.fail((String)("expected no exception, but " + e.getClass() + " was thrown. " + e));
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationTaskInstanceDefinitionNotSpecified() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().setTaskInstances(null);
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
        }
        catch (Exception e) {
            Assert.fail((String)("expected no exception, but " + e.getClass() + " was thrown. " + e));
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationBlankSubnet() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.setSubnetId(" \r\t\n");
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationSubnetListBlankElement() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.setSubnetId(MockEc2OperationsImpl.SUBNET_1 + ", \r\t\n");
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationMasterSpotPriceNegative() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceSpotPrice(BigDecimal.ONE.negate());
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationMasterSpotPriceAndMaxSearchPriceSpecified() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceSpotPrice(BigDecimal.ONE);
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceMaxSearchPrice(BigDecimal.ONE);
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationMasterMaxSearchPriceNegative() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceMaxSearchPrice(BigDecimal.ONE.negate());
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationMasterOnDemandThresholdSpecified() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceOnDemandThreshold(BigDecimal.ONE);
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationMasterMaxSearchPriceSpecifiedAndOnDemandThresholdNegative() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceMaxSearchPrice(BigDecimal.ONE);
        emrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceOnDemandThreshold(BigDecimal.ONE.negate());
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Master instance on-demand threshold must be greater than 0", (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationCoreInstancesNotSpecified() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().setCoreInstances(null);
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
        }
        catch (Exception e) {
            Assert.fail((String)("expected no exception, but " + e.getClass() + " was thrown. " + e));
        }
    }

    @Test
    public void testValidateEmrClusterDefinitionConfigurationCoreInstanceSpecifiedInstanceCountNegative() {
        EmrClusterDefinition emrClusterDefinition = this.createValidEmrClusterDefinition();
        emrClusterDefinition.getInstanceDefinitions().getCoreInstances().setInstanceCount(-1);
        try {
            this.emrClusterDefinitionHelper.validateEmrClusterDefinitionConfiguration(emrClusterDefinition);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least 0 core instance must be specified.", (Object)e.getMessage());
        }
    }

    private EmrClusterDefinition createValidEmrClusterDefinition() {
        EmrClusterDefinition emrClusterDefinition = new EmrClusterDefinition();
        emrClusterDefinition.setSubnetId(MockEc2OperationsImpl.SUBNET_1);
        InstanceDefinitions instanceDefinitions = new InstanceDefinitions();
        MasterInstanceDefinition masterInstanceDefinition = new MasterInstanceDefinition();
        masterInstanceDefinition.setInstanceCount(1);
        masterInstanceDefinition.setInstanceType(MockEc2OperationsImpl.INSTANCE_TYPE_1);
        instanceDefinitions.setMasterInstances(masterInstanceDefinition);
        InstanceDefinition coreInstanceDefinition = new InstanceDefinition();
        coreInstanceDefinition.setInstanceCount(1);
        coreInstanceDefinition.setInstanceType(MockEc2OperationsImpl.INSTANCE_TYPE_1);
        instanceDefinitions.setCoreInstances(coreInstanceDefinition);
        InstanceDefinition taskInstanceDefinition = new InstanceDefinition();
        taskInstanceDefinition.setInstanceCount(1);
        taskInstanceDefinition.setInstanceType(MockEc2OperationsImpl.INSTANCE_TYPE_1);
        instanceDefinitions.setTaskInstances(taskInstanceDefinition);
        emrClusterDefinition.setInstanceDefinitions(instanceDefinitions);
        ArrayList<NodeTag> nodeTags = new ArrayList<NodeTag>();
        nodeTags.add(new NodeTag("test_nodeTagName", "test_nodeTagValue"));
        emrClusterDefinition.setNodeTags(nodeTags);
        return emrClusterDefinition;
    }
}

