/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.dao.GlobalAttributeDefinitionDao;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.GlobalAttributeDefinitionKey;
import org.finra.herd.model.jpa.GlobalAttributeDefinitionEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.GlobalAttributeDefinitionDaoHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class GlobalAttributeDefinitionDaoHelperTest
extends AbstractServiceTest {
    @InjectMocks
    private GlobalAttributeDefinitionDaoHelper globalAttributeDefinitionDaoHelper;
    @Mock
    private GlobalAttributeDefinitionDao globalAttributeDefinitionDao;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testGetGlobalAttributeDefinitionEntity() {
        GlobalAttributeDefinitionKey globalAttributeDefinitionKey = new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        GlobalAttributeDefinitionEntity globalAttributeDefinitionEntity = this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        Mockito.when((Object)this.globalAttributeDefinitionDao.getGlobalAttributeDefinitionByKey(globalAttributeDefinitionKey)).thenReturn((Object)globalAttributeDefinitionEntity);
        GlobalAttributeDefinitionEntity response = this.globalAttributeDefinitionDaoHelper.getGlobalAttributeDefinitionEntity(globalAttributeDefinitionKey);
        ((GlobalAttributeDefinitionDao)Mockito.verify((Object)this.globalAttributeDefinitionDao)).getGlobalAttributeDefinitionByKey(globalAttributeDefinitionKey);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.globalAttributeDefinitionDao});
        Assert.assertEquals((Object)globalAttributeDefinitionEntity, (Object)response);
    }

    @Test
    public void testGetGlobalAttributeDefinitionEntityEntityNoExists() {
        GlobalAttributeDefinitionKey globalAttributeDefinitionKey = new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        Mockito.when((Object)this.globalAttributeDefinitionDao.getGlobalAttributeDefinitionByKey(globalAttributeDefinitionKey)).thenReturn(null);
        try {
            this.globalAttributeDefinitionDaoHelper.getGlobalAttributeDefinitionEntity(globalAttributeDefinitionKey);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Global attribute definition with level \"%s\" doesn't exist for global attribute definition name \"%s\".", globalAttributeDefinitionKey.getGlobalAttributeDefinitionLevel(), globalAttributeDefinitionKey.getGlobalAttributeDefinitionName()), (Object)e.getMessage());
        }
        ((GlobalAttributeDefinitionDao)Mockito.verify((Object)this.globalAttributeDefinitionDao)).getGlobalAttributeDefinitionByKey(globalAttributeDefinitionKey);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.globalAttributeDefinitionDao});
    }

    @Test
    public void testValidateGlobalAttributeDefinitionNoExistsEntityExists() {
        GlobalAttributeDefinitionKey globalAttributeDefinitionKey = new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        GlobalAttributeDefinitionEntity globalAttributeDefinitionEntity = new GlobalAttributeDefinitionEntity();
        Mockito.when((Object)this.globalAttributeDefinitionDao.getGlobalAttributeDefinitionByKey(globalAttributeDefinitionKey)).thenReturn((Object)globalAttributeDefinitionEntity);
        try {
            this.globalAttributeDefinitionDaoHelper.validateGlobalAttributeDefinitionNoExists(globalAttributeDefinitionKey);
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create global attribute definition with global attribute definition level \"%s\" and global attribute definition name \"%s\" because it already exists.", globalAttributeDefinitionKey.getGlobalAttributeDefinitionLevel(), globalAttributeDefinitionKey.getGlobalAttributeDefinitionName()), (Object)e.getMessage());
        }
        ((GlobalAttributeDefinitionDao)Mockito.verify((Object)this.globalAttributeDefinitionDao)).getGlobalAttributeDefinitionByKey(globalAttributeDefinitionKey);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.globalAttributeDefinitionDao});
    }

    @Test
    public void testValidateGlobalAttributeDefinitionNoExists() {
        GlobalAttributeDefinitionKey globalAttributeDefinitionKey = new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        Mockito.when((Object)this.globalAttributeDefinitionDao.getGlobalAttributeDefinitionByKey(globalAttributeDefinitionKey)).thenReturn(null);
        this.globalAttributeDefinitionDaoHelper.validateGlobalAttributeDefinitionNoExists(globalAttributeDefinitionKey);
        ((GlobalAttributeDefinitionDao)Mockito.verify((Object)this.globalAttributeDefinitionDao)).getGlobalAttributeDefinitionByKey(globalAttributeDefinitionKey);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.globalAttributeDefinitionDao});
    }
}

