/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectFormatDdlRequest;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.model.dto.HivePartitionDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.SchemaColumnEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class Hive13DdlGeneratorTest
extends AbstractServiceTest {
    @Test
    public void testGetHivePartitions() {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        List<SchemaColumn> autoDiscoverableSubPartitionColumns = this.getPartitionColumns(Arrays.asList("Column1", "column2"));
        List<Object> storageFilePaths = new ArrayList();
        List<Object> expectedHivePartitions = new ArrayList();
        List resultHivePartitions = this.hive13DdlGenerator.getHivePartitions(businessObjectDataKey, autoDiscoverableSubPartitionColumns, TEST_S3_KEY_PREFIX, storageFilePaths, businessObjectDataEntity, STORAGE_NAME);
        Assert.assertEquals(expectedHivePartitions, (Object)resultHivePartitions);
        autoDiscoverableSubPartitionColumns = new ArrayList<SchemaColumn>();
        storageFilePaths = this.getStorageFilePaths(Arrays.asList("/file1.dat", "/file2.dat"));
        expectedHivePartitions = Arrays.asList(HivePartitionDto.builder().withPath("").withPartitionValues(Arrays.asList(PARTITION_VALUE)).build());
        resultHivePartitions = this.hive13DdlGenerator.getHivePartitions(businessObjectDataKey, autoDiscoverableSubPartitionColumns, TEST_S3_KEY_PREFIX, storageFilePaths, businessObjectDataEntity, STORAGE_NAME);
        Assert.assertEquals(expectedHivePartitions, (Object)resultHivePartitions);
        autoDiscoverableSubPartitionColumns = this.getPartitionColumns(Arrays.asList("Column1", "column2"));
        storageFilePaths = this.getStorageFilePaths(Arrays.asList("/COLUMN1=111/COLUMN2=222/file.dat", "/column1=aa/column2=bb/"));
        expectedHivePartitions = Arrays.asList(HivePartitionDto.builder().withPath("/COLUMN1=111/COLUMN2=222").withPartitionValues(Arrays.asList(PARTITION_VALUE, "111", "222")).build(), HivePartitionDto.builder().withPath("/column1=aa/column2=bb").withPartitionValues(Arrays.asList(PARTITION_VALUE, "aa", "bb")).build());
        resultHivePartitions = this.hive13DdlGenerator.getHivePartitions(businessObjectDataKey, autoDiscoverableSubPartitionColumns, TEST_S3_KEY_PREFIX, storageFilePaths, businessObjectDataEntity, STORAGE_NAME);
        Assert.assertEquals(expectedHivePartitions, (Object)resultHivePartitions);
    }

    @Test
    public void testGetHivePartitionsPatternMismatch() {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        List<SchemaColumn> autoDiscoverableSubPartitionColumns = this.getPartitionColumns(Arrays.asList("Column1", "column2"));
        String pattern = this.hive13DdlGenerator.getHivePathPattern(autoDiscoverableSubPartitionColumns).pattern();
        List<String> badFilePaths = Arrays.asList("/column1=a/column2=b/extra-folder/file.dat", "/column2=a/column1=b/file.dat", "/column1=a/file.dat", "/column1=a/column2=/file.dat", "/column1=a/column2/file.dat", "/column1=a/a/column2=2/file.dat", "/column1=a/column2=2");
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        for (int i = 0; i < badFilePaths.size(); ++i) {
            List<String> storageFilePaths = this.getStorageFilePaths(badFilePaths.subList(i, i + 1));
            try {
                this.hive13DdlGenerator.getHivePartitions(businessObjectDataKey, autoDiscoverableSubPartitionColumns, TEST_S3_KEY_PREFIX, storageFilePaths, businessObjectDataEntity, STORAGE_NAME);
                Assert.fail((String)"Should throw an IllegalArgumentException when storage file does not match the expected Hive sub-directory pattern.");
                continue;
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)String.format("Registered storage file or directory does not match the expected Hive sub-directory pattern. Storage: {%s}, file/directory: {%s}, business object data: {%s}, S3 key prefix: {%s}, pattern: {^%s$}", STORAGE_NAME, storageFilePaths.get(0), this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity), TEST_S3_KEY_PREFIX, pattern), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testGetHivePartitionsMultiplePathsFound() {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        List<SchemaColumn> autoDiscoverableSubPartitionColumns = this.getPartitionColumns(Arrays.asList("Column1", "column2"));
        List<String> partitionPaths = Arrays.asList("/COLUMN1=111/COLUMN2=222", "/column1=111/COLUMN2=222");
        List<String> storageFilePaths = this.getStorageFilePaths(Arrays.asList(partitionPaths.get(0) + "/file.dat", partitionPaths.get(1) + "/file.dat"));
        try {
            this.hive13DdlGenerator.getHivePartitions(this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity), autoDiscoverableSubPartitionColumns, TEST_S3_KEY_PREFIX, storageFilePaths, businessObjectDataEntity, STORAGE_NAME);
            Assert.fail((String)"Should throw an IllegalArgumentException when multiple locations exist for the same Hive partition.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Found two different locations for the same Hive partition. Storage: {%s}, business object data: {%s}, S3 key prefix: {%s}, path[1]: {%s}, path[2]: {%s}", STORAGE_NAME, this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity), TEST_S3_KEY_PREFIX, partitionPaths.get(0), partitionPaths.get(1)), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetDdlCharacterValueEmptyString() {
        Assert.assertEquals((Object)"", (Object)this.hive13DdlGenerator.getDdlCharacterValue(""));
    }

    @Test
    public void testGetDdlCharacterValueLineFeed() {
        Assert.assertEquals((Object)"\\012", (Object)this.hive13DdlGenerator.getDdlCharacterValue("\n"));
    }

    @Test
    public void testGetDdlCharacterValueAsciiPrintable() {
        Assert.assertEquals((Object)"|", (Object)this.hive13DdlGenerator.getDdlCharacterValue("|"));
    }

    @Test
    public void testGetDdlCharacterValueAsciiNonAsciiMix() {
        Assert.assertEquals((Object)"A\\200B", (Object)this.hive13DdlGenerator.getDdlCharacterValue("A" + String.valueOf('\u0080') + "B"));
    }

    @Test
    public void testGetDdlCharacterValueTwoNonAsciiPrintableChars() {
        Assert.assertEquals((Object)"\\200\\001", (Object)this.hive13DdlGenerator.getDdlCharacterValue(String.valueOf('\u0080') + String.valueOf('\u0001')));
    }

    @Test
    public void testGetDdlCharacterValueEscapeSingleBackslash() {
        Assert.assertEquals((Object)"\\", (Object)this.hive13DdlGenerator.getDdlCharacterValue("\\"));
        Assert.assertEquals((Object)"\\", (Object)this.hive13DdlGenerator.getDdlCharacterValue("\\", false));
        Assert.assertEquals((Object)"\\\\", (Object)this.hive13DdlGenerator.getDdlCharacterValue("\\", true));
        Assert.assertEquals((Object)"\\\\", (Object)this.hive13DdlGenerator.getDdlCharacterValue("\\\\", true));
    }

    @Test
    public void testEscapeSingleQuotes() {
        LinkedHashMap<String, String> testVector = new LinkedHashMap<String, String>();
        testVector.put("some text without single quotes", "some text without single quotes");
        testVector.put("'some \\'text\\' with single 'quotes'", "\\'some \\'text\\' with single \\'quotes\\'");
        testVector.put("'", "\\'");
        testVector.put("''''", "\\'\\'\\'\\'");
        testVector.put("'", "\\'");
        testVector.put("''\\'", "\\'\\'\\'");
        Iterator iterator = testVector.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry set;
            Map.Entry entry = set = iterator.next();
            Assert.assertEquals(entry.getValue(), (Object)this.hive13DdlGenerator.escapeSingleQuotes((String)entry.getKey()));
        }
    }

    @Test
    public void testGenerateReplaceColumnsStatement() {
        BusinessObjectFormatDdlRequest businessObjectFormatDdlRequest = new BusinessObjectFormatDdlRequest();
        businessObjectFormatDdlRequest.setTableName(TABLE_NAME);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, Boolean.valueOf(true), PARTITION_KEY);
        SchemaColumnEntity schemaColumnEntity = new SchemaColumnEntity();
        schemaColumnEntity.setPosition(Integer.valueOf(0));
        schemaColumnEntity.setName("col1");
        schemaColumnEntity.setType("varchar");
        schemaColumnEntity.setSize("255");
        schemaColumnEntity.setDescription("lorem ipsum");
        businessObjectFormatEntity.getSchemaColumns().add(schemaColumnEntity);
        schemaColumnEntity = new SchemaColumnEntity();
        schemaColumnEntity.setPosition(Integer.valueOf(1));
        schemaColumnEntity.setName("col2");
        schemaColumnEntity.setType("date");
        businessObjectFormatEntity.getSchemaColumns().add(schemaColumnEntity);
        String actual = this.hive13DdlGenerator.generateReplaceColumnsStatement(businessObjectFormatDdlRequest, businessObjectFormatEntity);
        String expected = "ALTER TABLE `" + businessObjectFormatDdlRequest.getTableName() + "` REPLACE COLUMNS (\n" + "    `col1` VARCHAR(255) COMMENT 'lorem ipsum',\n" + "    `col2` DATE);";
        Assert.assertEquals((String)"generated DDL", (Object)expected, (Object)actual);
    }

    @Test
    public void testGenerateReplaceColumnsStatementAssertionErrorIfColumnsEmpty() {
        BusinessObjectFormatDdlRequest businessObjectFormatDdlRequest = new BusinessObjectFormatDdlRequest();
        businessObjectFormatDdlRequest.setTableName(TABLE_NAME);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, Boolean.valueOf(true), PARTITION_KEY);
        SchemaColumnEntity schemaColumnEntity = new SchemaColumnEntity();
        schemaColumnEntity.setPartitionLevel(Integer.valueOf(0));
        schemaColumnEntity.setName("col1");
        schemaColumnEntity.setType("date");
        businessObjectFormatEntity.getSchemaColumns().add(schemaColumnEntity);
        try {
            this.hive13DdlGenerator.generateReplaceColumnsStatement(businessObjectFormatDdlRequest, businessObjectFormatEntity);
            Assert.fail((String)"expected IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)("No schema columns specified for business object format {namespace: \"" + NAMESPACE + "\", businessObjectDefinitionName: \"" + BDEF_NAME + "\", businessObjectFormatUsage: \"" + FORMAT_USAGE_CODE + "\", businessObjectFormatFileType: \"" + FORMAT_FILE_TYPE_CODE + "\", businessObjectFormatVersion: " + FORMAT_VERSION + "}."), (Object)e.getMessage());
        }
    }

    private List<SchemaColumn> getPartitionColumns(List<String> partitionColumnNames) {
        ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
        for (String partitionColumnName : partitionColumnNames) {
            SchemaColumn schemaColumn = new SchemaColumn();
            schemaColumns.add(schemaColumn);
            schemaColumn.setName(partitionColumnName);
        }
        return schemaColumns;
    }

    private List<String> getStorageFilePaths(List<String> storageFileRelativePaths) {
        ArrayList<String> storageFilePaths = new ArrayList<String>();
        for (String storageFileRelativePath : storageFileRelativePaths) {
            storageFilePaths.add(String.format("%s%s", TEST_S3_KEY_PREFIX, storageFileRelativePath));
        }
        return storageFilePaths;
    }
}

