/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.NamespaceIamRoleAuthorizationDao;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.model.jpa.NamespaceIamRoleAuthorizationEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.NamespaceIamRoleAuthorizationHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.security.access.AccessDeniedException;

public class NamespaceIamRoleAuthorizationHelperTest
extends AbstractServiceTest {
    @InjectMocks
    private NamespaceIamRoleAuthorizationHelper namespaceIamRoleAuthorizationHelper;
    @Mock
    private NamespaceIamRoleAuthorizationDao namespaceIamRoleAuthorizationDao;
    @Mock
    private ConfigurationHelper configurationHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void checkPermissionsAssertNoErrorWhenNamespaceAuthorizedToAllRoles() {
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        String iamRoleName1 = "iamRoleName1";
        String iamRoleName2 = "iamRoleName2";
        List<String> requestedIamRoleNames = Arrays.asList(iamRoleName1, iamRoleName2);
        ArrayList<NamespaceIamRoleAuthorizationEntity> namespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setIamRoleName(iamRoleName1);
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity2 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity2.setIamRoleName(iamRoleName2);
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity2);
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        this.namespaceIamRoleAuthorizationHelper.checkPermissions(expectedNamespaceEntity, requestedIamRoleNames);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getBooleanProperty(ConfigurationValue.NAMESPACE_IAM_ROLE_AUTHORIZATION_ENABLED);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void checkPermissionsAssertAccessDeniedWhenNamespaceNotAuthorizedToOneRole() {
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("namespace");
        String iamRoleName1 = "iamRoleName1";
        String iamRoleName2 = "iamRoleName2";
        List<String> requestedIamRoleNames = Arrays.asList(iamRoleName1, iamRoleName2);
        ArrayList<NamespaceIamRoleAuthorizationEntity> namespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setIamRoleName(iamRoleName1);
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        try {
            this.namespaceIamRoleAuthorizationHelper.checkPermissions(expectedNamespaceEntity, requestedIamRoleNames);
            Assert.fail();
        }
        catch (AccessDeniedException e) {
            Assert.assertEquals((Object)"The namespace \"namespace\" does not have access to the following IAM roles: [iamRoleName2]", (Object)e.getMessage());
        }
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getBooleanProperty(ConfigurationValue.NAMESPACE_IAM_ROLE_AUTHORIZATION_ENABLED);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void checkPermissionsAssertAccessDeniedWhenNamespaceNotAuthorizedToAllRole() {
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        expectedNamespaceEntity.setCode("namespace");
        String iamRoleName1 = "iamRoleName1";
        String iamRoleName2 = "iamRoleName2";
        List<String> requestedIamRoleNames = Arrays.asList(iamRoleName1, iamRoleName2);
        ArrayList namespaceIamRoleAuthorizationEntities = new ArrayList();
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        try {
            this.namespaceIamRoleAuthorizationHelper.checkPermissions(expectedNamespaceEntity, requestedIamRoleNames);
            Assert.fail();
        }
        catch (AccessDeniedException e) {
            Assert.assertEquals((Object)"The namespace \"namespace\" does not have access to the following IAM roles: [iamRoleName1, iamRoleName2]", (Object)e.getMessage());
        }
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getBooleanProperty(ConfigurationValue.NAMESPACE_IAM_ROLE_AUTHORIZATION_ENABLED);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void checkPermissionsAssertBlankRequestRoleIgnored() {
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        String iamRoleName1 = "      \t\t ";
        String iamRoleName2 = "iamRoleName2";
        List<String> requestedIamRoleNames = Arrays.asList(iamRoleName1, iamRoleName2);
        ArrayList<NamespaceIamRoleAuthorizationEntity> namespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setIamRoleName("iamRoleName1");
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity2 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity2.setIamRoleName(iamRoleName2);
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity2);
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        this.namespaceIamRoleAuthorizationHelper.checkPermissions(expectedNamespaceEntity, requestedIamRoleNames);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getBooleanProperty(ConfigurationValue.NAMESPACE_IAM_ROLE_AUTHORIZATION_ENABLED);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void checkPermissionsAssertDoNothingWhenAuthorizationDisabled() {
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        ArrayList requestedIamRoleNames = new ArrayList();
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)false);
        this.namespaceIamRoleAuthorizationHelper.checkPermissions(expectedNamespaceEntity, requestedIamRoleNames);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getBooleanProperty(ConfigurationValue.NAMESPACE_IAM_ROLE_AUTHORIZATION_ENABLED);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void checkPermissionsWithArrayAssertNoErrorWhenNamespaceAuthorizedToAllRoles() {
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        String iamRoleName1 = "iamRoleName1";
        String iamRoleName2 = "iamRoleName2";
        ArrayList<NamespaceIamRoleAuthorizationEntity> namespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setIamRoleName(iamRoleName1);
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity2 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity2.setIamRoleName(iamRoleName2);
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity2);
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        this.namespaceIamRoleAuthorizationHelper.checkPermissions(expectedNamespaceEntity, new String[]{iamRoleName1, iamRoleName2});
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getBooleanProperty(ConfigurationValue.NAMESPACE_IAM_ROLE_AUTHORIZATION_ENABLED);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void checkPermissionsAssertRoleNameIsTrimmed() {
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        String iamRoleName1 = "iamRoleName1";
        String iamRoleName2 = "iamRoleName2";
        List<String> requestedIamRoleNames = Arrays.asList(StringUtils.wrap((String)iamRoleName1, (String)"      \t\t "), StringUtils.wrap((String)iamRoleName2, (String)"      \t\t "));
        ArrayList<NamespaceIamRoleAuthorizationEntity> namespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setIamRoleName(iamRoleName1);
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity2 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity2.setIamRoleName(iamRoleName2);
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity2);
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        this.namespaceIamRoleAuthorizationHelper.checkPermissions(expectedNamespaceEntity, requestedIamRoleNames);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getBooleanProperty(ConfigurationValue.NAMESPACE_IAM_ROLE_AUTHORIZATION_ENABLED);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationHelper, this.namespaceIamRoleAuthorizationDao});
    }

    @Test
    public void checkPermissionsAssertRoleNameIsCaseInsensitive() {
        NamespaceEntity expectedNamespaceEntity = new NamespaceEntity();
        String iamRoleName1 = "iamRoleName1";
        String iamRoleName2 = "iamRoleName2";
        List<String> requestedIamRoleNames = Arrays.asList(StringUtils.capitalize((String)iamRoleName1), StringUtils.capitalize((String)iamRoleName2));
        ArrayList<NamespaceIamRoleAuthorizationEntity> namespaceIamRoleAuthorizationEntities = new ArrayList<NamespaceIamRoleAuthorizationEntity>();
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity1 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity1.setIamRoleName(iamRoleName1);
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity1);
        NamespaceIamRoleAuthorizationEntity namespaceIamRoleAuthorizationEntity2 = new NamespaceIamRoleAuthorizationEntity();
        namespaceIamRoleAuthorizationEntity2.setIamRoleName(iamRoleName2);
        namespaceIamRoleAuthorizationEntities.add(namespaceIamRoleAuthorizationEntity2);
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceIamRoleAuthorizationDao.getNamespaceIamRoleAuthorizations((NamespaceEntity)Matchers.any())).thenReturn(namespaceIamRoleAuthorizationEntities);
        this.namespaceIamRoleAuthorizationHelper.checkPermissions(expectedNamespaceEntity, requestedIamRoleNames);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getBooleanProperty(ConfigurationValue.NAMESPACE_IAM_ROLE_AUTHORIZATION_ENABLED);
        ((NamespaceIamRoleAuthorizationDao)Mockito.verify((Object)this.namespaceIamRoleAuthorizationDao)).getNamespaceIamRoleAuthorizations(expectedNamespaceEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationHelper, this.namespaceIamRoleAuthorizationDao});
    }
}

