/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.finra.herd.model.api.xml.NamespaceAuthorization;
import org.finra.herd.model.api.xml.NamespacePermissionEnum;
import org.finra.herd.model.dto.ApplicationUser;
import org.finra.herd.model.dto.SecurityUserWrapper;
import org.finra.herd.service.helper.NamespaceSecurityHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class NamespaceSecurityHelperTest {
    private NamespaceSecurityHelper namespaceSecurityHelper;

    @Before
    public void before() {
        this.namespaceSecurityHelper = new NamespaceSecurityHelper();
    }

    @After
    public void after() {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void getAuthorizedNamespacesWhenUserHasPermissionAssertReturnNamespace() {
        ApplicationUser applicationUser = new ApplicationUser(this.getClass());
        applicationUser.setNamespaceAuthorizations(new HashSet<NamespaceAuthorization>(Arrays.asList(new NamespaceAuthorization("namespace", Arrays.asList(NamespacePermissionEnum.READ)))));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper("username", "", true, true, true, true, Collections.emptyList(), applicationUser), null));
        Set authorizedNamespaces = this.namespaceSecurityHelper.getAuthorizedNamespaces(new NamespacePermissionEnum[]{NamespacePermissionEnum.READ});
        Assert.assertEquals((long)1L, (long)authorizedNamespaces.size());
        Assert.assertTrue((boolean)authorizedNamespaces.contains("namespace"));
    }

    @Test
    public void getAuthorizedNamespacesWhenUserHasNoPermissionAssertReturnEmpty() {
        ApplicationUser applicationUser = new ApplicationUser(this.getClass());
        applicationUser.setNamespaceAuthorizations(new HashSet<NamespaceAuthorization>(Arrays.asList(new NamespaceAuthorization("namespace", Arrays.asList(NamespacePermissionEnum.WRITE)))));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper("username", "", true, true, true, true, Collections.emptyList(), applicationUser), null));
        Set authorizedNamespaces = this.namespaceSecurityHelper.getAuthorizedNamespaces(new NamespacePermissionEnum[]{NamespacePermissionEnum.READ});
        Assert.assertEquals((long)0L, (long)authorizedNamespaces.size());
    }

    @Test
    public void getAuthorizedNamespacesWhenNoApplicationUserInContextReturnEmpty() {
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)new SecurityUserWrapper("username", "", true, true, true, true, Collections.emptyList(), null), null));
        Set authorizedNamespaces = this.namespaceSecurityHelper.getAuthorizedNamespaces(new NamespacePermissionEnum[]{NamespacePermissionEnum.READ});
        Assert.assertEquals((long)0L, (long)authorizedNamespaces.size());
    }

    @Test
    public void getAuthorizedNamespacesWhenNoAuthenticationInContextReturnEmpty() {
        SecurityContextHolder.clearContext();
        Set authorizedNamespaces = this.namespaceSecurityHelper.getAuthorizedNamespaces(new NamespacePermissionEnum[]{NamespacePermissionEnum.READ});
        Assert.assertEquals((long)0L, (long)authorizedNamespaces.size());
    }
}

