/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.NotificationMessage;
import org.finra.herd.model.dto.SearchIndexUpdateDto;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.MessageTypeEntity;
import org.finra.herd.model.jpa.TagEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.NotificationMessagePublishingService;
import org.finra.herd.service.helper.SearchIndexUpdateHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SearchIndexUpdateHelperTest
extends AbstractServiceTest {
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private NotificationMessagePublishingService notificationMessagePublishingService;
    @InjectMocks
    private SearchIndexUpdateHelper searchIndexUpdateHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testModifyBusinessObjectDefinitionInSearchIndex() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setId(Integer.valueOf(1));
        ArrayList<Integer> businessObjectDefinitionIds = new ArrayList<Integer>();
        businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)MESSAGE_TEXT);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"AWS_SQS_QUEUE_NAME");
        this.searchIndexUpdateHelper.modifyBusinessObjectDefinitionInSearchIndex(businessObjectDefinitionEntity, "UPDATE");
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME);
        ((NotificationMessagePublishingService)Mockito.verify((Object)this.notificationMessagePublishingService)).addNotificationMessageToDatabaseQueue(new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "AWS_SQS_QUEUE_NAME", MESSAGE_TEXT, NO_MESSAGE_HEADERS));
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyBusinessObjectDefinitionInSearchIndexBlankMessage() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setId(Integer.valueOf(1));
        ArrayList<Integer> businessObjectDefinitionIds = new ArrayList<Integer>();
        businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)"");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"AWS_SQS_QUEUE_NAME");
        this.searchIndexUpdateHelper.modifyBusinessObjectDefinitionInSearchIndex(businessObjectDefinitionEntity, "UPDATE");
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyBusinessObjectDefinitionInSearchIndexNoSqsQueueName() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setId(Integer.valueOf(1));
        ArrayList<Integer> businessObjectDefinitionIds = new ArrayList<Integer>();
        businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)MESSAGE_TEXT);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"      \t\t ");
        try {
            this.searchIndexUpdateHelper.modifyBusinessObjectDefinitionInSearchIndex(businessObjectDefinitionEntity, "UPDATE");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            MatcherAssert.assertThat((String)"Function is null.", (Object)illegalStateException.getMessage(), (Matcher)CoreMatchers.is((Object)"SQS queue name not found. Ensure the \"search.index.update.sqs.queue.name\" configuration entry is configured."));
        }
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyBusinessObjectDefinitionsInSearchIndex() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setId(Integer.valueOf(1));
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(businessObjectDefinitionEntity);
        ArrayList<Integer> businessObjectDefinitionIds = new ArrayList<Integer>();
        businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)MESSAGE_TEXT);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"AWS_SQS_QUEUE_NAME");
        this.searchIndexUpdateHelper.modifyBusinessObjectDefinitionsInSearchIndex(businessObjectDefinitionEntityList, "UPDATE");
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME);
        ((NotificationMessagePublishingService)Mockito.verify((Object)this.notificationMessagePublishingService)).addNotificationMessageToDatabaseQueue(new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "AWS_SQS_QUEUE_NAME", MESSAGE_TEXT, NO_MESSAGE_HEADERS));
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyBusinessObjectDefinitionsInSearchIndexBlankMessage() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setId(Integer.valueOf(1));
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(businessObjectDefinitionEntity);
        ArrayList<Integer> businessObjectDefinitionIds = new ArrayList<Integer>();
        businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)"");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"AWS_SQS_QUEUE_NAME");
        this.searchIndexUpdateHelper.modifyBusinessObjectDefinitionsInSearchIndex(businessObjectDefinitionEntityList, "UPDATE");
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyBusinessObjectDefinitionsInSearchIndexNoSqsQueueName() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setId(Integer.valueOf(1));
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(businessObjectDefinitionEntity);
        ArrayList<Integer> businessObjectDefinitionIds = new ArrayList<Integer>();
        businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)MESSAGE_TEXT);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"");
        try {
            this.searchIndexUpdateHelper.modifyBusinessObjectDefinitionsInSearchIndex(businessObjectDefinitionEntityList, "UPDATE");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            MatcherAssert.assertThat((String)"Function is null.", (Object)illegalStateException.getMessage(), (Matcher)CoreMatchers.is((Object)"SQS queue name not found. Ensure the \"search.index.update.sqs.queue.name\" configuration entry is configured."));
        }
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyTagInSearchIndex() {
        TagEntity tagEntity = new TagEntity();
        tagEntity.setId(Integer.valueOf(1));
        ArrayList<Integer> tagIds = new ArrayList<Integer>();
        tagIds.add(tagEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)MESSAGE_TEXT);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"AWS_SQS_QUEUE_NAME");
        this.searchIndexUpdateHelper.modifyTagInSearchIndex(tagEntity, "UPDATE");
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME);
        ((NotificationMessagePublishingService)Mockito.verify((Object)this.notificationMessagePublishingService)).addNotificationMessageToDatabaseQueue(new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "AWS_SQS_QUEUE_NAME", MESSAGE_TEXT, NO_MESSAGE_HEADERS));
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyTagInSearchIndexBlankMessage() {
        TagEntity tagEntity = new TagEntity();
        tagEntity.setId(Integer.valueOf(1));
        ArrayList<Integer> tagIds = new ArrayList<Integer>();
        tagIds.add(tagEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)"");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"AWS_SQS_QUEUE_NAME");
        this.searchIndexUpdateHelper.modifyTagInSearchIndex(tagEntity, "UPDATE");
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyTagInSearchIndexEmptyQueueName() {
        TagEntity tagEntity = new TagEntity();
        tagEntity.setId(Integer.valueOf(1));
        ArrayList<Integer> tagIds = new ArrayList<Integer>();
        tagIds.add(tagEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)MESSAGE_TEXT);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"");
        try {
            this.searchIndexUpdateHelper.modifyTagInSearchIndex(tagEntity, "UPDATE");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            MatcherAssert.assertThat((String)"Function is null.", (Object)illegalStateException.getMessage(), (Matcher)CoreMatchers.is((Object)"SQS queue name not found. Ensure the \"search.index.update.sqs.queue.name\" configuration entry is configured."));
        }
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyTagInSearchIndexSearchIndexUpdateJmsListenerDisabled() {
        TagEntity tagEntity = new TagEntity();
        tagEntity.setId(Integer.valueOf(1));
        ArrayList<Integer> tagIds = new ArrayList<Integer>();
        tagIds.add(tagEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)MESSAGE_TEXT);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"false");
        this.searchIndexUpdateHelper.modifyTagInSearchIndex(tagEntity, "UPDATE");
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyTagsInSearchIndex() {
        TagEntity tagEntity = new TagEntity();
        tagEntity.setId(Integer.valueOf(1));
        ArrayList<TagEntity> tagEntityList = new ArrayList<TagEntity>();
        tagEntityList.add(tagEntity);
        ArrayList<Integer> tagIds = new ArrayList<Integer>();
        tagIds.add(tagEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)MESSAGE_TEXT);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"AWS_SQS_QUEUE_NAME");
        this.searchIndexUpdateHelper.modifyTagsInSearchIndex(tagEntityList, "UPDATE");
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME);
        ((NotificationMessagePublishingService)Mockito.verify((Object)this.notificationMessagePublishingService)).addNotificationMessageToDatabaseQueue(new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "AWS_SQS_QUEUE_NAME", MESSAGE_TEXT, NO_MESSAGE_HEADERS));
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyTagsInSearchIndexBlankMessage() {
        TagEntity tagEntity = new TagEntity();
        tagEntity.setId(Integer.valueOf(1));
        ArrayList<TagEntity> tagEntityList = new ArrayList<TagEntity>();
        tagEntityList.add(tagEntity);
        ArrayList<Integer> tagIds = new ArrayList<Integer>();
        tagIds.add(tagEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)"");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"AWS_SQS_QUEUE_NAME");
        this.searchIndexUpdateHelper.modifyTagsInSearchIndex(tagEntityList, "UPDATE");
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testModifyTagsInSearchIndexNoSqsQueueName() {
        TagEntity tagEntity = new TagEntity();
        tagEntity.setId(Integer.valueOf(1));
        ArrayList<TagEntity> tagEntityList = new ArrayList<TagEntity>();
        tagEntityList.add(tagEntity);
        ArrayList<Integer> tagIds = new ArrayList<Integer>();
        tagIds.add(tagEntity.getId());
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "UPDATE");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)searchIndexUpdateDto)).thenReturn((Object)MESSAGE_TEXT);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME)).thenReturn((Object)"");
        try {
            this.searchIndexUpdateHelper.modifyTagsInSearchIndex(tagEntityList, "UPDATE");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            MatcherAssert.assertThat((String)"Function is null.", (Object)illegalStateException.getMessage(), (Matcher)CoreMatchers.is((Object)"SQS queue name not found. Ensure the \"search.index.update.sqs.queue.name\" configuration entry is configured."));
        }
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_SQS_QUEUE_NAME);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.configurationHelper, this.jsonHelper, this.notificationMessagePublishingService});
    }
}

