/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import org.finra.herd.core.ApplicationContextHolder;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.SearchIndexUpdateDto;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDefinitionService;
import org.finra.herd.service.TagService;
import org.finra.herd.service.helper.SearchIndexUpdateJmsMessageListener;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.test.util.ReflectionTestUtils;

public class SearchIndexUpdateJmsMessageListenerTest
extends AbstractServiceTest {
    @InjectMocks
    private SearchIndexUpdateJmsMessageListener searchIndexUpdateJmsMessageListener;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private BusinessObjectDefinitionService businessObjectDefinitionService;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private TagService tagService;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testProcessMessageBusinessObjectDefinition() throws Exception {
        ArrayList ids = new ArrayList();
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", ids, "UPDATE");
        Mockito.when((Object)this.jsonHelper.unmarshallJsonToObject(SearchIndexUpdateDto.class, "PAYLOAD")).thenReturn((Object)searchIndexUpdateDto);
        this.searchIndexUpdateJmsMessageListener.processMessage("PAYLOAD", null);
        ((BusinessObjectDefinitionService)Mockito.verify((Object)this.businessObjectDefinitionService, (VerificationMode)Mockito.times((int)1))).updateSearchIndexDocumentBusinessObjectDefinition((SearchIndexUpdateDto)Matchers.any(SearchIndexUpdateDto.class));
    }

    @Test
    public void testProcessMessageTag() throws Exception {
        ArrayList ids = new ArrayList();
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", ids, "UPDATE");
        Mockito.when((Object)this.jsonHelper.unmarshallJsonToObject(SearchIndexUpdateDto.class, "PAYLOAD")).thenReturn((Object)searchIndexUpdateDto);
        this.searchIndexUpdateJmsMessageListener.processMessage("PAYLOAD", null);
        ((TagService)Mockito.verify((Object)this.tagService, (VerificationMode)Mockito.times((int)1))).updateSearchIndexDocumentTag((SearchIndexUpdateDto)Matchers.any(SearchIndexUpdateDto.class));
    }

    @Test
    public void testProcessMessageOriginalMessageFormat() throws Exception {
        ArrayList ids = new ArrayList();
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto();
        searchIndexUpdateDto.setBusinessObjectDefinitionIds(ids);
        searchIndexUpdateDto.setModificationType("UPDATE");
        Mockito.when((Object)this.jsonHelper.unmarshallJsonToObject(SearchIndexUpdateDto.class, "PAYLOAD")).thenReturn((Object)searchIndexUpdateDto);
        this.searchIndexUpdateJmsMessageListener.processMessage("PAYLOAD", null);
        ((BusinessObjectDefinitionService)Mockito.verify((Object)this.businessObjectDefinitionService, (VerificationMode)Mockito.times((int)1))).updateSearchIndexDocumentBusinessObjectDefinition((SearchIndexUpdateDto)Matchers.any(SearchIndexUpdateDto.class));
    }

    @Test
    public void testControlListener() {
        ReflectionTestUtils.setField((Object)this.searchIndexUpdateJmsMessageListener, (String)"configurationHelper", (Object)this.configurationHelper);
        MessageListenerContainer mockMessageListenerContainer = (MessageListenerContainer)Mockito.mock(MessageListenerContainer.class);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"false");
        JmsListenerEndpointRegistry registry = (JmsListenerEndpointRegistry)ApplicationContextHolder.getApplicationContext().getBean("org.springframework.jms.config.internalJmsListenerEndpointRegistry", JmsListenerEndpointRegistry.class);
        Mockito.when((Object)registry.getListenerContainer("search_index_update_queue")).thenReturn((Object)mockMessageListenerContainer);
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)false);
        this.searchIndexUpdateJmsMessageListener.controlSearchIndexUpdateJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)0))).stop();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)0))).start();
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)true);
        this.searchIndexUpdateJmsMessageListener.controlSearchIndexUpdateJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)1))).stop();
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SEARCH_INDEX_UPDATE_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)true);
        this.searchIndexUpdateJmsMessageListener.controlSearchIndexUpdateJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)0))).start();
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)false);
        this.searchIndexUpdateJmsMessageListener.controlSearchIndexUpdateJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Configuration
    static class ContextConfiguration {
        ContextConfiguration() {
        }

        @Bean(name={"org.springframework.jms.config.internalJmsListenerEndpointRegistry"})
        JmsListenerEndpointRegistry registry() {
            try {
                Class.forName("org.mockito.Mockito");
            }
            catch (ClassNotFoundException ignored) {
                return null;
            }
            return (JmsListenerEndpointRegistry)Mockito.mock(JmsListenerEndpointRegistry.class);
        }
    }
}

