/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.Storage;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.util.CollectionUtils;

public class StorageFileHelperTest
extends AbstractServiceTest {
    protected static final Path LOCAL_TEMP_PATH = Paths.get(System.getProperty("java.io.tmpdir"), "herd-helper-test", RANDOM_SUFFIX);

    @Before
    public void setupEnv() {
        LOCAL_TEMP_PATH.toFile().mkdirs();
    }

    @After
    public void cleanEnv() throws IOException {
        FileUtils.deleteDirectory((File)LOCAL_TEMP_PATH.toFile());
    }

    @Test
    public void testValidateCopiedS3Files() throws IOException {
        ArrayList<StorageFile> testExpectedFiles = new ArrayList<StorageFile>();
        ArrayList<S3ObjectSummary> testActualFiles = new ArrayList<S3ObjectSummary>();
        for (String file : LOCAL_FILES) {
            String filePath = String.format(String.format("%s/%s", TEST_S3_KEY_PREFIX, file), new Object[0]);
            testExpectedFiles.add(new StorageFile(filePath, FILE_SIZE, ROW_COUNT));
            testActualFiles.add(this.createS3ObjectSummary(filePath, FILE_SIZE));
        }
        this.storageFileHelper.validateCopiedS3Files(testExpectedFiles, testActualFiles, STORAGE_NAME, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
    }

    @Test
    public void testValidateCopiedS3FilesActualFileNoExists() throws IOException {
        List<StorageFile> testExpectedFiles = Arrays.asList(new StorageFile(TARGET_S3_KEY, FILE_SIZE, Long.valueOf(1000L)));
        ArrayList testActualFiles = new ArrayList();
        try {
            this.storageFileHelper.validateCopiedS3Files(testExpectedFiles, testActualFiles, STORAGE_NAME, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when the copied S3 file does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Copied file \"%s\" does not exist in \"%s\" storage.", TARGET_S3_KEY, STORAGE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateCopiedS3FilesActualFileSizeMismatch() throws IOException {
        List<StorageFile> testExpectedFiles = Arrays.asList(new StorageFile(TARGET_S3_KEY, FILE_SIZE, NO_ROW_COUNT));
        List<S3ObjectSummary> testActualFiles = Arrays.asList(this.createS3ObjectSummary(TARGET_S3_KEY, FILE_SIZE_2));
        try {
            this.storageFileHelper.validateCopiedS3Files(testExpectedFiles, testActualFiles, STORAGE_NAME, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalStateException when expected file size does not match actual file size.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Specified file size of %d bytes for copied \"%s\" S3 file in \"%s\" storage does not match file size of %d bytes reported by S3.", FILE_SIZE, TARGET_S3_KEY, STORAGE_NAME, FILE_SIZE_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateCopiedS3FilesUnexpectedS3FileFound() throws IOException {
        ArrayList testExpectedFiles = new ArrayList();
        List<S3ObjectSummary> testActualFiles = Arrays.asList(this.createS3ObjectSummary(TARGET_S3_KEY, 1024L));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        try {
            this.storageFileHelper.validateCopiedS3Files(testExpectedFiles, testActualFiles, STORAGE_NAME, businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalStateException when S3 contains unexpected S3 file.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Found unexpected S3 file \"%s\" in \"%s\" storage while validating copied S3 files. Business object data {%s}", TARGET_S3_KEY, STORAGE_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateRegisteredS3Files() throws IOException {
        ArrayList<StorageFile> testExpectedFiles = new ArrayList<StorageFile>();
        ArrayList<S3ObjectSummary> testActualFiles = new ArrayList<S3ObjectSummary>();
        for (String file : LOCAL_FILES) {
            String filePath = String.format(String.format("%s/%s", TEST_S3_KEY_PREFIX, file), new Object[0]);
            testExpectedFiles.add(new StorageFile(filePath, FILE_SIZE, ROW_COUNT));
            testActualFiles.add(this.createS3ObjectSummary(filePath, FILE_SIZE));
        }
        this.storageFileHelper.validateRegisteredS3Files(testExpectedFiles, testActualFiles, STORAGE_NAME, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
    }

    @Test
    public void testValidateRegisteredS3FilesActualFileNoExists() throws IOException {
        List<StorageFile> testExpectedFiles = Arrays.asList(new StorageFile(TARGET_S3_KEY, FILE_SIZE, Long.valueOf(1000L)));
        ArrayList testActualFiles = new ArrayList();
        try {
            this.storageFileHelper.validateRegisteredS3Files(testExpectedFiles, testActualFiles, STORAGE_NAME, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when the registered S3 file does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Registered file \"%s\" does not exist in \"%s\" storage.", TARGET_S3_KEY, STORAGE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateRegisteredS3FilesActualFileSizeMismatch() throws IOException {
        List<StorageFile> testExpectedFiles = Arrays.asList(new StorageFile(TARGET_S3_KEY, FILE_SIZE, NO_ROW_COUNT));
        List<S3ObjectSummary> testActualFiles = Arrays.asList(this.createS3ObjectSummary(TARGET_S3_KEY, FILE_SIZE_2));
        try {
            this.storageFileHelper.validateRegisteredS3Files(testExpectedFiles, testActualFiles, STORAGE_NAME, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalStateException when expected file size does not match actual file size.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Specified file size of %d bytes for registered \"%s\" S3 file in \"%s\" storage does not match file size of %d bytes reported by S3.", FILE_SIZE, TARGET_S3_KEY, STORAGE_NAME, FILE_SIZE_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateRegisteredS3FilesUnexpectedS3FileFound() throws IOException {
        ArrayList testExpectedFiles = new ArrayList();
        List<S3ObjectSummary> testActualFiles = Arrays.asList(this.createS3ObjectSummary(TARGET_S3_KEY, 1024L));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        try {
            this.storageFileHelper.validateRegisteredS3Files(testExpectedFiles, testActualFiles, STORAGE_NAME, businessObjectDataKey);
            Assert.fail((String)"Should throw an IllegalStateException when S3 contains unexpected S3 file.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Found unexpected S3 file \"%s\" in \"%s\" storage while validating registered S3 files. Business object data {%s}", TARGET_S3_KEY, STORAGE_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(businessObjectDataKey)), (Object)e.getMessage());
        }
    }

    private S3ObjectSummary createS3ObjectSummary(String filePath, long fileSizeInBytes) {
        S3ObjectSummary s3ObjectSummary = new S3ObjectSummary();
        s3ObjectSummary.setKey(filePath);
        s3ObjectSummary.setSize(fileSizeInBytes);
        return s3ObjectSummary;
    }

    @Test
    public void testValidateStorageUnitS3Files() throws IOException {
        StorageUnit storageUnit = this.createStorageUnit(TEST_S3_KEY_PREFIX, LOCAL_FILES, 1024L);
        ArrayList<String> actualS3Files = new ArrayList<String>();
        for (String file : LOCAL_FILES) {
            actualS3Files.add(String.format("%s/%s", TEST_S3_KEY_PREFIX, file));
        }
        this.storageFileHelper.validateStorageUnitS3Files(storageUnit, actualS3Files, TEST_S3_KEY_PREFIX);
    }

    @Test
    public void testValidateStorageUnitS3FilesS3KeyPrefixMismatch() throws IOException {
        StorageUnit storageUnit = this.createStorageUnit("SOME_S3_KEY_PREFIX", LOCAL_FILES, 1024L);
        try {
            this.storageFileHelper.validateStorageUnitS3Files(storageUnit, new ArrayList(), TEST_S3_KEY_PREFIX);
            Assert.fail((String)"Should throw a RuntimeException when registered S3 file does match S3 key prefix.");
        }
        catch (RuntimeException e) {
            String expectedErrMsg = String.format("Storage file S3 key prefix \"%s\" does not match the expected S3 key prefix \"%s\".", ((StorageFile)storageUnit.getStorageFiles().get(0)).getFilePath(), TEST_S3_KEY_PREFIX);
            Assert.assertEquals((Object)expectedErrMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateStorageUnitS3FilesRegisteredFileNoExists() throws IOException {
        StorageUnit storageUnit = this.createStorageUnit(TEST_S3_KEY_PREFIX, LOCAL_FILES, 1024L);
        ArrayList actualS3Files = new ArrayList();
        try {
            this.storageFileHelper.validateStorageUnitS3Files(storageUnit, actualS3Files, TEST_S3_KEY_PREFIX);
            Assert.fail((String)"Should throw a RuntimeException when actual S3 files do not exist.");
        }
        catch (RuntimeException e) {
            String expectedErrMsg = String.format("Registered file \"%s\" does not exist in \"%s\" storage.", ((StorageFile)storageUnit.getStorageFiles().get(0)).getFilePath(), storageUnit.getStorage().getName());
            Assert.assertEquals((Object)expectedErrMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateStorageUnitS3FilesNotRegisteredS3FileFound() throws IOException {
        StorageUnit storageUnit = this.createStorageUnit(TEST_S3_KEY_PREFIX, new ArrayList<String>(), 1024L);
        List<String> actualS3Files = Arrays.asList(String.format("%s/%s", TEST_S3_KEY_PREFIX, LOCAL_FILES.get(0)));
        try {
            this.storageFileHelper.validateStorageUnitS3Files(storageUnit, actualS3Files, TEST_S3_KEY_PREFIX);
            Assert.fail((String)"Should throw a RuntimeException when S3 contains unregistered S3 file.");
        }
        catch (RuntimeException e) {
            String expectedErrMsg = String.format("Found S3 file \"%s\" in \"%s\" storage not registered with this business object data.", actualS3Files.get(0), storageUnit.getStorage().getName());
            Assert.assertEquals((Object)expectedErrMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateDownloadedS3Files() throws IOException {
        File targetLocalDirectory = Paths.get(LOCAL_TEMP_PATH.toString(), TEST_S3_KEY_PREFIX).toFile();
        this.createLocalFiles(targetLocalDirectory.getPath(), 1024L);
        StorageUnit storageUnit = this.createStorageUnit(TEST_S3_KEY_PREFIX, LOCAL_FILES, 1024L);
        this.storageFileHelper.validateDownloadedS3Files(LOCAL_TEMP_PATH.toString(), TEST_S3_KEY_PREFIX, storageUnit);
    }

    @Test
    public void testValidateDownloadedS3FilesZeroFiles() throws IOException {
        File targetLocalDirectory = Paths.get(LOCAL_TEMP_PATH.toString(), TEST_S3_KEY_PREFIX).toFile();
        Assert.assertTrue((boolean)targetLocalDirectory.mkdirs());
        StorageUnit storageUnit = this.createStorageUnit(TEST_S3_KEY_PREFIX, null, null);
        this.storageFileHelper.validateDownloadedS3Files(LOCAL_TEMP_PATH.toString(), TEST_S3_KEY_PREFIX, storageUnit);
    }

    @Test
    public void testValidateDownloadedS3FilesFileCountMismatch() throws IOException {
        File targetLocalDirectory = Paths.get(LOCAL_TEMP_PATH.toString(), TEST_S3_KEY_PREFIX).toFile();
        this.createLocalFiles(targetLocalDirectory.getPath(), 1024L);
        StorageFileHelperTest.createLocalFile((String)targetLocalDirectory.getPath(), (String)"EXTRA_FILE", (long)1024L);
        StorageUnit storageUnit = this.createStorageUnit(TEST_S3_KEY_PREFIX, LOCAL_FILES, 1024L);
        try {
            this.storageFileHelper.validateDownloadedS3Files(LOCAL_TEMP_PATH.toString(), TEST_S3_KEY_PREFIX, storageUnit);
            Assert.fail((String)"Should throw a RuntimeException when number of local files does not match to the storage unit information.");
        }
        catch (RuntimeException e) {
            String expectedErrMsg = String.format("Number of downloaded files does not match the storage unit information (expected %d files, actual %d files).", storageUnit.getStorageFiles().size(), LOCAL_FILES.size() + 1);
            Assert.assertEquals((Object)expectedErrMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateDownloadedS3FilesFileNoExists() throws IOException {
        File targetLocalDirectory = Paths.get(LOCAL_TEMP_PATH.toString(), TEST_S3_KEY_PREFIX).toFile();
        StorageFileHelperTest.createLocalFile((String)targetLocalDirectory.getPath(), (String)"ACTUAL_FILE", (long)1024L);
        StorageUnit storageUnit = this.createStorageUnit(TEST_S3_KEY_PREFIX, Arrays.asList("EXPECTED_FILE"), 1024L);
        try {
            this.storageFileHelper.validateDownloadedS3Files(LOCAL_TEMP_PATH.toString(), TEST_S3_KEY_PREFIX, storageUnit);
            Assert.fail((String)"Should throw a RuntimeException when actual local files do not exist.");
        }
        catch (RuntimeException e) {
            String expectedErrMsg = String.format("Downloaded \"%s\" file doesn't exist.", Paths.get(LOCAL_TEMP_PATH.toString(), ((StorageFile)storageUnit.getStorageFiles().get(0)).getFilePath()).toFile().getPath());
            Assert.assertEquals((Object)expectedErrMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateDownloadedS3FilesFileSizeMismatch() throws IOException {
        File targetLocalDirectory = Paths.get(LOCAL_TEMP_PATH.toString(), TEST_S3_KEY_PREFIX).toFile();
        this.createLocalFiles(targetLocalDirectory.getPath(), 1024L);
        StorageUnit storageUnit = this.createStorageUnit(TEST_S3_KEY_PREFIX, LOCAL_FILES, 2048L);
        try {
            this.storageFileHelper.validateDownloadedS3Files(LOCAL_TEMP_PATH.toString(), TEST_S3_KEY_PREFIX, storageUnit);
            Assert.fail((String)"Should throw a RuntimeException when actual file sizes do not not match to the storage unit information.");
        }
        catch (RuntimeException e) {
            String expectedErrMsg = String.format("Size of the downloaded \"%s\" S3 file does not match the expected value (expected %d bytes, actual %d bytes).", Paths.get(LOCAL_TEMP_PATH.toString(), ((StorageFile)storageUnit.getStorageFiles().get(0)).getFilePath()).toFile().getPath(), 2048L, 1024L);
            Assert.assertEquals((Object)expectedErrMsg, (Object)e.getMessage());
        }
    }

    private void createLocalFiles(String baseDirectory, long size) throws IOException {
        for (String file : LOCAL_FILES) {
            StorageFileHelperTest.createLocalFile((String)baseDirectory, (String)file, (long)size);
        }
    }

    private StorageUnit createStorageUnit(String s3KeyPrefix, List<String> files, Long fileSizeBytes) {
        StorageUnit storageUnit = new StorageUnit();
        Storage storage = new Storage();
        storageUnit.setStorage(storage);
        storage.setName("TEST_STORAGE");
        ArrayList<StorageFile> storageFiles = new ArrayList<StorageFile>();
        storageUnit.setStorageFiles(storageFiles);
        if (!CollectionUtils.isEmpty(files)) {
            for (String file : files) {
                StorageFile storageFile = new StorageFile();
                storageFiles.add(storageFile);
                storageFile.setFilePath(String.format("%s/%s", s3KeyPrefix, file));
                storageFile.setFileSizeBytes(fileSizeBytes);
            }
        }
        storageUnit.setStorageUnitStatus("ENABLED");
        return storageUnit;
    }
}

