/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.finra.herd.core.ApplicationContextHolder;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StoragePolicyKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.dto.StoragePolicySelection;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.StorageFileHelper;
import org.finra.herd.service.helper.StoragePolicyProcessorJmsMessageListener;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.test.util.ReflectionTestUtils;

public class StoragePolicyProcessorJmsMessageListenerTest
extends AbstractServiceTest {
    @Autowired
    private StorageFileHelper storageFileHelper;
    @Autowired
    StoragePolicyProcessorJmsMessageListener storagePolicyProcessorJmsMessageListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessMessage() throws Exception {
        String s3KeyPrefix = StoragePolicyProcessorJmsMessageListenerTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
        S3FileTransferRequestParamsDto sourceS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().withS3BucketName(S3_BUCKET_NAME).withS3KeyPrefix(s3KeyPrefix + "/").build();
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList("GLACIER"));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        for (String filePath : LOCAL_FILES) {
            this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, s3KeyPrefix + "/" + filePath, Long.valueOf(1024L), Long.valueOf(1000L));
        }
        List sourceStorageFiles = this.storageFileHelper.createStorageFilesFromEntities(sourceStorageUnitEntity.getStorageFiles());
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_ARN.getKey(), S3_OBJECT_TAGGER_ROLE_ARN);
        overrideMap.put(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_SESSION_NAME.getKey(), S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            for (StorageFile storageFile : sourceStorageFiles) {
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFile.getFilePath(), (InputStream)new ByteArrayInputStream(new byte[storageFile.getFileSizeBytes().intValue()]), null), null);
            }
            this.storagePolicyProcessorJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION)), null);
            Assert.assertEquals((Object)"ARCHIVED", (Object)sourceStorageUnitEntity.getStatus().getCode());
        }
        finally {
            if (!this.s3Dao.listDirectory(sourceS3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(sourceS3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
            this.restorePropertySourceInEnvironment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessMessageStorageUnitAlreadyArchived() throws Exception {
        String s3KeyPrefix = StoragePolicyProcessorJmsMessageListenerTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList("GLACIER"));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ARCHIVED", NO_STORAGE_DIRECTORY_PATH);
        for (String filePath : LOCAL_FILES) {
            this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, s3KeyPrefix + "/" + filePath, Long.valueOf(1024L), Long.valueOf(1000L));
        }
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_ARN.getKey(), S3_OBJECT_TAGGER_ROLE_ARN);
        overrideMap.put(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_SESSION_NAME.getKey(), S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.executeWithoutLogging(StoragePolicyProcessorJmsMessageListener.class, () -> this.storagePolicyProcessorJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION)), null));
            Assert.assertEquals((Object)"ARCHIVED", (Object)sourceStorageUnitEntity.getStatus().getCode());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testProcessMessageBusinessObjectDataNoExists() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.executeWithoutLogging(StoragePolicyProcessorJmsMessageListener.class, () -> this.storagePolicyProcessorJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION)), null));
    }

    @Test
    public void testControlListener() {
        this.configurationHelper = (ConfigurationHelper)Mockito.mock(ConfigurationHelper.class);
        ReflectionTestUtils.setField((Object)this.storagePolicyProcessorJmsMessageListener, (String)"configurationHelper", (Object)this.configurationHelper);
        MessageListenerContainer mockMessageListenerContainer = (MessageListenerContainer)Mockito.mock(MessageListenerContainer.class);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.STORAGE_POLICY_PROCESSOR_JMS_LISTENER_ENABLED)).thenReturn((Object)"false");
        JmsListenerEndpointRegistry registry = (JmsListenerEndpointRegistry)ApplicationContextHolder.getApplicationContext().getBean("org.springframework.jms.config.internalJmsListenerEndpointRegistry", JmsListenerEndpointRegistry.class);
        Mockito.when((Object)registry.getListenerContainer("storage_policy_selector_job_sqs_queue")).thenReturn((Object)mockMessageListenerContainer);
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)false);
        this.storagePolicyProcessorJmsMessageListener.controlStoragePolicyProcessorJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)0))).stop();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)0))).start();
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)true);
        this.storagePolicyProcessorJmsMessageListener.controlStoragePolicyProcessorJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer)).stop();
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.STORAGE_POLICY_PROCESSOR_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)true);
        this.storagePolicyProcessorJmsMessageListener.controlStoragePolicyProcessorJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)0))).start();
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)false);
        this.storagePolicyProcessorJmsMessageListener.controlStoragePolicyProcessorJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer)).start();
    }

    @Configuration
    static class ContextConfiguration {
        ContextConfiguration() {
        }

        @Bean(name={"org.springframework.jms.config.internalJmsListenerEndpointRegistry"})
        JmsListenerEndpointRegistry registry() {
            try {
                Class.forName("org.mockito.Mockito");
            }
            catch (ClassNotFoundException ignored) {
                return null;
            }
            return (JmsListenerEndpointRegistry)Mockito.mock(JmsListenerEndpointRegistry.class);
        }
    }
}

