/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.dto.BusinessObjectDataRestoreDto;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.model.jpa.StorageUnitStatusEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.S3Service;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.S3KeyPrefixHelper;
import org.finra.herd.service.helper.StorageFileDaoHelper;
import org.finra.herd.service.helper.StorageFileHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.finra.herd.service.helper.StorageUnitDaoHelper;
import org.finra.herd.service.helper.StorageUnitStatusDaoHelper;
import org.finra.herd.service.impl.BusinessObjectDataFinalizeRestoreHelperServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BusinessObjectDataFinalizeRestoreHelperServiceImplTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDataDaoHelper businessObjectDataDaoHelper;
    @InjectMocks
    private BusinessObjectDataFinalizeRestoreHelperServiceImpl businessObjectDataFinalizeRestoreHelperServiceImpl;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private S3KeyPrefixHelper s3KeyPrefixHelper;
    @Mock
    private S3Service s3Service;
    @Mock
    private StorageFileDaoHelper storageFileDaoHelper;
    @Mock
    private StorageFileHelper storageFileHelper;
    @Mock
    private StorageHelper storageHelper;
    @Mock
    private StorageUnitDaoHelper storageUnitDaoHelper;
    @Mock
    private StorageUnitStatusDaoHelper storageUnitStatusDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCompleteFinalizeRestore() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, Arrays.asList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT)), NO_EXCEPTION);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageUnitStatusEntity newStorageUnitStatusEntity = new StorageUnitStatusEntity();
        newStorageUnitStatusEntity.setCode("RESTORED");
        StorageUnitStatusEntity oldStorageUnitStatusEntity = new StorageUnitStatusEntity();
        oldStorageUnitStatusEntity.setCode("RESTORING");
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStatus(oldStorageUnitStatusEntity);
        Mockito.when((Object)this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity)).thenReturn((Object)storageUnitEntity);
        Mockito.when((Object)this.storageUnitStatusDaoHelper.getStorageUnitStatusEntity("RESTORED")).thenReturn((Object)newStorageUnitStatusEntity);
        this.businessObjectDataFinalizeRestoreHelperServiceImpl.completeFinalizeRestore(businessObjectDataRestoreDto);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        ((StorageUnitStatusDaoHelper)Mockito.verify((Object)this.storageUnitStatusDaoHelper)).getStorageUnitStatusEntity("RESTORED");
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, newStorageUnitStatusEntity, "RESTORED");
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)"RESTORED", (Object)businessObjectDataRestoreDto.getNewStorageUnitStatus());
        Assert.assertEquals((Object)"RESTORING", (Object)businessObjectDataRestoreDto.getOldStorageUnitStatus());
    }

    @Test
    public void testExecuteS3SpecificSteps() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List<StorageFile> storageFiles = Arrays.asList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT), new StorageFile(S3_KEY_2, FILE_SIZE_2, ROW_COUNT_2));
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, STORAGE_UNIT_STATUS_2, STORAGE_UNIT_STATUS, storageFiles, NO_EXCEPTION);
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferRequestParamsDto updatedS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        updatedS3FileTransferRequestParamsDto.setS3BucketName(S3_BUCKET_NAME);
        updatedS3FileTransferRequestParamsDto.setS3Endpoint(S3_ENDPOINT);
        updatedS3FileTransferRequestParamsDto.setS3KeyPrefix(S3_KEY_PREFIX + "/");
        S3ObjectSummary glacierS3ObjectSummary = (S3ObjectSummary)Mockito.mock(S3ObjectSummary.class);
        Mockito.when((Object)glacierS3ObjectSummary.getStorageClass()).thenReturn((Object)StorageClass.Glacier.toString());
        S3ObjectSummary standardS3ObjectSummary = (S3ObjectSummary)Mockito.mock(S3ObjectSummary.class);
        Mockito.when((Object)standardS3ObjectSummary.getStorageClass()).thenReturn((Object)StorageClass.Standard.toString());
        List<S3ObjectSummary> s3Files = Arrays.asList(glacierS3ObjectSummary, standardS3ObjectSummary);
        List<S3ObjectSummary> glacierS3Files = Arrays.asList(glacierS3ObjectSummary);
        List<StorageFile> glacierStorageFiles = Arrays.asList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT));
        List<File> files = Arrays.asList(new File(S3_KEY));
        S3FileTransferRequestParamsDto finalS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        finalS3FileTransferRequestParamsDto.setS3BucketName(S3_BUCKET_NAME);
        finalS3FileTransferRequestParamsDto.setS3Endpoint(S3_ENDPOINT);
        finalS3FileTransferRequestParamsDto.setS3KeyPrefix(S3_KEY_PREFIX + "/");
        finalS3FileTransferRequestParamsDto.setFiles(files);
        Mockito.when((Object)this.storageHelper.getS3FileTransferRequestParamsDto()).thenReturn((Object)s3FileTransferRequestParamsDto);
        Mockito.when((Object)this.s3Service.listDirectory(updatedS3FileTransferRequestParamsDto, true)).thenReturn(s3Files);
        Mockito.when((Object)this.storageFileHelper.createStorageFilesFromS3ObjectSummaries(glacierS3Files)).thenReturn(glacierStorageFiles);
        Mockito.when((Object)this.storageFileHelper.getFiles(glacierStorageFiles)).thenReturn(files);
        this.businessObjectDataFinalizeRestoreHelperServiceImpl.executeS3SpecificSteps(businessObjectDataRestoreDto);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getS3FileTransferRequestParamsDto();
        ((S3Service)Mockito.verify((Object)this.s3Service)).listDirectory((S3FileTransferRequestParamsDto)Matchers.any(S3FileTransferRequestParamsDto.class), Matchers.eq((boolean)true));
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).validateRegisteredS3Files(storageFiles, s3Files, STORAGE_NAME, businessObjectDataKey);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).createStorageFilesFromS3ObjectSummaries(glacierS3Files);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).getFiles(glacierStorageFiles);
        ((S3Service)Mockito.verify((Object)this.s3Service)).validateGlacierS3FilesRestored(finalS3FileTransferRequestParamsDto);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataDaoHelper, this.businessObjectDataHelper, this.configurationHelper, this.s3KeyPrefixHelper, this.s3Service, this.storageFileDaoHelper, this.storageFileHelper, this.storageHelper, this.storageUnitDaoHelper, this.storageUnitStatusDaoHelper});
    }
}

