/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import java.util.Arrays;
import java.util.List;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.BusinessObjectDataDao;
import org.finra.herd.dao.StorageUnitDao;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributesUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.BusinessObjectDataDestroyDto;
import org.finra.herd.model.jpa.BusinessObjectDataAttributeDefinitionEntity;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDataInitiateDestroyHelperService;
import org.finra.herd.service.BusinessObjectDataInitiateRestoreHelperService;
import org.finra.herd.service.NotificationEventService;
import org.finra.herd.service.S3Service;
import org.finra.herd.service.helper.AttributeDaoHelper;
import org.finra.herd.service.helper.AttributeHelper;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.BusinessObjectDataInvalidateUnregisteredHelper;
import org.finra.herd.service.helper.BusinessObjectDataRetryStoragePolicyTransitionHelper;
import org.finra.herd.service.helper.BusinessObjectDataSearchHelper;
import org.finra.herd.service.helper.BusinessObjectDataStatusDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.finra.herd.service.helper.BusinessObjectFormatDaoHelper;
import org.finra.herd.service.helper.BusinessObjectFormatHelper;
import org.finra.herd.service.helper.CustomDdlDaoHelper;
import org.finra.herd.service.helper.DdlGeneratorFactory;
import org.finra.herd.service.helper.S3KeyPrefixHelper;
import org.finra.herd.service.helper.StorageDaoHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.finra.herd.service.helper.StorageUnitHelper;
import org.finra.herd.service.impl.BusinessObjectDataServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class BusinessObjectDataServiceImplTest
extends AbstractServiceTest {
    @Mock
    private AttributeDaoHelper attributeDaoHelper;
    @Mock
    private AttributeHelper attributeHelper;
    @Mock
    private BusinessObjectDataDao businessObjectDataDao;
    @Mock
    private BusinessObjectDataDaoHelper businessObjectDataDaoHelper;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Mock
    private BusinessObjectDataInitiateDestroyHelperService businessObjectDataInitiateDestroyHelperService;
    @Mock
    private BusinessObjectDataInitiateRestoreHelperService businessObjectDataInitiateRestoreHelperService;
    @Mock
    private BusinessObjectDataInvalidateUnregisteredHelper businessObjectDataInvalidateUnregisteredHelper;
    @Mock
    private BusinessObjectDataRetryStoragePolicyTransitionHelper businessObjectDataRetryStoragePolicyTransitionHelper;
    @Mock
    private BusinessObjectDataSearchHelper businessObjectDataSearchHelper;
    @InjectMocks
    private BusinessObjectDataServiceImpl businessObjectDataServiceImpl;
    @Mock
    private BusinessObjectDataStatusDaoHelper businessObjectDataStatusDaoHelper;
    @Mock
    private BusinessObjectDefinitionDaoHelper businessObjectDefinitionDaoHelper;
    @Mock
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @Mock
    private BusinessObjectFormatDaoHelper businessObjectFormatDaoHelper;
    @Mock
    private BusinessObjectFormatHelper businessObjectFormatHelper;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private CustomDdlDaoHelper customDdlDaoHelper;
    @Mock
    private DdlGeneratorFactory ddlGeneratorFactory;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private NotificationEventService notificationEventService;
    @Mock
    private S3KeyPrefixHelper s3KeyPrefixHelper;
    @Mock
    private S3Service s3Service;
    @Mock
    private StorageDaoHelper storageDaoHelper;
    @Mock
    private StorageHelper storageHelper;
    @Mock
    private StorageUnitDao storageUnitDao;
    @Mock
    private StorageUnitHelper storageUnitHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testDestroyBusinessObjectData() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List<BusinessObjectDataDestroyDto> businessObjectDataDestroyDtoStates = Arrays.asList(new BusinessObjectDataDestroyDto(businessObjectDataKey, STORAGE_NAME, "DELETED", "VALID", "DISABLING", "ENABLED", S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME, BDATA_FINAL_DESTROY_DELAY_IN_DAYS), new BusinessObjectDataDestroyDto(businessObjectDataKey, STORAGE_NAME, "DELETED", "VALID", "DISABLED", "DISABLING", S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME, BDATA_FINAL_DESTROY_DELAY_IN_DAYS));
        BusinessObjectData businessObjectData = new BusinessObjectData();
        businessObjectData.setId(ID.intValue());
        ((BusinessObjectDataInitiateDestroyHelperService)Mockito.doAnswer(invocation -> {
            BusinessObjectDataDestroyDto businessObjectDataDestroyDto = (BusinessObjectDataDestroyDto)invocation.getArguments()[0];
            ((BusinessObjectDataDestroyDto)businessObjectDataDestroyDtoStates.get(0)).copyTo((Object)businessObjectDataDestroyDto);
            return null;
        }).when((Object)this.businessObjectDataInitiateDestroyHelperService)).prepareToInitiateDestroy(new BusinessObjectDataDestroyDto(), businessObjectDataKey);
        ((BusinessObjectDataInitiateDestroyHelperService)Mockito.doAnswer(invocation -> {
            BusinessObjectDataDestroyDto businessObjectDataDestroyDto = (BusinessObjectDataDestroyDto)invocation.getArguments()[0];
            ((BusinessObjectDataDestroyDto)businessObjectDataDestroyDtoStates.get(1)).copyTo((Object)businessObjectDataDestroyDto);
            return null;
        }).when((Object)this.businessObjectDataInitiateDestroyHelperService)).executeInitiateDestroyAfterStep((BusinessObjectDataDestroyDto)ArgumentMatchers.any(BusinessObjectDataDestroyDto.class));
        Mockito.when((Object)this.businessObjectDataInitiateDestroyHelperService.executeInitiateDestroyAfterStep((BusinessObjectDataDestroyDto)ArgumentMatchers.any(BusinessObjectDataDestroyDto.class))).thenReturn((Object)businessObjectData);
        BusinessObjectData result = this.businessObjectDataServiceImpl.destroyBusinessObjectData(businessObjectDataKey);
        ((BusinessObjectDataInitiateDestroyHelperService)Mockito.verify((Object)this.businessObjectDataInitiateDestroyHelperService)).prepareToInitiateDestroy((BusinessObjectDataDestroyDto)ArgumentMatchers.any(BusinessObjectDataDestroyDto.class), (BusinessObjectDataKey)ArgumentMatchers.any(BusinessObjectDataKey.class));
        ((BusinessObjectDataInitiateDestroyHelperService)Mockito.verify((Object)this.businessObjectDataInitiateDestroyHelperService)).executeS3SpecificSteps((BusinessObjectDataDestroyDto)ArgumentMatchers.any(BusinessObjectDataDestroyDto.class));
        ((BusinessObjectDataInitiateDestroyHelperService)Mockito.verify((Object)this.businessObjectDataInitiateDestroyHelperService)).executeInitiateDestroyAfterStep((BusinessObjectDataDestroyDto)ArgumentMatchers.any(BusinessObjectDataDestroyDto.class));
        ((NotificationEventService)Mockito.verify((Object)this.notificationEventService, (VerificationMode)Mockito.times((int)2))).processStorageUnitNotificationEventAsync((NotificationEventTypeEntity.EventTypesStorageUnit)ArgumentMatchers.any(NotificationEventTypeEntity.EventTypesStorageUnit.class), (BusinessObjectDataKey)ArgumentMatchers.any(BusinessObjectDataKey.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class));
        ((NotificationEventService)Mockito.verify((Object)this.notificationEventService)).processBusinessObjectDataNotificationEventAsync((NotificationEventTypeEntity.EventTypesBdata)ArgumentMatchers.any(NotificationEventTypeEntity.EventTypesBdata.class), (BusinessObjectDataKey)ArgumentMatchers.any(BusinessObjectDataKey.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class));
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)businessObjectData, (Object)result);
    }

    @Test
    public void testUpdateBusinessObjectDataAttributes() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List<Attribute> attributes = Arrays.asList(new Attribute(ATTRIBUTE_NAME, ATTRIBUTE_VALUE));
        BusinessObjectDataAttributesUpdateRequest businessObjectDataAttributesUpdateRequest = new BusinessObjectDataAttributesUpdateRequest(attributes);
        List<BusinessObjectDataAttributeDefinitionEntity> attributeDefinitionEntities = Arrays.asList(new BusinessObjectDataAttributeDefinitionEntity());
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        businessObjectFormatEntity.setAttributeDefinitions(attributeDefinitionEntities);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setBusinessObjectFormat(businessObjectFormatEntity);
        BusinessObjectData businessObjectData = new BusinessObjectData();
        businessObjectData.setId(ID.intValue());
        Mockito.when((Object)this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.businessObjectDataDao.saveAndRefresh((Object)businessObjectDataEntity)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.businessObjectDataHelper.createBusinessObjectDataFromEntity(businessObjectDataEntity)).thenReturn((Object)businessObjectData);
        BusinessObjectData result = this.businessObjectDataServiceImpl.updateBusinessObjectDataAttributes(businessObjectDataKey, businessObjectDataAttributesUpdateRequest);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).validateBusinessObjectDataKey(businessObjectDataKey, true, true);
        ((AttributeHelper)Mockito.verify((Object)this.attributeHelper)).validateAttributes(attributes);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((AttributeDaoHelper)Mockito.verify((Object)this.attributeDaoHelper)).validateAttributesAgainstBusinessObjectDataAttributeDefinitions(attributes, attributeDefinitionEntities);
        ((AttributeDaoHelper)Mockito.verify((Object)this.attributeDaoHelper)).updateBusinessObjectDataAttributes(businessObjectDataEntity, attributes);
        ((BusinessObjectDataDao)Mockito.verify((Object)this.businessObjectDataDao)).saveAndRefresh((Object)businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).createBusinessObjectDataFromEntity(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)businessObjectData, (Object)result);
    }

    @Test
    public void testUpdateBusinessObjectDataAttributesMissingRequiredParameters() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        try {
            this.businessObjectDataServiceImpl.updateBusinessObjectDataAttributes(businessObjectDataKey, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A business object data attributes update request must be specified.", new Object[0]), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataServiceImpl.updateBusinessObjectDataAttributes(businessObjectDataKey, new BusinessObjectDataAttributesUpdateRequest());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A list of business object data attributes must be specified.", new Object[0]), (Object)e.getMessage());
        }
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper, (VerificationMode)Mockito.times((int)2))).validateBusinessObjectDataKey(businessObjectDataKey, true, true);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attributeDaoHelper, this.attributeHelper, this.businessObjectDataDao, this.businessObjectDataDaoHelper, this.businessObjectDataHelper, this.businessObjectDataInitiateDestroyHelperService, this.businessObjectDataInitiateRestoreHelperService, this.businessObjectDataInvalidateUnregisteredHelper, this.businessObjectDataRetryStoragePolicyTransitionHelper, this.businessObjectDataSearchHelper, this.businessObjectDataStatusDaoHelper, this.businessObjectDefinitionDaoHelper, this.businessObjectDefinitionHelper, this.businessObjectFormatDaoHelper, this.businessObjectFormatHelper, this.configurationHelper, this.customDdlDaoHelper, this.ddlGeneratorFactory, this.jsonHelper, this.notificationEventService, this.s3KeyPrefixHelper, this.s3Service, this.storageDaoHelper, this.storageHelper, this.storageUnitDao, this.storageUnitHelper});
    }
}

