/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.dao.Ec2OnDemandPricingDao;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.dao.helper.UrlHelper;
import org.finra.herd.model.dto.Ec2OnDemandPricing;
import org.finra.herd.model.dto.Ec2OnDemandPricingKey;
import org.finra.herd.model.jpa.Ec2OnDemandPricingEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.Ec2OnDemandPricingUpdateServiceImpl;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class Ec2OnDemandPricingUpdateServiceImplTest
extends AbstractServiceTest {
    @Mock
    private Ec2OnDemandPricingDao ec2OnDemandPricingDao;
    @InjectMocks
    private Ec2OnDemandPricingUpdateServiceImpl ec2OnDemandPricingUpdateServiceImpl;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private UrlHelper urlHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testConvertLocationToRegionName() {
        Assert.assertEquals((Object)"us-east-1", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("US East (N. Virginia)"));
        Assert.assertEquals((Object)"us-east-2", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("US East (Ohio)"));
        Assert.assertEquals((Object)"us-west-1", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("US West (N. California)"));
        Assert.assertEquals((Object)"us-west-2", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("US West (Oregon)"));
        Assert.assertEquals((Object)"ca-central-1", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("Canada (Central)"));
        Assert.assertEquals((Object)"ap-south-1", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("Asia Pacific (Mumbai)"));
        Assert.assertEquals((Object)"ap-northeast-2", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("Asia Pacific (Seoul)"));
        Assert.assertEquals((Object)"ap-southeast-1", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("Asia Pacific (Singapore)"));
        Assert.assertEquals((Object)"ap-southeast-2", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("Asia Pacific (Sydney)"));
        Assert.assertEquals((Object)"ap-northeast-1", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("Asia Pacific (Tokyo)"));
        Assert.assertEquals((Object)"eu-central-1", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("EU (Frankfurt)"));
        Assert.assertEquals((Object)"eu-west-1", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("EU (Ireland)"));
        Assert.assertEquals((Object)"eu-west-2", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("EU (London)"));
        Assert.assertEquals((Object)"sa-east-1", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("South America (Sao Paulo)"));
        Assert.assertEquals((Object)"us-gov-west-1", (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName("AWS GovCloud (US)"));
        Assert.assertEquals((Object)AWS_REGION_NAME, (Object)this.ec2OnDemandPricingUpdateServiceImpl.convertLocationToRegionName(AWS_REGION_NAME));
    }

    @Test
    public void testCreateEc2OnDemandPricingEntry() {
        Assert.assertEquals((Object)new Ec2OnDemandPricing(new Ec2OnDemandPricingKey(AWS_REGION_NAME, EC2_INSTANCE_TYPE), NO_HOURLY_PRICE, SKU), (Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"Linux", (Object)EC2_INSTANCE_TYPE, (Object)"Shared", (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertEquals((Object)new Ec2OnDemandPricing(new Ec2OnDemandPricingKey(AWS_REGION_NAME, EC2_INSTANCE_TYPE), NO_HOURLY_PRICE, SKU), (Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"Linux", (Object)EC2_INSTANCE_TYPE, (Object)"Shared", (Object)(RANDOM_SUFFIX + "-BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, null, (Object)"Linux", (Object)EC2_INSTANCE_TYPE, (Object)"Shared", (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, null, (Object)EC2_INSTANCE_TYPE, (Object)"Shared", (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"Linux", null, (Object)"Shared", (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"Linux", (Object)EC2_INSTANCE_TYPE, null, (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"Linux", (Object)EC2_INSTANCE_TYPE, (Object)"Shared", null));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)"      \t\t ", (Object)"Linux", (Object)EC2_INSTANCE_TYPE, (Object)"Shared", (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"      \t\t ", (Object)EC2_INSTANCE_TYPE, (Object)"Shared", (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"Linux", (Object)"      \t\t ", (Object)"Shared", (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"Linux", (Object)EC2_INSTANCE_TYPE, (Object)"      \t\t ", (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"Linux", (Object)EC2_INSTANCE_TYPE, (Object)"Shared", (Object)"      \t\t "));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)STRING_VALUE, (Object)EC2_INSTANCE_TYPE, (Object)"Shared", (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"Linux", (Object)EC2_INSTANCE_TYPE, (Object)STRING_VALUE, (Object)("BoxUsage" + RANDOM_SUFFIX)));
        Assert.assertNull((Object)this.ec2OnDemandPricingUpdateServiceImpl.createEc2OnDemandPricingEntry(SKU, (Object)AWS_REGION_NAME, (Object)"Linux", (Object)EC2_INSTANCE_TYPE, (Object)"Shared", (Object)STRING_VALUE));
    }

    @Test
    public void testGetEc2OnDemandPricing() {
        JSONObject jsonObject = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject products = (JSONObject)Mockito.mock(JSONObject.class);
        Mockito.when((Object)products.keySet()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{EC2_PRODUCT_KEY}));
        JSONObject product = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject attributes = (JSONObject)Mockito.mock(JSONObject.class);
        Mockito.when((Object)attributes.get((Object)"location")).thenReturn((Object)AWS_REGION_NAME);
        Mockito.when((Object)attributes.get((Object)"operatingSystem")).thenReturn((Object)"Linux");
        Mockito.when((Object)attributes.get((Object)"instanceType")).thenReturn((Object)EC2_INSTANCE_TYPE);
        Mockito.when((Object)attributes.get((Object)"tenancy")).thenReturn((Object)"Shared");
        Mockito.when((Object)attributes.get((Object)"usagetype")).thenReturn((Object)"BoxUsage");
        JSONObject terms = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject onDemand = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject onDemandSkuInformation = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject pricingWrapper = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject priceDimensions = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject innerPricingWrapper = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject pricePerUnit = (JSONObject)Mockito.mock(JSONObject.class);
        Mockito.when((Object)this.urlHelper.parseJsonObjectFromUrl(EC2_PRICING_LIST_URL)).thenReturn((Object)jsonObject);
        Mockito.when((Object)this.jsonHelper.getKeyValue(jsonObject, (Object)"products", JSONObject.class)).thenReturn((Object)products);
        Mockito.when((Object)this.jsonHelper.getKeyValue(products, (Object)EC2_PRODUCT_KEY, JSONObject.class)).thenReturn((Object)product);
        Mockito.when((Object)this.jsonHelper.getKeyValue(product, (Object)"sku", String.class)).thenReturn((Object)SKU);
        Mockito.when((Object)this.jsonHelper.getKeyValue(product, (Object)"attributes", JSONObject.class)).thenReturn((Object)attributes);
        Mockito.when((Object)this.jsonHelper.getKeyValue(jsonObject, (Object)"terms", JSONObject.class)).thenReturn((Object)terms);
        Mockito.when((Object)this.jsonHelper.getKeyValue(terms, (Object)"OnDemand", JSONObject.class)).thenReturn((Object)onDemand);
        Mockito.when((Object)this.jsonHelper.getKeyValue(onDemand, (Object)SKU, JSONObject.class)).thenReturn((Object)onDemandSkuInformation);
        Mockito.when((Object)this.jsonHelper.getKeyValue(onDemandSkuInformation, (Object)(SKU + ".JRTCKXETXF"), JSONObject.class)).thenReturn((Object)pricingWrapper);
        Mockito.when((Object)this.jsonHelper.getKeyValue(pricingWrapper, (Object)"priceDimensions", JSONObject.class)).thenReturn((Object)priceDimensions);
        Mockito.when((Object)this.jsonHelper.getKeyValue(priceDimensions, (Object)(SKU + ".JRTCKXETXF" + ".6YS6EN2CT7"), JSONObject.class)).thenReturn((Object)innerPricingWrapper);
        Mockito.when((Object)this.jsonHelper.getKeyValue(innerPricingWrapper, (Object)"pricePerUnit", JSONObject.class)).thenReturn((Object)pricePerUnit);
        Mockito.when((Object)this.jsonHelper.getKeyValue(pricePerUnit, (Object)"USD", String.class)).thenReturn((Object)HOURLY_PRICE.toString());
        List result = this.ec2OnDemandPricingUpdateServiceImpl.getEc2OnDemandPricing(EC2_PRICING_LIST_URL);
        ((UrlHelper)Mockito.verify((Object)this.urlHelper)).parseJsonObjectFromUrl(EC2_PRICING_LIST_URL);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(jsonObject, (Object)"products", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(products, (Object)EC2_PRODUCT_KEY, JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(product, (Object)"sku", String.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(product, (Object)"attributes", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(jsonObject, (Object)"terms", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(terms, (Object)"OnDemand", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(onDemand, (Object)SKU, JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(onDemandSkuInformation, (Object)(SKU + ".JRTCKXETXF"), JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(pricingWrapper, (Object)"priceDimensions", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(priceDimensions, (Object)(SKU + ".JRTCKXETXF" + ".6YS6EN2CT7"), JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(innerPricingWrapper, (Object)"pricePerUnit", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(pricePerUnit, (Object)"USD", String.class);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals(Arrays.asList(new Ec2OnDemandPricing(new Ec2OnDemandPricingKey(AWS_REGION_NAME, EC2_INSTANCE_TYPE), HOURLY_PRICE, SKU)), (Object)result);
    }

    @Test
    public void testGetEc2OnDemandPricingDuplicateEc2OnDemandPricingKeys() {
        JSONObject jsonObject = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject products = (JSONObject)Mockito.mock(JSONObject.class);
        Mockito.when((Object)products.keySet()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{EC2_PRODUCT_KEY, EC2_PRODUCT_KEY_2}));
        JSONObject product = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject attributes = (JSONObject)Mockito.mock(JSONObject.class);
        Mockito.when((Object)attributes.get((Object)"location")).thenReturn((Object)AWS_REGION_NAME);
        Mockito.when((Object)attributes.get((Object)"operatingSystem")).thenReturn((Object)"Linux");
        Mockito.when((Object)attributes.get((Object)"instanceType")).thenReturn((Object)EC2_INSTANCE_TYPE);
        Mockito.when((Object)attributes.get((Object)"tenancy")).thenReturn((Object)"Shared");
        Mockito.when((Object)attributes.get((Object)"usagetype")).thenReturn((Object)"BoxUsage");
        Mockito.when((Object)this.urlHelper.parseJsonObjectFromUrl(EC2_PRICING_LIST_URL)).thenReturn((Object)jsonObject);
        Mockito.when((Object)this.jsonHelper.getKeyValue(jsonObject, (Object)"products", JSONObject.class)).thenReturn((Object)products);
        Mockito.when((Object)this.jsonHelper.getKeyValue(products, (Object)EC2_PRODUCT_KEY, JSONObject.class)).thenReturn((Object)product);
        Mockito.when((Object)this.jsonHelper.getKeyValue(products, (Object)EC2_PRODUCT_KEY_2, JSONObject.class)).thenReturn((Object)product);
        Mockito.when((Object)this.jsonHelper.getKeyValue(product, (Object)"sku", String.class)).thenReturn((Object)SKU);
        Mockito.when((Object)this.jsonHelper.getKeyValue(product, (Object)"attributes", JSONObject.class)).thenReturn((Object)attributes);
        try {
            this.ec2OnDemandPricingUpdateServiceImpl.getEc2OnDemandPricing(EC2_PRICING_LIST_URL);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Found duplicate EC2 on-demand pricing entry for \"%s\" AWS region and \"%s\" EC2 instance type.", AWS_REGION_NAME, EC2_INSTANCE_TYPE), (Object)e.getMessage());
        }
        ((UrlHelper)Mockito.verify((Object)this.urlHelper)).parseJsonObjectFromUrl(EC2_PRICING_LIST_URL);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(jsonObject, (Object)"products", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(products, (Object)EC2_PRODUCT_KEY, JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(products, (Object)EC2_PRODUCT_KEY_2, JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper, (VerificationMode)Mockito.times((int)2))).getKeyValue(product, (Object)"sku", String.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper, (VerificationMode)Mockito.times((int)2))).getKeyValue(product, (Object)"attributes", JSONObject.class);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetEc2OnDemandPricingNoEc2OnDemandPricingEntriesCreated() {
        JSONObject jsonObject = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject products = (JSONObject)Mockito.mock(JSONObject.class);
        Mockito.when((Object)products.keySet()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{EC2_PRODUCT_KEY}));
        JSONObject product = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject attributes = (JSONObject)Mockito.mock(JSONObject.class);
        Mockito.when((Object)attributes.get((Object)"location")).thenReturn(null);
        Mockito.when((Object)attributes.get((Object)"operatingSystem")).thenReturn((Object)"Linux");
        Mockito.when((Object)attributes.get((Object)"instanceType")).thenReturn((Object)EC2_INSTANCE_TYPE);
        Mockito.when((Object)attributes.get((Object)"tenancy")).thenReturn((Object)"Shared");
        Mockito.when((Object)attributes.get((Object)"usagetype")).thenReturn((Object)"BoxUsage");
        Mockito.when((Object)this.urlHelper.parseJsonObjectFromUrl(EC2_PRICING_LIST_URL)).thenReturn((Object)jsonObject);
        Mockito.when((Object)this.jsonHelper.getKeyValue(jsonObject, (Object)"products", JSONObject.class)).thenReturn((Object)products);
        Mockito.when((Object)this.jsonHelper.getKeyValue(products, (Object)EC2_PRODUCT_KEY, JSONObject.class)).thenReturn((Object)product);
        Mockito.when((Object)this.jsonHelper.getKeyValue(product, (Object)"sku", String.class)).thenReturn((Object)SKU);
        Mockito.when((Object)this.jsonHelper.getKeyValue(product, (Object)"attributes", JSONObject.class)).thenReturn((Object)attributes);
        List result = this.ec2OnDemandPricingUpdateServiceImpl.getEc2OnDemandPricing(EC2_PRICING_LIST_URL);
        ((UrlHelper)Mockito.verify((Object)this.urlHelper)).parseJsonObjectFromUrl(EC2_PRICING_LIST_URL);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(jsonObject, (Object)"products", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(products, (Object)EC2_PRODUCT_KEY, JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(product, (Object)"sku", String.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(product, (Object)"attributes", JSONObject.class);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testGetEc2OnDemandPricingNumberFormatException() {
        JSONObject jsonObject = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject products = (JSONObject)Mockito.mock(JSONObject.class);
        Mockito.when((Object)products.keySet()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{EC2_PRODUCT_KEY}));
        JSONObject product = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject attributes = (JSONObject)Mockito.mock(JSONObject.class);
        Mockito.when((Object)attributes.get((Object)"location")).thenReturn((Object)AWS_REGION_NAME);
        Mockito.when((Object)attributes.get((Object)"operatingSystem")).thenReturn((Object)"Linux");
        Mockito.when((Object)attributes.get((Object)"instanceType")).thenReturn((Object)EC2_INSTANCE_TYPE);
        Mockito.when((Object)attributes.get((Object)"tenancy")).thenReturn((Object)"Shared");
        Mockito.when((Object)attributes.get((Object)"usagetype")).thenReturn((Object)"BoxUsage");
        JSONObject terms = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject onDemand = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject onDemandSkuInformation = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject pricingWrapper = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject priceDimensions = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject innerPricingWrapper = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject pricePerUnit = (JSONObject)Mockito.mock(JSONObject.class);
        Mockito.when((Object)this.urlHelper.parseJsonObjectFromUrl(EC2_PRICING_LIST_URL)).thenReturn((Object)jsonObject);
        Mockito.when((Object)this.jsonHelper.getKeyValue(jsonObject, (Object)"products", JSONObject.class)).thenReturn((Object)products);
        Mockito.when((Object)this.jsonHelper.getKeyValue(products, (Object)EC2_PRODUCT_KEY, JSONObject.class)).thenReturn((Object)product);
        Mockito.when((Object)this.jsonHelper.getKeyValue(product, (Object)"sku", String.class)).thenReturn((Object)SKU);
        Mockito.when((Object)this.jsonHelper.getKeyValue(product, (Object)"attributes", JSONObject.class)).thenReturn((Object)attributes);
        Mockito.when((Object)this.jsonHelper.getKeyValue(jsonObject, (Object)"terms", JSONObject.class)).thenReturn((Object)terms);
        Mockito.when((Object)this.jsonHelper.getKeyValue(terms, (Object)"OnDemand", JSONObject.class)).thenReturn((Object)onDemand);
        Mockito.when((Object)this.jsonHelper.getKeyValue(onDemand, (Object)SKU, JSONObject.class)).thenReturn((Object)onDemandSkuInformation);
        Mockito.when((Object)this.jsonHelper.getKeyValue(onDemandSkuInformation, (Object)(SKU + ".JRTCKXETXF"), JSONObject.class)).thenReturn((Object)pricingWrapper);
        Mockito.when((Object)this.jsonHelper.getKeyValue(pricingWrapper, (Object)"priceDimensions", JSONObject.class)).thenReturn((Object)priceDimensions);
        Mockito.when((Object)this.jsonHelper.getKeyValue(priceDimensions, (Object)(SKU + ".JRTCKXETXF" + ".6YS6EN2CT7"), JSONObject.class)).thenReturn((Object)innerPricingWrapper);
        Mockito.when((Object)this.jsonHelper.getKeyValue(innerPricingWrapper, (Object)"pricePerUnit", JSONObject.class)).thenReturn((Object)pricePerUnit);
        Mockito.when((Object)this.jsonHelper.getKeyValue(pricePerUnit, (Object)"USD", String.class)).thenReturn((Object)STRING_VALUE);
        try {
            this.ec2OnDemandPricingUpdateServiceImpl.getEc2OnDemandPricing(EC2_PRICING_LIST_URL);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Failed to convert \"%s\" value to %s.", STRING_VALUE, BigDecimal.class.getName()), (Object)e.getMessage());
        }
        ((UrlHelper)Mockito.verify((Object)this.urlHelper)).parseJsonObjectFromUrl(EC2_PRICING_LIST_URL);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(jsonObject, (Object)"products", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(products, (Object)EC2_PRODUCT_KEY, JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(product, (Object)"sku", String.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(product, (Object)"attributes", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(jsonObject, (Object)"terms", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(terms, (Object)"OnDemand", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(onDemand, (Object)SKU, JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(onDemandSkuInformation, (Object)(SKU + ".JRTCKXETXF"), JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(pricingWrapper, (Object)"priceDimensions", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(priceDimensions, (Object)(SKU + ".JRTCKXETXF" + ".6YS6EN2CT7"), JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(innerPricingWrapper, (Object)"pricePerUnit", JSONObject.class);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).getKeyValue(pricePerUnit, (Object)"USD", String.class);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateEc2OnDemandPricing() {
        List<Ec2OnDemandPricingKey> ec2OnDemandPricingKeys = Arrays.asList(new Ec2OnDemandPricingKey(AWS_REGION_NAME, EC2_INSTANCE_TYPE), new Ec2OnDemandPricingKey(AWS_REGION_NAME_2, EC2_INSTANCE_TYPE_2), new Ec2OnDemandPricingKey(AWS_REGION_NAME_3, EC2_INSTANCE_TYPE_3), new Ec2OnDemandPricingKey(AWS_REGION_NAME_4, EC2_INSTANCE_TYPE_4));
        List<Ec2OnDemandPricingEntity> ec2OnDemandPricingEntities = Arrays.asList(new Ec2OnDemandPricingEntity(), new Ec2OnDemandPricingEntity(), new Ec2OnDemandPricingEntity());
        ec2OnDemandPricingEntities.get(0).setRegionName(AWS_REGION_NAME);
        ec2OnDemandPricingEntities.get(0).setInstanceType(EC2_INSTANCE_TYPE);
        ec2OnDemandPricingEntities.get(0).setHourlyPrice(HOURLY_PRICE);
        ec2OnDemandPricingEntities.get(1).setRegionName(AWS_REGION_NAME_2);
        ec2OnDemandPricingEntities.get(1).setInstanceType(EC2_INSTANCE_TYPE_2);
        ec2OnDemandPricingEntities.get(1).setHourlyPrice(HOURLY_PRICE_2);
        ec2OnDemandPricingEntities.get(2).setRegionName(AWS_REGION_NAME_3);
        ec2OnDemandPricingEntities.get(2).setInstanceType(EC2_INSTANCE_TYPE_3);
        ec2OnDemandPricingEntities.get(2).setHourlyPrice(HOURLY_PRICE_3);
        List<Ec2OnDemandPricing> ec2OnDemandPricingEntries = Arrays.asList(new Ec2OnDemandPricing(ec2OnDemandPricingKeys.get(1), HOURLY_PRICE_2, NO_SKU), new Ec2OnDemandPricing(ec2OnDemandPricingKeys.get(2), HOURLY_PRICE_5, NO_SKU), new Ec2OnDemandPricing(ec2OnDemandPricingKeys.get(3), HOURLY_PRICE_4, NO_SKU));
        Mockito.when((Object)this.ec2OnDemandPricingDao.getEc2OnDemandPricingEntities()).thenReturn(ec2OnDemandPricingEntities);
        this.ec2OnDemandPricingUpdateServiceImpl.updateEc2OnDemandPricing(ec2OnDemandPricingEntries);
        ((Ec2OnDemandPricingDao)Mockito.verify((Object)this.ec2OnDemandPricingDao)).getEc2OnDemandPricingEntities();
        ((Ec2OnDemandPricingDao)Mockito.verify((Object)this.ec2OnDemandPricingDao, (VerificationMode)Mockito.times((int)2))).saveAndRefresh(Matchers.any(Ec2OnDemandPricingEntity.class));
        ((Ec2OnDemandPricingDao)Mockito.verify((Object)this.ec2OnDemandPricingDao)).delete((Object)ec2OnDemandPricingEntities.get(0));
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)HOURLY_PRICE_2, (Object)ec2OnDemandPricingEntities.get(1).getHourlyPrice());
        Assert.assertEquals((Object)HOURLY_PRICE_5, (Object)ec2OnDemandPricingEntities.get(2).getHourlyPrice());
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ec2OnDemandPricingDao, this.jsonHelper, this.urlHelper});
    }
}

