/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.dto.BusinessObjectDataRestoreDto;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.model.jpa.StorageUnitStatusEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.S3Service;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.S3KeyPrefixHelper;
import org.finra.herd.service.helper.StorageFileDaoHelper;
import org.finra.herd.service.helper.StorageFileHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.finra.herd.service.helper.StorageUnitDaoHelper;
import org.finra.herd.service.helper.StorageUnitStatusDaoHelper;
import org.finra.herd.service.impl.ExpireRestoredBusinessObjectDataHelperServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ExpireRestoredBusinessObjectDataHelperServiceImplTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDataDaoHelper businessObjectDataDaoHelper;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Mock
    private ConfigurationHelper configurationHelper;
    @InjectMocks
    private ExpireRestoredBusinessObjectDataHelperServiceImpl expireRestoredBusinessObjectDataHelperServiceImpl;
    @Mock
    private S3KeyPrefixHelper s3KeyPrefixHelper;
    @Mock
    private S3Service s3Service;
    @Mock
    private StorageFileDaoHelper storageFileDaoHelper;
    @Mock
    private StorageFileHelper storageFileHelper;
    @Mock
    private StorageHelper storageHelper;
    @Mock
    private StorageUnitDaoHelper storageUnitDaoHelper;
    @Mock
    private StorageUnitStatusDaoHelper storageUnitStatusDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCompleteStorageUnitExpiration() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, Arrays.asList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT)), NO_EXCEPTION);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        final StorageUnitStatusEntity newStorageUnitStatusEntity = new StorageUnitStatusEntity();
        newStorageUnitStatusEntity.setCode("ARCHIVED");
        StorageUnitStatusEntity oldStorageUnitStatusEntity = new StorageUnitStatusEntity();
        oldStorageUnitStatusEntity.setCode("EXPIRING");
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStatus(oldStorageUnitStatusEntity);
        Mockito.when((Object)this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity)).thenReturn((Object)storageUnitEntity);
        ((StorageUnitDaoHelper)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                StorageUnitEntity storageUnitEntity = (StorageUnitEntity)invocation.getArguments()[0];
                storageUnitEntity.setStatus(newStorageUnitStatusEntity);
                return null;
            }
        }).when((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "ARCHIVED", "ARCHIVED");
        this.expireRestoredBusinessObjectDataHelperServiceImpl.completeStorageUnitExpiration(businessObjectDataRestoreDto);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "ARCHIVED", "ARCHIVED");
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)"ARCHIVED", (Object)businessObjectDataRestoreDto.getNewStorageUnitStatus());
        Assert.assertEquals((Object)"EXPIRING", (Object)businessObjectDataRestoreDto.getOldStorageUnitStatus());
    }

    @Test
    public void testExecuteS3SpecificSteps() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List<StorageFile> storageFiles = Arrays.asList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT), new StorageFile(S3_KEY_2, FILE_SIZE_2, ROW_COUNT_2));
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, STORAGE_UNIT_STATUS_2, STORAGE_UNIT_STATUS, storageFiles, NO_EXCEPTION);
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferRequestParamsDto updatedS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        updatedS3FileTransferRequestParamsDto.setS3BucketName(S3_BUCKET_NAME);
        updatedS3FileTransferRequestParamsDto.setS3Endpoint(S3_ENDPOINT);
        updatedS3FileTransferRequestParamsDto.setS3KeyPrefix(S3_KEY_PREFIX + "/");
        S3ObjectSummary glacierS3ObjectSummary = (S3ObjectSummary)Mockito.mock(S3ObjectSummary.class);
        Mockito.when((Object)glacierS3ObjectSummary.getStorageClass()).thenReturn((Object)StorageClass.Glacier.toString());
        S3ObjectSummary standardS3ObjectSummary = (S3ObjectSummary)Mockito.mock(S3ObjectSummary.class);
        Mockito.when((Object)standardS3ObjectSummary.getStorageClass()).thenReturn((Object)StorageClass.Standard.toString());
        List<S3ObjectSummary> s3Files = Arrays.asList(glacierS3ObjectSummary, standardS3ObjectSummary);
        List<S3ObjectSummary> glacierS3Files = Arrays.asList(glacierS3ObjectSummary);
        List<StorageFile> glacierStorageFiles = Arrays.asList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT));
        List<File> files = Arrays.asList(new File(S3_KEY));
        S3FileTransferRequestParamsDto finalS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        finalS3FileTransferRequestParamsDto.setS3BucketName(S3_BUCKET_NAME);
        finalS3FileTransferRequestParamsDto.setS3Endpoint(S3_ENDPOINT);
        finalS3FileTransferRequestParamsDto.setS3KeyPrefix(S3_KEY_PREFIX + "/");
        finalS3FileTransferRequestParamsDto.setFiles(files);
        Mockito.when((Object)this.storageHelper.getS3FileTransferRequestParamsDto()).thenReturn((Object)s3FileTransferRequestParamsDto);
        Mockito.when((Object)this.s3Service.listDirectory(updatedS3FileTransferRequestParamsDto, true)).thenReturn(s3Files);
        Mockito.when((Object)this.storageFileHelper.createStorageFilesFromS3ObjectSummaries(glacierS3Files)).thenReturn(glacierStorageFiles);
        Mockito.when((Object)this.storageFileHelper.getFiles(glacierStorageFiles)).thenReturn(files);
        this.expireRestoredBusinessObjectDataHelperServiceImpl.executeS3SpecificSteps(businessObjectDataRestoreDto);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getS3FileTransferRequestParamsDto();
        ((S3Service)Mockito.verify((Object)this.s3Service)).listDirectory((S3FileTransferRequestParamsDto)Matchers.any(S3FileTransferRequestParamsDto.class), Matchers.eq((boolean)true));
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).validateRegisteredS3Files(storageFiles, s3Files, STORAGE_NAME, businessObjectDataKey);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).createStorageFilesFromS3ObjectSummaries(glacierS3Files);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).getFiles(glacierStorageFiles);
        ((S3Service)Mockito.verify((Object)this.s3Service)).restoreObjects(finalS3FileTransferRequestParamsDto, 1);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetStorageUnitStorageUnitNotRestored() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode(STORAGE_UNIT_STATUS);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity)).thenReturn((Object)storageUnitEntity);
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.expireRestoredBusinessObjectDataHelperServiceImpl.getStorageUnit(STORAGE_NAME, businessObjectDataEntity);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("S3 storage unit in \"%s\" storage must have \"%s\" status, but it actually has \"%s\" status. Business object data: {%s}", STORAGE_NAME, "RESTORED", STORAGE_UNIT_STATUS, BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataEntityAltKeyToString(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testPrepareToExpireStorageUnit() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStorageUnitKey storageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(STORAGE_NAME);
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setBusinessObjectFormat(businessObjectFormatEntity);
        final StorageUnitStatusEntity newStorageUnitStatusEntity = new StorageUnitStatusEntity();
        newStorageUnitStatusEntity.setCode("EXPIRING");
        StorageUnitStatusEntity oldStorageUnitStatusEntity = new StorageUnitStatusEntity();
        oldStorageUnitStatusEntity.setCode("RESTORED");
        List<StorageFileEntity> storageFileEntities = Arrays.asList(new StorageFileEntity());
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStorage(storageEntity);
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStatus(oldStorageUnitStatusEntity);
        storageUnitEntity.setStorageFiles(storageFileEntities);
        List<StorageFile> storageFiles = Arrays.asList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT));
        Mockito.when((Object)this.businessObjectDataHelper.createBusinessObjectDataKeyFromStorageUnitKey(storageUnitKey)).thenReturn((Object)businessObjectDataKey);
        Mockito.when((Object)this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity)).thenReturn((Object)storageUnitEntity);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME)).thenReturn((Object)S3_ATTRIBUTE_NAME_BUCKET_NAME);
        Mockito.when((Object)this.storageHelper.getStorageAttributeValueByName(S3_ATTRIBUTE_NAME_BUCKET_NAME, storageEntity, true)).thenReturn((Object)S3_BUCKET_NAME);
        Mockito.when((Object)this.s3KeyPrefixHelper.buildS3KeyPrefix(storageEntity, businessObjectFormatEntity, businessObjectDataKey)).thenReturn((Object)S3_KEY_PREFIX);
        Mockito.when((Object)this.storageFileHelper.getAndValidateStorageFiles(storageUnitEntity, S3_KEY_PREFIX, STORAGE_NAME, businessObjectDataKey)).thenReturn(storageFiles);
        ((StorageUnitDaoHelper)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                StorageUnitEntity storageUnitEntity = (StorageUnitEntity)invocation.getArguments()[0];
                storageUnitEntity.setStatus(newStorageUnitStatusEntity);
                return null;
            }
        }).when((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "EXPIRING", "EXPIRING");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.S3_ENDPOINT)).thenReturn((Object)S3_ENDPOINT);
        BusinessObjectDataRestoreDto result = this.expireRestoredBusinessObjectDataHelperServiceImpl.prepareToExpireStorageUnit(storageUnitKey);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).createBusinessObjectDataKeyFromStorageUnitKey(storageUnitKey);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getStorageAttributeValueByName(S3_ATTRIBUTE_NAME_BUCKET_NAME, storageEntity, true);
        ((S3KeyPrefixHelper)Mockito.verify((Object)this.s3KeyPrefixHelper)).buildS3KeyPrefix(storageEntity, businessObjectFormatEntity, businessObjectDataKey);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).getAndValidateStorageFiles(storageUnitEntity, S3_KEY_PREFIX, STORAGE_NAME, businessObjectDataKey);
        ((StorageFileDaoHelper)Mockito.verify((Object)this.storageFileDaoHelper)).validateStorageFilesCount(STORAGE_NAME, businessObjectDataKey, S3_KEY_PREFIX, storageFiles.size());
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "EXPIRING", "EXPIRING");
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.S3_ENDPOINT);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, "EXPIRING", "RESTORED", storageFiles, NO_EXCEPTION), (Object)result);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataDaoHelper, this.businessObjectDataHelper, this.configurationHelper, this.s3KeyPrefixHelper, this.s3Service, this.storageFileDaoHelper, this.storageFileHelper, this.storageHelper, this.storageUnitDaoHelper});
    }
}

