/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.BusinessObjectDataDao;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.exception.CredStashGetCredentialFailedException;
import org.finra.herd.dao.helper.CredStashHelper;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.RelationalStorageAttributesDto;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectFormatService;
import org.finra.herd.service.MessageNotificationEventService;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.BusinessObjectDataStatusDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionDaoHelper;
import org.finra.herd.service.helper.BusinessObjectFormatDaoHelper;
import org.finra.herd.service.helper.BusinessObjectFormatHelper;
import org.finra.herd.service.helper.DataProviderDaoHelper;
import org.finra.herd.service.helper.NamespaceDaoHelper;
import org.finra.herd.service.helper.SearchIndexUpdateHelper;
import org.finra.herd.service.helper.StorageDaoHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.finra.herd.service.helper.StorageUnitStatusDaoHelper;
import org.finra.herd.service.impl.RelationalTableRegistrationHelperServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RelationalTableRegistrationHelperServiceImplTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private BusinessObjectDataDao businessObjectDataDao;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Mock
    private BusinessObjectDataStatusDaoHelper businessObjectDataStatusDaoHelper;
    @Mock
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Mock
    private BusinessObjectDefinitionDaoHelper businessObjectDefinitionDaoHelper;
    @Mock
    private BusinessObjectFormatDaoHelper businessObjectFormatDaoHelper;
    @Mock
    private BusinessObjectFormatHelper businessObjectFormatHelper;
    @Mock
    private BusinessObjectFormatService businessObjectFormatService;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private CredStashHelper credStashHelper;
    @Mock
    private DataProviderDaoHelper dataProviderDaoHelper;
    @Mock
    private MessageNotificationEventService messageNotificationEventService;
    @Mock
    private NamespaceDaoHelper namespaceDaoHelper;
    @InjectMocks
    private RelationalTableRegistrationHelperServiceImpl relationalTableRegistrationHelperServiceImpl;
    @Mock
    private SearchIndexUpdateHelper searchIndexUpdateHelper;
    @Mock
    private StorageDaoHelper storageDaoHelper;
    @Mock
    private StorageHelper storageHelper;
    @Mock
    private StorageUnitStatusDaoHelper storageUnitStatusDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testGetPassword() throws Exception {
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.CREDSTASH_RELATIONAL_STORAGE_ENCRYPTION_CONTEXT)).thenReturn((Object)CREDSTASH_ENCRYPTION_CONTEXT);
        Mockito.when((Object)this.credStashHelper.getCredentialFromCredStash(CREDSTASH_ENCRYPTION_CONTEXT, USER_CREDENTIAL_NAME)).thenReturn((Object)PASSWORD);
        String result = this.relationalTableRegistrationHelperServiceImpl.getPassword(new RelationalStorageAttributesDto("jdbc:h2:mem:herdTestDb", USERNAME, USER_CREDENTIAL_NAME));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.CREDSTASH_RELATIONAL_STORAGE_ENCRYPTION_CONTEXT);
        ((CredStashHelper)Mockito.verify((Object)this.credStashHelper)).getCredentialFromCredStash(CREDSTASH_ENCRYPTION_CONTEXT, USER_CREDENTIAL_NAME);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)PASSWORD, (Object)result);
    }

    @Test
    public void testGetPasswordCredStashException() throws Exception {
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.CREDSTASH_RELATIONAL_STORAGE_ENCRYPTION_CONTEXT)).thenReturn((Object)CREDSTASH_ENCRYPTION_CONTEXT);
        Mockito.when((Object)this.credStashHelper.getCredentialFromCredStash(CREDSTASH_ENCRYPTION_CONTEXT, USER_CREDENTIAL_NAME)).thenThrow(new Throwable[]{new CredStashGetCredentialFailedException(ERROR_MESSAGE)});
        try {
            this.relationalTableRegistrationHelperServiceImpl.getPassword(new RelationalStorageAttributesDto("jdbc:h2:mem:herdTestDb", USERNAME, USER_CREDENTIAL_NAME));
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("%s: %s", CredStashGetCredentialFailedException.class.getName(), ERROR_MESSAGE), (Object)e.getMessage());
        }
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.CREDSTASH_RELATIONAL_STORAGE_ENCRYPTION_CONTEXT);
        ((CredStashHelper)Mockito.verify((Object)this.credStashHelper)).getCredentialFromCredStash(CREDSTASH_ENCRYPTION_CONTEXT, USER_CREDENTIAL_NAME);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetPasswordNoUserCredentialName() {
        String result = this.relationalTableRegistrationHelperServiceImpl.getPassword(new RelationalStorageAttributesDto("jdbc:h2:mem:herdTestDb", USERNAME, NO_USER_CREDENTIAL_NAME));
        this.verifyNoMoreInteractionsHelper();
        Assert.assertNull((Object)result);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDataDao, this.businessObjectDataHelper, this.businessObjectDataStatusDaoHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionDaoHelper, this.businessObjectFormatDaoHelper, this.businessObjectFormatHelper, this.businessObjectFormatService, this.configurationHelper, this.credStashHelper, this.dataProviderDaoHelper, this.messageNotificationEventService, this.namespaceDaoHelper, this.searchIndexUpdateHelper, this.storageDaoHelper, this.storageHelper, this.storageUnitStatusDaoHelper});
    }
}

