/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.IndexFunctionsDao;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.finra.herd.service.helper.SearchIndexDaoHelper;
import org.finra.herd.service.impl.SearchIndexHelperServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SearchIndexHelperServiceImplTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Mock
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @Mock
    private SearchIndexDaoHelper searchIndexDaoHelper;
    @InjectMocks
    private SearchIndexHelperServiceImpl searchIndexHelperServiceImpl;
    @Mock
    private IndexFunctionsDao indexFunctionsDao;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testValidateSearchIndexSizeValidationFails() {
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE)).thenReturn((Object)1L);
        boolean response = this.searchIndexHelperServiceImpl.validateSearchIndexSize(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE, 2);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.indexFunctionsDao, this.searchIndexDaoHelper});
        Assert.assertFalse((boolean)response);
    }

    @Test
    public void testValidateSearchIndexSizeValidationPasses() {
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE)).thenReturn((Object)2L);
        boolean response = this.searchIndexHelperServiceImpl.validateSearchIndexSize(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE, 2);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.indexFunctionsDao, this.searchIndexDaoHelper});
        Assert.assertTrue((boolean)response);
    }
}

