/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import java.sql.Timestamp;
import java.util.concurrent.Future;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.DocsStats;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.IndexFunctionsDao;
import org.finra.herd.dao.SearchIndexDao;
import org.finra.herd.dao.TagDao;
import org.finra.herd.model.api.xml.SearchIndex;
import org.finra.herd.model.api.xml.SearchIndexCreateRequest;
import org.finra.herd.model.api.xml.SearchIndexKey;
import org.finra.herd.model.api.xml.SearchIndexStatistics;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.SearchIndexEntity;
import org.finra.herd.model.jpa.SearchIndexStatusEntity;
import org.finra.herd.model.jpa.SearchIndexTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.SearchIndexHelperService;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.finra.herd.service.helper.ConfigurationDaoHelper;
import org.finra.herd.service.helper.SearchIndexDaoHelper;
import org.finra.herd.service.helper.SearchIndexStatusDaoHelper;
import org.finra.herd.service.helper.SearchIndexTypeDaoHelper;
import org.finra.herd.service.impl.SearchIndexServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SearchIndexServiceImplTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Mock
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @Mock
    private ConfigurationDaoHelper configurationDaoHelper;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private IndexFunctionsDao indexFunctionDao;
    @Mock
    private SearchIndexDao searchIndexDao;
    @Mock
    private SearchIndexDaoHelper searchIndexDaoHelper;
    @Mock
    private SearchIndexHelperService searchIndexHelperService;
    @InjectMocks
    private SearchIndexServiceImpl searchIndexServiceImpl;
    @Mock
    private SearchIndexStatusDaoHelper searchIndexStatusDaoHelper;
    @Mock
    private SearchIndexTypeDaoHelper searchIndexTypeDaoHelper;
    @Mock
    private TagDao tagDao;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCreateSearchIndexEntity() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        SearchIndexCreateRequest searchIndexCreateRequest = new SearchIndexCreateRequest(SEARCH_INDEX_TYPE);
        SearchIndexTypeEntity searchIndexTypeEntity = new SearchIndexTypeEntity();
        searchIndexTypeEntity.setCode(SEARCH_INDEX_TYPE);
        SearchIndexStatusEntity searchIndexStatusEntity = new SearchIndexStatusEntity();
        searchIndexStatusEntity.setCode(SEARCH_INDEX_STATUS);
        SearchIndexEntity searchIndexEntity = this.searchIndexServiceImpl.createSearchIndexEntity(searchIndexCreateRequest, searchIndexTypeEntity, searchIndexStatusEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
        Assert.assertNotNull((Object)searchIndexEntity);
        Assert.assertNotNull((Object)searchIndexEntity.getType());
        Assert.assertEquals((Object)SEARCH_INDEX_TYPE, (Object)searchIndexEntity.getType().getCode());
        Assert.assertNotNull((Object)searchIndexEntity.getStatus());
        Assert.assertEquals((Object)SEARCH_INDEX_STATUS, (Object)searchIndexEntity.getStatus().getCode());
        Assert.assertNull((Object)searchIndexEntity.getCreatedBy());
        Assert.assertNull((Object)searchIndexEntity.getCreatedOn());
        Assert.assertNull((Object)searchIndexEntity.getUpdatedBy());
        Assert.assertNull((Object)searchIndexEntity.getUpdatedOn());
    }

    @Test
    public void testCreateSearchIndexFromEntity() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        SearchIndexTypeEntity searchIndexTypeEntity = new SearchIndexTypeEntity();
        searchIndexTypeEntity.setCode(SEARCH_INDEX_TYPE);
        SearchIndexStatusEntity searchIndexStatusEntity = new SearchIndexStatusEntity();
        searchIndexStatusEntity.setCode(SEARCH_INDEX_STATUS);
        SearchIndexEntity searchIndexEntity = new SearchIndexEntity();
        searchIndexEntity.setName(SEARCH_INDEX_NAME);
        searchIndexEntity.setType(searchIndexTypeEntity);
        searchIndexEntity.setStatus(searchIndexStatusEntity);
        searchIndexEntity.setCreatedBy(USER_ID);
        searchIndexEntity.setCreatedOn(new Timestamp(CREATED_ON.toGregorianCalendar().getTimeInMillis()));
        searchIndexEntity.setUpdatedOn(new Timestamp(UPDATED_ON.toGregorianCalendar().getTimeInMillis()));
        searchIndexEntity.setActive(Boolean.FALSE);
        SearchIndex searchIndex = this.searchIndexServiceImpl.createSearchIndexFromEntity(searchIndexEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.configurationHelper, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
        Assert.assertEquals((Object)new SearchIndex(searchIndexKey, SEARCH_INDEX_TYPE, SEARCH_INDEX_STATUS, SEARCH_INDEX_DEFAULT_ACTIVE_FLAG.booleanValue(), NO_SEARCH_INDEX_STATISTICS, USER_ID, CREATED_ON, UPDATED_ON), (Object)searchIndex);
    }

    @Test
    public void testCreateSearchIndexHelper() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        String searchIndexType = SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name();
        Future mockedFuture = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)"bdef");
        Mockito.when((Object)this.configurationDaoHelper.getClobProperty(ConfigurationValue.ELASTICSEARCH_BDEF_MAPPINGS_JSON.getKey())).thenReturn((Object)SEARCH_INDEX_MAPPING);
        Mockito.when((Object)this.configurationDaoHelper.getClobProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SETTINGS_JSON.getKey())).thenReturn((Object)SEARCH_INDEX_SETTINGS);
        Mockito.when((Object)this.searchIndexHelperService.indexAllBusinessObjectDefinitions(searchIndexKey, SEARCH_INDEX_DOCUMENT_TYPE)).thenReturn((Object)mockedFuture);
        this.searchIndexServiceImpl.createSearchIndexHelper(searchIndexKey, searchIndexType);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationDaoHelper)Mockito.verify((Object)this.configurationDaoHelper)).getClobProperty(ConfigurationValue.ELASTICSEARCH_BDEF_MAPPINGS_JSON.getKey());
        ((ConfigurationDaoHelper)Mockito.verify((Object)this.configurationDaoHelper)).getClobProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SETTINGS_JSON.getKey());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionDao)).createIndex((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any());
        ((SearchIndexHelperService)Mockito.verify((Object)this.searchIndexHelperService)).indexAllBusinessObjectDefinitions(searchIndexKey, SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.indexFunctionDao, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
    }

    @Test
    public void testCreateSearchIndexHelperInvalidSearchIndexType() {
        try {
            this.searchIndexServiceImpl.createSearchIndexHelper(new SearchIndexKey(SEARCH_INDEX_NAME), SEARCH_INDEX_TYPE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Search index type with code \"%s\" is not supported.", SEARCH_INDEX_TYPE), (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.configurationHelper, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
    }

    @Test
    public void testCreateSearchIndexStatisticsNoIndexCreationDate() {
        ImmutableOpenMap getIndexResponseSettings = ImmutableOpenMap.builder().fPut((Object)SEARCH_INDEX_NAME, (Object)Settings.builder().put("index.uuid", SEARCH_INDEX_STATISTICS_INDEX_UUID).build()).build();
        DocsStats mockedDocsStats = (DocsStats)Mockito.mock(DocsStats.class);
        Mockito.when((Object)mockedDocsStats.getCount()).thenReturn((Object)SEARCH_INDEX_STATISTICS_NUMBER_OF_ACTIVE_DOCUMENTS);
        Mockito.when((Object)mockedDocsStats.getDeleted()).thenReturn((Object)SEARCH_INDEX_STATISTICS_NUMBER_OF_DELETED_DOCUMENTS);
        SearchIndexStatistics response = this.searchIndexServiceImpl.createSearchIndexStatistics((Settings)getIndexResponseSettings.get((Object)SEARCH_INDEX_NAME), mockedDocsStats, 0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.configurationHelper, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
        Assert.assertEquals((Object)new SearchIndexStatistics(NO_SEARCH_INDEX_STATISTICS_CREATION_DATE, SEARCH_INDEX_STATISTICS_NUMBER_OF_ACTIVE_DOCUMENTS, SEARCH_INDEX_STATISTICS_NUMBER_OF_DELETED_DOCUMENTS, SEARCH_INDEX_STATISTICS_INDEX_UUID, Long.valueOf(0L)), (Object)response);
    }

    @Test
    public void testDeleteSearchIndexHelperIndexAlreadyExists() {
        Mockito.when((Object)this.indexFunctionDao.isIndexExists(SEARCH_INDEX_NAME)).thenReturn((Object)true);
        ((IndexFunctionsDao)Mockito.doNothing().when((Object)this.indexFunctionDao)).deleteIndex(SEARCH_INDEX_NAME);
        this.searchIndexServiceImpl.deleteSearchIndexHelper(SEARCH_INDEX_NAME);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionDao)).isIndexExists(SEARCH_INDEX_NAME);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionDao)).deleteIndex(SEARCH_INDEX_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.configurationHelper, this.indexFunctionDao, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
    }

    @Test
    public void testDeleteSearchIndexHelperIndexNoExists() {
        Mockito.when((Object)this.indexFunctionDao.isIndexExists(SEARCH_INDEX_NAME)).thenReturn((Object)false);
        this.searchIndexServiceImpl.deleteSearchIndexHelper(SEARCH_INDEX_NAME);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionDao)).isIndexExists(SEARCH_INDEX_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.configurationHelper, this.indexFunctionDao, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
    }
}

