/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.finra.herd.dao.BusinessObjectDataDao;
import org.finra.herd.dao.SqsDao;
import org.finra.herd.dao.helper.AwsHelper;
import org.finra.herd.dao.helper.HerdStringHelper;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.dao.impl.HerdDaoImpl;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.StoragePolicyPriorityLevel;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.impl.StoragePolicySelectorServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class StoragePolicySelectorServiceImplTest
extends AbstractServiceTest {
    @Mock
    private AwsHelper awsHelper;
    @Mock
    private BusinessObjectDataDao businessObjectDataDao;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Mock
    private HerdDaoImpl herdDao;
    @Mock
    private HerdStringHelper herdStringHelper;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private SqsDao sqsDao;
    @InjectMocks
    private StoragePolicySelectorServiceImpl storagePolicySelectorServiceImpl;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCompleteStoragePolicyTransitionImpl() {
        Timestamp currentTimestamp = new Timestamp(LONG_VALUE);
        Integer maxResults = 10;
        Integer updatedOnThresholdInDays = 90;
        Integer storagePolicyTransitionMaxAllowedAttempts = 3;
        HashMap noMatchingBusinessObjectDataEntities = new HashMap();
        ArrayList storagePolicySelections = new ArrayList();
        Mockito.when((Object)this.herdDao.getCurrentTimestamp()).thenReturn((Object)currentTimestamp);
        Mockito.when((Object)this.herdStringHelper.getConfigurationValueAsInteger(ConfigurationValue.STORAGE_POLICY_PROCESSOR_BDATA_UPDATED_ON_THRESHOLD_DAYS)).thenReturn((Object)updatedOnThresholdInDays);
        Mockito.when((Object)this.businessObjectDataDao.getBusinessObjectDataEntitiesMatchingStoragePolicies((StoragePolicyPriorityLevel)StoragePolicySelectorServiceImpl.STORAGE_POLICY_PRIORITY_LEVELS.get(0), StoragePolicySelectorServiceImpl.SUPPORTED_BUSINESS_OBJECT_DATA_STATUSES, storagePolicyTransitionMaxAllowedAttempts.intValue(), 0, maxResults.intValue())).thenReturn(noMatchingBusinessObjectDataEntities);
        Mockito.when((Object)this.businessObjectDataDao.getBusinessObjectDataEntitiesMatchingStoragePolicies((StoragePolicyPriorityLevel)StoragePolicySelectorServiceImpl.STORAGE_POLICY_PRIORITY_LEVELS.get(1), StoragePolicySelectorServiceImpl.SUPPORTED_BUSINESS_OBJECT_DATA_STATUSES, storagePolicyTransitionMaxAllowedAttempts.intValue(), 0, maxResults.intValue())).thenReturn(noMatchingBusinessObjectDataEntities);
        Mockito.when((Object)this.businessObjectDataDao.getBusinessObjectDataEntitiesMatchingStoragePolicies((StoragePolicyPriorityLevel)StoragePolicySelectorServiceImpl.STORAGE_POLICY_PRIORITY_LEVELS.get(2), StoragePolicySelectorServiceImpl.SUPPORTED_BUSINESS_OBJECT_DATA_STATUSES, storagePolicyTransitionMaxAllowedAttempts.intValue(), 0, maxResults.intValue())).thenReturn(noMatchingBusinessObjectDataEntities);
        Mockito.when((Object)this.businessObjectDataDao.getBusinessObjectDataEntitiesMatchingStoragePolicies((StoragePolicyPriorityLevel)StoragePolicySelectorServiceImpl.STORAGE_POLICY_PRIORITY_LEVELS.get(3), StoragePolicySelectorServiceImpl.SUPPORTED_BUSINESS_OBJECT_DATA_STATUSES, storagePolicyTransitionMaxAllowedAttempts.intValue(), 0, maxResults.intValue())).thenReturn(noMatchingBusinessObjectDataEntities);
        Mockito.when((Object)this.herdStringHelper.getConfigurationValueAsInteger(ConfigurationValue.STORAGE_POLICY_TRANSITION_MAX_ALLOWED_ATTEMPTS)).thenReturn((Object)storagePolicyTransitionMaxAllowedAttempts);
        List result = this.storagePolicySelectorServiceImpl.execute("AWS_SQS_QUEUE_NAME", maxResults.intValue());
        ((HerdDaoImpl)Mockito.verify((Object)this.herdDao)).getCurrentTimestamp();
        ((HerdStringHelper)Mockito.verify((Object)this.herdStringHelper)).getConfigurationValueAsInteger(ConfigurationValue.STORAGE_POLICY_PROCESSOR_BDATA_UPDATED_ON_THRESHOLD_DAYS);
        ((HerdStringHelper)Mockito.verify((Object)this.herdStringHelper)).getConfigurationValueAsInteger(ConfigurationValue.STORAGE_POLICY_TRANSITION_MAX_ALLOWED_ATTEMPTS);
        ((BusinessObjectDataDao)Mockito.verify((Object)this.businessObjectDataDao)).getBusinessObjectDataEntitiesMatchingStoragePolicies((StoragePolicyPriorityLevel)StoragePolicySelectorServiceImpl.STORAGE_POLICY_PRIORITY_LEVELS.get(0), StoragePolicySelectorServiceImpl.SUPPORTED_BUSINESS_OBJECT_DATA_STATUSES, storagePolicyTransitionMaxAllowedAttempts.intValue(), 0, maxResults.intValue());
        ((BusinessObjectDataDao)Mockito.verify((Object)this.businessObjectDataDao)).getBusinessObjectDataEntitiesMatchingStoragePolicies((StoragePolicyPriorityLevel)StoragePolicySelectorServiceImpl.STORAGE_POLICY_PRIORITY_LEVELS.get(1), StoragePolicySelectorServiceImpl.SUPPORTED_BUSINESS_OBJECT_DATA_STATUSES, storagePolicyTransitionMaxAllowedAttempts.intValue(), 0, maxResults.intValue());
        ((BusinessObjectDataDao)Mockito.verify((Object)this.businessObjectDataDao)).getBusinessObjectDataEntitiesMatchingStoragePolicies((StoragePolicyPriorityLevel)StoragePolicySelectorServiceImpl.STORAGE_POLICY_PRIORITY_LEVELS.get(2), StoragePolicySelectorServiceImpl.SUPPORTED_BUSINESS_OBJECT_DATA_STATUSES, storagePolicyTransitionMaxAllowedAttempts.intValue(), 0, maxResults.intValue());
        ((BusinessObjectDataDao)Mockito.verify((Object)this.businessObjectDataDao)).getBusinessObjectDataEntitiesMatchingStoragePolicies((StoragePolicyPriorityLevel)StoragePolicySelectorServiceImpl.STORAGE_POLICY_PRIORITY_LEVELS.get(3), StoragePolicySelectorServiceImpl.SUPPORTED_BUSINESS_OBJECT_DATA_STATUSES, storagePolicyTransitionMaxAllowedAttempts.intValue(), 0, maxResults.intValue());
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals(storagePolicySelections, (Object)result);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.awsHelper, this.businessObjectDataDao, this.businessObjectDataHelper, this.herdDao, this.herdStringHelper, this.jsonHelper, this.sqsDao});
    }
}

