/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ExecutionQuery;
import org.activiti.engine.runtime.JobQuery;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.model.api.xml.JobStatusEnum;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.impl.ActivitiServiceImpl;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ActivitiServiceTest {
    @InjectMocks
    private ActivitiServiceImpl activitiService;
    @Mock
    private HistoryService activitiHistoryService;
    @Mock
    private ManagementService activitiManagementService;
    @Mock
    private RepositoryService activitiRepositoryService;
    @Mock
    private RuntimeService activitiRuntimeService;
    @Mock
    private ConfigurationHelper configurationHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testGetProcessDefinitionById() {
        String processDefinitionId = "processDefinitionId";
        ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)Mockito.mock(ProcessDefinitionQuery.class);
        Mockito.when((Object)this.activitiRepositoryService.createProcessDefinitionQuery()).thenReturn((Object)processDefinitionQuery);
        Mockito.when((Object)processDefinitionQuery.processDefinitionId(processDefinitionId)).thenReturn((Object)processDefinitionQuery);
        ProcessDefinition expectedProcessDefinition = (ProcessDefinition)Mockito.mock(ProcessDefinition.class);
        Mockito.when((Object)processDefinitionQuery.singleResult()).thenReturn((Object)expectedProcessDefinition);
        ProcessDefinition actualProcessDefinition = this.activitiService.getProcessDefinitionById(processDefinitionId);
        Assert.assertSame((Object)expectedProcessDefinition, (Object)actualProcessDefinition);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{processDefinitionQuery});
        ((ProcessDefinitionQuery)inOrder.verify((Object)processDefinitionQuery)).processDefinitionId(processDefinitionId);
        ((ProcessDefinitionQuery)inOrder.verify((Object)processDefinitionQuery)).singleResult();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testStartProcessInstanceByProcessDefinitionId() {
        String processDefinitionId = "processDefinitionId";
        HashMap variables = new HashMap();
        ProcessInstance expectedProcessInstance = (ProcessInstance)Mockito.mock(ProcessInstance.class);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.HERD_ENVIRONMENT)).thenReturn((Object)"DEV");
        Mockito.when((Object)this.activitiRuntimeService.startProcessInstanceById(processDefinitionId, variables)).thenReturn((Object)expectedProcessInstance);
        ProcessInstance actualProcessInstance = this.activitiService.startProcessInstanceByProcessDefinitionId(processDefinitionId, variables);
        Assert.assertSame((Object)expectedProcessInstance, (Object)actualProcessInstance);
        ((RuntimeService)Mockito.verify((Object)this.activitiRuntimeService)).startProcessInstanceById(processDefinitionId, variables);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.activitiRuntimeService});
    }

    @Test
    public void testGetProcessInstanceById() {
        String processInstanceId = "processInstanceId";
        ProcessInstanceQuery processInstanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)this.activitiRuntimeService.createProcessInstanceQuery()).thenReturn((Object)processInstanceQuery);
        Mockito.when((Object)processInstanceQuery.processInstanceId(processInstanceId)).thenReturn((Object)processInstanceQuery);
        Mockito.when((Object)processInstanceQuery.includeProcessVariables()).thenReturn((Object)processInstanceQuery);
        ProcessInstance expectedProcessInstance = (ProcessInstance)Mockito.mock(ProcessInstance.class);
        Mockito.when((Object)processInstanceQuery.singleResult()).thenReturn((Object)expectedProcessInstance);
        ProcessInstance actualProcessInstance = this.activitiService.getProcessInstanceById(processInstanceId);
        Assert.assertSame((Object)expectedProcessInstance, (Object)actualProcessInstance);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{processInstanceQuery});
        ((ProcessInstanceQuery)inOrder.verify((Object)processInstanceQuery)).processInstanceId(processInstanceId);
        ((ProcessInstanceQuery)inOrder.verify((Object)processInstanceQuery)).includeProcessVariables();
        ((ProcessInstanceQuery)inOrder.verify((Object)processInstanceQuery)).singleResult();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testGetHistoricProcessInstanceByProcessInstanceId() {
        String processInstanceId = "processInstanceId";
        HistoricProcessInstanceQuery historicProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.activitiHistoryService.createHistoricProcessInstanceQuery()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.processInstanceId(processInstanceId)).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.includeProcessVariables()).thenReturn((Object)historicProcessInstanceQuery);
        HistoricProcessInstance expectedHistoricProcessInstance = (HistoricProcessInstance)Mockito.mock(HistoricProcessInstance.class);
        Mockito.when((Object)historicProcessInstanceQuery.singleResult()).thenReturn((Object)expectedHistoricProcessInstance);
        HistoricProcessInstance actualHistoricProcessInstance = this.activitiService.getHistoricProcessInstanceByProcessInstanceId(processInstanceId);
        Assert.assertSame((Object)expectedHistoricProcessInstance, (Object)actualHistoricProcessInstance);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{historicProcessInstanceQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).processInstanceId(processInstanceId);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).includeProcessVariables();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).singleResult();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testGetHistoricActivityInstancesByProcessInstanceId() {
        String processInstanceId = "processInstanceId";
        HistoricActivityInstanceQuery historicActivityInstanceQuery = (HistoricActivityInstanceQuery)Mockito.mock(HistoricActivityInstanceQuery.class);
        Mockito.when((Object)this.activitiHistoryService.createHistoricActivityInstanceQuery()).thenReturn((Object)historicActivityInstanceQuery);
        Mockito.when((Object)historicActivityInstanceQuery.processInstanceId(processInstanceId)).thenReturn((Object)historicActivityInstanceQuery);
        Mockito.when((Object)historicActivityInstanceQuery.orderByHistoricActivityInstanceStartTime()).thenReturn((Object)historicActivityInstanceQuery);
        Mockito.when((Object)historicActivityInstanceQuery.asc()).thenReturn((Object)historicActivityInstanceQuery);
        Mockito.when((Object)historicActivityInstanceQuery.orderByHistoricActivityInstanceEndTime()).thenReturn((Object)historicActivityInstanceQuery);
        Mockito.when((Object)historicActivityInstanceQuery.asc()).thenReturn((Object)historicActivityInstanceQuery);
        ArrayList expectedHistoricActivityInstances = new ArrayList();
        Mockito.when((Object)historicActivityInstanceQuery.list()).thenReturn(expectedHistoricActivityInstances);
        List actualHistoricActivityInstances = this.activitiService.getHistoricActivityInstancesByProcessInstanceId(processInstanceId);
        Assert.assertSame(expectedHistoricActivityInstances, (Object)actualHistoricActivityInstances);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{historicActivityInstanceQuery});
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)historicActivityInstanceQuery)).processInstanceId(processInstanceId);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)historicActivityInstanceQuery)).orderByHistoricActivityInstanceStartTime();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)historicActivityInstanceQuery)).asc();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)historicActivityInstanceQuery)).orderByHistoricActivityInstanceEndTime();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)historicActivityInstanceQuery)).asc();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)historicActivityInstanceQuery)).list();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testGetJobsWithExceptionByProcessInstanceId() {
        String processInstanceId = "processInstanceId";
        JobQuery jobQuery = (JobQuery)Mockito.mock(JobQuery.class);
        Mockito.when((Object)this.activitiManagementService.createJobQuery()).thenReturn((Object)jobQuery);
        Mockito.when((Object)jobQuery.withException()).thenReturn((Object)jobQuery);
        Mockito.when((Object)jobQuery.processInstanceId(processInstanceId)).thenReturn((Object)jobQuery);
        ArrayList expectedJobs = new ArrayList();
        Mockito.when((Object)jobQuery.list()).thenReturn(expectedJobs);
        List actualJobs = this.activitiService.getJobsWithExceptionByProcessInstanceId(processInstanceId);
        Assert.assertSame(expectedJobs, (Object)actualJobs);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{jobQuery});
        ((JobQuery)inOrder.verify((Object)jobQuery)).withException();
        ((JobQuery)inOrder.verify((Object)jobQuery)).processInstanceId(processInstanceId);
        ((JobQuery)inOrder.verify((Object)jobQuery)).list();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testGetJobExceptionStacktrace() {
        String jobId = "jobId";
        String expectedResult = "expectedResult";
        Mockito.when((Object)this.activitiManagementService.getJobExceptionStacktrace(jobId)).thenReturn((Object)expectedResult);
        String actualResult = this.activitiService.getJobExceptionStacktrace(jobId);
        Assert.assertSame((Object)expectedResult, (Object)actualResult);
        ((ManagementService)Mockito.verify((Object)this.activitiManagementService)).getJobExceptionStacktrace(jobId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.activitiManagementService});
    }

    @Test
    public void testGetProcessDefinitionsByIds() {
        HashSet processDefinitionIds = new HashSet();
        ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)Mockito.mock(ProcessDefinitionQuery.class);
        Mockito.when((Object)this.activitiRepositoryService.createProcessDefinitionQuery()).thenReturn((Object)processDefinitionQuery);
        Mockito.when((Object)processDefinitionQuery.processDefinitionIds(processDefinitionIds)).thenReturn((Object)processDefinitionQuery);
        ArrayList expectedProcessDefinitions = new ArrayList();
        Mockito.when((Object)processDefinitionQuery.list()).thenReturn(expectedProcessDefinitions);
        List actualProcessDefinitions = this.activitiService.getProcessDefinitionsByIds(processDefinitionIds);
        Assert.assertSame(expectedProcessDefinitions, (Object)actualProcessDefinitions);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{processDefinitionQuery});
        ((ProcessDefinitionQuery)inOrder.verify((Object)processDefinitionQuery)).processDefinitionIds(processDefinitionIds);
        ((ProcessDefinitionQuery)inOrder.verify((Object)processDefinitionQuery)).list();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testGetJobsWithExceptionCountByProcessInstanceId() {
        String processInstanceId = "processInstanceId";
        JobQuery jobQuery = (JobQuery)Mockito.mock(JobQuery.class);
        Mockito.when((Object)this.activitiManagementService.createJobQuery()).thenReturn((Object)jobQuery);
        Mockito.when((Object)jobQuery.withException()).thenReturn((Object)jobQuery);
        Mockito.when((Object)jobQuery.processInstanceId(processInstanceId)).thenReturn((Object)jobQuery);
        long expectedResult = 1234L;
        Mockito.when((Object)jobQuery.count()).thenReturn((Object)expectedResult);
        long actualResult = this.activitiService.getJobsWithExceptionCountByProcessInstanceId(processInstanceId);
        Assert.assertEquals((long)expectedResult, (long)actualResult);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{jobQuery});
        ((JobQuery)inOrder.verify((Object)jobQuery)).withException();
        ((JobQuery)inOrder.verify((Object)jobQuery)).processInstanceId(processInstanceId);
        ((JobQuery)inOrder.verify((Object)jobQuery)).count();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testGetHistoricProcessInstancesByStatusAndProcessDefinitionKeys() {
        JobStatusEnum jobStatus = JobStatusEnum.RUNNING;
        ArrayList processDefinitionKeys = new ArrayList();
        DateTime startTime = new DateTime();
        DateTime endTime = new DateTime();
        HistoricProcessInstanceQuery historicProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.activitiHistoryService.createHistoricProcessInstanceQuery()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.processDefinitionKeyIn(new ArrayList(processDefinitionKeys))).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.unfinished()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.startedAfter(startTime.toDate())).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.finishedBefore(endTime.toDate())).thenReturn((Object)historicProcessInstanceQuery);
        ArrayList expectedHistoricProcessInstances = new ArrayList();
        Mockito.when((Object)historicProcessInstanceQuery.list()).thenReturn(expectedHistoricProcessInstances);
        List actualHistoricProcessInstance = this.activitiService.getHistoricProcessInstancesByStatusAndProcessDefinitionKeys(jobStatus, processDefinitionKeys, startTime, endTime);
        Assert.assertSame(expectedHistoricProcessInstances, (Object)actualHistoricProcessInstance);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{historicProcessInstanceQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).processDefinitionKeyIn(new ArrayList(processDefinitionKeys));
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).unfinished();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).startedAfter(startTime.toDate());
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).finishedBefore(endTime.toDate());
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).list();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testGetHistoricProcessInstancesByStatusAndProcessDefinitionKeysWhenStatusCompleted() {
        JobStatusEnum jobStatus = JobStatusEnum.COMPLETED;
        ArrayList processDefinitionKeys = new ArrayList();
        DateTime startTime = new DateTime();
        DateTime endTime = new DateTime();
        HistoricProcessInstanceQuery historicProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.activitiHistoryService.createHistoricProcessInstanceQuery()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.processDefinitionKeyIn(new ArrayList(processDefinitionKeys))).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.unfinished()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.startedAfter(startTime.toDate())).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.finishedBefore(endTime.toDate())).thenReturn((Object)historicProcessInstanceQuery);
        ArrayList expectedHistoricProcessInstances = new ArrayList();
        Mockito.when((Object)historicProcessInstanceQuery.list()).thenReturn(expectedHistoricProcessInstances);
        List actualHistoricProcessInstance = this.activitiService.getHistoricProcessInstancesByStatusAndProcessDefinitionKeys(jobStatus, processDefinitionKeys, startTime, endTime);
        Assert.assertSame(expectedHistoricProcessInstances, (Object)actualHistoricProcessInstance);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{historicProcessInstanceQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).processDefinitionKeyIn(new ArrayList(processDefinitionKeys));
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).finished();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).startedAfter(startTime.toDate());
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).finishedBefore(endTime.toDate());
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).list();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testGetHistoricProcessInstancesByStatusAndProcessDefinitionKeysWhenStatusNotSpecified() {
        JobStatusEnum jobStatus = null;
        ArrayList processDefinitionKeys = new ArrayList();
        DateTime startTime = new DateTime();
        DateTime endTime = new DateTime();
        HistoricProcessInstanceQuery historicProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.activitiHistoryService.createHistoricProcessInstanceQuery()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.processDefinitionKeyIn(new ArrayList(processDefinitionKeys))).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.unfinished()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.startedAfter(startTime.toDate())).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.finishedBefore(endTime.toDate())).thenReturn((Object)historicProcessInstanceQuery);
        ArrayList expectedHistoricProcessInstances = new ArrayList();
        Mockito.when((Object)historicProcessInstanceQuery.list()).thenReturn(expectedHistoricProcessInstances);
        List actualHistoricProcessInstance = this.activitiService.getHistoricProcessInstancesByStatusAndProcessDefinitionKeys(jobStatus, processDefinitionKeys, startTime, endTime);
        Assert.assertSame(expectedHistoricProcessInstances, (Object)actualHistoricProcessInstance);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{historicProcessInstanceQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).processDefinitionKeyIn(new ArrayList(processDefinitionKeys));
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).startedAfter(startTime.toDate());
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).finishedBefore(endTime.toDate());
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).list();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testGetHistoricProcessInstancesByStatusAndProcessDefinitionKeysWhenStartTimeNotSpecified() {
        JobStatusEnum jobStatus = JobStatusEnum.RUNNING;
        ArrayList processDefinitionKeys = new ArrayList();
        DateTime startTime = null;
        DateTime endTime = new DateTime();
        HistoricProcessInstanceQuery historicProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.activitiHistoryService.createHistoricProcessInstanceQuery()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.processDefinitionKeyIn(new ArrayList(processDefinitionKeys))).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.unfinished()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.finishedBefore(endTime.toDate())).thenReturn((Object)historicProcessInstanceQuery);
        ArrayList expectedHistoricProcessInstances = new ArrayList();
        Mockito.when((Object)historicProcessInstanceQuery.list()).thenReturn(expectedHistoricProcessInstances);
        List actualHistoricProcessInstance = this.activitiService.getHistoricProcessInstancesByStatusAndProcessDefinitionKeys(jobStatus, processDefinitionKeys, startTime, endTime);
        Assert.assertSame(expectedHistoricProcessInstances, (Object)actualHistoricProcessInstance);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{historicProcessInstanceQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).processDefinitionKeyIn(new ArrayList(processDefinitionKeys));
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).unfinished();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).finishedBefore(endTime.toDate());
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).list();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testGetHistoricProcessInstancesByStatusAndProcessDefinitionKeysWhenEndTimeNotSpecified() {
        JobStatusEnum jobStatus = JobStatusEnum.RUNNING;
        ArrayList processDefinitionKeys = new ArrayList();
        DateTime startTime = new DateTime();
        DateTime endTime = null;
        HistoricProcessInstanceQuery historicProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.activitiHistoryService.createHistoricProcessInstanceQuery()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.processDefinitionKeyIn(new ArrayList(processDefinitionKeys))).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.unfinished()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.startedAfter(startTime.toDate())).thenReturn((Object)historicProcessInstanceQuery);
        ArrayList expectedHistoricProcessInstances = new ArrayList();
        Mockito.when((Object)historicProcessInstanceQuery.list()).thenReturn(expectedHistoricProcessInstances);
        List actualHistoricProcessInstance = this.activitiService.getHistoricProcessInstancesByStatusAndProcessDefinitionKeys(jobStatus, processDefinitionKeys, startTime, endTime);
        Assert.assertSame(expectedHistoricProcessInstances, (Object)actualHistoricProcessInstance);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{historicProcessInstanceQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).processDefinitionKeyIn(new ArrayList(processDefinitionKeys));
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).unfinished();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).startedAfter(startTime.toDate());
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).list();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void getHistoricProcessInstancesCountByStatusAndProcessDefinitionKeys() {
        JobStatusEnum jobStatus = JobStatusEnum.RUNNING;
        ArrayList processDefinitionKeys = new ArrayList();
        DateTime startTime = new DateTime();
        DateTime endTime = new DateTime();
        HistoricProcessInstanceQuery historicProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.activitiHistoryService.createHistoricProcessInstanceQuery()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.processDefinitionKeyIn(new ArrayList(processDefinitionKeys))).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.unfinished()).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.startedAfter(startTime.toDate())).thenReturn((Object)historicProcessInstanceQuery);
        Mockito.when((Object)historicProcessInstanceQuery.finishedBefore(endTime.toDate())).thenReturn((Object)historicProcessInstanceQuery);
        long expectedResult = 1234L;
        Mockito.when((Object)historicProcessInstanceQuery.count()).thenReturn((Object)expectedResult);
        long actualResult = this.activitiService.getHistoricProcessInstancesCountByStatusAndProcessDefinitionKeys(jobStatus, processDefinitionKeys, startTime, endTime);
        Assert.assertEquals((long)expectedResult, (long)actualResult);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{historicProcessInstanceQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).processDefinitionKeyIn(new ArrayList(processDefinitionKeys));
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).unfinished();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).startedAfter(startTime.toDate());
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).finishedBefore(endTime.toDate());
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)historicProcessInstanceQuery)).count();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void getExecutionByProcessInstanceIdAndActivitiId() {
        String processInstanceId = "processInstanceId";
        String activitiId = "activitiId";
        ExecutionQuery executionQuery = (ExecutionQuery)Mockito.mock(ExecutionQuery.class);
        Mockito.when((Object)this.activitiRuntimeService.createExecutionQuery()).thenReturn((Object)executionQuery);
        Mockito.when((Object)executionQuery.processInstanceId(processInstanceId)).thenReturn((Object)executionQuery);
        Mockito.when((Object)executionQuery.activityId(activitiId)).thenReturn((Object)executionQuery);
        Execution expectedExecution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)executionQuery.singleResult()).thenReturn((Object)expectedExecution);
        Execution actualExecution = this.activitiService.getExecutionByProcessInstanceIdAndActivitiId(processInstanceId, activitiId);
        Assert.assertSame((Object)expectedExecution, (Object)actualExecution);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{executionQuery});
        ((ExecutionQuery)inOrder.verify((Object)executionQuery)).processInstanceId(processInstanceId);
        ((ExecutionQuery)inOrder.verify((Object)executionQuery)).activityId(activitiId);
        ((ExecutionQuery)inOrder.verify((Object)executionQuery)).singleResult();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testSignal() {
        String executionId = "executionId";
        HashMap processVariables = new HashMap();
        this.activitiService.signal(executionId, processVariables);
        ((RuntimeService)Mockito.verify((Object)this.activitiRuntimeService)).signal(executionId, processVariables);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.activitiRuntimeService});
    }

    @Test
    public void getProcessModel() {
        String processDefinitionId = "processDefinitionId";
        String expectedResult = "expectedResult";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(expectedResult.getBytes());
        Mockito.when((Object)this.activitiRepositoryService.getProcessModel(processDefinitionId)).thenReturn((Object)inputStream);
        String actualResult = this.activitiService.getProcessModel(processDefinitionId);
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
        ((RepositoryService)Mockito.verify((Object)this.activitiRepositoryService)).getProcessModel(processDefinitionId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.activitiRepositoryService});
    }

    @Test
    public void getProcessModelWhenIOExceptionThrown() throws Exception {
        String processDefinitionId = "processDefinitionId";
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inputStream.read()).thenThrow(new Throwable[]{new IOException()});
        Mockito.when((Object)this.activitiRepositoryService.getProcessModel(processDefinitionId)).thenReturn((Object)inputStream);
        try {
            this.activitiService.getProcessModel(processDefinitionId);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertSame(IOException.class, illegalArgumentException.getCause().getClass());
        }
    }

    @Test
    public void testDeleteProcessInstance() {
        String processInstanceId = "processInstanceId";
        String deleteReason = "deleteReason";
        this.activitiService.deleteProcessInstance(processInstanceId, deleteReason);
        ((RuntimeService)Mockito.verify((Object)this.activitiRuntimeService)).deleteProcessInstance(processInstanceId, deleteReason);
    }
}

