/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.Deployment;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivitiTest
extends AbstractServiceTest {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;

    @Test
    public void testDeploySubmitAndDeleteWorkflow() throws Exception {
        String deploymentId = this.deployWorkflow();
        this.submitJob();
        this.deleteWorkflow(deploymentId);
    }

    private String deployWorkflow() throws Exception {
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/finra/herd/service/testHerdWorkflow.bpmn20.xml").deploy();
        Assert.assertNotNull((Object)deployment.getId());
        return deployment.getId();
    }

    private String submitJob() throws Exception {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("testNamespace.testHerdWorkflow").getId();
        Assert.assertNotNull((Object)processInstanceId);
        return processInstanceId;
    }

    private void deleteWorkflow(String deploymentId) throws Exception {
        this.repositoryService.deleteDeployment(deploymentId);
        List deployResources = this.repositoryService.getDeploymentResourceNames(deploymentId);
        Assert.assertTrue((boolean)deployResources.isEmpty());
    }
}

