/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import org.finra.herd.dao.AllowedAttributeValueDao;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.AllowedAttributeValuesCreateRequest;
import org.finra.herd.model.api.xml.AllowedAttributeValuesDeleteRequest;
import org.finra.herd.model.api.xml.AllowedAttributeValuesInformation;
import org.finra.herd.model.api.xml.AttributeValueListKey;
import org.finra.herd.model.jpa.AllowedAttributeValueEntity;
import org.finra.herd.model.jpa.AttributeValueListEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.AttributeValueListDaoHelper;
import org.finra.herd.service.helper.AttributeValueListHelper;
import org.finra.herd.service.impl.AllowedAttributeValueServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class AllowedAttributeValueServiceTest
extends AbstractServiceTest {
    @InjectMocks
    private AllowedAttributeValueServiceImpl allowedAttributeValueService;
    @Mock
    private AllowedAttributeValueDao allowedAttributeValueDao;
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private AttributeValueListDaoHelper attributeValueListDaoHelper;
    @Mock
    private AttributeValueListHelper attributeValueListHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCreateAllowedAttributeValues() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(ATTRIBUTE_VALUE_LIST_NAMESPACE);
        AttributeValueListEntity attributeValueListEntity = new AttributeValueListEntity();
        attributeValueListEntity.setId(Integer.valueOf(1009));
        attributeValueListEntity.setNamespace(namespaceEntity);
        attributeValueListEntity.setName(ATTRIBUTE_VALUE_LIST_NAME);
        attributeValueListEntity.setAllowedAttributeValues(new ArrayList());
        AllowedAttributeValueEntity allowedAttributeValueEntity = new AllowedAttributeValueEntity();
        allowedAttributeValueEntity.setAllowedAttributeValue("Attribute_Value_1");
        allowedAttributeValueEntity.setAttributeValueList(attributeValueListEntity);
        Mockito.when((Object)this.attributeValueListDaoHelper.getAttributeValueListEntity(attributeValueListKey)).thenReturn((Object)attributeValueListEntity);
        Mockito.when((Object)this.allowedAttributeValueDao.saveAndRefresh(Matchers.any(AllowedAttributeValueEntity.class))).thenReturn((Object)allowedAttributeValueEntity);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("An", "allowed attribute value", "Attribute_Value_1")).thenReturn((Object)"Attribute_Value_1");
        AllowedAttributeValuesInformation response = this.allowedAttributeValueService.createAllowedAttributeValues(new AllowedAttributeValuesCreateRequest(attributeValueListKey, Arrays.asList("Attribute_Value_1")));
        ((AttributeValueListDaoHelper)Mockito.verify((Object)this.attributeValueListDaoHelper)).getAttributeValueListEntity(attributeValueListKey);
        ((AllowedAttributeValueDao)Mockito.verify((Object)this.allowedAttributeValueDao, (VerificationMode)Mockito.times((int)1))).saveAndRefresh(Matchers.any(AllowedAttributeValueEntity.class));
        ((AllowedAttributeValueDao)Mockito.verify((Object)this.allowedAttributeValueDao, (VerificationMode)Mockito.times((int)1))).saveAndRefresh(Matchers.any(AttributeValueListEntity.class));
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("An", "allowed attribute value", "Attribute_Value_1");
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListKey(attributeValueListKey);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)attributeValueListKey, (Object)response.getAttributeValueListKey());
        Assert.assertEquals(Arrays.asList("Attribute_Value_1"), (Object)response.getAllowedAttributeValues());
    }

    @Test
    public void testCreateAllowedAttributeValuesAlreadyExists() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(ATTRIBUTE_VALUE_LIST_NAMESPACE);
        ArrayList<AllowedAttributeValueEntity> allowedAttributeValueEntities = new ArrayList<AllowedAttributeValueEntity>();
        AttributeValueListEntity attributeValueListEntity = new AttributeValueListEntity();
        attributeValueListEntity.setId(Integer.valueOf(1009));
        attributeValueListEntity.setNamespace(namespaceEntity);
        attributeValueListEntity.setName(ATTRIBUTE_VALUE_LIST_NAME);
        attributeValueListEntity.setAllowedAttributeValues(allowedAttributeValueEntities);
        AllowedAttributeValueEntity allowedAttributeValueEntity = new AllowedAttributeValueEntity();
        allowedAttributeValueEntity.setAllowedAttributeValue("Attribute_Value_1");
        allowedAttributeValueEntity.setAttributeValueList(attributeValueListEntity);
        allowedAttributeValueEntities.add(allowedAttributeValueEntity);
        Mockito.when((Object)this.attributeValueListDaoHelper.getAttributeValueListEntity(attributeValueListKey)).thenReturn((Object)attributeValueListEntity);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("An", "allowed attribute value", "Attribute_Value_1")).thenReturn((Object)"Attribute_Value_1");
        try {
            this.allowedAttributeValueService.createAllowedAttributeValues(new AllowedAttributeValuesCreateRequest(attributeValueListKey, Arrays.asList("Attribute_Value_1")));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Allowed attribute value \"%s\" already exists in \"%s\" attribute value list.", "Attribute_Value_1", attributeValueListEntity.getName()), (Object)e.getMessage());
        }
        ((AttributeValueListDaoHelper)Mockito.verify((Object)this.attributeValueListDaoHelper)).getAttributeValueListEntity(attributeValueListKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("An", "allowed attribute value", "Attribute_Value_1");
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListKey(attributeValueListKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCreateAllowedAttributeValuesMissingCreateRequest() {
        try {
            this.allowedAttributeValueService.createAllowedAttributeValues(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An allowed attribute value create request must be specified.", (Object)e.getMessage());
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCreateAllowedAttributeValuesMissingAllowedAttributeValue() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        AllowedAttributeValuesCreateRequest request = new AllowedAttributeValuesCreateRequest(attributeValueListKey, NO_ALLOWED_ATTRIBUTE_VALUES);
        try {
            this.allowedAttributeValueService.createAllowedAttributeValues(request);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one allowed attribute value must be specified.", (Object)e.getMessage());
        }
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListKey(attributeValueListKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteAllowedAttributeValues() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(ATTRIBUTE_VALUE_LIST_NAMESPACE);
        ArrayList<AllowedAttributeValueEntity> allowedAttributeValueEntities = new ArrayList<AllowedAttributeValueEntity>();
        AttributeValueListEntity attributeValueListEntity = new AttributeValueListEntity();
        attributeValueListEntity.setId(Integer.valueOf(1009));
        attributeValueListEntity.setNamespace(namespaceEntity);
        attributeValueListEntity.setName(ATTRIBUTE_VALUE_LIST_NAME);
        attributeValueListEntity.setAllowedAttributeValues(allowedAttributeValueEntities);
        AllowedAttributeValueEntity allowedAttributeValueEntity = new AllowedAttributeValueEntity();
        allowedAttributeValueEntity.setAllowedAttributeValue("Attribute_Value_1");
        allowedAttributeValueEntity.setAttributeValueList(attributeValueListEntity);
        allowedAttributeValueEntities.add(allowedAttributeValueEntity);
        Mockito.when((Object)this.attributeValueListDaoHelper.getAttributeValueListEntity(attributeValueListKey)).thenReturn((Object)attributeValueListEntity);
        Mockito.when((Object)this.allowedAttributeValueDao.saveAndRefresh(Matchers.any(AllowedAttributeValueEntity.class))).thenReturn((Object)allowedAttributeValueEntity);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("An", "allowed attribute value", "Attribute_Value_1")).thenReturn((Object)"Attribute_Value_1");
        AllowedAttributeValuesInformation response = this.allowedAttributeValueService.deleteAllowedAttributeValues(new AllowedAttributeValuesDeleteRequest(attributeValueListKey, Arrays.asList("Attribute_Value_1")));
        ((AttributeValueListDaoHelper)Mockito.verify((Object)this.attributeValueListDaoHelper)).getAttributeValueListEntity(attributeValueListKey);
        ((AllowedAttributeValueDao)Mockito.verify((Object)this.allowedAttributeValueDao)).saveAndRefresh(Matchers.any(AttributeValueListEntity.class));
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("An", "allowed attribute value", "Attribute_Value_1");
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListKey(attributeValueListKey);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)attributeValueListKey, (Object)response.getAttributeValueListKey());
        Assert.assertEquals(Arrays.asList("Attribute_Value_1"), (Object)response.getAllowedAttributeValues());
    }

    @Test
    public void testDeleteAllowedAttributeValuesMissingDeleteRequest() {
        try {
            this.allowedAttributeValueService.deleteAllowedAttributeValues(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An allowed attribute value delete request must be specified.", (Object)e.getMessage());
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteAllowedAttributeValuesMissingAllowedAttributeValue() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        AllowedAttributeValuesDeleteRequest request = new AllowedAttributeValuesDeleteRequest(attributeValueListKey, NO_ALLOWED_ATTRIBUTE_VALUES);
        try {
            this.allowedAttributeValueService.deleteAllowedAttributeValues(request);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one allowed attribute value must be specified.", (Object)e.getMessage());
        }
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListKey(attributeValueListKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteAllowedAttributeValuesDuplicateAttributeValues() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        AllowedAttributeValuesDeleteRequest request = new AllowedAttributeValuesDeleteRequest(attributeValueListKey, Arrays.asList("Attribute_Value_1", "Attribute_Value_1"));
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("An", "allowed attribute value", "Attribute_Value_1")).thenReturn((Object)"Attribute_Value_1");
        try {
            this.allowedAttributeValueService.deleteAllowedAttributeValues(request);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate allowed attribute value \"%s\" found.", "Attribute_Value_1"), (Object)e.getMessage());
        }
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper, (VerificationMode)Mockito.times((int)2))).validateStringParameter("An", "allowed attribute value", "Attribute_Value_1");
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListKey(attributeValueListKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteAllowedAttributeValuesNoExists() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(ATTRIBUTE_VALUE_LIST_NAMESPACE);
        AttributeValueListEntity attributeValueListEntity = new AttributeValueListEntity();
        attributeValueListEntity.setId(Integer.valueOf(1009));
        attributeValueListEntity.setNamespace(namespaceEntity);
        attributeValueListEntity.setName(ATTRIBUTE_VALUE_LIST_NAME);
        attributeValueListEntity.setAllowedAttributeValues(new ArrayList());
        AllowedAttributeValueEntity allowedAttributeValueEntity = new AllowedAttributeValueEntity();
        allowedAttributeValueEntity.setAllowedAttributeValue("Attribute_Value_1");
        allowedAttributeValueEntity.setAttributeValueList(attributeValueListEntity);
        Mockito.when((Object)this.attributeValueListDaoHelper.getAttributeValueListEntity(attributeValueListKey)).thenReturn((Object)attributeValueListEntity);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("An", "allowed attribute value", "Attribute_Value_1")).thenReturn((Object)"Attribute_Value_1");
        try {
            this.allowedAttributeValueService.deleteAllowedAttributeValues(new AllowedAttributeValuesDeleteRequest(attributeValueListKey, Arrays.asList("Attribute_Value_1")));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Allowed attribute value \"%s\" doesn't exist in \"%s\" attribute value list.", "Attribute_Value_1", attributeValueListEntity.getName()), (Object)e.getMessage());
        }
        ((AttributeValueListDaoHelper)Mockito.verify((Object)this.attributeValueListDaoHelper)).getAttributeValueListEntity(attributeValueListKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("An", "allowed attribute value", "Attribute_Value_1");
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListKey(attributeValueListKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetAllowedAttributeValues() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(ATTRIBUTE_VALUE_LIST_NAMESPACE);
        AttributeValueListEntity attributeValueListEntity = new AttributeValueListEntity();
        attributeValueListEntity.setId(Integer.valueOf(1009));
        attributeValueListEntity.setNamespace(namespaceEntity);
        attributeValueListEntity.setName(ATTRIBUTE_VALUE_LIST_NAME);
        attributeValueListEntity.setAllowedAttributeValues(new ArrayList());
        AllowedAttributeValueEntity allowedAttributeValueEntity = new AllowedAttributeValueEntity();
        allowedAttributeValueEntity.setAllowedAttributeValue("Attribute_Value_1");
        allowedAttributeValueEntity.setAttributeValueList(attributeValueListEntity);
        ArrayList<AllowedAttributeValueEntity> allowedAttributeValueEntities = new ArrayList<AllowedAttributeValueEntity>();
        allowedAttributeValueEntities.add(allowedAttributeValueEntity);
        Mockito.when((Object)this.attributeValueListDaoHelper.getAttributeValueListEntity(attributeValueListKey)).thenReturn((Object)attributeValueListEntity);
        Mockito.when((Object)this.allowedAttributeValueDao.getAllowedAttributeValuesByAttributeValueListKey(attributeValueListKey)).thenReturn(allowedAttributeValueEntities);
        AllowedAttributeValuesInformation response = this.allowedAttributeValueService.getAllowedAttributeValues(attributeValueListKey);
        ((AttributeValueListDaoHelper)Mockito.verify((Object)this.attributeValueListDaoHelper)).getAttributeValueListEntity(attributeValueListKey);
        ((AllowedAttributeValueDao)Mockito.verify((Object)this.allowedAttributeValueDao)).getAllowedAttributeValuesByAttributeValueListKey(attributeValueListKey);
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListKey(attributeValueListKey);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)attributeValueListKey, (Object)response.getAttributeValueListKey());
        Assert.assertEquals(Arrays.asList("Attribute_Value_1"), (Object)response.getAllowedAttributeValues());
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.allowedAttributeValueDao, this.attributeValueListDaoHelper, this.alternateKeyHelper, this.attributeValueListHelper});
    }
}

