/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.finra.herd.dao.AttributeValueListDao;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.api.xml.AttributeValueList;
import org.finra.herd.model.api.xml.AttributeValueListCreateRequest;
import org.finra.herd.model.api.xml.AttributeValueListKey;
import org.finra.herd.model.api.xml.AttributeValueListKeys;
import org.finra.herd.model.api.xml.NamespacePermissionEnum;
import org.finra.herd.model.jpa.AttributeValueListEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AttributeValueListDaoHelper;
import org.finra.herd.service.helper.AttributeValueListHelper;
import org.finra.herd.service.helper.NamespaceDaoHelper;
import org.finra.herd.service.helper.NamespaceSecurityHelper;
import org.finra.herd.service.impl.AttributeValueListServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AttributeValueListServiceTest
extends AbstractServiceTest {
    @Mock
    private AttributeValueListDao attributeValueListDao;
    @Mock
    private AttributeValueListDaoHelper attributeValueListDaoHelper;
    @Mock
    private AttributeValueListHelper attributeValueListHelper;
    @InjectMocks
    private AttributeValueListServiceImpl attributeValueListService;
    @Mock
    private NamespaceDaoHelper namespaceDaoHelper;
    @Mock
    private NamespaceSecurityHelper namespaceSecurityHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void createAttributeValueList() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        AttributeValueListCreateRequest request = new AttributeValueListCreateRequest(attributeValueListKey);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(ATTRIBUTE_VALUE_LIST_NAMESPACE);
        AttributeValueListEntity attributeValueListEntity = new AttributeValueListEntity();
        attributeValueListEntity.setId(Integer.valueOf(1009));
        attributeValueListEntity.setNamespace(namespaceEntity);
        attributeValueListEntity.setName(ATTRIBUTE_VALUE_LIST_NAME);
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity(ATTRIBUTE_VALUE_LIST_NAMESPACE)).thenReturn((Object)namespaceEntity);
        Mockito.when((Object)this.attributeValueListDao.getAttributeValueListByKey(attributeValueListKey)).thenReturn(null);
        Mockito.when((Object)this.attributeValueListDao.saveAndRefresh(Matchers.any(AttributeValueListEntity.class))).thenReturn((Object)attributeValueListEntity);
        Mockito.when((Object)this.attributeValueListDaoHelper.createAttributeValueListFromEntity(attributeValueListEntity)).thenCallRealMethod();
        AttributeValueList result = this.attributeValueListService.createAttributeValueList(request);
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListCreateRequest(request);
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(ATTRIBUTE_VALUE_LIST_NAMESPACE);
        ((AttributeValueListDao)Mockito.verify((Object)this.attributeValueListDao)).getAttributeValueListByKey(attributeValueListKey);
        ((AttributeValueListDao)Mockito.verify((Object)this.attributeValueListDao)).saveAndRefresh(Matchers.any(AttributeValueListEntity.class));
        ((AttributeValueListDaoHelper)Mockito.verify((Object)this.attributeValueListDaoHelper)).createAttributeValueListFromEntity(attributeValueListEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new AttributeValueList(1009, attributeValueListKey), (Object)result);
    }

    @Test
    public void createAttributeValueListAlreadyExists() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        AttributeValueListCreateRequest request = new AttributeValueListCreateRequest(attributeValueListKey);
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity(ATTRIBUTE_VALUE_LIST_NAMESPACE)).thenReturn((Object)new NamespaceEntity());
        Mockito.when((Object)this.attributeValueListDao.getAttributeValueListByKey(attributeValueListKey)).thenReturn((Object)new AttributeValueListEntity());
        try {
            this.attributeValueListService.createAttributeValueList(request);
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create attribute value list with name \"%s\" because it already exists for namespace \"%s\".", ATTRIBUTE_VALUE_LIST_NAME, ATTRIBUTE_VALUE_LIST_NAMESPACE), (Object)e.getMessage());
        }
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListCreateRequest(request);
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(ATTRIBUTE_VALUE_LIST_NAMESPACE);
        ((AttributeValueListDao)Mockito.verify((Object)this.attributeValueListDao)).getAttributeValueListByKey(attributeValueListKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteAttributeValueList() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(ATTRIBUTE_VALUE_LIST_NAMESPACE);
        AttributeValueListEntity attributeValueListEntity = new AttributeValueListEntity();
        attributeValueListEntity.setId(Integer.valueOf(1009));
        attributeValueListEntity.setNamespace(namespaceEntity);
        attributeValueListEntity.setName(ATTRIBUTE_VALUE_LIST_NAME);
        Mockito.when((Object)this.attributeValueListDaoHelper.getAttributeValueListEntity(attributeValueListKey)).thenReturn((Object)attributeValueListEntity);
        Mockito.when((Object)this.attributeValueListDaoHelper.createAttributeValueListFromEntity(attributeValueListEntity)).thenCallRealMethod();
        AttributeValueList result = this.attributeValueListService.deleteAttributeValueList(attributeValueListKey);
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListKey(attributeValueListKey);
        ((AttributeValueListDaoHelper)Mockito.verify((Object)this.attributeValueListDaoHelper)).getAttributeValueListEntity(attributeValueListKey);
        ((AttributeValueListDao)Mockito.verify((Object)this.attributeValueListDao)).delete((Object)attributeValueListEntity);
        ((AttributeValueListDaoHelper)Mockito.verify((Object)this.attributeValueListDaoHelper)).createAttributeValueListFromEntity(attributeValueListEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new AttributeValueList(1009, attributeValueListKey), (Object)result);
    }

    @Test
    public void testGetAttributeValueList() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(ATTRIBUTE_VALUE_LIST_NAMESPACE);
        AttributeValueListEntity attributeValueListEntity = new AttributeValueListEntity();
        attributeValueListEntity.setId(Integer.valueOf(1009));
        attributeValueListEntity.setNamespace(namespaceEntity);
        attributeValueListEntity.setName(ATTRIBUTE_VALUE_LIST_NAME);
        Mockito.when((Object)this.attributeValueListDaoHelper.getAttributeValueListEntity(attributeValueListKey)).thenReturn((Object)attributeValueListEntity);
        Mockito.when((Object)this.attributeValueListDaoHelper.createAttributeValueListFromEntity(attributeValueListEntity)).thenCallRealMethod();
        AttributeValueList result = this.attributeValueListService.getAttributeValueList(attributeValueListKey);
        ((AttributeValueListHelper)Mockito.verify((Object)this.attributeValueListHelper)).validateAttributeValueListKey(attributeValueListKey);
        ((AttributeValueListDaoHelper)Mockito.verify((Object)this.attributeValueListDaoHelper)).getAttributeValueListEntity(attributeValueListKey);
        ((AttributeValueListDaoHelper)Mockito.verify((Object)this.attributeValueListDaoHelper)).createAttributeValueListFromEntity(attributeValueListEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new AttributeValueList(1009, attributeValueListKey), (Object)result);
    }

    @Test
    public void testGetAttributeValueLists() {
        HashSet<String> authorizedNamespaces = new HashSet<String>();
        authorizedNamespaces.add(NAMESPACE);
        List<AttributeValueListKey> attributeValueListKeys = Arrays.asList(new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces(new NamespacePermissionEnum[]{NamespacePermissionEnum.READ})).thenReturn(authorizedNamespaces);
        Mockito.when((Object)this.attributeValueListDao.getAttributeValueLists(authorizedNamespaces)).thenReturn(attributeValueListKeys);
        AttributeValueListKeys result = this.attributeValueListService.getAttributeValueLists();
        ((NamespaceSecurityHelper)Mockito.verify((Object)this.namespaceSecurityHelper)).getAuthorizedNamespaces(new NamespacePermissionEnum[]{NamespacePermissionEnum.READ});
        ((AttributeValueListDao)Mockito.verify((Object)this.attributeValueListDao)).getAttributeValueLists(authorizedNamespaces);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new AttributeValueListKeys(attributeValueListKeys), (Object)result);
    }

    @Test
    public void testGetAttributeValueListsNoAuthorizedNamespaces() {
        HashSet authorizedNamespaces = new HashSet();
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces(new NamespacePermissionEnum[]{NamespacePermissionEnum.READ})).thenReturn(authorizedNamespaces);
        AttributeValueListKeys result = this.attributeValueListService.getAttributeValueLists();
        ((NamespaceSecurityHelper)Mockito.verify((Object)this.namespaceSecurityHelper)).getAuthorizedNamespaces(new NamespacePermissionEnum[]{NamespacePermissionEnum.READ});
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new AttributeValueListKeys(), (Object)result);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attributeValueListDao, this.attributeValueListDaoHelper, this.attributeValueListHelper, this.namespaceDaoHelper, this.namespaceSecurityHelper});
    }
}

