/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailabilityCollectionRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailabilityCollectionResponse;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataServiceCheckBusinessObjectDataAvailabilityCollectionTest
extends AbstractServiceTest {
    @Test
    public void testCheckBusinessObjectDataAvailabilityCollection() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataAvailabilityCollectionTesting();
        BusinessObjectDataAvailabilityCollectionResponse resultBusinessObjectDataAvailabilityCollectionResponse = this.businessObjectDataService.checkBusinessObjectDataAvailabilityCollection(this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityCollectionRequest());
        Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataAvailabilityCollectionResponse(), (Object)resultBusinessObjectDataAvailabilityCollectionResponse);
    }

    @Test
    public void testCheckBusinessObjectDataAvailabilityCollectionMissingRequiredParameters() {
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailabilityCollection(null);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data availability collection request is null.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data availability collection request must be specified.", (Object)e.getMessage());
        }
        BusinessObjectDataAvailabilityCollectionRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityCollectionRequest();
        for (List list : Arrays.asList(null, new ArrayList())) {
            request.setBusinessObjectDataAvailabilityRequests(list);
            try {
                this.businessObjectDataService.checkBusinessObjectDataAvailabilityCollection(request);
                Assert.fail((String)"Should throw an IllegalArgumentException when business object data availability request is not specified.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"At least one business object data availability request must be specified.", (Object)e.getMessage());
            }
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataAvailabilityCollectionRequest();
        request.getBusinessObjectDataAvailabilityRequests().set(0, null);
        try {
            this.businessObjectDataService.checkBusinessObjectDataAvailabilityCollection(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data availability request is null.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data availability request must be specified.", (Object)e.getMessage());
        }
    }
}

