/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.PersistenceException;
import org.apache.commons.io.FileUtils;
import org.finra.herd.core.Command;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.Storage;
import org.finra.herd.model.api.xml.StorageDirectory;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.model.api.xml.StorageUnitCreateRequest;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class BusinessObjectDataServiceCreateBusinessObjectDataTest
extends AbstractServiceTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessObjectDataServiceCreateBusinessObjectDataTest.class);
    private static final String testS3KeyPrefix = BusinessObjectDataServiceCreateBusinessObjectDataTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, INITIAL_DATA_VERSION);
    private Path localTempPath;

    @Before
    public void setupEnv() throws IOException {
        this.localTempPath = Files.createTempDirectory(null, new FileAttribute[0]);
    }

    @After
    public void cleanEnv() throws IOException {
        try {
            FileUtils.deleteDirectory((File)this.localTempPath.toFile());
            S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto();
            s3FileTransferRequestParamsDto.setS3KeyPrefix(testS3KeyPrefix);
            this.s3Dao.deleteDirectory(s3FileTransferRequestParamsDto);
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to cleanup environment.", (Throwable)ex);
        }
    }

    @Test
    public void testCreateBusinessObjectData() {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest();
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataCreateRequest, INITIAL_DATA_VERSION, true, resultBusinessObjectData);
    }

    @Test
    public void testCreateBusinessObjectDataMissingRequiredParameters() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, "      \t\t ", PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format partition key is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, "      \t\t ", "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        request.setStorageUnits(null);
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when when request contains no storage units element.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one storage unit must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        request.setStorageUnits(new ArrayList());
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when when no storage units are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one storage unit must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        ArrayList<Object> storageUnits = new ArrayList<Object>();
        storageUnits.add(null);
        request.setStorageUnits(storageUnits);
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when when no storage units are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage unit can't be null.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        ((StorageUnitCreateRequest)request.getStorageUnits().get(0)).setStorageName("      \t\t ");
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when storage name is not specified for a storage unit.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name is required for each storage unit.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, null, null);
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when both storage directory and storage files are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage directory or at least one storage file must be specified for each storage unit.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, "      \t\t ", this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when storage directory element is present, but the actual directory path value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage directory path must be specified.", (Object)e.getMessage());
        }
        List<StorageFile> storageFiles = this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat"));
        storageFiles.get(0).setFilePath("      \t\t ");
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, storageFiles);
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when storage file element is present, but the actual file path value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A file path must be specified.", (Object)e.getMessage());
        }
        storageFiles = this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat"));
        storageFiles.get(0).setFileSizeBytes(null);
        request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, storageFiles);
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when storage file size is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A file size must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataMissingOptionalParameters() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, null);
        Assert.assertNull((Object)request.getSubPartitionValues());
        request.setStatus("      \t\t ");
        Assert.assertNull((Object)request.getAttributes());
        Assert.assertNull((Object)((StorageUnitCreateRequest)request.getStorageUnits().get(0)).getStorageFiles());
        request.setCreateNewVersion(null);
        Assert.assertNull((Object)request.getBusinessObjectDataParents());
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(request, INITIAL_DATA_VERSION, true, resultBusinessObjectData);
    }

    @Test
    public void testCreateBusinessObjectDataNoStorageDirectory() {
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest();
        ((StorageUnitCreateRequest)request.getStorageUnits().get(0)).setStorageDirectory(null);
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(request, INITIAL_DATA_VERSION, true, resultBusinessObjectData);
    }

    @Test
    public void testCreateBusinessObjectDataNoStorageFiles() {
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest();
        ((StorageUnitCreateRequest)request.getStorageUnits().get(0)).setStorageFiles(null);
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(request, INITIAL_DATA_VERSION, true, resultBusinessObjectData);
    }

    @Test
    public void testCreateBusinessObjectDataNoAttributes() {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest(false);
        this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
    }

    @Test
    public void testCreateBusinessObjectDataTrimParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), INITIAL_FORMAT_VERSION, this.addWhitespace(PARTITION_KEY), this.addWhitespace(PARTITION_VALUE), this.addWhitespace(BDATA_STATUS), this.addWhitespace(STORAGE_NAME), this.addWhitespace(testS3KeyPrefix), this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        for (StorageFile storageFile : ((StorageUnitCreateRequest)request.getStorageUnits().get(0)).getStorageFiles()) {
            storageFile.setFilePath(this.addWhitespace(storageFile.getFilePath()));
        }
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectFormatEntity, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION, true, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, SORTED_LOCAL_FILES), CollectionUtils.isEmpty((Collection)request.getAttributes()) ? new ArrayList() : request.getAttributes(), resultBusinessObjectData);
    }

    @Test
    public void testCreateBusinessObjectDataInvalidParameters() {
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(this.addSlash(BDEF_NAMESPACE), BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, SUBPARTITION_VALUES, "VALID", Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(STORAGE_DIRECTORY_PATH), NO_STORAGE_FILES, NO_DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(BDEF_NAMESPACE, this.addSlash(BDEF_NAME), FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, SUBPARTITION_VALUES, "VALID", Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(STORAGE_DIRECTORY_PATH), NO_STORAGE_FILES, NO_DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(BDEF_NAMESPACE, BDEF_NAME, this.addSlash(FORMAT_USAGE_CODE), FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, SUBPARTITION_VALUES, "VALID", Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(STORAGE_DIRECTORY_PATH), NO_STORAGE_FILES, NO_DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format usage can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, this.addSlash(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, SUBPARTITION_VALUES, "VALID", Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(STORAGE_DIRECTORY_PATH), NO_STORAGE_FILES, NO_DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format file type can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, this.addSlash(PARTITION_KEY), PARTITION_VALUE, SUBPARTITION_VALUES, "VALID", Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(STORAGE_DIRECTORY_PATH), NO_STORAGE_FILES, NO_DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Partition key can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, this.addSlash(PARTITION_VALUE), SUBPARTITION_VALUES, "VALID", Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(STORAGE_DIRECTORY_PATH), NO_STORAGE_FILES, NO_DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Partition value can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, Arrays.asList(this.addSlash(PARTITION_VALUE_2)), "VALID", Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(STORAGE_DIRECTORY_PATH), NO_STORAGE_FILES, NO_DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when sub-partition value contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Subpartition value can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, SUBPARTITION_VALUES, "VALID", Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(STORAGE_DIRECTORY_PATH), NO_STORAGE_FILES, NO_DISCOVER_STORAGE_FILES)), Arrays.asList(new Attribute(this.addSlash("Attribute Name 1"), "Attribute Value 1")), NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when attribute name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Attribute name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectBusinessObjectStatusCodeNoExists() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        String invalidStatusCode = "I_DO_NOT_EXIST";
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, invalidStatusCode, STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat")));
        try {
            this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data status code does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data status \"%s\" doesn't exist.", invalidStatusCode), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataBusinessObjectFormatNoExists() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        String invalidBusinessObjectFormatUsage = "I_DO_NOT_EXIST";
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, invalidBusinessObjectFormatUsage, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat")));
        try {
            this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
            Assert.fail((String)"Should throw an ObjectNotFoundException when a non-existing business object format is specified.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, invalidBusinessObjectFormatUsage, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataInvalidPartitionKey() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, "INVALID_PARTITION_KEY", PARTITION_VALUE, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat")));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when an invalid partition key value is specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Partition key \"%s\" doesn't match configured business object format partition key \"%s\".", request.getPartitionKey(), PARTITION_KEY), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageNotFound() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        String invalidStorageName = "I_DO_NOT_EXIST";
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, invalidStorageName, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat")));
        try {
            this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
            Assert.fail((String)"Should throw an ObjectNotFoundException when specified storage name does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", invalidStorageName), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataStorageHasValidateFileSizeEnabledWithoutValidateFileExistence() {
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME_2), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_SIZE), Boolean.toString(true))));
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        try {
            this.businessObjectDataService.createBusinessObjectData(this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when using storage with file existence validation enabled without file size validation.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage \"%s\" has file size validation enabled without file existence validation.", STORAGE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataInvalidStorageFile() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        String wrongS3KeyPrefix = "WRONG_S3_KEY_PREFIX";
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(wrongS3KeyPrefix, Arrays.asList("foo.dat")));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when a storage storage file path does not match the storage directory path.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage file path \"%s/%s\" does not match the storage directory path \"%s\".", wrongS3KeyPrefix, "foo.dat", testS3KeyPrefix), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataValidateFileExistenceNoValidatePrefix() throws Exception {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), Boolean.TRUE.toString()));
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", attributes);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        List<StorageFile> storageFiles = this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(S3_BUCKET_NAME, testS3KeyPrefix, this.localTempPath, LOCAL_FILES, new ArrayList<String>());
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, storageFiles);
        this.businessObjectDataService.createBusinessObjectData(request);
    }

    @Test
    public void testCreateBusinessObjectDataValidateFileExistenceNoValidatePrefixDirectoryInvalid() throws Exception {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), Boolean.TRUE.toString()));
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", attributes);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        List<StorageFile> storageFiles = this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(S3_BUCKET_NAME, testS3KeyPrefix, this.localTempPath, LOCAL_FILES, new ArrayList<String>());
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, STORAGE_NAME, "INVALID_DIRECTORY_PATH", storageFiles);
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when a directory path doesn't match the S3 uploaded files.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(String.format("does not match the storage directory path \"%s\"", "INVALID_DIRECTORY_PATH")));
        }
    }

    @Test
    public void testCreateBusinessObjectDataInvalidValidationBooleanValue() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), "INVALID_BOOLEAN_VALUE"));
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", attributes);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        List<StorageFile> storageFiles = this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, SORTED_LOCAL_FILES);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, storageFiles);
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalStateException when a validation boolean value is invalid.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage has an invalid boolean value: \"%s\".", ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE.getDefaultValue(), STORAGE_NAME, "INVALID_BOOLEAN_VALUE"), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataValidateFlagIgnoredForNonS3Storage() throws Exception {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME));
        attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), Boolean.TRUE.toString()));
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "NON_S3_STORAGE", attributes);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        List<StorageFile> storageFiles = this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, storageFiles);
        this.businessObjectDataService.createBusinessObjectData(request);
    }

    @Test
    public void testCreateBusinessObjectDataInvalidStorageFileRowCount() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        List<StorageFile> storageFiles = this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat"));
        storageFiles.get(0).setRowCount(Long.valueOf(-1L));
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, storageFiles);
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when storage file size is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("File \"%s/%s\" has a row count which is < 0.", testS3KeyPrefix, "foo.dat"), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataInitialDataVersionExists() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        List<StorageFile> storageFiles = this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, SORTED_LOCAL_FILES);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, storageFiles);
        for (Boolean createNewVersionFlag : new Boolean[]{null, Boolean.FALSE}) {
            request.setCreateNewVersion(createNewVersionFlag);
            try {
                this.businessObjectDataService.createBusinessObjectData(request);
                Assert.fail((String)String.format("Should throw an IllegalArgumentException when the initial data version exists and createNewVersion flag is set to \"%s\".", createNewVersionFlag));
            }
            catch (AlreadyExistsException e) {
                Assert.assertEquals((Object)"Unable to create business object data because it already exists and a new version is not allowed since the \"createNewVersion\" flag is not set to \"true\" in the request.", (Object)e.getMessage());
            }
        }
        request.setCreateNewVersion(Boolean.valueOf(true));
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(request, SECOND_DATA_VERSION, true, resultBusinessObjectData);
        BusinessObjectDataEntity initialVersionBusinessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertEquals((Object)false, (Object)initialVersionBusinessObjectDataEntity.getLatestVersion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBusinessObjectDataMissingRequiredAttribute() {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest(true);
        businessObjectDataCreateRequest.setAttributes(null);
        this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
    }

    @Test
    public void testCreateBusinessObjectDataDuplicateAttributeNames() throws Exception {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, "VALID", STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        request.setAttributes(attributes);
        attributes.add(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1"));
        attributes.add(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1"));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate attribute names are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate attribute name found: %s", "Attribute Name 1".toLowerCase()), (Object)e.getMessage());
        }
    }

    @Test(expected=PersistenceException.class)
    public void testCreateBusinessObjectDataAttributeValueTooLarge() throws Exception {
        final BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest();
        Attribute newAttribute = new Attribute();
        newAttribute.setName("Valid Name");
        newAttribute.setValue(new String(new char[4001]).replace('\u0000', 'A'));
        businessObjectDataCreateRequest.getAttributes().add(newAttribute);
        this.executeWithoutLogging(SqlExceptionHelper.class, new Command(){

            public void execute() {
                BusinessObjectDataServiceCreateBusinessObjectDataTest.this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
            }
        });
    }

    @Test
    public void testCreateBusinessObjectDataS3ManagedBucket() throws Exception {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, LOCAL_FILES);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectFormatEntity, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION, true, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, SORTED_LOCAL_FILES), CollectionUtils.isEmpty((Collection)request.getAttributes()) ? new ArrayList() : request.getAttributes(), resultBusinessObjectData);
    }

    @Test
    public void testCreateBusinessObjectDataS3ManagedBucketExtraFilesInS3() throws Exception {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        ArrayList<String> localFiles = new ArrayList<String>();
        localFiles.addAll(LOCAL_FILES);
        localFiles.add(FILE_NAME);
        localFiles.add(FILE_NAME_2);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, localFiles);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectFormatEntity, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION, true, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, SORTED_LOCAL_FILES), CollectionUtils.isEmpty((Collection)request.getAttributes()) ? new ArrayList() : request.getAttributes(), resultBusinessObjectData);
    }

    @Test
    public void testCreateBusinessObjectDataS3ManagedBucketInvalidStorageDirectory() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        String invalidS3KeyPrefix = "INVALID_S3_KEY_PREFIX";
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, "S3_MANAGED", invalidS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when a storage directory path in S3 managed storage does not match the expected S3 key prefix.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Specified directory path \"%s\" does not match the expected S3 key prefix \"%s\".", invalidS3KeyPrefix, testS3KeyPrefix), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataS3ManagedBucketInvalidStorageFile() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        String invalidS3KeyPrefix = "INVALID_S3_KEY_PREFIX";
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(invalidS3KeyPrefix, Arrays.asList("foo.dat")));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when a storage storage file path in S3 managed storage does not match the expected S3 key prefix.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Specified storage file path \"%s/%s\" does not match the expected S3 key prefix \"%s\".", invalidS3KeyPrefix, "foo.dat", testS3KeyPrefix), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataS3ManagedBucketDirectoryPathAlreadyRegistered() {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE_2, INITIAL_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDao.getStorageByName("S3_MANAGED"), businessObjectDataEntity, "ENABLED", testS3KeyPrefix);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat")));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an AlreadyExistsException when directory path in S3 managed storage matches the location of an already registered business object data.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Storage directory \"%s\" in \"%s\" storage is already registered by the business object data {%s}.", testS3KeyPrefix, "S3_MANAGED", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE_2, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataS3ManagedBucketFileAlreadyRegistered() {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE_2, INITIAL_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(this.storageDao.getStorageByName("S3_MANAGED"), businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, String.format("%s/%s", testS3KeyPrefix, "foo.dat"), Long.valueOf(1024L), Long.valueOf(1000L));
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat")));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an AlreadyExistsException when a storage file in S3 managed storage is already registered by another business object data.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Found 1 storage file(s) matching \"%s\" S3 key prefix in \"%s\" storage that is registered with another business object data.", testS3KeyPrefix, "S3_MANAGED"), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataS3ManagedBucketS3FileNotFound() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat")));
        try {
            this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
            Assert.fail((String)"Should throw an ObjectNotFoundException when a storage file does not exist in S3 managed storage.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("File not found at s3://%s/%s/%s location.", this.storageDaoTestHelper.getS3ManagedBucketName(), testS3KeyPrefix, "foo.dat"), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataS3ManagedBucketS3FileSizeMismatch() throws Exception {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, Arrays.asList("foo.dat"));
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat")));
        ((StorageFile)((StorageUnitCreateRequest)request.getStorageUnits().get(0)).getStorageFiles().get(0)).setFileSizeBytes(Long.valueOf(0L));
        try {
            this.businessObjectDataService.createBusinessObjectData(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when a storage file size does not match file size reported by S3.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Specified file size of %d bytes for \"%s/%s\" storage file does not match file size of %d bytes reported by S3.", 0L, testS3KeyPrefix, "foo.dat", 1024L), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataS3ManagedBucketWithZeroByteDirectoryMarkers() throws Exception {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, LOCAL_FILES, S3_DIRECTORY_MARKERS);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, LOCAL_FILES));
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectFormatEntity, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION, true, BDATA_STATUS, "S3_MANAGED", testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, SORTED_LOCAL_FILES), CollectionUtils.isEmpty((Collection)request.getAttributes()) ? new ArrayList() : request.getAttributes(), resultBusinessObjectData);
    }

    @Test
    public void testCreateBusinessObjectDataDuplicateParents() {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest(true);
        List businessObjectDataKeys = businessObjectDataCreateRequest.getBusinessObjectDataParents();
        businessObjectDataKeys.add(businessObjectDataKeys.get(0));
        try {
            this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data create request contains duplicate parents.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object data keys can not contain duplicates.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataParentMissingBusinessObjectFormatVersion() {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest(true);
        List businessObjectDataKeys = businessObjectDataCreateRequest.getBusinessObjectDataParents();
        ((BusinessObjectDataKey)businessObjectDataKeys.get(0)).setBusinessObjectFormatVersion(null);
        try {
            this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified for a business object data parent.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataParentMissingPartitionValue() {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest(true);
        List businessObjectDataKeys = businessObjectDataCreateRequest.getBusinessObjectDataParents();
        ((BusinessObjectDataKey)businessObjectDataKeys.get(0)).setPartitionValue(null);
        try {
            this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified for a business object data parent.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataParentMissingBusinessObjectDataVersion() {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest(true);
        List businessObjectDataKeys = businessObjectDataCreateRequest.getBusinessObjectDataParents();
        ((BusinessObjectDataKey)businessObjectDataKeys.get(0)).setBusinessObjectDataVersion(null);
        try {
            this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data version is not specified for a business object data parent.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testCreateBusinessObjectDataParentNoExists() {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest(true);
        List businessObjectDataKeys = businessObjectDataCreateRequest.getBusinessObjectDataParents();
        ((BusinessObjectDataKey)businessObjectDataKeys.get(0)).setPartitionValue("Invalid_Partition_Value");
        this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
    }

    @Test
    public void testCreateBusinessObjectDataIgnoringCircularDependency() {
        BusinessObjectDataKey alphaBusinessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataKey betaBusinessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity alphaBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(alphaBusinessObjectDataKey, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataEntity betaBusinessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(betaBusinessObjectDataKey, Boolean.valueOf(true), BDATA_STATUS);
        alphaBusinessObjectDataEntity.getBusinessObjectDataChildren().add(betaBusinessObjectDataEntity);
        betaBusinessObjectDataEntity.getBusinessObjectDataParents().add(alphaBusinessObjectDataEntity);
        betaBusinessObjectDataEntity.getBusinessObjectDataChildren().add(alphaBusinessObjectDataEntity);
        alphaBusinessObjectDataEntity.getBusinessObjectDataParents().add(betaBusinessObjectDataEntity);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        BusinessObjectDataCreateRequest request = this.businessObjectDataServiceTestHelper.createBusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE_2, BDATA_STATUS, STORAGE_NAME, testS3KeyPrefix, this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, Arrays.asList("foo.dat")));
        ArrayList<BusinessObjectDataKey> parents = new ArrayList<BusinessObjectDataKey>();
        request.setBusinessObjectDataParents(parents);
        parents.add(betaBusinessObjectDataKey);
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        Assert.assertNotNull((Object)resultBusinessObjectData);
        Assert.assertNotNull((Object)resultBusinessObjectData.getBusinessObjectDataParents());
        Assert.assertEquals((long)1L, (long)resultBusinessObjectData.getBusinessObjectDataParents().size());
        Assert.assertTrue((boolean)resultBusinessObjectData.getBusinessObjectDataParents().contains(betaBusinessObjectDataKey));
    }

    @Test
    public void testCreateBusinessObjectDataDiscoverStorageFiles() throws Exception {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, LOCAL_FILES);
        BusinessObjectDataCreateRequest request = new BusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, NO_SUBPARTITION_VALUES, BDATA_STATUS, Arrays.asList(new StorageUnitCreateRequest("S3_MANAGED", new StorageDirectory(testS3KeyPrefix), NO_STORAGE_FILES, DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION);
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        Assert.assertEquals((Object)new BusinessObjectData(resultBusinessObjectData.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION.intValue(), PARTITION_KEY, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION.intValue(), LATEST_VERSION_FLAG_SET, BDATA_STATUS, Arrays.asList(new StorageUnit(new Storage("S3_MANAGED", "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), this.storageDaoTestHelper.getS3ManagedBucketName()), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), Boolean.TRUE.toString()), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_SIZE), Boolean.TRUE.toString()), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX), Boolean.TRUE.toString()))), new StorageDirectory(testS3KeyPrefix), this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, SORTED_LOCAL_FILES, false), "ENABLED", NO_STORAGE_UNIT_STATUS_HISTORY, NO_STORAGE_POLICY_TRANSITION_FAILED_ATTEMPTS, NO_RESTORE_EXPIRATION_ON)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_BUSINESS_OBJECT_DATA_CHILDREN, NO_BUSINESS_OBJECT_DATA_STATUS_HISTORY, NO_RETENTION_EXPIRATION_DATE), (Object)resultBusinessObjectData);
    }

    @Test
    public void testCreateBusinessObjectDataDiscoverStorageFilesNoStorageDirectory() {
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "VALID", Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, NO_STORAGE_DIRECTORY, NO_STORAGE_FILES, DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when discovery of storage files is enabled and storage directory is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage directory must be specified when discovery of storage files is enabled.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataDiscoverStorageFilesStorageFilesSpecified() {
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "VALID", Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(STORAGE_DIRECTORY_PATH), Arrays.asList(new StorageFile("foo.dat", Long.valueOf(1024L), Long.valueOf(1000L))), DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when discovery of storage files is enabled and storage files are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Storage files cannot be specified when discovery of storage files is enabled.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataDiscoverStorageFilesInvalidStoragePlatform() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, STORAGE_PLATFORM_CODE, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME);
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, NO_SUBPARTITION_VALUES, BDATA_STATUS, Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(testS3KeyPrefix), NO_STORAGE_FILES, DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage platform is not supported for discovery of storage files.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Cannot discover storage files at \"%s\" storage platform.", STORAGE_PLATFORM_CODE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataDiscoverStorageFilesNoS3FilesExist() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        try {
            this.businessObjectDataService.createBusinessObjectData(new BusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, NO_SUBPARTITION_VALUES, BDATA_STATUS, Arrays.asList(new StorageUnitCreateRequest("S3_MANAGED", new StorageDirectory(testS3KeyPrefix), NO_STORAGE_FILES, DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when there are no files in S3 to discover.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith(String.format("Found no files at \"s3://%s", this.storageDaoTestHelper.getS3ManagedBucketName())));
        }
    }

    @Test
    public void testCreateBusinessObjectDataDiscoverStorageFilesStorageDirectoryEndsWithSlash() throws Exception {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(BDATA_STATUS);
        this.businessObjectDataServiceTestHelper.prepareTestS3Files(testS3KeyPrefix, this.localTempPath, LOCAL_FILES);
        String testBucketName = this.storageDaoTestHelper.getS3ManagedBucketName();
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), testBucketName);
        String testStorageDirectoryPath = testS3KeyPrefix + "/";
        BusinessObjectDataCreateRequest request = new BusinessObjectDataCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, NO_SUBPARTITION_VALUES, BDATA_STATUS, Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, new StorageDirectory(testStorageDirectoryPath), NO_STORAGE_FILES, DISCOVER_STORAGE_FILES)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_CREATE_NEW_VERSION);
        BusinessObjectData resultBusinessObjectData = this.businessObjectDataService.createBusinessObjectData(request);
        Assert.assertEquals((Object)new BusinessObjectData(resultBusinessObjectData.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION.intValue(), PARTITION_KEY, PARTITION_VALUE, NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION.intValue(), LATEST_VERSION_FLAG_SET, BDATA_STATUS, Arrays.asList(new StorageUnit(new Storage(STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), testBucketName))), new StorageDirectory(testStorageDirectoryPath), this.businessObjectDataServiceTestHelper.getTestStorageFiles(testS3KeyPrefix, SORTED_LOCAL_FILES, false), "ENABLED", NO_STORAGE_UNIT_STATUS_HISTORY, NO_STORAGE_POLICY_TRANSITION_FAILED_ATTEMPTS, NO_RESTORE_EXPIRATION_ON)), NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_BUSINESS_OBJECT_DATA_CHILDREN, NO_BUSINESS_OBJECT_DATA_STATUS_HISTORY, NO_RETENTION_EXPIRATION_DATE), (Object)resultBusinessObjectData);
    }

    @Test
    public void testCreateBusinessObjectDataPreRegistrationAssertDirectoryPathNotRequiredWhenStatusIsPreRegistrationAndDirectoryIsSetInResponse() {
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME);
        storageEntity.getAttributes().add(this.storageDaoTestHelper.createStorageAttributeEntity(storageEntity, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "foo"));
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest();
        businessObjectDataCreateRequest.setSubPartitionValues(null);
        businessObjectDataCreateRequest.setStatus("UPLOADING");
        businessObjectDataCreateRequest.setStorageUnits(Arrays.asList(new StorageUnitCreateRequest(STORAGE_NAME, null, null, null)));
        BusinessObjectData businessObjectData = this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
        Assert.assertEquals((Object)"foo", (Object)((StorageUnit)businessObjectData.getStorageUnits().get(0)).getStorageDirectory().getDirectoryPath());
    }

    @Test
    public void testCreateBusinessObjectDataPreRegistrationAssertCannotCreateNewVersionWhenLatestIsPreRegistrationStatus() {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest();
        businessObjectDataCreateRequest.setStatus("UPLOADING");
        this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
        businessObjectDataCreateRequest.setCreateNewVersion(Boolean.valueOf(true));
        businessObjectDataCreateRequest.setStatus("VALID");
        try {
            this.businessObjectDataService.createBusinessObjectData(businessObjectDataCreateRequest);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(AlreadyExistsException.class, e.getClass());
            Assert.assertEquals((Object)"Unable to create business object data because it already exists and a new version is not allowed since the latest version is still in \"UPLOADING\", which is one of the pre-registration statuses.", (Object)e.getMessage());
        }
    }
}

