/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.GetObjectTaggingRequest;
import com.amazonaws.services.s3.model.GetObjectTaggingResult;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.Tag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataServiceDestroyBusinessObjectDataTest
extends AbstractServiceTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDestroyBusinessObjectData() throws Exception {
        String primaryPartitionValue = DateFormatUtils.format((Date)DateUtils.addDays((Date)new Date(), (int)(-1 * (RETENTION_PERIOD_DAYS + 1))), (String)"yyyy-MM-dd");
        String s3KeyPrefix = BusinessObjectDataServiceDestroyBusinessObjectDataTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, primaryPartitionValue, null, null, DATA_VERSION);
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().withS3BucketName(S3_BUCKET_NAME).withS3KeyPrefix(s3KeyPrefix + "/").build();
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), AbstractServiceTest.S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end"), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX), Boolean.TRUE.toString()), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE), Boolean.TRUE.toString())));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        for (String filePath : LOCAL_FILES) {
            this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, s3KeyPrefix + "/" + filePath, Long.valueOf(1024L), Long.valueOf(1000L));
        }
        List storageFiles = this.storageFileHelper.createStorageFilesFromEntities(storageUnitEntity.getStorageFiles());
        BusinessObjectFormatEntity businessObjectFormatEntity = storageUnitEntity.getBusinessObjectData().getBusinessObjectFormat();
        businessObjectFormatEntity.setRetentionType(this.retentionTypeDao.getRetentionTypeByCode("PARTITION_VALUE"));
        businessObjectFormatEntity.setRetentionPeriodInDays(RETENTION_PERIOD_DAYS);
        this.businessObjectFormatDao.saveAndRefresh((Object)businessObjectFormatEntity);
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.S3_OBJECT_DELETE_TAG_KEY.getKey(), S3_OBJECT_TAG_KEY);
        overrideMap.put(ConfigurationValue.S3_OBJECT_DELETE_TAG_VALUE.getKey(), S3_OBJECT_TAG_VALUE);
        overrideMap.put(ConfigurationValue.S3_OBJECT_DELETE_ROLE_ARN.getKey(), S3_OBJECT_TAGGER_ROLE_ARN);
        overrideMap.put(ConfigurationValue.S3_OBJECT_DELETE_ROLE_SESSION_NAME.getKey(), S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            for (StorageFile storageFile : storageFiles) {
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFile.getFilePath(), (InputStream)new ByteArrayInputStream(new byte[storageFile.getFileSizeBytes().intValue()]), null), null);
            }
            BusinessObjectData result = this.businessObjectDataService.destroyBusinessObjectData(businessObjectDataKey);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)storageUnitEntity.getBusinessObjectData().getId(), (Object)result.getId());
            Assert.assertEquals((Object)"DISABLED", (Object)storageUnitEntity.getStatus().getCode());
            Assert.assertEquals((Object)"DELETED", (Object)storageUnitEntity.getBusinessObjectData().getStatus().getCode());
            for (StorageFile storageFile : storageFiles) {
                GetObjectTaggingResult getObjectTaggingResult = this.s3Operations.getObjectTagging(new GetObjectTaggingRequest(S3_BUCKET_NAME, storageFile.getFilePath()), null);
                Assert.assertEquals(Arrays.asList(new Tag(S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE)), (Object)getObjectTaggingResult.getTagSet());
            }
        }
        finally {
            if (!this.s3Dao.listDirectory(s3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(s3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
            this.restorePropertySourceInEnvironment();
        }
    }
}

