/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlCollectionRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlCollectionResponse;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataServiceGenerateBusinessObjectDataDllCollectionTest
extends AbstractServiceTest {
    @Test
    public void testGenerateBusinessObjectDataDdlCollection() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(AbstractServiceTest.PARTITION_VALUE);
        BusinessObjectDataDdlCollectionResponse resultBusinessObjectDataDdlCollectionResponse = this.businessObjectDataService.generateBusinessObjectDataDdlCollection(this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlCollectionRequest());
        Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdlCollectionResponse(), (Object)resultBusinessObjectDataDdlCollectionResponse);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlCollectionMissingRequiredParameters() {
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdlCollection(null);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data DDL collection request is null.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data DDL collection request must be specified.", (Object)e.getMessage());
        }
        BusinessObjectDataDdlCollectionRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlCollectionRequest();
        for (List list : Arrays.asList(null, new ArrayList())) {
            request.setBusinessObjectDataDdlRequests(list);
            try {
                this.businessObjectDataService.generateBusinessObjectDataDdlCollection(request);
                Assert.fail((String)"Should throw an IllegalArgumentException when business object data DDL request is not specified.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"At least one business object data DDL request must be specified.", (Object)e.getMessage());
            }
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlCollectionRequest();
        request.getBusinessObjectDataDdlRequests().set(0, null);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdlCollection(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data DDL request is null.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data DDL request must be specified.", (Object)e.getMessage());
        }
    }
}

